/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.transaction.state.storeview;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.mockito.InOrder;
import org.mockito.Mockito;
import org.neo4j.graphdb.Label;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.Transaction;
import org.neo4j.helpers.collection.Iterators;
import org.neo4j.helpers.collection.Visitor;
import org.neo4j.kernel.api.Statement;
import org.neo4j.kernel.api.exceptions.EntityNotFoundException;
import org.neo4j.kernel.api.exceptions.KernelException;
import org.neo4j.kernel.api.exceptions.PropertyNotFoundException;
import org.neo4j.kernel.api.index.NodePropertyUpdate;
import org.neo4j.kernel.api.properties.Property;
import org.neo4j.kernel.impl.api.index.NodePropertyUpdates;
import org.neo4j.kernel.impl.api.index.StoreScan;
import org.neo4j.kernel.impl.core.ThreadToStatementContextBridge;
import org.neo4j.kernel.impl.locking.Lock;
import org.neo4j.kernel.impl.locking.LockService;
import org.neo4j.kernel.impl.storageengine.impl.recordstorage.RecordStorageEngine;
import org.neo4j.kernel.impl.store.NeoStores;
import org.neo4j.kernel.impl.store.record.AbstractBaseRecord;
import org.neo4j.kernel.impl.store.record.NodeRecord;
import org.neo4j.kernel.impl.store.record.RecordLoad;
import org.neo4j.kernel.impl.transaction.state.storeview.NeoStoreIndexStoreView;
import org.neo4j.kernel.impl.transaction.state.storeview.StoreViewNodeStoreScan;
import org.neo4j.kernel.internal.GraphDatabaseAPI;
import org.neo4j.test.EmbeddedDatabaseRule;

public class NeoStoreIndexStoreViewTest {
    @Rule
    public EmbeddedDatabaseRule dbRule = new EmbeddedDatabaseRule(this.getClass());
    private Map<Long, Lock> lockMocks = new HashMap<Long, Lock>();
    private Label label = Label.label((String)"Person");
    private GraphDatabaseAPI graphDb;
    private NeoStoreIndexStoreView storeView;
    private int labelId;
    private int propertyKeyId;
    private Node alistair;
    private Node stefan;
    private LockService locks;
    private NeoStores neoStores;

    @Before
    public void before() throws KernelException {
        this.graphDb = this.dbRule.getGraphDatabaseAPI();
        this.createAlistairAndStefanNodes();
        this.getOrCreateIds();
        this.neoStores = ((RecordStorageEngine)this.graphDb.getDependencyResolver().resolveDependency(RecordStorageEngine.class)).testAccessNeoStores();
        this.locks = (LockService)Mockito.mock(LockService.class, invocation -> {
            Long nodeId = (Long)invocation.getArguments()[0];
            Lock lock = this.lockMocks.get(nodeId);
            if (lock == null) {
                lock = (Lock)Mockito.mock(Lock.class);
                this.lockMocks.put(nodeId, lock);
            }
            return lock;
        });
        this.storeView = new NeoStoreIndexStoreView(this.locks, this.neoStores);
    }

    @Test
    public void shouldScanExistingNodesForALabel() throws Exception {
        NodeUpdateCollectingVisitor visitor = new NodeUpdateCollectingVisitor();
        Visitor labelVisitor = (Visitor)Mockito.mock(Visitor.class);
        StoreScan storeScan = this.storeView.visitNodes(new int[]{this.labelId}, id -> id == this.propertyKeyId, (Visitor)visitor, labelVisitor);
        storeScan.run();
        Assert.assertEquals((Object)Iterators.asSet((Object[])new NodePropertyUpdate[]{NodePropertyUpdate.add((long)this.alistair.getId(), (int)this.propertyKeyId, (Object)"Alistair", (long[])new long[]{this.labelId}), NodePropertyUpdate.add((long)this.stefan.getId(), (int)this.propertyKeyId, (Object)"Stefan", (long[])new long[]{this.labelId})}), visitor.getUpdates());
    }

    @Test
    public void shouldIgnoreDeletedNodesDuringScan() throws Exception {
        this.deleteAlistairAndStefanNodes();
        NodeUpdateCollectingVisitor visitor = new NodeUpdateCollectingVisitor();
        Visitor labelVisitor = (Visitor)Mockito.mock(Visitor.class);
        StoreScan storeScan = this.storeView.visitNodes(new int[]{this.labelId}, id -> id == this.propertyKeyId, (Visitor)visitor, labelVisitor);
        storeScan.run();
        Assert.assertEquals((Object)Iterators.emptySetOf(NodePropertyUpdate.class), visitor.getUpdates());
    }

    @Test
    public void shouldLockNodesWhileReadingThem() throws Exception {
        Visitor visitor = (Visitor)Mockito.mock(Visitor.class);
        StoreScan storeScan = this.storeView.visitNodes(new int[]{this.labelId}, id -> id == this.propertyKeyId, visitor, null);
        storeScan.run();
        Assert.assertEquals((String)("allocated locks: " + this.lockMocks.keySet()), (long)2L, (long)this.lockMocks.size());
        Lock lock0 = this.lockMocks.get(0L);
        Lock lock1 = this.lockMocks.get(1L);
        Assert.assertNotNull((String)"Lock[node=0] never acquired", (Object)lock0);
        Assert.assertNotNull((String)"Lock[node=1] never acquired", (Object)lock1);
        InOrder order = Mockito.inOrder((Object[])new Object[]{this.locks, lock0, lock1});
        ((LockService)order.verify((Object)this.locks)).acquireNodeLock(0L, LockService.LockType.READ_LOCK);
        ((Lock)order.verify((Object)lock0)).release();
        ((LockService)order.verify((Object)this.locks)).acquireNodeLock(1L, LockService.LockType.READ_LOCK);
        ((Lock)order.verify((Object)lock1)).release();
        order.verifyNoMoreInteractions();
    }

    @Test
    public void shouldReadProperties() throws PropertyNotFoundException, EntityNotFoundException {
        Property property = this.storeView.getProperty(this.alistair.getId(), this.propertyKeyId);
        Assert.assertTrue((boolean)property.valueEquals((Object)"Alistair"));
    }

    @Test
    public void processAllNodeProperties() throws Exception {
        CopyUpdateVisitor propertyUpdateVisitor = new CopyUpdateVisitor();
        StoreViewNodeStoreScan storeViewNodeStoreScan = new StoreViewNodeStoreScan(this.neoStores.getNodeStore(), this.locks, this.neoStores.getPropertyStore(), null, (Visitor)propertyUpdateVisitor, new int[]{this.labelId}, id -> true);
        NodeRecord nodeRecord = new NodeRecord(-1L);
        this.neoStores.getNodeStore().getRecord(1L, (AbstractBaseRecord)nodeRecord, RecordLoad.FORCE);
        storeViewNodeStoreScan.process(nodeRecord);
        NodePropertyUpdates propertyUpdates = propertyUpdateVisitor.getPropertyUpdates();
        Assert.assertNotNull((String)"Visitor should containts container with 2 updates.", (Object)propertyUpdates);
        Assert.assertThat((String)"Node should have 2 property and we should get 2 updates", (Object)propertyUpdates.getPropertyUpdates(), (Matcher)Matchers.hasSize((int)2));
    }

    private void createAlistairAndStefanNodes() {
        try (Transaction tx = this.graphDb.beginTx();){
            this.alistair = this.graphDb.createNode(new Label[]{this.label});
            this.alistair.setProperty("name", (Object)"Alistair");
            this.alistair.setProperty("country", (Object)"UK");
            this.stefan = this.graphDb.createNode(new Label[]{this.label});
            this.stefan.setProperty("name", (Object)"Stefan");
            this.stefan.setProperty("country", (Object)"Deutschland");
            tx.success();
        }
    }

    private void deleteAlistairAndStefanNodes() {
        try (Transaction tx = this.graphDb.beginTx();){
            this.alistair.delete();
            this.stefan.delete();
            tx.success();
        }
    }

    private void getOrCreateIds() throws KernelException {
        try (Transaction tx = this.graphDb.beginTx();){
            ThreadToStatementContextBridge bridge = (ThreadToStatementContextBridge)this.graphDb.getDependencyResolver().resolveDependency(ThreadToStatementContextBridge.class);
            try (Statement statement = bridge.get();){
                this.labelId = statement.dataWriteOperations().labelGetOrCreateForName("Person");
                this.propertyKeyId = statement.dataWriteOperations().propertyKeyGetOrCreateForName("name");
            }
            tx.success();
        }
    }

    class NodeUpdateCollectingVisitor
    implements Visitor<NodePropertyUpdates, Exception> {
        private final Set<NodePropertyUpdate> updates = new HashSet<NodePropertyUpdate>();

        NodeUpdateCollectingVisitor() {
        }

        public boolean visit(NodePropertyUpdates propertyUpdates) throws Exception {
            this.updates.addAll(propertyUpdates.getPropertyUpdates());
            return false;
        }

        Set<NodePropertyUpdate> getUpdates() {
            return this.updates;
        }
    }

    private static class CopyUpdateVisitor
    implements Visitor<NodePropertyUpdates, RuntimeException> {
        private NodePropertyUpdates propertyUpdates;

        private CopyUpdateVisitor() {
        }

        public boolean visit(NodePropertyUpdates element) throws RuntimeException {
            this.propertyUpdates = new NodePropertyUpdates();
            this.propertyUpdates.initForNodeId(element.getNodeId());
            this.propertyUpdates.addAll(element.getPropertyUpdates());
            return true;
        }

        public NodePropertyUpdates getPropertyUpdates() {
            return this.propertyUpdates;
        }
    }
}

