/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.transaction.state;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLong;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.mockito.Matchers;
import org.mockito.Mockito;
import org.mockito.invocation.InvocationOnMock;
import org.mockito.stubbing.Answer;
import org.mockito.verification.VerificationMode;
import org.neo4j.collection.primitive.Primitive;
import org.neo4j.collection.primitive.PrimitiveLongCollections;
import org.neo4j.collection.primitive.PrimitiveLongSet;
import org.neo4j.graphdb.Direction;
import org.neo4j.graphdb.factory.GraphDatabaseSettings;
import org.neo4j.helpers.collection.Iterables;
import org.neo4j.helpers.collection.Iterators;
import org.neo4j.helpers.collection.Visitor;
import org.neo4j.kernel.api.exceptions.TransactionFailureException;
import org.neo4j.kernel.api.index.NodePropertyUpdate;
import org.neo4j.kernel.api.index.SchemaIndexProvider;
import org.neo4j.kernel.api.properties.DefinedProperty;
import org.neo4j.kernel.impl.api.BatchTransactionApplier;
import org.neo4j.kernel.impl.api.CommandVisitor;
import org.neo4j.kernel.impl.api.TransactionToApply;
import org.neo4j.kernel.impl.api.index.NodePropertyCommandsExtractor;
import org.neo4j.kernel.impl.api.index.PropertyPhysicalToLogicalConverter;
import org.neo4j.kernel.impl.api.index.TestSchemaIndexProviderDescriptor;
import org.neo4j.kernel.impl.core.CacheAccessBackDoor;
import org.neo4j.kernel.impl.locking.Lock;
import org.neo4j.kernel.impl.locking.LockService;
import org.neo4j.kernel.impl.locking.NoOpClient;
import org.neo4j.kernel.impl.store.DynamicArrayStore;
import org.neo4j.kernel.impl.store.NeoStores;
import org.neo4j.kernel.impl.store.NodeStore;
import org.neo4j.kernel.impl.store.RecordStore;
import org.neo4j.kernel.impl.store.StoreType;
import org.neo4j.kernel.impl.store.format.standard.StandardV3_0;
import org.neo4j.kernel.impl.store.record.DynamicRecord;
import org.neo4j.kernel.impl.store.record.IndexRule;
import org.neo4j.kernel.impl.store.record.NodeRecord;
import org.neo4j.kernel.impl.store.record.PropertyBlock;
import org.neo4j.kernel.impl.store.record.PropertyRecord;
import org.neo4j.kernel.impl.store.record.Record;
import org.neo4j.kernel.impl.store.record.RecordLoad;
import org.neo4j.kernel.impl.store.record.RelationshipGroupRecord;
import org.neo4j.kernel.impl.store.record.RelationshipRecord;
import org.neo4j.kernel.impl.store.record.UniquePropertyConstraintRule;
import org.neo4j.kernel.impl.transaction.CommittedTransactionRepresentation;
import org.neo4j.kernel.impl.transaction.TransactionRepresentation;
import org.neo4j.kernel.impl.transaction.command.Command;
import org.neo4j.kernel.impl.transaction.command.CommandHandlerContract;
import org.neo4j.kernel.impl.transaction.command.NeoStoreBatchTransactionApplier;
import org.neo4j.kernel.impl.transaction.log.FlushableChannel;
import org.neo4j.kernel.impl.transaction.log.InMemoryVersionableReadableClosablePositionAwareChannel;
import org.neo4j.kernel.impl.transaction.log.PhysicalTransactionCursor;
import org.neo4j.kernel.impl.transaction.log.PhysicalTransactionRepresentation;
import org.neo4j.kernel.impl.transaction.log.ReadableClosablePositionAwareChannel;
import org.neo4j.kernel.impl.transaction.log.ReadableLogChannel;
import org.neo4j.kernel.impl.transaction.log.TransactionLogWriter;
import org.neo4j.kernel.impl.transaction.log.entry.LogEntryReader;
import org.neo4j.kernel.impl.transaction.log.entry.LogEntryWriter;
import org.neo4j.kernel.impl.transaction.log.entry.VersionAwareLogEntryReader;
import org.neo4j.kernel.impl.transaction.state.IntegrityValidator;
import org.neo4j.kernel.impl.transaction.state.Loaders;
import org.neo4j.kernel.impl.transaction.state.OnlineIndexUpdates;
import org.neo4j.kernel.impl.transaction.state.PrepareTrackingRecordFormats;
import org.neo4j.kernel.impl.transaction.state.PropertyCreator;
import org.neo4j.kernel.impl.transaction.state.PropertyDeleter;
import org.neo4j.kernel.impl.transaction.state.PropertyLoader;
import org.neo4j.kernel.impl.transaction.state.PropertyTraverser;
import org.neo4j.kernel.impl.transaction.state.RecordAccess;
import org.neo4j.kernel.impl.transaction.state.RecordChangeSet;
import org.neo4j.kernel.impl.transaction.state.RelationshipCreator;
import org.neo4j.kernel.impl.transaction.state.RelationshipDeleter;
import org.neo4j.kernel.impl.transaction.state.RelationshipGroupGetter;
import org.neo4j.kernel.impl.transaction.state.TransactionRecordState;
import org.neo4j.storageengine.api.StorageCommand;
import org.neo4j.storageengine.api.lock.ResourceLocker;
import org.neo4j.storageengine.api.schema.SchemaRule;
import org.neo4j.test.NeoStoresRule;

public class TransactionRecordStateTest {
    private static final String LONG_STRING = "string value long enough not to be stored as a short string";
    @Rule
    public final NeoStoresRule neoStoresRule = new NeoStoresRule(this.getClass(), new StoreType[0]);
    private final IntegrityValidator integrityValidator = (IntegrityValidator)Mockito.mock(IntegrityValidator.class);
    private RecordChangeSet recordChangeSet;

    public static void assertRelationshipGroupDoesNotExist(RecordChangeSet recordChangeSet, NodeRecord node, int type) {
        Assert.assertNull(TransactionRecordStateTest.getRelationshipGroup(recordChangeSet, node, type));
    }

    public static void assertDenseRelationshipCounts(RecordChangeSet recordChangeSet, long nodeId, int type, int outCount, int inCount) {
        RelationshipRecord rel;
        RelationshipGroupRecord group = (RelationshipGroupRecord)TransactionRecordStateTest.getRelationshipGroup(recordChangeSet, (NodeRecord)recordChangeSet.getNodeRecords().getOrLoad((Object)nodeId, null).forReadingData(), type).forReadingData();
        Assert.assertNotNull((Object)group);
        long relId = group.getFirstOut();
        if (relId != (long)Record.NO_NEXT_RELATIONSHIP.intValue()) {
            rel = (RelationshipRecord)recordChangeSet.getRelRecords().getOrLoad((Object)relId, null).forReadingData();
            Assert.assertEquals((String)"Stored relationship count for OUTGOING differs", (long)outCount, (long)rel.getFirstPrevRel());
            Assert.assertEquals((String)"Manually counted relationships for OUTGOING differs", (long)outCount, (long)TransactionRecordStateTest.manuallyCountRelationships(recordChangeSet, nodeId, relId));
        }
        if ((relId = group.getFirstIn()) != (long)Record.NO_NEXT_RELATIONSHIP.intValue()) {
            rel = (RelationshipRecord)recordChangeSet.getRelRecords().getOrLoad((Object)relId, null).forReadingData();
            Assert.assertEquals((String)"Stored relationship count for INCOMING differs", (long)inCount, (long)rel.getSecondPrevRel());
            Assert.assertEquals((String)"Manually counted relationships for INCOMING differs", (long)inCount, (long)TransactionRecordStateTest.manuallyCountRelationships(recordChangeSet, nodeId, relId));
        }
    }

    private static RecordAccess.RecordProxy<Long, RelationshipGroupRecord, Integer> getRelationshipGroup(RecordChangeSet recordChangeSet, NodeRecord node, int type) {
        long groupId = node.getNextRel();
        long previousGroupId = Record.NO_NEXT_RELATIONSHIP.intValue();
        while (groupId != (long)Record.NO_NEXT_RELATIONSHIP.intValue()) {
            RecordAccess.RecordProxy change = recordChangeSet.getRelGroupRecords().getOrLoad((Object)groupId, (Object)type);
            RelationshipGroupRecord record = (RelationshipGroupRecord)change.forReadingData();
            record.setPrev(previousGroupId);
            if (record.getType() == type) {
                return change;
            }
            previousGroupId = groupId;
            groupId = record.getNext();
        }
        return null;
    }

    private static int manuallyCountRelationships(RecordChangeSet recordChangeSet, long nodeId, long firstRelId) {
        int count = 0;
        long relId = firstRelId;
        while (relId != (long)Record.NO_NEXT_RELATIONSHIP.intValue()) {
            ++count;
            RelationshipRecord record = (RelationshipRecord)recordChangeSet.getRelRecords().getOrLoad((Object)relId, null).forReadingData();
            relId = record.getFirstNode() == nodeId ? record.getFirstNextRel() : record.getSecondNextRel();
        }
        return count;
    }

    @Test
    public void shouldCreateEqualNodePropertyUpdatesOnRecoveryOfCreatedNode() throws Exception {
        NeoStores neoStores = this.neoStoresRule.open(new String[0]);
        long nodeId = 0L;
        int labelId = 5;
        int propertyKeyId = 7;
        long ruleId = 0L;
        TransactionRecordState recordState = this.newTransactionRecordState(neoStores);
        IndexRule rule = IndexRule.indexRule((long)ruleId, (int)labelId, (int)propertyKeyId, (SchemaIndexProvider.Descriptor)TestSchemaIndexProviderDescriptor.PROVIDER_DESCRIPTOR);
        recordState.createSchemaRule((SchemaRule)rule);
        this.apply(neoStores, recordState);
        recordState = this.newTransactionRecordState(neoStores);
        recordState.nodeCreate(nodeId);
        recordState.addLabelToNode(labelId, nodeId);
        recordState.nodeAddProperty(nodeId, propertyKeyId, (Object)"Neo");
        PhysicalTransactionRepresentation transaction = this.transactionRepresentationOf(recordState);
        NodePropertyCommandsExtractor extractor = new NodePropertyCommandsExtractor();
        transaction.accept((Visitor)extractor);
        Assert.assertTrue((boolean)extractor.containsAnyNodeOrPropertyUpdate());
        PrimitiveLongSet recoveredNodeIds = Primitive.longSet();
        recoveredNodeIds.addAll(extractor.nodeCommandsById().iterator());
        recoveredNodeIds.addAll(extractor.propertyCommandsByNodeIds().iterator());
        Assert.assertEquals((long)1L, (long)recoveredNodeIds.size());
        Assert.assertEquals((long)nodeId, (long)recoveredNodeIds.iterator().next());
    }

    @Test
    public void shouldWriteProperPropertyRecordsWhenOnlyChangingLinkage() throws Exception {
        NeoStores neoStores = this.neoStoresRule.open(new String[0]);
        TransactionRecordState recordState = this.newTransactionRecordState(neoStores);
        int nodeId = 0;
        recordState.nodeCreate((long)nodeId);
        int index = 0;
        recordState.nodeAddProperty((long)nodeId, index, (Object)this.string(70));
        this.apply(neoStores, recordState);
        recordState = this.newTransactionRecordState(neoStores);
        int index2 = 1;
        recordState.nodeAddProperty((long)nodeId, index2, (Object)this.string(40));
        PhysicalTransactionRepresentation representation = this.transactionRepresentationOf(recordState);
        representation.accept(command -> ((Command)command).handle((CommandVisitor)new CommandVisitor.Adapter(){

            public boolean visitPropertyCommand(Command.PropertyCommand command) throws IOException {
                this.verifyPropertyRecord((PropertyRecord)command.getBefore());
                this.verifyPropertyRecord((PropertyRecord)command.getAfter());
                return false;
            }

            private void verifyPropertyRecord(PropertyRecord record) {
                if (record.getPrevProp() != (long)Record.NO_NEXT_PROPERTY.intValue()) {
                    for (PropertyBlock block : record) {
                        Assert.assertTrue((boolean)block.isLight());
                    }
                }
            }
        }));
    }

    @Test
    public void shouldConvertLabelAdditionToNodePropertyUpdates() throws Exception {
        NeoStores neoStores = this.neoStoresRule.open(new String[0]);
        long nodeId = 0L;
        TransactionRecordState recordState = this.newTransactionRecordState(neoStores);
        int propertyKey1 = 1;
        int propertyKey2 = 2;
        int labelId = 3;
        long[] labelIds = new long[]{labelId};
        String value1 = LONG_STRING;
        byte[] value2 = LONG_STRING.getBytes();
        recordState.nodeCreate(nodeId);
        recordState.nodeAddProperty(nodeId, propertyKey1, (Object)value1);
        recordState.nodeAddProperty(nodeId, propertyKey2, (Object)value2);
        this.apply(neoStores, recordState);
        recordState = this.newTransactionRecordState(neoStores);
        recordState.addLabelToNode(labelId, nodeId);
        Iterable<NodePropertyUpdate> indexUpdates = this.indexUpdatesOf(neoStores, recordState);
        Assert.assertEquals((Object)Iterators.asSet((Object[])new NodePropertyUpdate[]{NodePropertyUpdate.add((long)nodeId, (int)propertyKey1, (Object)value1, (long[])labelIds), NodePropertyUpdate.add((long)nodeId, (int)propertyKey2, (Object)value2, (long[])labelIds)}), (Object)Iterables.asSet(indexUpdates));
    }

    @Test
    public void shouldConvertMixedLabelAdditionAndSetPropertyToNodePropertyUpdates() throws Exception {
        NeoStores neoStores = this.neoStoresRule.open(new String[0]);
        long nodeId = 0L;
        TransactionRecordState recordState = this.newTransactionRecordState(neoStores);
        int propertyKey1 = 1;
        int propertyKey2 = 2;
        int labelId1 = 3;
        int labelId2 = 4;
        String value1 = "first";
        Integer value2 = 4;
        recordState.nodeCreate(nodeId);
        recordState.nodeAddProperty(nodeId, propertyKey1, (Object)value1);
        recordState.addLabelToNode(labelId1, nodeId);
        this.apply(neoStores, recordState);
        recordState = this.newTransactionRecordState(neoStores);
        recordState.nodeAddProperty(nodeId, propertyKey2, (Object)value2);
        recordState.addLabelToNode(labelId2, nodeId);
        Iterable<NodePropertyUpdate> indexUpdates = this.indexUpdatesOf(neoStores, recordState);
        Assert.assertEquals((Object)Iterators.asSet((Object[])new NodePropertyUpdate[]{NodePropertyUpdate.add((long)nodeId, (int)propertyKey1, (Object)value1, (long[])new long[]{labelId2}), NodePropertyUpdate.add((long)nodeId, (int)propertyKey2, (Object)value2, (long[])new long[]{labelId2}), NodePropertyUpdate.add((long)nodeId, (int)propertyKey2, (Object)value2, (long[])new long[]{labelId1})}), (Object)Iterables.asSet(indexUpdates));
    }

    @Test
    public void shouldConvertLabelRemovalToNodePropertyUpdates() throws Exception {
        NeoStores neoStores = this.neoStoresRule.open(new String[0]);
        long nodeId = 0L;
        TransactionRecordState recordState = this.newTransactionRecordState(neoStores);
        int propertyKey1 = 1;
        int propertyKey2 = 2;
        int labelId = 3;
        long[] labelIds = new long[]{labelId};
        String value1 = "first";
        Integer value2 = 4;
        recordState.nodeCreate(nodeId);
        recordState.nodeAddProperty(nodeId, propertyKey1, (Object)value1);
        recordState.nodeAddProperty(nodeId, propertyKey2, (Object)value2);
        recordState.addLabelToNode(labelId, nodeId);
        this.apply(neoStores, recordState);
        recordState = this.newTransactionRecordState(neoStores);
        recordState.removeLabelFromNode(labelId, nodeId);
        Iterable<NodePropertyUpdate> indexUpdates = this.indexUpdatesOf(neoStores, recordState);
        Assert.assertEquals((Object)Iterators.asSet((Object[])new NodePropertyUpdate[]{NodePropertyUpdate.remove((long)nodeId, (int)propertyKey1, (Object)value1, (long[])labelIds), NodePropertyUpdate.remove((long)nodeId, (int)propertyKey2, (Object)value2, (long[])labelIds)}), (Object)Iterables.asSet(indexUpdates));
    }

    @Test
    public void shouldConvertMixedLabelRemovalAndRemovePropertyToNodePropertyUpdates() throws Exception {
        NeoStores neoStores = this.neoStoresRule.open(new String[0]);
        long nodeId = 0L;
        TransactionRecordState recordState = this.newTransactionRecordState(neoStores);
        int propertyKey1 = 1;
        int propertyKey2 = 2;
        int labelId1 = 3;
        int labelId2 = 4;
        String value1 = "first";
        Integer value2 = 4;
        recordState.nodeCreate(nodeId);
        DefinedProperty property1 = recordState.nodeAddProperty(nodeId, propertyKey1, (Object)value1);
        recordState.nodeAddProperty(nodeId, propertyKey2, (Object)value2);
        recordState.addLabelToNode(labelId1, nodeId);
        recordState.addLabelToNode(labelId2, nodeId);
        this.apply(neoStores, recordState);
        recordState = this.newTransactionRecordState(neoStores);
        recordState.nodeRemoveProperty(nodeId, property1.propertyKeyId());
        recordState.removeLabelFromNode(labelId2, nodeId);
        Iterable<NodePropertyUpdate> indexUpdates = this.indexUpdatesOf(neoStores, recordState);
        Assert.assertEquals((Object)Iterators.asSet((Object[])new NodePropertyUpdate[]{NodePropertyUpdate.remove((long)nodeId, (int)propertyKey1, (Object)value1, (long[])new long[]{labelId1, labelId2}), NodePropertyUpdate.remove((long)nodeId, (int)propertyKey2, (Object)value2, (long[])new long[]{labelId2})}), (Object)Iterables.asSet(indexUpdates));
    }

    @Test
    public void shouldConvertMixedLabelRemovalAndAddPropertyToNodePropertyUpdates() throws Exception {
        NeoStores neoStores = this.neoStoresRule.open(new String[0]);
        long nodeId = 0L;
        TransactionRecordState recordState = this.newTransactionRecordState(neoStores);
        int propertyKey1 = 1;
        int propertyKey2 = 2;
        int labelId1 = 3;
        int labelId2 = 4;
        String value1 = "first";
        Integer value2 = 4;
        recordState.nodeCreate(nodeId);
        recordState.nodeAddProperty(nodeId, propertyKey1, (Object)value1);
        recordState.addLabelToNode(labelId1, nodeId);
        recordState.addLabelToNode(labelId2, nodeId);
        this.apply(neoStores, recordState);
        recordState = this.newTransactionRecordState(neoStores);
        recordState.nodeAddProperty(nodeId, propertyKey2, (Object)value2);
        recordState.removeLabelFromNode(labelId2, nodeId);
        Iterable<NodePropertyUpdate> indexUpdates = this.indexUpdatesOf(neoStores, recordState);
        Assert.assertEquals((Object)Iterators.asSet((Object[])new NodePropertyUpdate[]{NodePropertyUpdate.add((long)nodeId, (int)propertyKey2, (Object)value2, (long[])new long[]{labelId1}), NodePropertyUpdate.remove((long)nodeId, (int)propertyKey1, (Object)value1, (long[])new long[]{labelId2}), NodePropertyUpdate.remove((long)nodeId, (int)propertyKey2, (Object)value2, (long[])new long[]{labelId2})}), (Object)Iterables.asSet(indexUpdates));
    }

    @Test
    public void shouldConvertChangedPropertyToNodePropertyUpdates() throws Exception {
        NeoStores neoStores = this.neoStoresRule.open(new String[0]);
        int nodeId = 0;
        TransactionRecordState recordState = this.newTransactionRecordState(neoStores);
        int propertyKey1 = 1;
        int propertyKey2 = 2;
        String value1 = "first";
        Integer value2 = 4;
        recordState.nodeCreate((long)nodeId);
        DefinedProperty property1 = recordState.nodeAddProperty((long)nodeId, propertyKey1, (Object)value1);
        DefinedProperty property2 = recordState.nodeAddProperty((long)nodeId, propertyKey2, (Object)value2);
        this.apply(neoStores, (TransactionRepresentation)this.transactionRepresentationOf(recordState));
        String newValue1 = "new";
        String newValue2 = "new 2";
        recordState = this.newTransactionRecordState(neoStores);
        recordState.nodeChangeProperty((long)nodeId, property1.propertyKeyId(), (Object)newValue1);
        recordState.nodeChangeProperty((long)nodeId, property2.propertyKeyId(), (Object)newValue2);
        Iterable<NodePropertyUpdate> indexUpdates = this.indexUpdatesOf(neoStores, recordState);
        Assert.assertEquals((Object)Iterators.asSet((Object[])new NodePropertyUpdate[]{NodePropertyUpdate.change((long)nodeId, (int)propertyKey1, (Object)value1, (long[])PrimitiveLongCollections.EMPTY_LONG_ARRAY, (Object)newValue1, (long[])PrimitiveLongCollections.EMPTY_LONG_ARRAY), NodePropertyUpdate.change((long)nodeId, (int)propertyKey2, (Object)value2, (long[])PrimitiveLongCollections.EMPTY_LONG_ARRAY, (Object)newValue2, (long[])PrimitiveLongCollections.EMPTY_LONG_ARRAY)}), (Object)Iterables.asSet(indexUpdates));
    }

    @Test
    public void shouldConvertRemovedPropertyToNodePropertyUpdates() throws Exception {
        NeoStores neoStores = this.neoStoresRule.open(new String[0]);
        int nodeId = 0;
        TransactionRecordState recordState = this.newTransactionRecordState(neoStores);
        int propertyKey1 = 1;
        int propertyKey2 = 2;
        int labelId = 3;
        String value1 = "first";
        Integer value2 = 4;
        recordState.nodeCreate((long)nodeId);
        recordState.addLabelToNode(labelId, (long)nodeId);
        DefinedProperty property1 = recordState.nodeAddProperty((long)nodeId, propertyKey1, (Object)value1);
        DefinedProperty property2 = recordState.nodeAddProperty((long)nodeId, propertyKey2, (Object)value2);
        this.apply(neoStores, (TransactionRepresentation)this.transactionRepresentationOf(recordState));
        recordState = this.newTransactionRecordState(neoStores);
        recordState.nodeRemoveProperty((long)nodeId, property1.propertyKeyId());
        recordState.nodeRemoveProperty((long)nodeId, property2.propertyKeyId());
        Iterable<NodePropertyUpdate> indexUpdates = this.indexUpdatesOf(neoStores, recordState);
        Assert.assertEquals((Object)Iterators.asSet((Object[])new NodePropertyUpdate[]{NodePropertyUpdate.remove((long)nodeId, (int)propertyKey1, (Object)value1, (long[])new long[]{labelId}), NodePropertyUpdate.remove((long)nodeId, (int)propertyKey2, (Object)value2, (long[])new long[]{labelId})}), (Object)Iterables.asSet(indexUpdates));
    }

    @Test
    public void shouldDeleteDynamicLabelsForDeletedNode() throws Throwable {
        NeoStores store = this.neoStoresRule.open(new String[0]);
        NeoStoreBatchTransactionApplier applier = new NeoStoreBatchTransactionApplier(store, (CacheAccessBackDoor)Mockito.mock(CacheAccessBackDoor.class), LockService.NO_LOCK_SERVICE);
        AtomicLong nodeId = new AtomicLong();
        AtomicLong dynamicLabelRecordId = new AtomicLong();
        this.apply((BatchTransactionApplier)applier, this.transaction(this.nodeWithDynamicLabelRecord(store, nodeId, dynamicLabelRecordId)));
        this.assertDynamicLabelRecordInUse(store, dynamicLabelRecordId.get(), true);
        this.apply((BatchTransactionApplier)applier, this.transaction(this.deleteNode(store, nodeId.get())));
        this.assertDynamicLabelRecordInUse(store, dynamicLabelRecordId.get(), false);
    }

    @Test
    public void shouldDeleteDynamicLabelsForDeletedNodeForRecoveredTransaction() throws Throwable {
        NeoStores store = this.neoStoresRule.open(new String[0]);
        NeoStoreBatchTransactionApplier applier = new NeoStoreBatchTransactionApplier(store, (CacheAccessBackDoor)Mockito.mock(CacheAccessBackDoor.class), LockService.NO_LOCK_SERVICE);
        AtomicLong nodeId = new AtomicLong();
        AtomicLong dynamicLabelRecordId = new AtomicLong();
        this.apply((BatchTransactionApplier)applier, this.transaction(this.nodeWithDynamicLabelRecord(store, nodeId, dynamicLabelRecordId)));
        this.assertDynamicLabelRecordInUse(store, dynamicLabelRecordId.get(), true);
        TransactionRepresentation transaction = this.transaction(this.deleteNode(store, nodeId.get()));
        InMemoryVersionableReadableClosablePositionAwareChannel channel = new InMemoryVersionableReadableClosablePositionAwareChannel();
        this.writeToChannel(transaction, (FlushableChannel)channel);
        CommittedTransactionRepresentation recoveredTransaction = this.readFromChannel(channel);
        this.apply((BatchTransactionApplier)applier, recoveredTransaction.getTransactionRepresentation());
        this.assertDynamicLabelRecordInUse(store, dynamicLabelRecordId.get(), false);
    }

    @Test
    public void shouldExtractCreatedCommandsInCorrectOrder() throws Throwable {
        NeoStores neoStores = this.neoStoresRule.open(GraphDatabaseSettings.dense_node_threshold.name(), "1");
        TransactionRecordState recordState = this.newTransactionRecordState(neoStores);
        long nodeId = 0L;
        long relId = 1L;
        recordState.nodeCreate(nodeId);
        recordState.relCreate(relId++, 0, nodeId, nodeId);
        recordState.relCreate(relId, 0, nodeId, nodeId);
        recordState.nodeAddProperty(nodeId, 0, (Object)101);
        ArrayList commands = new ArrayList();
        recordState.extractCommands(commands);
        Iterator commandIterator = commands.iterator();
        this.assertCommand((StorageCommand)commandIterator.next(), Command.PropertyCommand.class);
        this.assertCommand((StorageCommand)commandIterator.next(), Command.RelationshipCommand.class);
        this.assertCommand((StorageCommand)commandIterator.next(), Command.RelationshipCommand.class);
        this.assertCommand((StorageCommand)commandIterator.next(), Command.RelationshipGroupCommand.class);
        this.assertCommand((StorageCommand)commandIterator.next(), Command.NodeCommand.class);
        Assert.assertFalse((boolean)commandIterator.hasNext());
    }

    @Test
    public void shouldExtractUpdateCommandsInCorrectOrder() throws Throwable {
        NeoStores neoStores = this.neoStoresRule.open(GraphDatabaseSettings.dense_node_threshold.name(), "1");
        TransactionRecordState recordState = this.newTransactionRecordState(neoStores);
        long nodeId = 0L;
        long relId1 = 1L;
        long relId2 = 2L;
        long relId3 = 3L;
        recordState.nodeCreate(nodeId);
        recordState.relCreate(relId1, 0, nodeId, nodeId);
        recordState.relCreate(relId2, 0, nodeId, nodeId);
        recordState.nodeAddProperty(nodeId, 0, (Object)101);
        NeoStoreBatchTransactionApplier applier = new NeoStoreBatchTransactionApplier(neoStores, (CacheAccessBackDoor)Mockito.mock(CacheAccessBackDoor.class), LockService.NO_LOCK_SERVICE);
        this.apply((BatchTransactionApplier)applier, this.transaction(recordState));
        recordState = this.newTransactionRecordState(neoStores);
        recordState.nodeChangeProperty(nodeId, 0, (Object)102);
        recordState.relCreate(relId3, 0, nodeId, nodeId);
        recordState.relAddProperty(relId1, 0, (Object)123);
        ArrayList commands = new ArrayList();
        recordState.extractCommands(commands);
        Iterator commandIterator = commands.iterator();
        this.assertCommand((StorageCommand)commandIterator.next(), Command.PropertyCommand.class);
        this.assertCommand((StorageCommand)commandIterator.next(), Command.RelationshipCommand.class);
        this.assertCommand((StorageCommand)commandIterator.next(), Command.PropertyCommand.class);
        this.assertCommand((StorageCommand)commandIterator.next(), Command.RelationshipCommand.class);
        this.assertCommand((StorageCommand)commandIterator.next(), Command.RelationshipCommand.class);
        this.assertCommand((StorageCommand)commandIterator.next(), Command.RelationshipGroupCommand.class);
        this.assertCommand((StorageCommand)commandIterator.next(), Command.NodeCommand.class);
        Assert.assertFalse((boolean)commandIterator.hasNext());
    }

    @Test
    public void shouldIgnoreRelationshipGroupCommandsForGroupThatIsCreatedAndDeletedInThisTx() throws Exception {
        NeoStores neoStore = this.neoStoresRule.open(GraphDatabaseSettings.dense_node_threshold.name(), "5");
        int A = 0;
        int B = 1;
        TransactionRecordState state = this.newTransactionRecordState(neoStore);
        state.nodeCreate(0L);
        state.relCreate(0L, A, 0L, 0L);
        state.relCreate(1L, A, 0L, 0L);
        state.relCreate(2L, A, 0L, 0L);
        state.relCreate(3L, A, 0L, 0L);
        state.relCreate(4L, B, 0L, 0L);
        this.apply(neoStore, state);
        state = this.newTransactionRecordState(neoStore);
        state.relCreate(5L, A, 0L, 0L);
        state.relDelete(4L);
        ArrayList<StorageCommand> commands = new ArrayList<StorageCommand>();
        state.extractCommands(commands);
        Command.RelationshipGroupCommand group = this.singleRelationshipGroupCommand(commands);
        Assert.assertEquals((long)A, (long)((RelationshipGroupRecord)group.getAfter()).getType());
    }

    @Test
    public void shouldExtractDeleteCommandsInCorrectOrder() throws Exception {
        NeoStores neoStores = this.neoStoresRule.open(GraphDatabaseSettings.dense_node_threshold.name(), "1");
        TransactionRecordState recordState = this.newTransactionRecordState(neoStores);
        long nodeId1 = 0L;
        long nodeId2 = 1L;
        long relId1 = 1L;
        long relId2 = 2L;
        long relId4 = 10L;
        recordState.nodeCreate(nodeId1);
        recordState.nodeCreate(nodeId2);
        recordState.relCreate(relId1, 0, nodeId1, nodeId1);
        recordState.relCreate(relId2, 0, nodeId1, nodeId1);
        recordState.relCreate(relId4, 1, nodeId1, nodeId1);
        recordState.nodeAddProperty(nodeId1, 0, (Object)101);
        NeoStoreBatchTransactionApplier applier = new NeoStoreBatchTransactionApplier(neoStores, (CacheAccessBackDoor)Mockito.mock(CacheAccessBackDoor.class), LockService.NO_LOCK_SERVICE);
        this.apply((BatchTransactionApplier)applier, this.transaction(recordState));
        recordState = this.newTransactionRecordState(neoStores);
        recordState.relDelete(relId4);
        recordState.nodeDelete(nodeId2);
        recordState.nodeRemoveProperty(nodeId1, 0);
        ArrayList commands = new ArrayList();
        recordState.extractCommands(commands);
        Iterator commandIterator = commands.iterator();
        this.assertCommand((StorageCommand)commandIterator.next(), Command.RelationshipGroupCommand.class);
        this.assertCommand((StorageCommand)commandIterator.next(), Command.NodeCommand.class);
        this.assertCommand((StorageCommand)commandIterator.next(), Command.PropertyCommand.class);
        this.assertCommand((StorageCommand)commandIterator.next(), Command.RelationshipCommand.class);
        this.assertCommand((StorageCommand)commandIterator.next(), Command.RelationshipGroupCommand.class);
        this.assertCommand((StorageCommand)commandIterator.next(), Command.NodeCommand.class);
        Assert.assertFalse((boolean)commandIterator.hasNext());
    }

    @Test
    public void shouldValidateConstraintIndexAsPartOfExtraction() throws Throwable {
        NeoStores neoStores = this.neoStoresRule.open(new String[0]);
        TransactionRecordState recordState = this.newTransactionRecordState(neoStores);
        long indexId = neoStores.getSchemaStore().nextId();
        long constraintId = neoStores.getSchemaStore().nextId();
        recordState.createSchemaRule((SchemaRule)UniquePropertyConstraintRule.uniquenessConstraintRule((long)constraintId, (int)1, (int)1, (long)indexId));
        recordState.extractCommands(new ArrayList());
        ((IntegrityValidator)Mockito.verify((Object)this.integrityValidator)).validateSchemaRule((SchemaRule)Matchers.any());
    }

    @Test
    public void shouldCreateProperBeforeAndAfterPropertyCommandsWhenAddingProperty() throws Exception {
        NeoStores neoStores = this.neoStoresRule.open(new String[0]);
        TransactionRecordState recordState = this.newTransactionRecordState(neoStores);
        int nodeId = 1;
        recordState.nodeCreate((long)nodeId);
        int propertyKey = 1;
        Integer value = 5;
        recordState.nodeAddProperty((long)nodeId, propertyKey, (Object)value);
        ArrayList<StorageCommand> commands = new ArrayList<StorageCommand>();
        recordState.extractCommands(commands);
        Command.PropertyCommand propertyCommand = this.singlePropertyCommand(commands);
        PropertyRecord before = (PropertyRecord)propertyCommand.getBefore();
        Assert.assertFalse((boolean)before.inUse());
        Assert.assertFalse((boolean)before.iterator().hasNext());
        PropertyRecord after = (PropertyRecord)propertyCommand.getAfter();
        Assert.assertTrue((boolean)after.inUse());
        Assert.assertEquals((long)1L, (long)Iterables.count((Iterable)after));
    }

    @Test
    public void shouldConvertAddedPropertyToNodePropertyUpdates() throws Exception {
        NeoStores neoStores = this.neoStoresRule.open(new String[0]);
        long nodeId = 0L;
        TransactionRecordState recordState = this.newTransactionRecordState(neoStores);
        int labelId = 3;
        int propertyKey1 = 1;
        int propertyKey2 = 2;
        String value1 = "first";
        Integer value2 = 4;
        recordState.nodeCreate(nodeId);
        recordState.addLabelToNode(labelId, nodeId);
        recordState.nodeAddProperty(nodeId, propertyKey1, (Object)value1);
        recordState.nodeAddProperty(nodeId, propertyKey2, (Object)value2);
        Iterable<NodePropertyUpdate> updates = this.indexUpdatesOf(neoStores, recordState);
        Assert.assertEquals((Object)Iterators.asSet((Object[])new NodePropertyUpdate[]{NodePropertyUpdate.add((long)nodeId, (int)propertyKey1, (Object)value1, (long[])new long[]{labelId}), NodePropertyUpdate.add((long)nodeId, (int)propertyKey2, (Object)value2, (long[])new long[]{labelId})}), (Object)Iterables.asSet(updates));
    }

    @Test
    public void shouldLockUpdatedNodes() throws Exception {
        LockService locks = (LockService)Mockito.mock(LockService.class, (Answer)new Answer<Object>(){

            public synchronized Object answer(InvocationOnMock invocation) throws Throwable {
                String name = invocation.getMethod().getName();
                if (name.equals("acquireNodeLock") || name.equals("acquireRelationshipLock")) {
                    return Mockito.mock(Lock.class, invocationOnMock -> null);
                }
                return null;
            }
        });
        NeoStores neoStores = this.neoStoresRule.open(new String[0]);
        NodeStore nodeStore = neoStores.getNodeStore();
        long[] nodes = new long[]{nodeStore.nextId(), nodeStore.nextId(), nodeStore.nextId(), nodeStore.nextId(), nodeStore.nextId(), nodeStore.nextId(), nodeStore.nextId()};
        TransactionRecordState tx = this.newTransactionRecordState(neoStores);
        for (int i = 1; i < nodes.length - 1; ++i) {
            tx.nodeCreate(nodes[i]);
        }
        tx.nodeAddProperty(nodes[3], 0, (Object)"old");
        tx.nodeAddProperty(nodes[4], 0, (Object)"old");
        NeoStoreBatchTransactionApplier applier = new NeoStoreBatchTransactionApplier(neoStores, (CacheAccessBackDoor)Mockito.mock(CacheAccessBackDoor.class), locks);
        this.apply((BatchTransactionApplier)applier, this.transaction(tx));
        Mockito.reset((Object[])new LockService[]{locks});
        tx = this.newTransactionRecordState(neoStores);
        tx.nodeCreate(nodes[0]);
        tx.addLabelToNode(0, nodes[1]);
        tx.nodeAddProperty(nodes[2], 0, (Object)"value");
        tx.nodeChangeProperty(nodes[3], 0, (Object)"value");
        tx.nodeRemoveProperty(nodes[4], 0);
        tx.nodeDelete(nodes[5]);
        tx.nodeCreate(nodes[6]);
        tx.addLabelToNode(0, nodes[6]);
        tx.nodeAddProperty(nodes[6], 0, (Object)"value");
        applier = new NeoStoreBatchTransactionApplier(neoStores, (CacheAccessBackDoor)Mockito.mock(CacheAccessBackDoor.class), locks);
        this.apply((BatchTransactionApplier)applier, this.transaction(tx));
        ((LockService)Mockito.verify((Object)locks, (VerificationMode)Mockito.times((int)1))).acquireNodeLock(nodes[0], LockService.LockType.WRITE_LOCK);
        ((LockService)Mockito.verify((Object)locks, (VerificationMode)Mockito.times((int)1))).acquireNodeLock(nodes[1], LockService.LockType.WRITE_LOCK);
        ((LockService)Mockito.verify((Object)locks, (VerificationMode)Mockito.times((int)2))).acquireNodeLock(nodes[2], LockService.LockType.WRITE_LOCK);
        ((LockService)Mockito.verify((Object)locks, (VerificationMode)Mockito.times((int)1))).acquireNodeLock(nodes[3], LockService.LockType.WRITE_LOCK);
        ((LockService)Mockito.verify((Object)locks, (VerificationMode)Mockito.times((int)2))).acquireNodeLock(nodes[4], LockService.LockType.WRITE_LOCK);
        ((LockService)Mockito.verify((Object)locks, (VerificationMode)Mockito.times((int)1))).acquireNodeLock(nodes[5], LockService.LockType.WRITE_LOCK);
        ((LockService)Mockito.verify((Object)locks, (VerificationMode)Mockito.times((int)2))).acquireNodeLock(nodes[6], LockService.LockType.WRITE_LOCK);
    }

    @Test
    public void movingBilaterallyOfTheDenseNodeThresholdIsConsistent() throws Exception {
        long[] relationshipsOfTypeB;
        NeoStores neoStores = this.neoStoresRule.open(GraphDatabaseSettings.dense_node_threshold.name(), "10");
        TransactionRecordState tx = this.newTransactionRecordState(neoStores);
        long nodeId = neoStores.getNodeStore().nextId();
        tx.nodeCreate(nodeId);
        int typeA = (int)neoStores.getRelationshipTypeTokenStore().nextId();
        tx.createRelationshipTypeToken("A", typeA);
        this.createRelationships(neoStores, tx, nodeId, typeA, Direction.INCOMING, 20);
        NeoStoreBatchTransactionApplier applier = new NeoStoreBatchTransactionApplier(neoStores, (CacheAccessBackDoor)Mockito.mock(CacheAccessBackDoor.class), LockService.NO_LOCK_SERVICE);
        this.apply((BatchTransactionApplier)applier, this.transaction(tx));
        tx = this.newTransactionRecordState(neoStores);
        int typeB = 1;
        tx.createRelationshipTypeToken("B", typeB);
        for (long relationshipToDelete : relationshipsOfTypeB = this.createRelationships(neoStores, tx, nodeId, typeB, Direction.OUTGOING, 5)) {
            tx.relDelete(relationshipToDelete);
        }
        PhysicalTransactionRepresentation ptx = this.transactionRepresentationOf(tx);
        this.apply((BatchTransactionApplier)applier, (TransactionRepresentation)ptx);
        final AtomicBoolean foundRelationshipGroupInUse = new AtomicBoolean();
        ptx.accept(command -> ((Command)command).handle((CommandVisitor)new CommandVisitor.Adapter(){

            public boolean visitRelationshipGroupCommand(Command.RelationshipGroupCommand command) throws IOException {
                if (((RelationshipGroupRecord)command.getAfter()).inUse()) {
                    if (!foundRelationshipGroupInUse.get()) {
                        foundRelationshipGroupInUse.set(true);
                    } else {
                        Assert.fail();
                    }
                }
                return false;
            }
        }));
        Assert.assertTrue((String)"Did not create relationship group command", (boolean)foundRelationshipGroupInUse.get());
    }

    @Test
    public void shouldConvertToDenseNodeRepresentationWhenHittingThresholdWithDifferentTypes() throws Exception {
        NeoStores neoStores = this.neoStoresRule.open(GraphDatabaseSettings.dense_node_threshold.name(), "50");
        TransactionRecordState tx = this.newTransactionRecordState(neoStores);
        long nodeId = neoStores.getNodeStore().nextId();
        int typeA = 0;
        int typeB = 1;
        int typeC = 2;
        tx.nodeCreate(nodeId);
        tx.createRelationshipTypeToken("A", typeA);
        this.createRelationships(neoStores, tx, nodeId, typeA, Direction.OUTGOING, 6);
        this.createRelationships(neoStores, tx, nodeId, typeA, Direction.INCOMING, 7);
        tx.createRelationshipTypeToken("B", typeB);
        this.createRelationships(neoStores, tx, nodeId, typeB, Direction.OUTGOING, 8);
        this.createRelationships(neoStores, tx, nodeId, typeB, Direction.INCOMING, 9);
        tx.createRelationshipTypeToken("C", typeC);
        this.createRelationships(neoStores, tx, nodeId, typeC, Direction.OUTGOING, 10);
        this.createRelationships(neoStores, tx, nodeId, typeC, Direction.INCOMING, 10);
        Assert.assertFalse((boolean)((NodeRecord)this.recordChangeSet.getNodeRecords().getOrLoad((Object)nodeId, null).forReadingData()).isDense());
        this.createRelationships(neoStores, tx, nodeId, typeC, Direction.INCOMING, 1);
        Assert.assertTrue((boolean)((NodeRecord)this.recordChangeSet.getNodeRecords().getOrLoad((Object)nodeId, null).forReadingData()).isDense());
        TransactionRecordStateTest.assertDenseRelationshipCounts(this.recordChangeSet, nodeId, typeA, 6, 7);
        TransactionRecordStateTest.assertDenseRelationshipCounts(this.recordChangeSet, nodeId, typeB, 8, 9);
        TransactionRecordStateTest.assertDenseRelationshipCounts(this.recordChangeSet, nodeId, typeC, 10, 11);
    }

    @Test
    public void shouldConvertToDenseNodeRepresentationWhenHittingThresholdWithTheSameTypeDifferentDirection() throws Exception {
        NeoStores neoStores = this.neoStoresRule.open(GraphDatabaseSettings.dense_node_threshold.name(), "49");
        TransactionRecordState tx = this.newTransactionRecordState(neoStores);
        long nodeId = neoStores.getNodeStore().nextId();
        int typeA = 0;
        tx.nodeCreate(nodeId);
        tx.createRelationshipTypeToken("A", typeA);
        this.createRelationships(neoStores, tx, nodeId, typeA, Direction.OUTGOING, 24);
        this.createRelationships(neoStores, tx, nodeId, typeA, Direction.INCOMING, 25);
        Assert.assertFalse((boolean)((NodeRecord)this.recordChangeSet.getNodeRecords().getOrLoad((Object)nodeId, null).forReadingData()).isDense());
        this.createRelationships(neoStores, tx, nodeId, typeA, Direction.INCOMING, 1);
        Assert.assertTrue((boolean)((NodeRecord)this.recordChangeSet.getNodeRecords().getOrLoad((Object)nodeId, null).forReadingData()).isDense());
        TransactionRecordStateTest.assertDenseRelationshipCounts(this.recordChangeSet, nodeId, typeA, 24, 26);
    }

    @Test
    public void shouldConvertToDenseNodeRepresentationWhenHittingThresholdWithTheSameTypeSameDirection() throws Exception {
        NeoStores neoStores = this.neoStoresRule.open(GraphDatabaseSettings.dense_node_threshold.name(), "8");
        TransactionRecordState tx = this.newTransactionRecordState(neoStores);
        long nodeId = neoStores.getNodeStore().nextId();
        int typeA = 0;
        tx.nodeCreate(nodeId);
        tx.createRelationshipTypeToken("A", typeA);
        this.createRelationships(neoStores, tx, nodeId, typeA, Direction.OUTGOING, 8);
        Assert.assertFalse((boolean)((NodeRecord)this.recordChangeSet.getNodeRecords().getOrLoad((Object)nodeId, null).forReadingData()).isDense());
        this.createRelationships(neoStores, tx, nodeId, typeA, Direction.OUTGOING, 1);
        Assert.assertTrue((boolean)((NodeRecord)this.recordChangeSet.getNodeRecords().getOrLoad((Object)nodeId, null).forReadingData()).isDense());
        TransactionRecordStateTest.assertDenseRelationshipCounts(this.recordChangeSet, nodeId, typeA, 9, 0);
    }

    @Test
    public void shouldMaintainCorrectDataWhenDeletingFromDenseNodeWithOneType() throws Exception {
        NeoStores neoStores = this.neoStoresRule.open(GraphDatabaseSettings.dense_node_threshold.name(), "13");
        TransactionRecordState tx = this.newTransactionRecordState(neoStores);
        int nodeId = (int)neoStores.getNodeStore().nextId();
        int typeA = 0;
        tx.nodeCreate((long)nodeId);
        tx.createRelationshipTypeToken("A", typeA);
        long[] relationshipsCreated = this.createRelationships(neoStores, tx, nodeId, typeA, Direction.INCOMING, 15);
        tx.relDelete(relationshipsCreated[0]);
        TransactionRecordStateTest.assertDenseRelationshipCounts(this.recordChangeSet, nodeId, typeA, 0, 14);
    }

    @Test
    public void shouldMaintainCorrectDataWhenDeletingFromDenseNodeWithManyTypes() throws Exception {
        NeoStores neoStores = this.neoStoresRule.open(GraphDatabaseSettings.dense_node_threshold.name(), "1");
        TransactionRecordState tx = this.newTransactionRecordState(neoStores);
        long nodeId = neoStores.getNodeStore().nextId();
        int typeA = 0;
        int typeB = 12;
        int typeC = 600;
        tx.nodeCreate(nodeId);
        tx.createRelationshipTypeToken("A", typeA);
        long[] relationshipsCreatedAIncoming = this.createRelationships(neoStores, tx, nodeId, typeA, Direction.INCOMING, 1);
        long[] relationshipsCreatedAOutgoing = this.createRelationships(neoStores, tx, nodeId, typeA, Direction.OUTGOING, 1);
        tx.createRelationshipTypeToken("B", typeB);
        long[] relationshipsCreatedBIncoming = this.createRelationships(neoStores, tx, nodeId, typeB, Direction.INCOMING, 1);
        long[] relationshipsCreatedBOutgoing = this.createRelationships(neoStores, tx, nodeId, typeB, Direction.OUTGOING, 1);
        tx.createRelationshipTypeToken("C", typeC);
        long[] relationshipsCreatedCIncoming = this.createRelationships(neoStores, tx, nodeId, typeC, Direction.INCOMING, 1);
        long[] relationshipsCreatedCOutgoing = this.createRelationships(neoStores, tx, nodeId, typeC, Direction.OUTGOING, 1);
        tx.relDelete(relationshipsCreatedAIncoming[0]);
        TransactionRecordStateTest.assertDenseRelationshipCounts(this.recordChangeSet, nodeId, typeA, 1, 0);
        TransactionRecordStateTest.assertDenseRelationshipCounts(this.recordChangeSet, nodeId, typeB, 1, 1);
        TransactionRecordStateTest.assertDenseRelationshipCounts(this.recordChangeSet, nodeId, typeC, 1, 1);
        tx.relDelete(relationshipsCreatedAOutgoing[0]);
        TransactionRecordStateTest.assertRelationshipGroupDoesNotExist(this.recordChangeSet, (NodeRecord)this.recordChangeSet.getNodeRecords().getOrLoad((Object)nodeId, null).forReadingData(), typeA);
        TransactionRecordStateTest.assertDenseRelationshipCounts(this.recordChangeSet, nodeId, typeB, 1, 1);
        TransactionRecordStateTest.assertDenseRelationshipCounts(this.recordChangeSet, nodeId, typeC, 1, 1);
        tx.relDelete(relationshipsCreatedBIncoming[0]);
        TransactionRecordStateTest.assertRelationshipGroupDoesNotExist(this.recordChangeSet, (NodeRecord)this.recordChangeSet.getNodeRecords().getOrLoad((Object)nodeId, null).forReadingData(), typeA);
        TransactionRecordStateTest.assertDenseRelationshipCounts(this.recordChangeSet, nodeId, typeB, 1, 0);
        TransactionRecordStateTest.assertDenseRelationshipCounts(this.recordChangeSet, nodeId, typeC, 1, 1);
        tx.relDelete(relationshipsCreatedBOutgoing[0]);
        TransactionRecordStateTest.assertRelationshipGroupDoesNotExist(this.recordChangeSet, (NodeRecord)this.recordChangeSet.getNodeRecords().getOrLoad((Object)nodeId, null).forReadingData(), typeA);
        TransactionRecordStateTest.assertRelationshipGroupDoesNotExist(this.recordChangeSet, (NodeRecord)this.recordChangeSet.getNodeRecords().getOrLoad((Object)nodeId, null).forReadingData(), typeB);
        TransactionRecordStateTest.assertDenseRelationshipCounts(this.recordChangeSet, nodeId, typeC, 1, 1);
        tx.relDelete(relationshipsCreatedCIncoming[0]);
        TransactionRecordStateTest.assertRelationshipGroupDoesNotExist(this.recordChangeSet, (NodeRecord)this.recordChangeSet.getNodeRecords().getOrLoad((Object)nodeId, null).forReadingData(), typeA);
        TransactionRecordStateTest.assertRelationshipGroupDoesNotExist(this.recordChangeSet, (NodeRecord)this.recordChangeSet.getNodeRecords().getOrLoad((Object)nodeId, null).forReadingData(), typeB);
        TransactionRecordStateTest.assertDenseRelationshipCounts(this.recordChangeSet, nodeId, typeC, 1, 0);
        tx.relDelete(relationshipsCreatedCOutgoing[0]);
        TransactionRecordStateTest.assertRelationshipGroupDoesNotExist(this.recordChangeSet, (NodeRecord)this.recordChangeSet.getNodeRecords().getOrLoad((Object)nodeId, null).forReadingData(), typeA);
        TransactionRecordStateTest.assertRelationshipGroupDoesNotExist(this.recordChangeSet, (NodeRecord)this.recordChangeSet.getNodeRecords().getOrLoad((Object)nodeId, null).forReadingData(), typeB);
        TransactionRecordStateTest.assertRelationshipGroupDoesNotExist(this.recordChangeSet, (NodeRecord)this.recordChangeSet.getNodeRecords().getOrLoad((Object)nodeId, null).forReadingData(), typeC);
    }

    @Test
    public void shouldSortRelationshipGroups() throws Throwable {
        int type5 = 5;
        int type10 = 10;
        int type15 = 15;
        NeoStores neoStores = this.neoStoresRule.open(GraphDatabaseSettings.dense_node_threshold.name(), "1");
        TransactionRecordState recordState = this.newTransactionRecordState(neoStores);
        neoStores.getRelationshipTypeTokenStore().setHighId(16L);
        recordState.createRelationshipTypeToken("5", type5);
        recordState.createRelationshipTypeToken("10", type10);
        recordState.createRelationshipTypeToken("15", type15);
        NeoStoreBatchTransactionApplier applier = new NeoStoreBatchTransactionApplier(neoStores, (CacheAccessBackDoor)Mockito.mock(CacheAccessBackDoor.class), LockService.NO_LOCK_SERVICE);
        this.apply((BatchTransactionApplier)applier, this.transaction(recordState));
        long nodeId = neoStores.getNodeStore().nextId();
        long otherNode1Id = neoStores.getNodeStore().nextId();
        long otherNode2Id = neoStores.getNodeStore().nextId();
        TransactionRecordState recordState2 = this.newTransactionRecordState(neoStores);
        recordState2.nodeCreate(nodeId);
        recordState2.nodeCreate(otherNode1Id);
        recordState2.nodeCreate(otherNode2Id);
        recordState2.relCreate(neoStores.getRelationshipStore().nextId(), type10, nodeId, otherNode1Id);
        recordState2.relCreate(neoStores.getRelationshipStore().nextId(), type10, nodeId, otherNode2Id);
        NeoStoreBatchTransactionApplier applier2 = new NeoStoreBatchTransactionApplier(neoStores, (CacheAccessBackDoor)Mockito.mock(CacheAccessBackDoor.class), LockService.NO_LOCK_SERVICE);
        this.apply((BatchTransactionApplier)applier2, this.transaction(recordState2));
        this.assertRelationshipGroupsInOrder(neoStores, nodeId, type10);
        TransactionRecordState recordState3 = this.newTransactionRecordState(neoStores);
        long otherNodeId = neoStores.getNodeStore().nextId();
        recordState3.nodeCreate(otherNodeId);
        recordState3.relCreate(neoStores.getRelationshipStore().nextId(), type5, nodeId, otherNodeId);
        NeoStoreBatchTransactionApplier applier3 = new NeoStoreBatchTransactionApplier(neoStores, (CacheAccessBackDoor)Mockito.mock(CacheAccessBackDoor.class), LockService.NO_LOCK_SERVICE);
        this.apply((BatchTransactionApplier)applier3, this.transaction(recordState3));
        this.assertRelationshipGroupsInOrder(neoStores, nodeId, type5, type10);
        recordState3 = this.newTransactionRecordState(neoStores);
        otherNodeId = neoStores.getNodeStore().nextId();
        recordState3.nodeCreate(otherNodeId);
        recordState3.relCreate(neoStores.getRelationshipStore().nextId(), type15, nodeId, otherNodeId);
        applier3 = new NeoStoreBatchTransactionApplier(neoStores, (CacheAccessBackDoor)Mockito.mock(CacheAccessBackDoor.class), LockService.NO_LOCK_SERVICE);
        this.apply((BatchTransactionApplier)applier3, this.transaction(recordState3));
        this.assertRelationshipGroupsInOrder(neoStores, nodeId, type5, type10, type15);
    }

    @Test
    public void shouldPrepareRelevantRecords() throws Exception {
        PrepareTrackingRecordFormats format = new PrepareTrackingRecordFormats(StandardV3_0.RECORD_FORMATS);
        NeoStores neoStores = this.neoStoresRule.open(format, GraphDatabaseSettings.dense_node_threshold.name(), "1");
        TransactionRecordState state = this.newTransactionRecordState(neoStores);
        state.nodeCreate(0L);
        state.relCreate(0L, 0, 0L, 0L);
        state.relCreate(1L, 0, 0L, 0L);
        state.relCreate(2L, 0, 0L, 0L);
        ArrayList commands = new ArrayList();
        state.extractCommands(commands);
        int nodes = 0;
        int rels = 0;
        int groups = 0;
        for (StorageCommand command : commands) {
            if (command instanceof Command.NodeCommand) {
                Assert.assertTrue((boolean)format.node().prepared(((Command.NodeCommand)command).getAfter()));
                ++nodes;
                continue;
            }
            if (command instanceof Command.RelationshipCommand) {
                Assert.assertTrue((boolean)format.relationship().prepared(((Command.RelationshipCommand)command).getAfter()));
                ++rels;
                continue;
            }
            if (!(command instanceof Command.RelationshipGroupCommand)) continue;
            Assert.assertTrue((boolean)format.relationshipGroup().prepared(((Command.RelationshipGroupCommand)command).getAfter()));
            ++groups;
        }
        Assert.assertEquals((long)1L, (long)nodes);
        Assert.assertEquals((long)3L, (long)rels);
        Assert.assertEquals((long)1L, (long)groups);
    }

    private long[] createRelationships(NeoStores neoStores, TransactionRecordState tx, long nodeId, int type, Direction direction, int count) {
        long[] result = new long[count];
        for (int i = 0; i < count; ++i) {
            long relId;
            long otherNodeId = neoStores.getNodeStore().nextId();
            tx.nodeCreate(otherNodeId);
            long first = direction == Direction.OUTGOING ? nodeId : otherNodeId;
            long other = direction == Direction.INCOMING ? nodeId : otherNodeId;
            result[i] = relId = neoStores.getRelationshipStore().nextId();
            tx.relCreate(relId, type, first, other);
        }
        return result;
    }

    private void assertRelationshipGroupsInOrder(NeoStores neoStores, long nodeId, int ... types) {
        NodeStore nodeStore = neoStores.getNodeStore();
        NodeRecord node = (NodeRecord)nodeStore.getRecord(nodeId, nodeStore.newRecord(), RecordLoad.NORMAL);
        Assert.assertTrue((String)("Node should be dense, is " + node), (boolean)node.isDense());
        long groupId = node.getNextRel();
        int cursor = 0;
        ArrayList<RelationshipGroupRecord> seen = new ArrayList<RelationshipGroupRecord>();
        while (groupId != (long)Record.NO_NEXT_RELATIONSHIP.intValue()) {
            RecordStore relationshipGroupStore = neoStores.getRelationshipGroupStore();
            RelationshipGroupRecord group = (RelationshipGroupRecord)relationshipGroupStore.getRecord(groupId, relationshipGroupStore.newRecord(), RecordLoad.NORMAL);
            seen.add(group);
            Assert.assertEquals((String)("Invalid type, seen groups so far " + seen), (long)types[cursor++], (long)group.getType());
            groupId = group.getNext();
        }
        Assert.assertEquals((String)("Not enough relationship group records found in chain for " + node), (long)types.length, (long)cursor);
    }

    private Iterable<NodePropertyUpdate> indexUpdatesOf(NeoStores neoStores, TransactionRecordState state) throws IOException, TransactionFailureException {
        return this.indexUpdatesOf(neoStores, (TransactionRepresentation)this.transactionRepresentationOf(state));
    }

    private Iterable<NodePropertyUpdate> indexUpdatesOf(NeoStores neoStores, TransactionRepresentation transaction) throws IOException {
        NodePropertyCommandsExtractor extractor = new NodePropertyCommandsExtractor();
        transaction.accept((Visitor)extractor);
        OnlineIndexUpdates lazyIndexUpdates = new OnlineIndexUpdates(neoStores.getNodeStore(), new PropertyLoader(neoStores), new PropertyPhysicalToLogicalConverter(neoStores.getPropertyStore()));
        lazyIndexUpdates.feed(extractor.propertyCommandsByNodeIds(), extractor.nodeCommandsById());
        return lazyIndexUpdates;
    }

    private PhysicalTransactionRepresentation transactionRepresentationOf(TransactionRecordState writeTransaction) throws TransactionFailureException {
        ArrayList commands = new ArrayList();
        writeTransaction.extractCommands(commands);
        PhysicalTransactionRepresentation tx = new PhysicalTransactionRepresentation(commands);
        tx.setHeader(new byte[0], 0, 0, 0L, 0L, 0L, 0);
        return tx;
    }

    private void assertCommand(StorageCommand next, Class<?> klass) {
        Assert.assertTrue((String)("Expected " + klass + ". was: " + next), (boolean)klass.isInstance(next));
    }

    private CommittedTransactionRepresentation readFromChannel(ReadableLogChannel channel) throws IOException {
        VersionAwareLogEntryReader logEntryReader = new VersionAwareLogEntryReader();
        try (PhysicalTransactionCursor cursor = new PhysicalTransactionCursor((ReadableClosablePositionAwareChannel)channel, (LogEntryReader)logEntryReader);){
            Assert.assertTrue((boolean)cursor.next());
            CommittedTransactionRepresentation committedTransactionRepresentation = cursor.get();
            return committedTransactionRepresentation;
        }
    }

    private void writeToChannel(TransactionRepresentation transaction, FlushableChannel channel) throws IOException {
        TransactionLogWriter writer = new TransactionLogWriter(new LogEntryWriter(channel));
        writer.append(transaction, 2L);
    }

    private TransactionRecordState nodeWithDynamicLabelRecord(NeoStores store, AtomicLong nodeId, AtomicLong dynamicLabelRecordId) {
        TransactionRecordState recordState = this.newTransactionRecordState(store);
        nodeId.set(store.getNodeStore().nextId());
        int[] labelIds = new int[20];
        for (int i = 0; i < labelIds.length; ++i) {
            int labelId = (int)store.getLabelTokenStore().nextId();
            recordState.createLabelToken("Label" + i, labelId);
            labelIds[i] = labelId;
        }
        recordState.nodeCreate(nodeId.get());
        for (int labelId : labelIds) {
            recordState.addLabelToNode(labelId, nodeId.get());
        }
        NodeRecord node = (NodeRecord)((RecordAccess.RecordProxy)Iterables.single((Iterable)this.recordChangeSet.getNodeRecords().changes())).forReadingData();
        dynamicLabelRecordId.set(((DynamicRecord)Iterables.single((Iterable)node.getDynamicLabelRecords())).getId());
        return recordState;
    }

    private TransactionRecordState deleteNode(NeoStores store, long nodeId) {
        TransactionRecordState recordState = this.newTransactionRecordState(store);
        recordState.nodeDelete(nodeId);
        return recordState;
    }

    private void apply(BatchTransactionApplier applier, TransactionRepresentation transaction) throws Exception {
        CommandHandlerContract.apply(applier, new TransactionToApply(transaction));
    }

    private void apply(NeoStores neoStores, TransactionRepresentation transaction) throws Exception {
        NeoStoreBatchTransactionApplier applier = new NeoStoreBatchTransactionApplier(neoStores, (CacheAccessBackDoor)Mockito.mock(CacheAccessBackDoor.class), LockService.NO_LOCK_SERVICE);
        this.apply((BatchTransactionApplier)applier, transaction);
    }

    private void apply(NeoStores neoStores, TransactionRecordState state) throws Exception {
        NeoStoreBatchTransactionApplier applier = new NeoStoreBatchTransactionApplier(neoStores, (CacheAccessBackDoor)Mockito.mock(CacheAccessBackDoor.class), LockService.NO_LOCK_SERVICE);
        this.apply((BatchTransactionApplier)applier, (TransactionRepresentation)this.transactionRepresentationOf(state));
    }

    private TransactionRecordState newTransactionRecordState(NeoStores neoStores) {
        Loaders loaders = new Loaders(neoStores);
        this.recordChangeSet = new RecordChangeSet(loaders);
        PropertyTraverser propertyTraverser = new PropertyTraverser();
        RelationshipGroupGetter relationshipGroupGetter = new RelationshipGroupGetter(neoStores.getRelationshipGroupStore());
        PropertyDeleter propertyDeleter = new PropertyDeleter(propertyTraverser);
        return new TransactionRecordState(neoStores, this.integrityValidator, this.recordChangeSet, 0L, (ResourceLocker)new NoOpClient(), new RelationshipCreator(relationshipGroupGetter, neoStores.getRelationshipGroupStore().getStoreHeaderInt()), new RelationshipDeleter(relationshipGroupGetter, propertyDeleter), new PropertyCreator(neoStores.getPropertyStore(), propertyTraverser), propertyDeleter);
    }

    private TransactionRepresentation transaction(TransactionRecordState recordState) throws TransactionFailureException {
        ArrayList commands = new ArrayList();
        recordState.extractCommands(commands);
        PhysicalTransactionRepresentation transaction = new PhysicalTransactionRepresentation(commands);
        transaction.setHeader(new byte[0], 0, 0, 0L, 0L, 0L, 0);
        return transaction;
    }

    private void assertDynamicLabelRecordInUse(NeoStores store, long id, boolean inUse) {
        DynamicArrayStore dynamicLabelStore = store.getNodeStore().getDynamicLabelStore();
        DynamicRecord record = (DynamicRecord)dynamicLabelStore.getRecord(id, dynamicLabelStore.newRecord(), RecordLoad.FORCE);
        Assert.assertTrue((inUse == record.inUse() ? 1 : 0) != 0);
    }

    private String string(int length) {
        StringBuilder result = new StringBuilder();
        int ch = 97;
        for (int i = 0; i < length; ++i) {
            result.append((char)(ch + i % 10));
        }
        return result.toString();
    }

    private Command.PropertyCommand singlePropertyCommand(Collection<StorageCommand> commands) {
        return (Command.PropertyCommand)Iterables.single((Iterable)Iterables.filter(t -> t instanceof Command.PropertyCommand, commands));
    }

    private Command.RelationshipGroupCommand singleRelationshipGroupCommand(Collection<StorageCommand> commands) {
        return (Command.RelationshipGroupCommand)Iterables.single((Iterable)Iterables.filter(t -> t instanceof Command.RelationshipGroupCommand, commands));
    }
}

