/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.transaction.state;

import java.io.IOException;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import junit.framework.TestCase;
import org.junit.Assert;
import org.junit.Test;
import org.neo4j.helpers.collection.MapUtil;
import org.neo4j.kernel.api.index.SchemaIndexProvider;
import org.neo4j.kernel.impl.index.IndexCommand;
import org.neo4j.kernel.impl.index.IndexDefineCommand;
import org.neo4j.kernel.impl.index.IndexEntityType;
import org.neo4j.kernel.impl.store.record.DynamicRecord;
import org.neo4j.kernel.impl.store.record.IndexRule;
import org.neo4j.kernel.impl.store.record.LabelTokenRecord;
import org.neo4j.kernel.impl.store.record.NeoStoreRecord;
import org.neo4j.kernel.impl.store.record.NodeRecord;
import org.neo4j.kernel.impl.store.record.PrimitiveRecord;
import org.neo4j.kernel.impl.store.record.PropertyKeyTokenRecord;
import org.neo4j.kernel.impl.store.record.PropertyRecord;
import org.neo4j.kernel.impl.store.record.RelationshipRecord;
import org.neo4j.kernel.impl.store.record.RelationshipTypeTokenRecord;
import org.neo4j.kernel.impl.transaction.TransactionRepresentation;
import org.neo4j.kernel.impl.transaction.command.Command;
import org.neo4j.kernel.impl.transaction.log.FlushableChannel;
import org.neo4j.kernel.impl.transaction.log.InMemoryClosableChannel;
import org.neo4j.kernel.impl.transaction.log.PhysicalTransactionRepresentation;
import org.neo4j.kernel.impl.transaction.log.ReadableClosablePositionAwareChannel;
import org.neo4j.kernel.impl.transaction.log.entry.LogEntry;
import org.neo4j.kernel.impl.transaction.log.entry.LogEntryCommand;
import org.neo4j.kernel.impl.transaction.log.entry.LogEntryReader;
import org.neo4j.kernel.impl.transaction.log.entry.LogEntryWriter;
import org.neo4j.kernel.impl.transaction.log.entry.VersionAwareLogEntryReader;
import org.neo4j.storageengine.api.StorageCommand;
import org.neo4j.storageengine.api.schema.SchemaRule;

public class LogTruncationTest {
    private final InMemoryClosableChannel inMemoryChannel = new InMemoryClosableChannel();
    private final LogEntryReader<ReadableClosablePositionAwareChannel> logEntryReader = new VersionAwareLogEntryReader();
    private final LogEntryWriter writer = new LogEntryWriter((FlushableChannel)this.inMemoryChannel);
    private final Map<Class<?>, Command[]> permutations = new HashMap();

    public LogTruncationTest() {
        NeoStoreRecord after = new NeoStoreRecord();
        after.setNextProp(42L);
        this.permutations.put(Command.NeoStoreCommand.class, new Command[]{new Command.NeoStoreCommand(new NeoStoreRecord(), after)});
        this.permutations.put(Command.NodeCommand.class, new Command[]{new Command.NodeCommand(new NodeRecord(12L, false, 13L, 13L), new NodeRecord(0L, false, 0L, 0L))});
        this.permutations.put(Command.RelationshipCommand.class, new Command[]{new Command.RelationshipCommand(new RelationshipRecord(1L), new RelationshipRecord(1L, 2L, 3L, 4))});
        this.permutations.put(Command.PropertyCommand.class, new Command[]{new Command.PropertyCommand(new PropertyRecord(1L, (PrimitiveRecord)new NodeRecord(12L, false, 13L, 13L)), new PropertyRecord(1L, (PrimitiveRecord)new NodeRecord(12L, false, 13L, 13L)))});
        this.permutations.put(Command.RelationshipGroupCommand.class, new Command[]{new Command.LabelTokenCommand(new LabelTokenRecord(1), this.createLabelTokenRecord(1))});
        this.permutations.put(Command.SchemaRuleCommand.class, new Command[]{new Command.SchemaRuleCommand(Arrays.asList(DynamicRecord.dynamicRecord((long)1L, (boolean)false, (boolean)true, (long)-1L, (int)1, (byte[])"hello".getBytes())), Arrays.asList(DynamicRecord.dynamicRecord((long)1L, (boolean)true, (boolean)true, (long)-1L, (int)1, (byte[])"hello".getBytes())), (SchemaRule)new IndexRule(1L, 3, 4, new SchemaIndexProvider.Descriptor("1", "2"), null))});
        this.permutations.put(Command.RelationshipTypeTokenCommand.class, new Command[]{new Command.RelationshipTypeTokenCommand(new RelationshipTypeTokenRecord(1), this.createRelationshipTypeTokenRecord(1))});
        this.permutations.put(Command.PropertyKeyTokenCommand.class, new Command[]{new Command.PropertyKeyTokenCommand(new PropertyKeyTokenRecord(1), this.createPropertyKeyTokenRecord(1))});
        this.permutations.put(Command.LabelTokenCommand.class, new Command[]{new Command.LabelTokenCommand(new LabelTokenRecord(1), this.createLabelTokenRecord(1))});
        IndexCommand.AddRelationshipCommand addRelationshipCommand = new IndexCommand.AddRelationshipCommand();
        addRelationshipCommand.init(1, 1L, 12345, (Object)"some value", 1L, 1L);
        this.permutations.put(IndexCommand.AddRelationshipCommand.class, new Command[]{addRelationshipCommand});
        IndexCommand.CreateCommand createCommand = new IndexCommand.CreateCommand();
        createCommand.init(1, IndexEntityType.Relationship.id(), MapUtil.stringMap((String[])new String[]{"string1", "string 2"}));
        this.permutations.put(IndexCommand.CreateCommand.class, new Command[]{createCommand});
        IndexCommand.AddNodeCommand addCommand = new IndexCommand.AddNodeCommand();
        addCommand.init(1234, 122L, 2, (Object)"value");
        this.permutations.put(IndexCommand.AddNodeCommand.class, new Command[]{addCommand});
        IndexCommand.DeleteCommand deleteCommand = new IndexCommand.DeleteCommand();
        deleteCommand.init(1, IndexEntityType.Relationship.id());
        this.permutations.put(IndexCommand.DeleteCommand.class, new Command[]{deleteCommand});
        IndexCommand.RemoveCommand removeCommand = new IndexCommand.RemoveCommand();
        removeCommand.init(1, IndexEntityType.Node.id(), 126L, 3, (Object)"the value");
        this.permutations.put(IndexCommand.RemoveCommand.class, new Command[]{removeCommand});
        IndexDefineCommand indexDefineCommand = new IndexDefineCommand();
        indexDefineCommand.init(MapUtil.genericMap((Object[])new Object[]{"string1", 45, "key1", 2}), MapUtil.genericMap((Object[])new Object[]{"string", 2}));
        this.permutations.put(IndexDefineCommand.class, new Command[]{indexDefineCommand});
        this.permutations.put(Command.NodeCountsCommand.class, new Command[]{new Command.NodeCountsCommand(42, 11L)});
        this.permutations.put(Command.RelationshipCountsCommand.class, new Command[]{new Command.RelationshipCountsCommand(17, 2, 13, -2L)});
    }

    @Test
    public void testSerializationInFaceOfLogTruncation() throws Exception {
        for (Command cmd : this.enumerateCommands()) {
            this.assertHandlesLogTruncation(cmd);
        }
    }

    private Iterable<Command> enumerateCommands() {
        ArrayList<Command> commands = new ArrayList<Command>();
        for (Class<?> cmd : Command.class.getClasses()) {
            if (!Command.class.isAssignableFrom(cmd)) continue;
            if (this.permutations.containsKey(cmd)) {
                commands.addAll(Arrays.asList((Object[])this.permutations.get(cmd)));
                continue;
            }
            if (!Modifier.isAbstract(cmd.getModifiers())) {
                throw new AssertionError((Object)("Unknown command type: " + cmd + ", please add missing instantiation to " + "test serialization of this command."));
            }
        }
        for (Class<?> cmd : IndexCommand.class.getClasses()) {
            if (!Command.class.isAssignableFrom(cmd)) continue;
            if (this.permutations.containsKey(cmd)) {
                commands.addAll(Arrays.asList((Object[])this.permutations.get(cmd)));
                continue;
            }
            if (!Modifier.isAbstract(cmd.getModifiers())) {
                throw new AssertionError((Object)("Unknown command type: " + cmd + ", please add missing instantiation to " + "test serialization of this command."));
            }
        }
        return commands;
    }

    private void assertHandlesLogTruncation(Command cmd) throws IOException {
        this.inMemoryChannel.reset();
        this.writer.serialize((TransactionRepresentation)new PhysicalTransactionRepresentation(Arrays.asList(cmd)));
        int bytesSuccessfullyWritten = this.inMemoryChannel.writerPosition();
        try {
            LogEntry logEntry = this.logEntryReader.readLogEntry((ReadableClosablePositionAwareChannel)this.inMemoryChannel);
            StorageCommand command = ((LogEntryCommand)logEntry).getXaCommand();
            Assert.assertEquals((Object)cmd, (Object)command);
        }
        catch (Exception e) {
            throw new AssertionError("Failed to deserialize " + cmd.toString() + ", because: ", e);
        }
        while (true) {
            int n = --bytesSuccessfullyWritten;
            --bytesSuccessfullyWritten;
            if (n <= 0) break;
            this.inMemoryChannel.reset();
            this.writer.serialize((TransactionRepresentation)new PhysicalTransactionRepresentation(Arrays.asList(cmd)));
            this.inMemoryChannel.truncateTo(bytesSuccessfullyWritten);
            LogEntry deserialized = this.logEntryReader.readLogEntry((ReadableClosablePositionAwareChannel)this.inMemoryChannel);
            TestCase.assertNull((String)("Deserialization did not detect log truncation!Record: " + cmd + ", deserialized: " + deserialized), (Object)deserialized);
        }
    }

    @Test
    public void testInMemoryLogChannel() throws Exception {
        long i;
        int i2;
        InMemoryClosableChannel channel = new InMemoryClosableChannel();
        for (i2 = 0; i2 < 25; ++i2) {
            channel.putInt(i2);
        }
        for (i2 = 0; i2 < 25; ++i2) {
            Assert.assertEquals((long)i2, (long)channel.getInt());
        }
        channel.reset();
        for (i = 0L; i < 12L; ++i) {
            channel.putLong(i);
        }
        for (i = 0L; i < 12L; ++i) {
            Assert.assertEquals((long)i, (long)channel.getLong());
        }
        channel.reset();
        for (i = 0L; i < 8L; ++i) {
            channel.putLong(i);
            channel.putInt((int)i);
        }
        for (i = 0L; i < 8L; ++i) {
            Assert.assertEquals((long)i, (long)channel.getLong());
            Assert.assertEquals((long)i, (long)channel.getInt());
        }
        channel.close();
    }

    private LabelTokenRecord createLabelTokenRecord(int id) {
        LabelTokenRecord labelTokenRecord = new LabelTokenRecord(id);
        labelTokenRecord.setInUse(true);
        labelTokenRecord.setNameId(333);
        labelTokenRecord.addNameRecord(new DynamicRecord(43L));
        return labelTokenRecord;
    }

    private RelationshipTypeTokenRecord createRelationshipTypeTokenRecord(int id) {
        RelationshipTypeTokenRecord relationshipTypeTokenRecord = new RelationshipTypeTokenRecord(id);
        relationshipTypeTokenRecord.setInUse(true);
        relationshipTypeTokenRecord.setNameId(333);
        relationshipTypeTokenRecord.addNameRecord(new DynamicRecord(43L));
        return relationshipTypeTokenRecord;
    }

    private PropertyKeyTokenRecord createPropertyKeyTokenRecord(int id) {
        PropertyKeyTokenRecord propertyKeyTokenRecord = new PropertyKeyTokenRecord(id);
        propertyKeyTokenRecord.setInUse(true);
        propertyKeyTokenRecord.setNameId(333);
        propertyKeyTokenRecord.addNameRecord(new DynamicRecord(43L));
        return propertyKeyTokenRecord;
    }
}

