/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.transaction.log.checkpoint;

import java.time.Clock;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import org.neo4j.kernel.impl.transaction.log.checkpoint.TimeCheckPointThreshold;
import org.neo4j.kernel.impl.transaction.log.checkpoint.TriggerInfo;
import org.neo4j.time.FakeClock;

public class TimeCheckPointThresholdTest {
    private final FakeClock clock = new FakeClock();
    private final TriggerInfo triggerInfo = (TriggerInfo)Mockito.mock(TriggerInfo.class);

    @Test
    public void shouldBeFalseIfTimeThresholdIsNotReachedAndThereAreCommittedTransactions() throws Throwable {
        TimeCheckPointThreshold threshold = new TimeCheckPointThreshold(100L, (Clock)this.clock);
        threshold.initialize(2L);
        this.clock.forward(50L, TimeUnit.MILLISECONDS);
        boolean checkPointingNeeded = threshold.isCheckPointingNeeded(42L, (Consumer)this.triggerInfo);
        Assert.assertFalse((boolean)checkPointingNeeded);
        Mockito.verifyZeroInteractions((Object[])new Object[]{this.triggerInfo});
    }

    @Test
    public void shouldBeTrueIfTimeThresholdIsReachedAndThereAreCommittedTransactions() throws Throwable {
        TimeCheckPointThreshold threshold = new TimeCheckPointThreshold(100L, (Clock)this.clock);
        threshold.initialize(2L);
        this.clock.forward(100L, TimeUnit.MILLISECONDS);
        boolean checkPointingNeeded = threshold.isCheckPointingNeeded(42L, (Consumer)this.triggerInfo);
        Assert.assertTrue((boolean)checkPointingNeeded);
        ((TriggerInfo)Mockito.verify((Object)this.triggerInfo, (VerificationMode)Mockito.times((int)1))).accept((Object)threshold.description());
    }

    @Test
    public void shouldBeFalseIfTimeThresholdIsReachedButThereAreNoCommittedTransactions() throws Throwable {
        TimeCheckPointThreshold threshold = new TimeCheckPointThreshold(100L, (Clock)this.clock);
        threshold.initialize(42L);
        this.clock.forward(100L, TimeUnit.MILLISECONDS);
        boolean checkPointingNeeded = threshold.isCheckPointingNeeded(42L, (Consumer)this.triggerInfo);
        Assert.assertFalse((boolean)checkPointingNeeded);
        Mockito.verifyZeroInteractions((Object[])new Object[]{this.triggerInfo});
    }

    @Test
    public void shouldBeFalseIfTimeThresholdIsReachedAfterCheckPointHappenedButThereAreNoCommittedTransactions() throws Throwable {
        TimeCheckPointThreshold threshold = new TimeCheckPointThreshold(100L, (Clock)this.clock);
        threshold.initialize(2L);
        this.clock.forward(100L, TimeUnit.MILLISECONDS);
        threshold.checkPointHappened(42L);
        this.clock.forward(100L, TimeUnit.MILLISECONDS);
        boolean checkPointingNeeded = threshold.isCheckPointingNeeded(42L, (Consumer)this.triggerInfo);
        Assert.assertFalse((boolean)checkPointingNeeded);
        Mockito.verifyZeroInteractions((Object[])new Object[]{this.triggerInfo});
    }

    @Test
    public void shouldBeTrueIfTimeThresholdIsReachedAfterCheckPointHappenedAndThereAreCommittedTransactions() throws Throwable {
        TimeCheckPointThreshold threshold = new TimeCheckPointThreshold(100L, (Clock)this.clock);
        threshold.initialize(2L);
        this.clock.forward(100L, TimeUnit.MILLISECONDS);
        threshold.checkPointHappened(42L);
        this.clock.forward(100L, TimeUnit.MILLISECONDS);
        boolean checkPointingNeeded = threshold.isCheckPointingNeeded(43L, (Consumer)this.triggerInfo);
        Assert.assertTrue((boolean)checkPointingNeeded);
        ((TriggerInfo)Mockito.verify((Object)this.triggerInfo, (VerificationMode)Mockito.times((int)1))).accept((Object)threshold.description());
    }
}

