/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.transaction.log.checkpoint;

import java.util.function.Consumer;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import org.neo4j.kernel.impl.transaction.log.checkpoint.CountCommittedTransactionThreshold;
import org.neo4j.kernel.impl.transaction.log.checkpoint.TriggerInfo;

public class CountCommittedTransactionThresholdTest {
    private final TriggerInfo triggerInfo = (TriggerInfo)Mockito.mock(TriggerInfo.class);

    @Test
    public void checkPointIsNotNeededWhenThereAreNoTransactions() throws Throwable {
        CountCommittedTransactionThreshold threshold = new CountCommittedTransactionThreshold(2);
        threshold.initialize(2L);
        boolean checkPointingNeeded = threshold.isCheckPointingNeeded(2L, (Consumer)this.triggerInfo);
        Assert.assertFalse((boolean)checkPointingNeeded);
        Mockito.verifyZeroInteractions((Object[])new Object[]{this.triggerInfo});
    }

    @Test
    public void checkPointIsNotNeededWhenTheNumberOfTransactionsIsUnderTheThreshold() throws Throwable {
        CountCommittedTransactionThreshold threshold = new CountCommittedTransactionThreshold(2);
        threshold.initialize(2L);
        boolean checkPointingNeeded = threshold.isCheckPointingNeeded(3L, (Consumer)this.triggerInfo);
        Assert.assertFalse((boolean)checkPointingNeeded);
        Mockito.verifyZeroInteractions((Object[])new Object[]{this.triggerInfo});
    }

    @Test
    public void checkPointIsNeededWhenTheNumberOfTransactionsIsEqualOrAboveTheThreshold() throws Throwable {
        CountCommittedTransactionThreshold threshold = new CountCommittedTransactionThreshold(2);
        threshold.initialize(2L);
        boolean checkPointingNeeded = threshold.isCheckPointingNeeded(4L, (Consumer)this.triggerInfo);
        Assert.assertTrue((boolean)checkPointingNeeded);
        ((TriggerInfo)Mockito.verify((Object)this.triggerInfo, (VerificationMode)Mockito.times((int)1))).accept((Object)threshold.description());
    }

    @Test
    public void checkPointIsNotNeededWhenThresholdIsReachedAndACheckPointHappened() throws Throwable {
        CountCommittedTransactionThreshold threshold = new CountCommittedTransactionThreshold(2);
        threshold.initialize(2L);
        threshold.checkPointHappened(4L);
        boolean checkPointingNeeded = threshold.isCheckPointingNeeded(4L, (Consumer)this.triggerInfo);
        Assert.assertFalse((boolean)checkPointingNeeded);
        Mockito.verifyZeroInteractions((Object[])new Object[]{this.triggerInfo});
    }

    @Test
    public void checkPointIsNotNeededWhenThresholdIsReachedAndACheckPointHappenedAndSomeTransactionsHaveBeenCommitted() throws Throwable {
        CountCommittedTransactionThreshold threshold = new CountCommittedTransactionThreshold(2);
        threshold.initialize(2L);
        threshold.checkPointHappened(4L);
        boolean checkPointingNeeded = threshold.isCheckPointingNeeded(5L, (Consumer)this.triggerInfo);
        Assert.assertFalse((boolean)checkPointingNeeded);
        Mockito.verifyZeroInteractions((Object[])new Object[]{this.triggerInfo});
    }

    @Test
    public void checkPointIsNeededWhenThresholdIsReachedAgainAfterACheckPointHappened() throws Throwable {
        CountCommittedTransactionThreshold threshold = new CountCommittedTransactionThreshold(2);
        threshold.initialize(2L);
        threshold.checkPointHappened(4L);
        boolean checkPointingNeeded = threshold.isCheckPointingNeeded(6L, (Consumer)this.triggerInfo);
        Assert.assertTrue((boolean)checkPointingNeeded);
        ((TriggerInfo)Mockito.verify((Object)this.triggerInfo, (VerificationMode)Mockito.times((int)1))).accept((Object)threshold.description());
    }
}

