/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.transaction.command;

import java.io.IOException;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.function.Supplier;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Matchers;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import org.neo4j.concurrent.WorkSync;
import org.neo4j.kernel.api.exceptions.index.IndexActivationFailedKernelException;
import org.neo4j.kernel.api.exceptions.index.IndexNotFoundKernelException;
import org.neo4j.kernel.api.exceptions.index.IndexPopulationFailedKernelException;
import org.neo4j.kernel.api.index.SchemaIndexProvider;
import org.neo4j.kernel.api.labelscan.LabelScanWriter;
import org.neo4j.kernel.impl.api.BatchTransactionApplier;
import org.neo4j.kernel.impl.api.BatchTransactionApplierFacade;
import org.neo4j.kernel.impl.api.TransactionToApply;
import org.neo4j.kernel.impl.api.index.IndexingService;
import org.neo4j.kernel.impl.api.index.PropertyPhysicalToLogicalConverter;
import org.neo4j.kernel.impl.core.CacheAccessBackDoor;
import org.neo4j.kernel.impl.core.RelationshipTypeToken;
import org.neo4j.kernel.impl.locking.LockService;
import org.neo4j.kernel.impl.store.DynamicArrayStore;
import org.neo4j.kernel.impl.store.LabelTokenStore;
import org.neo4j.kernel.impl.store.MetaDataStore;
import org.neo4j.kernel.impl.store.NeoStores;
import org.neo4j.kernel.impl.store.NodeStore;
import org.neo4j.kernel.impl.store.PropertyKeyTokenStore;
import org.neo4j.kernel.impl.store.PropertyStore;
import org.neo4j.kernel.impl.store.RecordStore;
import org.neo4j.kernel.impl.store.RelationshipGroupStore;
import org.neo4j.kernel.impl.store.RelationshipStore;
import org.neo4j.kernel.impl.store.RelationshipTypeTokenStore;
import org.neo4j.kernel.impl.store.SchemaStore;
import org.neo4j.kernel.impl.store.record.AbstractBaseRecord;
import org.neo4j.kernel.impl.store.record.DynamicRecord;
import org.neo4j.kernel.impl.store.record.IndexRule;
import org.neo4j.kernel.impl.store.record.LabelTokenRecord;
import org.neo4j.kernel.impl.store.record.NeoStoreRecord;
import org.neo4j.kernel.impl.store.record.NodeRecord;
import org.neo4j.kernel.impl.store.record.PropertyKeyTokenRecord;
import org.neo4j.kernel.impl.store.record.PropertyRecord;
import org.neo4j.kernel.impl.store.record.RelationshipGroupRecord;
import org.neo4j.kernel.impl.store.record.RelationshipRecord;
import org.neo4j.kernel.impl.store.record.RelationshipTypeTokenRecord;
import org.neo4j.kernel.impl.store.record.TokenRecord;
import org.neo4j.kernel.impl.store.record.UniquePropertyConstraintRule;
import org.neo4j.kernel.impl.transaction.command.CacheInvalidationBatchTransactionApplier;
import org.neo4j.kernel.impl.transaction.command.Command;
import org.neo4j.kernel.impl.transaction.command.CommandHandlerContract;
import org.neo4j.kernel.impl.transaction.command.HighIdBatchTransactionApplier;
import org.neo4j.kernel.impl.transaction.command.IndexBatchTransactionApplier;
import org.neo4j.kernel.impl.transaction.command.IndexUpdatesWork;
import org.neo4j.kernel.impl.transaction.command.LabelUpdateWork;
import org.neo4j.kernel.impl.transaction.command.NeoStoreBatchTransactionApplier;
import org.neo4j.kernel.impl.transaction.state.PropertyLoader;
import org.neo4j.storageengine.api.Token;
import org.neo4j.storageengine.api.TransactionApplicationMode;
import org.neo4j.storageengine.api.schema.SchemaRule;

public class NeoStoreTransactionApplierTest {
    private final NeoStores neoStores = (NeoStores)Mockito.mock(NeoStores.class);
    private final IndexingService indexingService = (IndexingService)Mockito.mock(IndexingService.class);
    private final Supplier<LabelScanWriter> labelScanStore = (Supplier)Mockito.mock(Supplier.class);
    private final CacheAccessBackDoor cacheAccess = (CacheAccessBackDoor)Mockito.mock(CacheAccessBackDoor.class);
    private final LockService lockService = (LockService)Mockito.mock(LockService.class);
    private final MetaDataStore metaDataStore = (MetaDataStore)Mockito.mock(MetaDataStore.class);
    private final NodeStore nodeStore = (NodeStore)Mockito.mock(NodeStore.class);
    private final RelationshipStore relationshipStore = (RelationshipStore)Mockito.mock(RelationshipStore.class);
    private final PropertyStore propertyStore = (PropertyStore)Mockito.mock(PropertyStore.class);
    private final RecordStore<RelationshipGroupRecord> relationshipGroupStore = (RecordStore)Mockito.mock(RelationshipGroupStore.class);
    private final RelationshipTypeTokenStore relationshipTypeTokenStore = (RelationshipTypeTokenStore)Mockito.mock(RelationshipTypeTokenStore.class);
    private final LabelTokenStore labelTokenStore = (LabelTokenStore)Mockito.mock(LabelTokenStore.class);
    private final PropertyKeyTokenStore propertyKeyTokenStore = (PropertyKeyTokenStore)Mockito.mock(PropertyKeyTokenStore.class);
    private final SchemaStore schemaStore = (SchemaStore)Mockito.mock(SchemaStore.class);
    private final DynamicArrayStore dynamicLabelStore = (DynamicArrayStore)Mockito.mock(DynamicArrayStore.class);
    private final long transactionId = 55555L;
    private final DynamicRecord one = DynamicRecord.dynamicRecord((long)1L, (boolean)true);
    private final DynamicRecord two = DynamicRecord.dynamicRecord((long)2L, (boolean)true);
    private final DynamicRecord three = DynamicRecord.dynamicRecord((long)3L, (boolean)true);
    private final WorkSync<Supplier<LabelScanWriter>, LabelUpdateWork> labelScanStoreSynchronizer = new WorkSync(this.labelScanStore);
    private final TransactionToApply transactionToApply = (TransactionToApply)Mockito.mock(TransactionToApply.class);
    private final WorkSync<IndexingService, IndexUpdatesWork> indexUpdatesSync = new WorkSync((Object)this.indexingService);

    @Before
    public void setup() {
        Mockito.when((Object)this.neoStores.getMetaDataStore()).thenReturn((Object)this.metaDataStore);
        Mockito.when((Object)this.neoStores.getNodeStore()).thenReturn((Object)this.nodeStore);
        Mockito.when((Object)this.neoStores.getRelationshipStore()).thenReturn((Object)this.relationshipStore);
        Mockito.when((Object)this.neoStores.getPropertyStore()).thenReturn((Object)this.propertyStore);
        Mockito.when((Object)this.neoStores.getRelationshipGroupStore()).thenReturn(this.relationshipGroupStore);
        Mockito.when((Object)this.neoStores.getRelationshipTypeTokenStore()).thenReturn((Object)this.relationshipTypeTokenStore);
        Mockito.when((Object)this.neoStores.getLabelTokenStore()).thenReturn((Object)this.labelTokenStore);
        Mockito.when((Object)this.neoStores.getPropertyKeyTokenStore()).thenReturn((Object)this.propertyKeyTokenStore);
        Mockito.when((Object)this.neoStores.getSchemaStore()).thenReturn((Object)this.schemaStore);
        Mockito.when((Object)this.nodeStore.getDynamicLabelStore()).thenReturn((Object)this.dynamicLabelStore);
        Mockito.when((Object)this.lockService.acquireNodeLock(Matchers.anyLong(), (LockService.LockType)Matchers.any())).thenReturn((Object)LockService.NO_LOCK);
        Mockito.when((Object)this.lockService.acquireRelationshipLock(Matchers.anyLong(), (LockService.LockType)Matchers.any())).thenReturn((Object)LockService.NO_LOCK);
        Mockito.when((Object)this.transactionToApply.transactionId()).thenReturn((Object)55555L);
    }

    @Test
    public void shouldApplyNodeCommandToTheStore() throws Exception {
        BatchTransactionApplier applier = this.newApplier(false);
        NodeRecord before = new NodeRecord(11L);
        before.setLabelField(42L, Arrays.asList(this.one, this.two));
        NodeRecord after = new NodeRecord(12L);
        after.setInUse(true);
        after.setLabelField(42L, Arrays.asList(this.one, this.two, this.three));
        Command.NodeCommand command = new Command.NodeCommand(before, after);
        boolean result = CommandHandlerContract.apply(applier, arg_0 -> ((Command.NodeCommand)command).handle(arg_0), this.transactionToApply);
        Assert.assertFalse((boolean)result);
        ((LockService)Mockito.verify((Object)this.lockService, (VerificationMode)Mockito.times((int)1))).acquireNodeLock(command.getKey(), LockService.LockType.WRITE_LOCK);
        ((NodeStore)Mockito.verify((Object)this.nodeStore, (VerificationMode)Mockito.times((int)1))).updateRecord(after);
    }

    @Test
    public void shouldApplyNodeCommandToTheStoreAndInvalidateTheCache() throws Exception {
        BatchTransactionApplier applier = this.newApplier(false);
        NodeRecord before = new NodeRecord(11L);
        before.setLabelField(42L, Arrays.asList(this.one, this.two));
        NodeRecord after = new NodeRecord(12L);
        after.setInUse(false);
        after.setLabelField(42L, Arrays.asList(this.one, this.two, this.three));
        Command.NodeCommand command = new Command.NodeCommand(before, after);
        boolean result = CommandHandlerContract.apply(applier, arg_0 -> ((Command.NodeCommand)command).handle(arg_0), this.transactionToApply);
        Assert.assertFalse((boolean)result);
        ((LockService)Mockito.verify((Object)this.lockService, (VerificationMode)Mockito.times((int)1))).acquireNodeLock(command.getKey(), LockService.LockType.WRITE_LOCK);
        ((NodeStore)Mockito.verify((Object)this.nodeStore, (VerificationMode)Mockito.times((int)1))).updateRecord(after);
    }

    @Test
    public void shouldApplyNodeCommandToTheStoreInRecoveryMode() throws Exception {
        BatchTransactionApplier applier = this.newApplier(true);
        NodeRecord before = new NodeRecord(11L);
        before.setLabelField(42L, Arrays.asList(this.one, this.two));
        NodeRecord after = new NodeRecord(12L);
        after.setInUse(true);
        after.setLabelField(42L, Arrays.asList(this.one, this.two, this.three));
        Command.NodeCommand command = new Command.NodeCommand(before, after);
        boolean result = CommandHandlerContract.apply(applier, arg_0 -> ((Command.NodeCommand)command).handle(arg_0), this.transactionToApply);
        Assert.assertFalse((boolean)result);
        ((LockService)Mockito.verify((Object)this.lockService, (VerificationMode)Mockito.times((int)1))).acquireNodeLock(command.getKey(), LockService.LockType.WRITE_LOCK);
        ((NodeStore)Mockito.verify((Object)this.nodeStore, (VerificationMode)Mockito.times((int)1))).setHighestPossibleIdInUse(after.getId());
        ((NodeStore)Mockito.verify((Object)this.nodeStore, (VerificationMode)Mockito.times((int)1))).updateRecord(after);
        ((DynamicArrayStore)Mockito.verify((Object)this.dynamicLabelStore, (VerificationMode)Mockito.times((int)1))).setHighestPossibleIdInUse(this.three.getId());
    }

    @Test
    public void shouldInvalidateTheCacheWhenTheNodeBecomesDense() throws Exception {
        BatchTransactionApplier applier = this.newApplier(false);
        NodeRecord before = new NodeRecord(11L);
        before.setLabelField(42L, Arrays.asList(this.one));
        before.setInUse(true);
        before.setDense(false);
        NodeRecord after = new NodeRecord(12L);
        after.setInUse(true);
        after.setDense(true);
        after.setLabelField(42L, Arrays.asList(this.one, this.two, this.three));
        Command.NodeCommand command = new Command.NodeCommand(before, after);
        boolean result = CommandHandlerContract.apply(applier, arg_0 -> ((Command.NodeCommand)command).handle(arg_0), this.transactionToApply);
        Assert.assertFalse((boolean)result);
        ((LockService)Mockito.verify((Object)this.lockService, (VerificationMode)Mockito.times((int)1))).acquireNodeLock(command.getKey(), LockService.LockType.WRITE_LOCK);
        ((NodeStore)Mockito.verify((Object)this.nodeStore, (VerificationMode)Mockito.times((int)1))).updateRecord(after);
    }

    @Test
    public void shouldApplyRelationshipCommandToTheStore() throws Exception {
        BatchTransactionApplier applier = this.newApplier(false);
        RelationshipRecord before = new RelationshipRecord(12L);
        RelationshipRecord record = new RelationshipRecord(12L, 3L, 4L, 5);
        record.setInUse(true);
        Command.RelationshipCommand command = new Command.RelationshipCommand(before, record);
        boolean result = CommandHandlerContract.apply(applier, arg_0 -> ((Command)command).handle(arg_0), this.transactionToApply);
        Assert.assertFalse((boolean)result);
        ((RelationshipStore)Mockito.verify((Object)this.relationshipStore, (VerificationMode)Mockito.times((int)1))).updateRecord((AbstractBaseRecord)record);
    }

    @Test
    public void shouldApplyRelationshipCommandToTheStoreAndInvalidateTheCache() throws Exception {
        BatchTransactionApplier applier = this.newApplier(false);
        RelationshipRecord before = new RelationshipRecord(12L);
        RelationshipRecord record = new RelationshipRecord(12L, 3L, 4L, 5);
        record.setInUse(false);
        Command.RelationshipCommand command = new Command.RelationshipCommand(before, record);
        boolean result = CommandHandlerContract.apply(applier, arg_0 -> ((Command)command).handle(arg_0), this.transactionToApply);
        Assert.assertFalse((boolean)result);
        ((RelationshipStore)Mockito.verify((Object)this.relationshipStore, (VerificationMode)Mockito.times((int)1))).updateRecord((AbstractBaseRecord)record);
    }

    @Test
    public void shouldApplyRelationshipCommandToTheStoreInRecovery() throws Exception {
        BatchTransactionApplier applier = this.newApplier(true);
        RelationshipRecord before = new RelationshipRecord(12L);
        RelationshipRecord record = new RelationshipRecord(12L, 3L, 4L, 5);
        record.setInUse(true);
        Command.RelationshipCommand command = new Command.RelationshipCommand(before, record);
        boolean result = CommandHandlerContract.apply(applier, arg_0 -> ((Command)command).handle(arg_0), this.transactionToApply);
        Assert.assertFalse((boolean)result);
        ((RelationshipStore)Mockito.verify((Object)this.relationshipStore, (VerificationMode)Mockito.times((int)1))).setHighestPossibleIdInUse(record.getId());
        ((RelationshipStore)Mockito.verify((Object)this.relationshipStore, (VerificationMode)Mockito.times((int)1))).updateRecord((AbstractBaseRecord)record);
    }

    @Test
    public void shouldApplyNodePropertyCommandToTheStore() throws Exception {
        BatchTransactionApplier applier = this.newApplier(false);
        PropertyRecord before = new PropertyRecord(11L);
        PropertyRecord after = new PropertyRecord(12L);
        after.setNodeId(42L);
        Command.PropertyCommand command = new Command.PropertyCommand(before, after);
        boolean result = CommandHandlerContract.apply(applier, arg_0 -> ((Command)command).handle(arg_0), this.transactionToApply);
        Assert.assertFalse((boolean)result);
        ((LockService)Mockito.verify((Object)this.lockService, (VerificationMode)Mockito.times((int)1))).acquireNodeLock(42L, LockService.LockType.WRITE_LOCK);
        ((PropertyStore)Mockito.verify((Object)this.propertyStore, (VerificationMode)Mockito.times((int)1))).updateRecord(after);
    }

    @Test
    public void shouldApplyNodePropertyCommandToTheStoreInRecovery() throws Exception {
        BatchTransactionApplier applier = this.newApplier(true);
        PropertyRecord before = new PropertyRecord(11L);
        PropertyRecord after = new PropertyRecord(12L);
        after.setNodeId(42L);
        Command.PropertyCommand command = new Command.PropertyCommand(before, after);
        boolean result = CommandHandlerContract.apply(applier, arg_0 -> ((Command)command).handle(arg_0), this.transactionToApply);
        Assert.assertFalse((boolean)result);
        ((LockService)Mockito.verify((Object)this.lockService, (VerificationMode)Mockito.times((int)1))).acquireNodeLock(42L, LockService.LockType.WRITE_LOCK);
        ((PropertyStore)Mockito.verify((Object)this.propertyStore, (VerificationMode)Mockito.times((int)1))).setHighestPossibleIdInUse(after.getId());
        ((PropertyStore)Mockito.verify((Object)this.propertyStore, (VerificationMode)Mockito.times((int)1))).updateRecord(after);
    }

    @Test
    public void shouldApplyRelPropertyCommandToTheStore() throws Exception {
        BatchTransactionApplier applier = this.newApplier(false);
        PropertyRecord before = new PropertyRecord(11L);
        PropertyRecord after = new PropertyRecord(12L);
        after.setRelId(42L);
        Command.PropertyCommand command = new Command.PropertyCommand(before, after);
        boolean result = CommandHandlerContract.apply(applier, arg_0 -> ((Command)command).handle(arg_0), this.transactionToApply);
        Assert.assertFalse((boolean)result);
        ((PropertyStore)Mockito.verify((Object)this.propertyStore, (VerificationMode)Mockito.times((int)1))).updateRecord(after);
    }

    @Test
    public void shouldApplyRelPropertyCommandToTheStoreInRecovery() throws Exception {
        BatchTransactionApplier applier = this.newApplier(true);
        PropertyRecord before = new PropertyRecord(11L);
        PropertyRecord after = new PropertyRecord(12L);
        after.setRelId(42L);
        Command.PropertyCommand command = new Command.PropertyCommand(before, after);
        boolean result = CommandHandlerContract.apply(applier, arg_0 -> ((Command)command).handle(arg_0), this.transactionToApply);
        Assert.assertFalse((boolean)result);
        ((PropertyStore)Mockito.verify((Object)this.propertyStore, (VerificationMode)Mockito.times((int)1))).setHighestPossibleIdInUse(12L);
        ((PropertyStore)Mockito.verify((Object)this.propertyStore, (VerificationMode)Mockito.times((int)1))).updateRecord(after);
    }

    @Test
    public void shouldApplyRelationshipGroupCommandToTheStore() throws Exception {
        BatchTransactionApplier applier = this.newApplier(false);
        RelationshipGroupRecord before = new RelationshipGroupRecord(42L, 1);
        RelationshipGroupRecord after = new RelationshipGroupRecord(42L, 1, 2L, 3L, 4L, 5L, 6L, true);
        Command.RelationshipGroupCommand command = new Command.RelationshipGroupCommand(before, after);
        boolean result = CommandHandlerContract.apply(applier, arg_0 -> ((Command)command).handle(arg_0), this.transactionToApply);
        Assert.assertFalse((boolean)result);
        ((RecordStore)Mockito.verify(this.relationshipGroupStore, (VerificationMode)Mockito.times((int)1))).updateRecord((AbstractBaseRecord)after);
    }

    @Test
    public void shouldApplyRelationshipGroupCommandToTheStoreInRecovery() throws Exception {
        BatchTransactionApplier applier = this.newApplier(true);
        RelationshipGroupRecord before = new RelationshipGroupRecord(42L, 1);
        RelationshipGroupRecord after = new RelationshipGroupRecord(42L, 1, 2L, 3L, 4L, 5L, 6L, true);
        Command.RelationshipGroupCommand command = new Command.RelationshipGroupCommand(before, after);
        boolean result = CommandHandlerContract.apply(applier, arg_0 -> ((Command)command).handle(arg_0), this.transactionToApply);
        Assert.assertFalse((boolean)result);
        ((RecordStore)Mockito.verify(this.relationshipGroupStore, (VerificationMode)Mockito.times((int)1))).setHighestPossibleIdInUse(after.getId());
        ((RecordStore)Mockito.verify(this.relationshipGroupStore, (VerificationMode)Mockito.times((int)1))).updateRecord((AbstractBaseRecord)after);
    }

    @Test
    public void shouldApplyRelationshipTypeTokenCommandToTheStore() throws Exception {
        BatchTransactionApplier applier = this.newApplier(false);
        RelationshipTypeTokenRecord before = new RelationshipTypeTokenRecord(42);
        RelationshipTypeTokenRecord after = new RelationshipTypeTokenRecord(42);
        after.setInUse(true);
        after.setNameId(323);
        Command.RelationshipTypeTokenCommand command = new Command.RelationshipTypeTokenCommand(before, after);
        boolean result = CommandHandlerContract.apply(applier, arg_0 -> ((Command)command).handle(arg_0), this.transactionToApply);
        Assert.assertFalse((boolean)result);
        ((RelationshipTypeTokenStore)Mockito.verify((Object)this.relationshipTypeTokenStore, (VerificationMode)Mockito.times((int)1))).updateRecord((TokenRecord)after);
    }

    @Test
    public void shouldApplyRelationshipTypeTokenCommandToTheStoreInRecovery() throws Exception {
        BatchTransactionApplier applier = this.newApplier(true);
        RelationshipTypeTokenRecord before = new RelationshipTypeTokenRecord(42);
        RelationshipTypeTokenRecord after = new RelationshipTypeTokenRecord(42);
        after.setInUse(true);
        after.setNameId(323);
        Command.RelationshipTypeTokenCommand command = new Command.RelationshipTypeTokenCommand(before, after);
        RelationshipTypeToken token = new RelationshipTypeToken("token", 21);
        Mockito.when((Object)this.relationshipTypeTokenStore.getToken((int)command.getKey())).thenReturn((Object)token);
        boolean result = CommandHandlerContract.apply(applier, arg_0 -> ((Command.RelationshipTypeTokenCommand)command).handle(arg_0), this.transactionToApply);
        Assert.assertFalse((boolean)result);
        ((RelationshipTypeTokenStore)Mockito.verify((Object)this.relationshipTypeTokenStore, (VerificationMode)Mockito.times((int)1))).setHighestPossibleIdInUse(after.getId());
        ((RelationshipTypeTokenStore)Mockito.verify((Object)this.relationshipTypeTokenStore, (VerificationMode)Mockito.times((int)1))).updateRecord((TokenRecord)after);
        ((CacheAccessBackDoor)Mockito.verify((Object)this.cacheAccess, (VerificationMode)Mockito.times((int)1))).addRelationshipTypeToken(token);
    }

    @Test
    public void shouldApplyLabelTokenCommandToTheStore() throws Exception {
        BatchTransactionApplier applier = this.newApplier(false);
        LabelTokenRecord before = new LabelTokenRecord(42);
        LabelTokenRecord after = new LabelTokenRecord(42);
        after.setInUse(true);
        after.setNameId(323);
        Command.LabelTokenCommand command = new Command.LabelTokenCommand(before, after);
        boolean result = CommandHandlerContract.apply(applier, arg_0 -> ((Command)command).handle(arg_0), this.transactionToApply);
        Assert.assertFalse((boolean)result);
        ((LabelTokenStore)Mockito.verify((Object)this.labelTokenStore, (VerificationMode)Mockito.times((int)1))).updateRecord((TokenRecord)after);
    }

    @Test
    public void shouldApplyLabelTokenCommandToTheStoreInRecovery() throws Exception {
        BatchTransactionApplier applier = this.newApplier(true);
        LabelTokenRecord before = new LabelTokenRecord(42);
        LabelTokenRecord after = new LabelTokenRecord(42);
        after.setInUse(true);
        after.setNameId(323);
        Command.LabelTokenCommand command = new Command.LabelTokenCommand(before, after);
        Token token = new Token("token", 21);
        Mockito.when((Object)this.labelTokenStore.getToken((int)command.getKey())).thenReturn((Object)token);
        boolean result = CommandHandlerContract.apply(applier, arg_0 -> ((Command.LabelTokenCommand)command).handle(arg_0), this.transactionToApply);
        Assert.assertFalse((boolean)result);
        ((LabelTokenStore)Mockito.verify((Object)this.labelTokenStore, (VerificationMode)Mockito.times((int)1))).setHighestPossibleIdInUse(after.getId());
        ((LabelTokenStore)Mockito.verify((Object)this.labelTokenStore, (VerificationMode)Mockito.times((int)1))).updateRecord((TokenRecord)after);
        ((CacheAccessBackDoor)Mockito.verify((Object)this.cacheAccess, (VerificationMode)Mockito.times((int)1))).addLabelToken(token);
    }

    @Test
    public void shouldApplyPropertyKeyTokenCommandToTheStore() throws Exception {
        BatchTransactionApplier applier = this.newApplier(false);
        PropertyKeyTokenRecord before = new PropertyKeyTokenRecord(42);
        PropertyKeyTokenRecord after = new PropertyKeyTokenRecord(42);
        after.setInUse(true);
        after.setNameId(323);
        Command.PropertyKeyTokenCommand command = new Command.PropertyKeyTokenCommand(before, after);
        boolean result = CommandHandlerContract.apply(applier, arg_0 -> ((Command)command).handle(arg_0), this.transactionToApply);
        Assert.assertFalse((boolean)result);
        ((PropertyKeyTokenStore)Mockito.verify((Object)this.propertyKeyTokenStore, (VerificationMode)Mockito.times((int)1))).updateRecord((TokenRecord)after);
    }

    @Test
    public void shouldApplyPropertyKeyTokenCommandToTheStoreInRecovery() throws Exception {
        BatchTransactionApplier applier = this.newApplier(true);
        PropertyKeyTokenRecord before = new PropertyKeyTokenRecord(42);
        PropertyKeyTokenRecord after = new PropertyKeyTokenRecord(42);
        after.setInUse(true);
        after.setNameId(323);
        Command.PropertyKeyTokenCommand command = new Command.PropertyKeyTokenCommand(before, after);
        Token token = new Token("token", 21);
        Mockito.when((Object)this.propertyKeyTokenStore.getToken((int)command.getKey())).thenReturn((Object)token);
        boolean result = CommandHandlerContract.apply(applier, arg_0 -> ((Command.PropertyKeyTokenCommand)command).handle(arg_0), this.transactionToApply);
        Assert.assertFalse((boolean)result);
        ((PropertyKeyTokenStore)Mockito.verify((Object)this.propertyKeyTokenStore, (VerificationMode)Mockito.times((int)1))).setHighestPossibleIdInUse(after.getId());
        ((PropertyKeyTokenStore)Mockito.verify((Object)this.propertyKeyTokenStore, (VerificationMode)Mockito.times((int)1))).updateRecord((TokenRecord)after);
        ((CacheAccessBackDoor)Mockito.verify((Object)this.cacheAccess, (VerificationMode)Mockito.times((int)1))).addPropertyKeyToken(token);
    }

    @Test
    public void shouldApplyCreateIndexRuleSchemaRuleCommandToTheStore() throws Exception {
        BatchTransactionApplier applier = this.newApplierFacade(this.newApplier(false), this.newIndexApplier());
        DynamicRecord record = DynamicRecord.dynamicRecord((long)21L, (boolean)true);
        record.setCreated();
        List<DynamicRecord> recordsAfter = Arrays.asList(record);
        IndexRule rule = IndexRule.indexRule((long)0L, (int)1, (int)2, (SchemaIndexProvider.Descriptor)new SchemaIndexProvider.Descriptor("K", "X.Y"));
        Command.SchemaRuleCommand command = new Command.SchemaRuleCommand(Collections.emptyList(), recordsAfter, (SchemaRule)rule);
        boolean result = CommandHandlerContract.apply(applier, arg_0 -> ((Command.SchemaRuleCommand)command).handle(arg_0), this.transactionToApply);
        Assert.assertFalse((boolean)result);
        ((SchemaStore)Mockito.verify((Object)this.schemaStore, (VerificationMode)Mockito.times((int)1))).updateRecord((AbstractBaseRecord)record);
        ((IndexingService)Mockito.verify((Object)this.indexingService, (VerificationMode)Mockito.times((int)1))).createIndexes(new IndexRule[]{rule});
        ((CacheAccessBackDoor)Mockito.verify((Object)this.cacheAccess, (VerificationMode)Mockito.times((int)1))).addSchemaRule((SchemaRule)rule);
    }

    @Test
    public void shouldApplyCreateIndexRuleSchemaRuleCommandToTheStoreInRecovery() throws Exception {
        BatchTransactionApplier applier = this.newApplierFacade(this.newIndexApplier(), this.newApplier(true));
        DynamicRecord record = DynamicRecord.dynamicRecord((long)21L, (boolean)true);
        record.setCreated();
        List<DynamicRecord> recordsAfter = Arrays.asList(record);
        IndexRule rule = IndexRule.indexRule((long)0L, (int)1, (int)2, (SchemaIndexProvider.Descriptor)new SchemaIndexProvider.Descriptor("K", "X.Y"));
        Command.SchemaRuleCommand command = new Command.SchemaRuleCommand(Collections.emptyList(), recordsAfter, (SchemaRule)rule);
        boolean result = CommandHandlerContract.apply(applier, arg_0 -> ((Command.SchemaRuleCommand)command).handle(arg_0), this.transactionToApply);
        Assert.assertFalse((boolean)result);
        ((SchemaStore)Mockito.verify((Object)this.schemaStore, (VerificationMode)Mockito.times((int)1))).setHighestPossibleIdInUse(record.getId());
        ((SchemaStore)Mockito.verify((Object)this.schemaStore, (VerificationMode)Mockito.times((int)1))).updateRecord((AbstractBaseRecord)record);
        ((IndexingService)Mockito.verify((Object)this.indexingService, (VerificationMode)Mockito.times((int)1))).createIndexes(new IndexRule[]{rule});
        ((CacheAccessBackDoor)Mockito.verify((Object)this.cacheAccess, (VerificationMode)Mockito.times((int)1))).addSchemaRule((SchemaRule)rule);
    }

    @Test
    public void shouldApplyUpdateIndexRuleSchemaRuleCommandToTheStore() throws Exception {
        BatchTransactionApplier applier = this.newApplierFacade(this.newIndexApplier(), this.newApplier(false));
        DynamicRecord record = DynamicRecord.dynamicRecord((long)21L, (boolean)true);
        List<DynamicRecord> recordsAfter = Arrays.asList(record);
        IndexRule rule = IndexRule.constraintIndexRule((long)0L, (int)1, (int)2, (SchemaIndexProvider.Descriptor)new SchemaIndexProvider.Descriptor("K", "X.Y"), (Long)42L);
        Command.SchemaRuleCommand command = new Command.SchemaRuleCommand(Collections.emptyList(), recordsAfter, (SchemaRule)rule);
        boolean result = CommandHandlerContract.apply(applier, arg_0 -> ((Command.SchemaRuleCommand)command).handle(arg_0), this.transactionToApply);
        Assert.assertFalse((boolean)result);
        ((SchemaStore)Mockito.verify((Object)this.schemaStore, (VerificationMode)Mockito.times((int)1))).updateRecord((AbstractBaseRecord)record);
        ((IndexingService)Mockito.verify((Object)this.indexingService, (VerificationMode)Mockito.times((int)1))).activateIndex(rule.getId());
        ((CacheAccessBackDoor)Mockito.verify((Object)this.cacheAccess, (VerificationMode)Mockito.times((int)1))).addSchemaRule((SchemaRule)rule);
    }

    @Test
    public void shouldApplyUpdateIndexRuleSchemaRuleCommandToTheStoreInRecovery() throws Exception {
        BatchTransactionApplier applier = this.newApplierFacade(this.newIndexApplier(), this.newApplier(true));
        DynamicRecord record = DynamicRecord.dynamicRecord((long)21L, (boolean)true);
        List<DynamicRecord> recordsAfter = Arrays.asList(record);
        IndexRule rule = IndexRule.constraintIndexRule((long)0L, (int)1, (int)2, (SchemaIndexProvider.Descriptor)new SchemaIndexProvider.Descriptor("K", "X.Y"), (Long)42L);
        Command.SchemaRuleCommand command = new Command.SchemaRuleCommand(Collections.emptyList(), recordsAfter, (SchemaRule)rule);
        boolean result = CommandHandlerContract.apply(applier, arg_0 -> ((Command.SchemaRuleCommand)command).handle(arg_0), this.transactionToApply);
        Assert.assertFalse((boolean)result);
        ((SchemaStore)Mockito.verify((Object)this.schemaStore, (VerificationMode)Mockito.times((int)1))).setHighestPossibleIdInUse(record.getId());
        ((SchemaStore)Mockito.verify((Object)this.schemaStore, (VerificationMode)Mockito.times((int)1))).updateRecord((AbstractBaseRecord)record);
        ((IndexingService)Mockito.verify((Object)this.indexingService, (VerificationMode)Mockito.times((int)1))).activateIndex(rule.getId());
        ((CacheAccessBackDoor)Mockito.verify((Object)this.cacheAccess, (VerificationMode)Mockito.times((int)1))).addSchemaRule((SchemaRule)rule);
    }

    @Test
    public void shouldApplyUpdateIndexRuleSchemaRuleCommandToTheStoreThrowingIndexProblem() throws IOException, IndexNotFoundKernelException, IndexPopulationFailedKernelException, IndexActivationFailedKernelException {
        BatchTransactionApplier applier = this.newIndexApplier();
        ((IndexingService)Mockito.doThrow((Throwable)new IndexNotFoundKernelException("")).when((Object)this.indexingService)).activateIndex(Matchers.anyLong());
        DynamicRecord record = DynamicRecord.dynamicRecord((long)21L, (boolean)true);
        List<DynamicRecord> recordsAfter = Arrays.asList(record);
        IndexRule rule = IndexRule.constraintIndexRule((long)0L, (int)1, (int)2, (SchemaIndexProvider.Descriptor)new SchemaIndexProvider.Descriptor("K", "X.Y"), (Long)42L);
        Command.SchemaRuleCommand command = new Command.SchemaRuleCommand(Collections.emptyList(), recordsAfter, (SchemaRule)rule);
        try {
            CommandHandlerContract.apply(applier, arg_0 -> ((Command.SchemaRuleCommand)command).handle(arg_0), this.transactionToApply);
            Assert.fail((String)"should have thrown");
        }
        catch (Exception e) {
            Assert.assertTrue((boolean)(e.getCause() instanceof IndexNotFoundKernelException));
        }
    }

    @Test
    public void shouldApplyDeleteIndexRuleSchemaRuleCommandToTheStore() throws Exception {
        BatchTransactionApplier base = this.newApplier(false);
        BatchTransactionApplier indexApplier = this.newIndexApplier();
        BatchTransactionApplierFacade applier = new BatchTransactionApplierFacade(new BatchTransactionApplier[]{base, indexApplier});
        DynamicRecord record = DynamicRecord.dynamicRecord((long)21L, (boolean)true);
        record.setInUse(false);
        List<DynamicRecord> recordsAfter = Arrays.asList(record);
        IndexRule rule = IndexRule.indexRule((long)0L, (int)1, (int)2, (SchemaIndexProvider.Descriptor)new SchemaIndexProvider.Descriptor("K", "X.Y"));
        Command.SchemaRuleCommand command = new Command.SchemaRuleCommand(Collections.emptyList(), recordsAfter, (SchemaRule)rule);
        boolean result = CommandHandlerContract.apply((BatchTransactionApplier)applier, arg_0 -> ((Command.SchemaRuleCommand)command).handle(arg_0), this.transactionToApply);
        Assert.assertFalse((boolean)result);
        ((SchemaStore)Mockito.verify((Object)this.schemaStore, (VerificationMode)Mockito.times((int)1))).updateRecord((AbstractBaseRecord)record);
        ((IndexingService)Mockito.verify((Object)this.indexingService, (VerificationMode)Mockito.times((int)1))).dropIndex(rule);
        ((CacheAccessBackDoor)Mockito.verify((Object)this.cacheAccess, (VerificationMode)Mockito.times((int)1))).removeSchemaRuleFromCache(command.getKey());
    }

    @Test
    public void shouldApplyDeleteIndexRuleSchemaRuleCommandToTheStoreInRecovery() throws Exception {
        BatchTransactionApplier applier = this.newApplierFacade(this.newIndexApplier(), this.newApplier(true));
        DynamicRecord record = DynamicRecord.dynamicRecord((long)21L, (boolean)true);
        record.setInUse(false);
        List<DynamicRecord> recordsAfter = Arrays.asList(record);
        IndexRule rule = IndexRule.indexRule((long)0L, (int)1, (int)2, (SchemaIndexProvider.Descriptor)new SchemaIndexProvider.Descriptor("K", "X.Y"));
        Command.SchemaRuleCommand command = new Command.SchemaRuleCommand(Collections.emptyList(), recordsAfter, (SchemaRule)rule);
        boolean result = CommandHandlerContract.apply(applier, arg_0 -> ((Command.SchemaRuleCommand)command).handle(arg_0), this.transactionToApply);
        Assert.assertFalse((boolean)result);
        ((SchemaStore)Mockito.verify((Object)this.schemaStore, (VerificationMode)Mockito.times((int)1))).setHighestPossibleIdInUse(record.getId());
        ((SchemaStore)Mockito.verify((Object)this.schemaStore, (VerificationMode)Mockito.times((int)1))).updateRecord((AbstractBaseRecord)record);
        ((IndexingService)Mockito.verify((Object)this.indexingService, (VerificationMode)Mockito.times((int)1))).dropIndex(rule);
        ((CacheAccessBackDoor)Mockito.verify((Object)this.cacheAccess, (VerificationMode)Mockito.times((int)1))).removeSchemaRuleFromCache(command.getKey());
    }

    @Test
    public void shouldApplyCreateUniquenessConstraintRuleSchemaRuleCommandToTheStore() throws Exception {
        BatchTransactionApplier applier = this.newApplier(false);
        DynamicRecord record = DynamicRecord.dynamicRecord((long)21L, (boolean)true);
        record.setCreated();
        List<DynamicRecord> recordsAfter = Arrays.asList(record);
        UniquePropertyConstraintRule rule = UniquePropertyConstraintRule.uniquenessConstraintRule((long)0L, (int)1, (int)2, (long)3L);
        Command.SchemaRuleCommand command = new Command.SchemaRuleCommand(Collections.emptyList(), recordsAfter, (SchemaRule)rule);
        boolean result = CommandHandlerContract.apply(applier, arg_0 -> ((Command.SchemaRuleCommand)command).handle(arg_0), this.transactionToApply);
        Assert.assertFalse((boolean)result);
        ((SchemaStore)Mockito.verify((Object)this.schemaStore, (VerificationMode)Mockito.times((int)1))).updateRecord((AbstractBaseRecord)record);
        ((MetaDataStore)Mockito.verify((Object)this.metaDataStore, (VerificationMode)Mockito.times((int)1))).setLatestConstraintIntroducingTx(55555L);
        ((CacheAccessBackDoor)Mockito.verify((Object)this.cacheAccess, (VerificationMode)Mockito.times((int)1))).addSchemaRule((SchemaRule)rule);
    }

    @Test
    public void shouldApplyCreateUniquenessConstraintRuleSchemaRuleCommandToTheStoreInRecovery() throws Exception {
        BatchTransactionApplier applier = this.newApplier(true);
        DynamicRecord record = DynamicRecord.dynamicRecord((long)21L, (boolean)true);
        record.setCreated();
        List<DynamicRecord> recordsAfter = Arrays.asList(record);
        UniquePropertyConstraintRule rule = UniquePropertyConstraintRule.uniquenessConstraintRule((long)0L, (int)1, (int)2, (long)3L);
        Command.SchemaRuleCommand command = new Command.SchemaRuleCommand(Collections.emptyList(), recordsAfter, (SchemaRule)rule);
        boolean result = CommandHandlerContract.apply(applier, arg_0 -> ((Command.SchemaRuleCommand)command).handle(arg_0), this.transactionToApply);
        Assert.assertFalse((boolean)result);
        ((SchemaStore)Mockito.verify((Object)this.schemaStore, (VerificationMode)Mockito.times((int)1))).setHighestPossibleIdInUse(record.getId());
        ((SchemaStore)Mockito.verify((Object)this.schemaStore, (VerificationMode)Mockito.times((int)1))).updateRecord((AbstractBaseRecord)record);
        ((MetaDataStore)Mockito.verify((Object)this.metaDataStore, (VerificationMode)Mockito.times((int)1))).setLatestConstraintIntroducingTx(55555L);
        ((CacheAccessBackDoor)Mockito.verify((Object)this.cacheAccess, (VerificationMode)Mockito.times((int)1))).addSchemaRule((SchemaRule)rule);
    }

    @Test
    public void shouldApplyUpdateUniquenessConstraintRuleSchemaRuleCommandToTheStore() throws Exception {
        BatchTransactionApplier applier = this.newApplier(false);
        DynamicRecord record = DynamicRecord.dynamicRecord((long)21L, (boolean)true);
        List<DynamicRecord> recordsAfter = Arrays.asList(record);
        UniquePropertyConstraintRule rule = UniquePropertyConstraintRule.uniquenessConstraintRule((long)0L, (int)1, (int)2, (long)3L);
        Command.SchemaRuleCommand command = new Command.SchemaRuleCommand(Collections.emptyList(), recordsAfter, (SchemaRule)rule);
        boolean result = CommandHandlerContract.apply(applier, arg_0 -> ((Command.SchemaRuleCommand)command).handle(arg_0), this.transactionToApply);
        Assert.assertFalse((boolean)result);
        ((SchemaStore)Mockito.verify((Object)this.schemaStore, (VerificationMode)Mockito.times((int)1))).updateRecord((AbstractBaseRecord)record);
        ((MetaDataStore)Mockito.verify((Object)this.metaDataStore, (VerificationMode)Mockito.times((int)1))).setLatestConstraintIntroducingTx(55555L);
        ((CacheAccessBackDoor)Mockito.verify((Object)this.cacheAccess, (VerificationMode)Mockito.times((int)1))).addSchemaRule((SchemaRule)rule);
    }

    @Test
    public void shouldApplyUpdateUniquenessConstraintRuleSchemaRuleCommandToTheStoreInRecovery() throws Exception {
        BatchTransactionApplier applier = this.newApplier(true);
        DynamicRecord record = DynamicRecord.dynamicRecord((long)21L, (boolean)true);
        List<DynamicRecord> recordsAfter = Arrays.asList(record);
        UniquePropertyConstraintRule rule = UniquePropertyConstraintRule.uniquenessConstraintRule((long)0L, (int)1, (int)2, (long)3L);
        Command.SchemaRuleCommand command = new Command.SchemaRuleCommand(Collections.emptyList(), recordsAfter, (SchemaRule)rule);
        boolean result = CommandHandlerContract.apply(applier, arg_0 -> ((Command.SchemaRuleCommand)command).handle(arg_0), this.transactionToApply);
        Assert.assertFalse((boolean)result);
        ((SchemaStore)Mockito.verify((Object)this.schemaStore, (VerificationMode)Mockito.times((int)1))).setHighestPossibleIdInUse(record.getId());
        ((SchemaStore)Mockito.verify((Object)this.schemaStore, (VerificationMode)Mockito.times((int)1))).updateRecord((AbstractBaseRecord)record);
        ((MetaDataStore)Mockito.verify((Object)this.metaDataStore, (VerificationMode)Mockito.times((int)1))).setLatestConstraintIntroducingTx(55555L);
        ((CacheAccessBackDoor)Mockito.verify((Object)this.cacheAccess, (VerificationMode)Mockito.times((int)1))).addSchemaRule((SchemaRule)rule);
    }

    @Test
    public void shouldApplyDeleteUniquenessConstraintRuleSchemaRuleCommandToTheStore() throws Exception {
        BatchTransactionApplier applier = this.newApplier(false);
        DynamicRecord record = DynamicRecord.dynamicRecord((long)21L, (boolean)true);
        record.setInUse(false);
        List<DynamicRecord> recordsAfter = Arrays.asList(record);
        UniquePropertyConstraintRule rule = UniquePropertyConstraintRule.uniquenessConstraintRule((long)0L, (int)1, (int)2, (long)3L);
        Command.SchemaRuleCommand command = new Command.SchemaRuleCommand(Collections.emptyList(), recordsAfter, (SchemaRule)rule);
        boolean result = CommandHandlerContract.apply(applier, arg_0 -> ((Command.SchemaRuleCommand)command).handle(arg_0), this.transactionToApply);
        Assert.assertFalse((boolean)result);
        ((SchemaStore)Mockito.verify((Object)this.schemaStore, (VerificationMode)Mockito.times((int)1))).updateRecord((AbstractBaseRecord)record);
        ((MetaDataStore)Mockito.verify((Object)this.metaDataStore, (VerificationMode)Mockito.never())).setLatestConstraintIntroducingTx(55555L);
        ((CacheAccessBackDoor)Mockito.verify((Object)this.cacheAccess, (VerificationMode)Mockito.times((int)1))).removeSchemaRuleFromCache(command.getKey());
    }

    @Test
    public void shouldApplyDeleteUniquenessConstraintRuleSchemaRuleCommandToTheStoreInRecovery() throws Exception {
        BatchTransactionApplier applier = this.newApplier(true);
        DynamicRecord record = DynamicRecord.dynamicRecord((long)21L, (boolean)true);
        record.setInUse(false);
        List<DynamicRecord> recordsAfter = Arrays.asList(record);
        UniquePropertyConstraintRule rule = UniquePropertyConstraintRule.uniquenessConstraintRule((long)0L, (int)1, (int)2, (long)3L);
        Command.SchemaRuleCommand command = new Command.SchemaRuleCommand(Collections.emptyList(), recordsAfter, (SchemaRule)rule);
        boolean result = CommandHandlerContract.apply(applier, arg_0 -> ((Command.SchemaRuleCommand)command).handle(arg_0), this.transactionToApply);
        Assert.assertFalse((boolean)result);
        ((SchemaStore)Mockito.verify((Object)this.schemaStore, (VerificationMode)Mockito.times((int)1))).setHighestPossibleIdInUse(record.getId());
        ((SchemaStore)Mockito.verify((Object)this.schemaStore, (VerificationMode)Mockito.times((int)1))).updateRecord((AbstractBaseRecord)record);
        ((MetaDataStore)Mockito.verify((Object)this.metaDataStore, (VerificationMode)Mockito.never())).setLatestConstraintIntroducingTx(55555L);
        ((CacheAccessBackDoor)Mockito.verify((Object)this.cacheAccess, (VerificationMode)Mockito.times((int)1))).removeSchemaRuleFromCache(command.getKey());
    }

    @Test
    public void shouldApplyNeoStoreCommandToTheStore() throws Exception {
        BatchTransactionApplier applier = this.newApplier(false);
        NeoStoreRecord before = new NeoStoreRecord();
        NeoStoreRecord after = new NeoStoreRecord();
        after.setNextProp(42L);
        Command.NeoStoreCommand command = new Command.NeoStoreCommand(before, after);
        boolean result = CommandHandlerContract.apply(applier, arg_0 -> ((Command)command).handle(arg_0), this.transactionToApply);
        Assert.assertFalse((boolean)result);
        ((MetaDataStore)Mockito.verify((Object)this.metaDataStore, (VerificationMode)Mockito.times((int)1))).setGraphNextProp(after.getNextProp());
    }

    @Test
    public void shouldApplyNeoStoreCommandToTheStoreInRecovery() throws Exception {
        BatchTransactionApplier applier = this.newApplier(true);
        NeoStoreRecord before = new NeoStoreRecord();
        NeoStoreRecord after = new NeoStoreRecord();
        after.setNextProp(42L);
        Command.NeoStoreCommand command = new Command.NeoStoreCommand(before, after);
        boolean result = CommandHandlerContract.apply(applier, arg_0 -> ((Command)command).handle(arg_0), this.transactionToApply);
        Assert.assertFalse((boolean)result);
        ((MetaDataStore)Mockito.verify((Object)this.metaDataStore, (VerificationMode)Mockito.times((int)1))).setGraphNextProp(after.getNextProp());
    }

    private BatchTransactionApplier newApplier(boolean recovery) {
        NeoStoreBatchTransactionApplier applier = new NeoStoreBatchTransactionApplier(this.neoStores, this.cacheAccess, this.lockService);
        if (recovery) {
            applier = this.newApplierFacade(new BatchTransactionApplier[]{new HighIdBatchTransactionApplier(this.neoStores), applier, new CacheInvalidationBatchTransactionApplier(this.neoStores, this.cacheAccess)});
        }
        return applier;
    }

    private BatchTransactionApplier newApplierFacade(BatchTransactionApplier ... appliers) {
        return new BatchTransactionApplierFacade(appliers);
    }

    private BatchTransactionApplier newIndexApplier() {
        return new IndexBatchTransactionApplier(this.indexingService, this.labelScanStoreSynchronizer, this.indexUpdatesSync, this.nodeStore, new PropertyLoader(this.neoStores), new PropertyPhysicalToLogicalConverter(this.propertyStore), TransactionApplicationMode.INTERNAL);
    }
}

