/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.transaction;

import java.io.IOException;
import java.util.Collections;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Mockito;
import org.mockito.stubbing.Answer;
import org.mockito.verification.VerificationMode;
import org.neo4j.kernel.impl.store.record.NodeRecord;
import org.neo4j.kernel.impl.transaction.CommittedTransactionRepresentation;
import org.neo4j.kernel.impl.transaction.TransactionRepresentation;
import org.neo4j.kernel.impl.transaction.command.Command;
import org.neo4j.kernel.impl.transaction.log.LogPosition;
import org.neo4j.kernel.impl.transaction.log.PhysicalTransactionCursor;
import org.neo4j.kernel.impl.transaction.log.PhysicalTransactionRepresentation;
import org.neo4j.kernel.impl.transaction.log.ReadableClosablePositionAwareChannel;
import org.neo4j.kernel.impl.transaction.log.ReadableLogChannel;
import org.neo4j.kernel.impl.transaction.log.entry.CheckPoint;
import org.neo4j.kernel.impl.transaction.log.entry.LogEntry;
import org.neo4j.kernel.impl.transaction.log.entry.LogEntryCommand;
import org.neo4j.kernel.impl.transaction.log.entry.LogEntryCommit;
import org.neo4j.kernel.impl.transaction.log.entry.LogEntryReader;
import org.neo4j.kernel.impl.transaction.log.entry.LogEntryStart;
import org.neo4j.kernel.impl.transaction.log.entry.OnePhaseCommit;
import org.neo4j.storageengine.api.StorageCommand;

public class PhysicalTransactionCursorTest {
    private final ReadableLogChannel channel = (ReadableLogChannel)Mockito.mock(ReadableLogChannel.class, (Answer)Mockito.RETURNS_MOCKS);
    private final LogEntryReader<ReadableLogChannel> entryReader = (LogEntryReader)Mockito.mock(LogEntryReader.class);
    private static final LogEntry NULL_ENTRY = null;
    private static final CheckPoint A_CHECK_POINT_ENTRY = new CheckPoint(LogPosition.UNSPECIFIED);
    private static final LogEntryStart A_START_ENTRY = new LogEntryStart(0, 0, 0L, 0L, null, LogPosition.UNSPECIFIED);
    private static final LogEntryCommit A_COMMIT_ENTRY = new OnePhaseCommit(42L, 0L);
    private static final LogEntryCommand A_COMMAND_ENTRY = new LogEntryCommand((StorageCommand)new Command.NodeCommand(new NodeRecord(42L), new NodeRecord(42L)));
    private PhysicalTransactionCursor<ReadableLogChannel> cursor;

    @Before
    public void setup() throws IOException {
        this.cursor = new PhysicalTransactionCursor((ReadableClosablePositionAwareChannel)this.channel, this.entryReader);
    }

    @Test
    public void shouldCloseTheUnderlyingChannel() throws IOException {
        this.cursor.close();
        ((ReadableLogChannel)Mockito.verify((Object)this.channel, (VerificationMode)Mockito.times((int)1))).close();
    }

    @Test
    public void shouldReturnFalseWhenThereAreNoEntries() throws IOException {
        Mockito.when((Object)this.entryReader.readLogEntry((ReadableClosablePositionAwareChannel)this.channel)).thenReturn((Object)NULL_ENTRY);
        boolean result = this.cursor.next();
        Assert.assertFalse((boolean)result);
        Assert.assertNull((Object)this.cursor.get());
    }

    @Test
    public void shouldReturnFalseWhenThereIsAStartEntryButNoCommitEntries() throws IOException {
        Mockito.when((Object)this.entryReader.readLogEntry((ReadableClosablePositionAwareChannel)this.channel)).thenReturn((Object)A_START_ENTRY, (Object[])new LogEntry[]{NULL_ENTRY});
        boolean result = this.cursor.next();
        Assert.assertFalse((boolean)result);
        Assert.assertNull((Object)this.cursor.get());
    }

    @Test
    public void shouldCallTheVisitorWithTheFoundTransaction() throws IOException {
        Mockito.when((Object)this.entryReader.readLogEntry((ReadableClosablePositionAwareChannel)this.channel)).thenReturn((Object)A_START_ENTRY, (Object[])new LogEntry[]{A_COMMAND_ENTRY, A_COMMIT_ENTRY});
        this.cursor.next();
        PhysicalTransactionRepresentation txRepresentation = new PhysicalTransactionRepresentation(Collections.singletonList(A_COMMAND_ENTRY.getXaCommand()));
        Assert.assertEquals((Object)new CommittedTransactionRepresentation(A_START_ENTRY, (TransactionRepresentation)txRepresentation, A_COMMIT_ENTRY), (Object)this.cursor.get());
    }

    @Test
    public void shouldSkipCheckPoints() throws IOException {
        Mockito.when((Object)this.entryReader.readLogEntry((ReadableClosablePositionAwareChannel)this.channel)).thenReturn((Object)A_CHECK_POINT_ENTRY, (Object[])new LogEntry[]{A_START_ENTRY, A_COMMAND_ENTRY, A_COMMIT_ENTRY, A_CHECK_POINT_ENTRY});
        this.cursor.next();
        PhysicalTransactionRepresentation txRepresentation = new PhysicalTransactionRepresentation(Collections.singletonList(A_COMMAND_ENTRY.getXaCommand()));
        Assert.assertEquals((Object)new CommittedTransactionRepresentation(A_START_ENTRY, (TransactionRepresentation)txRepresentation, A_COMMIT_ENTRY), (Object)this.cursor.get());
    }
}

