/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.transaction;

import org.junit.Assert;
import org.junit.Test;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import org.neo4j.kernel.impl.transaction.log.LogHeaderCache;
import org.neo4j.kernel.impl.transaction.log.PhysicalLogFileInformation;
import org.neo4j.kernel.impl.transaction.log.PhysicalLogFiles;
import org.neo4j.kernel.impl.transaction.log.TransactionIdStore;
import org.neo4j.kernel.impl.transaction.log.entry.LogHeader;

public class PhysicalLogFileInformationTest {
    private PhysicalLogFiles logFiles = (PhysicalLogFiles)Mockito.mock(PhysicalLogFiles.class);
    private LogHeaderCache logHeaderCache = (LogHeaderCache)Mockito.mock(LogHeaderCache.class);
    private TransactionIdStore transactionIdStore = (TransactionIdStore)Mockito.mock(TransactionIdStore.class);
    private PhysicalLogFileInformation.LogVersionToTimestamp logVersionToTimestamp = (PhysicalLogFileInformation.LogVersionToTimestamp)Mockito.mock(PhysicalLogFileInformation.LogVersionToTimestamp.class);

    @Test
    public void shouldReadAndCacheFirstCommittedTransactionIdForAGivenVersionWhenNotCached() throws Exception {
        PhysicalLogFileInformation info = new PhysicalLogFileInformation(this.logFiles, this.logHeaderCache, () -> ((TransactionIdStore)this.transactionIdStore).getLastCommittedTransactionId(), this.logVersionToTimestamp);
        long expected = 5L;
        long version = 10L;
        Mockito.when((Object)this.logHeaderCache.getLogHeader(version)).thenReturn(null);
        Mockito.when((Object)this.logFiles.versionExists(version)).thenReturn((Object)true);
        Mockito.when((Object)this.logFiles.extractHeader(version)).thenReturn((Object)new LogHeader(-1, -1L, expected - 1L));
        long firstCommittedTxId = info.getFirstEntryId(version);
        Assert.assertEquals((long)expected, (long)firstCommittedTxId);
        ((LogHeaderCache)Mockito.verify((Object)this.logHeaderCache, (VerificationMode)Mockito.times((int)1))).putHeader(version, expected - 1L);
    }

    @Test
    public void shouldReadFirstCommittedTransactionIdForAGivenVersionWhenCached() throws Exception {
        PhysicalLogFileInformation info = new PhysicalLogFileInformation(this.logFiles, this.logHeaderCache, () -> ((TransactionIdStore)this.transactionIdStore).getLastCommittedTransactionId(), this.logVersionToTimestamp);
        long expected = 5L;
        long version = 10L;
        Mockito.when((Object)this.logHeaderCache.getLogHeader(version)).thenReturn((Object)(expected - 1L));
        long firstCommittedTxId = info.getFirstEntryId(version);
        Assert.assertEquals((long)expected, (long)firstCommittedTxId);
    }

    @Test
    public void shouldReadAndCacheFirstCommittedTransactionIdWhenNotCached() throws Exception {
        PhysicalLogFileInformation info = new PhysicalLogFileInformation(this.logFiles, this.logHeaderCache, () -> ((TransactionIdStore)this.transactionIdStore).getLastCommittedTransactionId(), this.logVersionToTimestamp);
        long expected = 5L;
        long version = 10L;
        Mockito.when((Object)this.logFiles.getHighestLogVersion()).thenReturn((Object)version);
        Mockito.when((Object)this.logHeaderCache.getLogHeader(version)).thenReturn(null);
        Mockito.when((Object)this.logFiles.versionExists(version)).thenReturn((Object)true);
        Mockito.when((Object)this.logFiles.extractHeader(version)).thenReturn((Object)new LogHeader(-1, -1L, expected - 1L));
        Mockito.when((Object)this.logFiles.hasAnyEntries(version)).thenReturn((Object)true);
        long firstCommittedTxId = info.getFirstExistingEntryId();
        Assert.assertEquals((long)expected, (long)firstCommittedTxId);
        ((LogHeaderCache)Mockito.verify((Object)this.logHeaderCache, (VerificationMode)Mockito.times((int)1))).putHeader(version, expected - 1L);
    }

    @Test
    public void shouldReadFirstCommittedTransactionIdWhenCached() throws Exception {
        PhysicalLogFileInformation info = new PhysicalLogFileInformation(this.logFiles, this.logHeaderCache, () -> ((TransactionIdStore)this.transactionIdStore).getLastCommittedTransactionId(), this.logVersionToTimestamp);
        long expected = 5L;
        long version = 10L;
        Mockito.when((Object)this.logFiles.getHighestLogVersion()).thenReturn((Object)version);
        Mockito.when((Object)this.logFiles.versionExists(version)).thenReturn((Object)true);
        Mockito.when((Object)this.logHeaderCache.getLogHeader(version)).thenReturn((Object)(expected - 1L));
        Mockito.when((Object)this.logFiles.hasAnyEntries(version)).thenReturn((Object)true);
        long firstCommittedTxId = info.getFirstExistingEntryId();
        Assert.assertEquals((long)expected, (long)firstCommittedTxId);
    }

    @Test
    public void shouldReturnNothingWhenThereAreNoTransactions() throws Exception {
        PhysicalLogFileInformation info = new PhysicalLogFileInformation(this.logFiles, this.logHeaderCache, () -> ((TransactionIdStore)this.transactionIdStore).getLastCommittedTransactionId(), this.logVersionToTimestamp);
        long version = 10L;
        Mockito.when((Object)this.logFiles.getHighestLogVersion()).thenReturn((Object)version);
        Mockito.when((Object)this.logFiles.hasAnyEntries(version)).thenReturn((Object)false);
        long firstCommittedTxId = info.getFirstExistingEntryId();
        Assert.assertEquals((long)-1L, (long)firstCommittedTxId);
    }
}

