/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.storemigration.legacystore.v21.propertydeduplication;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.ClassRule;
import org.junit.Test;
import org.mockito.Mockito;
import org.neo4j.graphdb.DependencyResolver;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.graphdb.Label;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.Transaction;
import org.neo4j.kernel.impl.storageengine.impl.recordstorage.RecordStorageEngine;
import org.neo4j.kernel.impl.store.NeoStores;
import org.neo4j.kernel.impl.store.NodeStore;
import org.neo4j.kernel.impl.store.PropertyStore;
import org.neo4j.kernel.impl.store.RecordStore;
import org.neo4j.kernel.impl.store.record.NodeRecord;
import org.neo4j.kernel.impl.storemigration.legacystore.v21.propertydeduplication.DeferredIndexedConflictResolution;
import org.neo4j.kernel.impl.storemigration.legacystore.v21.propertydeduplication.DuplicateCluster;
import org.neo4j.kernel.impl.storemigration.legacystore.v21.propertydeduplication.DuplicatePropertyRemover;
import org.neo4j.kernel.impl.storemigration.legacystore.v21.propertydeduplication.IndexLookup;
import org.neo4j.kernel.impl.storemigration.legacystore.v21.propertydeduplication.IndexLookupTest;
import org.neo4j.kernel.impl.storemigration.legacystore.v21.propertydeduplication.PropertyDeduplicatorTestUtil;
import org.neo4j.kernel.internal.GraphDatabaseAPI;
import org.neo4j.test.TargetDirectory;
import org.neo4j.test.TestGraphDatabaseFactory;

public class DeferredIndexedConflictResolutionTest {
    @ClassRule
    public static TargetDirectory.TestDirectory storePath = TargetDirectory.testDirForTest(IndexLookupTest.class);
    private NodeRecord nodeRecord;
    private PropertyStore propertyStore;
    private NodeStore nodeStore;
    private List<DuplicateCluster> clusters;
    private DuplicateCluster clusterToRemove;
    private GraphDatabaseService db;

    @Test
    public void shouldRemoveDuplicateClustersForWhichThereIsAnIndex() throws IOException {
        DuplicatePropertyRemover remover = new DuplicatePropertyRemover(this.nodeStore, this.propertyStore);
        IndexLookup indexLookup = (IndexLookup)Mockito.mock(IndexLookup.class);
        IndexLookup.Index indexStub = new IndexLookup.Index(){

            public boolean contains(long nodeId, Object propertyValue) throws IOException {
                return true;
            }
        };
        Mockito.when((Object)indexLookup.getAnyIndexOrNull((long[])org.mockito.Matchers.any(long[].class), org.mockito.Matchers.intThat((Matcher)Matchers.is((Object)this.clusterToRemove.propertyKeyId)))).thenReturn((Object)indexStub);
        DeferredIndexedConflictResolution resolution = new DeferredIndexedConflictResolution(this.nodeRecord, this.clusters, this.nodeStore, indexLookup, this.propertyStore, remover);
        resolution.resolve();
        Assert.assertThat(this.clusters, (Matcher)Matchers.not((Matcher)Matchers.contains((Matcher)Matchers.sameInstance((Object)this.clusterToRemove))));
    }

    @Before
    public void setUp() {
        long nodeId;
        TestGraphDatabaseFactory factory = new TestGraphDatabaseFactory();
        this.db = factory.newEmbeddedDatabase(storePath.absolutePath());
        GraphDatabaseAPI api = (GraphDatabaseAPI)this.db;
        Label nodeLabel = Label.label((String)"Label");
        String propertyKey = "someProp";
        try (Transaction transaction = this.db.beginTx();){
            Node node = this.db.createNode(new Label[]{nodeLabel});
            node.setProperty(propertyKey, (Object)"someVal");
            nodeId = node.getId();
            transaction.success();
        }
        DependencyResolver resolver = api.getDependencyResolver();
        NeoStores neoStores = ((RecordStorageEngine)resolver.resolveDependency(RecordStorageEngine.class)).testAccessNeoStores();
        this.nodeStore = neoStores.getNodeStore();
        this.propertyStore = neoStores.getPropertyStore();
        Map<String, Integer> propertyKeys = PropertyDeduplicatorTestUtil.indexPropertyKeys(neoStores.getPropertyKeyTokenStore());
        this.nodeRecord = (NodeRecord)RecordStore.getRecord((RecordStore)this.nodeStore, (long)nodeId);
        int propertyKeyId = propertyKeys.get(propertyKey);
        this.clusterToRemove = this.createDuplicateCluster(propertyKeyId, this.nodeRecord.getNextProp());
        this.clusters = new ArrayList<DuplicateCluster>();
        this.clusters.add(this.createDuplicateCluster(propertyKeyId + 1, this.nodeRecord.getNextProp()));
        this.clusters.add(this.clusterToRemove);
        this.clusters.add(this.createDuplicateCluster(propertyKeyId + 2, this.nodeRecord.getNextProp()));
    }

    @After
    public void tearDown() {
        this.db.shutdown();
    }

    private DuplicateCluster createDuplicateCluster(int propertyKeyId, long firstPropertyId) {
        DuplicateCluster cluster = new DuplicateCluster(propertyKeyId);
        cluster.propertyRecordIds.add(firstPropertyId);
        return cluster;
    }
}

