/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.storemigration;

import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collection;
import org.junit.Assert;
import org.junit.Assume;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.experimental.runners.Enclosed;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import org.neo4j.graphdb.factory.GraphDatabaseSettings;
import org.neo4j.io.fs.DefaultFileSystemAbstraction;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.io.pagecache.PageCache;
import org.neo4j.kernel.impl.store.MetaDataStore;
import org.neo4j.kernel.impl.store.format.RecordFormats;
import org.neo4j.kernel.impl.store.format.StoreVersion;
import org.neo4j.kernel.impl.store.format.standard.StandardV2_0;
import org.neo4j.kernel.impl.store.format.standard.StandardV2_1;
import org.neo4j.kernel.impl.store.format.standard.StandardV2_2;
import org.neo4j.kernel.impl.store.format.standard.StandardV2_3;
import org.neo4j.kernel.impl.store.format.standard.StandardV3_0;
import org.neo4j.kernel.impl.storemigration.MigrationTestUtils;
import org.neo4j.kernel.impl.storemigration.StoreUpgrader;
import org.neo4j.kernel.impl.storemigration.StoreVersionCheck;
import org.neo4j.kernel.impl.storemigration.UpgradableDatabase;
import org.neo4j.kernel.impl.storemigration.legacystore.LegacyStoreVersionCheck;
import org.neo4j.kernel.internal.Version;
import org.neo4j.string.UTF8;
import org.neo4j.test.PageCacheRule;
import org.neo4j.test.TargetDirectory;

@RunWith(value=Enclosed.class)
public class UpgradableDatabaseTest {
    private static final FileSystemAbstraction fileSystem = new DefaultFileSystemAbstraction();

    private static RecordFormats getRecordFormat() {
        return StandardV3_0.RECORD_FORMATS;
    }

    @RunWith(value=Parameterized.class)
    public static class UnsupportedVersions {
        @Rule
        public final TargetDirectory.TestDirectory testDirectory = TargetDirectory.testDirForTest(this.getClass());
        @Parameterized.Parameter(value=0)
        public String version;
        private File workingDirectory;
        private static final String neostoreFilename = "neostore";
        @Rule
        public final PageCacheRule pageCacheRule = new PageCacheRule();

        @Parameterized.Parameters(name="{0}")
        public static Collection<String> versions() {
            return Arrays.asList("v0.9.5", "v0.A.4", StoreVersion.HIGH_LIMIT_V3_0_0.versionString());
        }

        @Before
        public void setup() throws IOException {
            this.workingDirectory = this.testDirectory.graphDbDir();
            MigrationTestUtils.findFormatStoreDirectoryForVersion(StandardV2_1.STORE_VERSION, this.workingDirectory);
            MigrationTestUtils.changeVersionNumber(fileSystem, new File(this.workingDirectory, neostoreFilename), this.version);
            File metadataStore = new File(this.workingDirectory, neostoreFilename);
            MetaDataStore.setRecord((PageCache)this.pageCacheRule.getPageCache(fileSystem), (File)metadataStore, (MetaDataStore.Position)MetaDataStore.Position.STORE_VERSION, (long)MetaDataStore.versionStringToLong((String)this.version));
        }

        @Test
        public void shouldDetectOldVersionAsDifferentFromCurrent() throws Exception {
            UpgradableDatabase upgradableDatabase = new UpgradableDatabase(fileSystem, new StoreVersionCheck(this.pageCacheRule.getPageCache(fileSystem)), new LegacyStoreVersionCheck(fileSystem), UpgradableDatabaseTest.getRecordFormat());
            boolean currentVersion = upgradableDatabase.hasCurrentVersion(this.workingDirectory);
            Assert.assertFalse((boolean)currentVersion);
        }

        @Test
        public void shouldCommunicateWhatCausesInabilityToUpgrade() {
            UpgradableDatabase upgradableDatabase = new UpgradableDatabase(fileSystem, new StoreVersionCheck(this.pageCacheRule.getPageCache(fileSystem)), new LegacyStoreVersionCheck(fileSystem), UpgradableDatabaseTest.getRecordFormat());
            try {
                upgradableDatabase.checkUpgradeable(this.workingDirectory);
                Assert.fail((String)"should not have been able to upgrade");
            }
            catch (StoreUpgrader.UnexpectedUpgradingStoreVersionException e) {
                Assert.assertFalse((boolean)StoreVersion.isEnterpriseStoreVersion((String)this.version));
                Assert.assertEquals((Object)String.format("Not possible to upgrade a store with version '%s' to current store version `%s` (Neo4j %s).", this.version, upgradableDatabase.currentVersion(), Version.getNeo4jVersion()), (Object)e.getMessage());
            }
            catch (StoreUpgrader.UnexpectedUpgradingStoreFormatException e) {
                Assert.assertTrue((boolean)StoreVersion.isEnterpriseStoreVersion((String)this.version));
                Assert.assertEquals((Object)String.format("This is an enterprise-only store. Please configure '%s' to open.", GraphDatabaseSettings.record_format.name()), (Object)e.getMessage());
            }
        }
    }

    @RunWith(value=Parameterized.class)
    public static class SupportedVersions {
        @Rule
        public final TargetDirectory.TestDirectory testDirectory = TargetDirectory.testDirForTest(this.getClass());
        @Parameterized.Parameter(value=0)
        public String version;
        private File workingDirectory;
        @Rule
        public final PageCacheRule pageCacheRule = new PageCacheRule();

        @Parameterized.Parameters(name="{0}")
        public static Collection<String> versions() {
            return Arrays.asList(StandardV2_0.STORE_VERSION, StandardV2_1.STORE_VERSION, StandardV2_2.STORE_VERSION, StandardV2_3.STORE_VERSION);
        }

        @Before
        public void setup() throws IOException {
            this.workingDirectory = this.testDirectory.graphDbDir();
            MigrationTestUtils.findFormatStoreDirectoryForVersion(this.version, this.workingDirectory);
        }

        boolean storeFilesUpgradeable(File storeDirectory, UpgradableDatabase upgradableDatabase) {
            try {
                upgradableDatabase.checkUpgradeable(storeDirectory);
                return true;
            }
            catch (StoreUpgrader.UnableToUpgradeException e) {
                return false;
            }
        }

        @Test
        public void shouldAcceptTheStoresInTheSampleDatabaseAsBeingEligibleForUpgrade() {
            UpgradableDatabase upgradableDatabase = new UpgradableDatabase(fileSystem, new StoreVersionCheck(this.pageCacheRule.getPageCache(fileSystem)), new LegacyStoreVersionCheck(fileSystem), UpgradableDatabaseTest.getRecordFormat());
            boolean result = this.storeFilesUpgradeable(this.workingDirectory, upgradableDatabase);
            Assert.assertTrue((boolean)result);
        }

        @Test
        public void shouldRejectStoresIfOneFileHasIncorrectVersion() throws IOException {
            Assume.assumeFalse((boolean)StandardV2_3.STORE_VERSION.equals(this.version));
            MigrationTestUtils.changeVersionNumber(fileSystem, new File(this.workingDirectory, "neostore.nodestore.db"), "v0.9.5");
            UpgradableDatabase upgradableDatabase = new UpgradableDatabase(fileSystem, new StoreVersionCheck(this.pageCacheRule.getPageCache(fileSystem)), new LegacyStoreVersionCheck(fileSystem), UpgradableDatabaseTest.getRecordFormat());
            boolean result = this.storeFilesUpgradeable(this.workingDirectory, upgradableDatabase);
            Assert.assertFalse((boolean)result);
        }

        @Test
        public void shouldDetectOldVersionAsDifferentFromCurrent() throws Exception {
            UpgradableDatabase upgradableDatabase = new UpgradableDatabase(fileSystem, new StoreVersionCheck(this.pageCacheRule.getPageCache(fileSystem)), new LegacyStoreVersionCheck(fileSystem), UpgradableDatabaseTest.getRecordFormat());
            boolean currentVersion = upgradableDatabase.hasCurrentVersion(this.workingDirectory);
            Assert.assertFalse((boolean)currentVersion);
        }

        @Test
        public void shouldRejectStoresIfOneFileShorterThanExpectedVersionString() throws IOException {
            Assume.assumeFalse((boolean)StandardV2_3.STORE_VERSION.equals(this.version));
            int shortFileLength = 15;
            Assert.assertTrue((15 < UTF8.encode((String)("StringPropertyStore " + this.version)).length ? 1 : 0) != 0);
            MigrationTestUtils.truncateToFixedLength(fileSystem, new File(this.workingDirectory, "neostore.relationshiptypestore.db"), 15);
            UpgradableDatabase upgradableDatabase = new UpgradableDatabase(fileSystem, new StoreVersionCheck(this.pageCacheRule.getPageCache(fileSystem)), new LegacyStoreVersionCheck(fileSystem), UpgradableDatabaseTest.getRecordFormat());
            boolean result = this.storeFilesUpgradeable(this.workingDirectory, upgradableDatabase);
            Assert.assertFalse((boolean)result);
        }

        @Test
        public void shouldRejectStoresIfDBIsNotShutdownCleanly() throws IOException {
            Assume.assumeTrue((boolean)StandardV2_3.STORE_VERSION.equals(this.version));
            MigrationTestUtils.removeCheckPointFromTxLog(fileSystem, this.workingDirectory);
            UpgradableDatabase upgradableDatabase = new UpgradableDatabase(fileSystem, new StoreVersionCheck(this.pageCacheRule.getPageCache(fileSystem)), new LegacyStoreVersionCheck(fileSystem), UpgradableDatabaseTest.getRecordFormat());
            boolean result = this.storeFilesUpgradeable(this.workingDirectory, upgradableDatabase);
            Assert.assertFalse((boolean)result);
        }
    }
}

