/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.store.format;

import java.util.Arrays;
import java.util.Collection;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import org.neo4j.kernel.impl.store.format.StoreVersion;

@RunWith(value=Parameterized.class)
public class StoreVersionTest {
    @Parameterized.Parameter(value=0)
    public String version;

    @Parameterized.Parameters(name="{0}")
    public static Collection<String> versions() {
        return Arrays.asList(StoreVersion.STANDARD_V2_0.versionString(), StoreVersion.STANDARD_V2_1.versionString(), StoreVersion.STANDARD_V2_2.versionString(), StoreVersion.STANDARD_V2_3.versionString(), StoreVersion.STANDARD_V3_0.versionString());
    }

    @Test
    public void shouldBeCommunityFormat() {
        Assert.assertTrue((String)"Expected community format", (boolean)StoreVersion.isCommunityStoreVersion((String)this.version));
    }

    @Test
    public void shouldNotBeLabeledEnterpriseFormat() {
        Assert.assertFalse((String)"Expected non-enterprise format", (boolean)StoreVersion.isEnterpriseStoreVersion((String)this.version));
    }

    @RunWith(value=Parameterized.class)
    public static class EnterpriseVersions {
        @Parameterized.Parameter(value=0)
        public String version;

        @Parameterized.Parameters(name="{0}")
        public static Collection<String> versions() {
            return Arrays.asList(StoreVersion.HIGH_LIMIT_V3_0_0.versionString());
        }

        @Test
        public void shouldBeCommunityFormat() {
            Assert.assertFalse((String)"Expected non-community format", (boolean)StoreVersion.isCommunityStoreVersion((String)this.version));
        }

        @Test
        public void shouldNotBeLabeledEnterpriseFormat() {
            Assert.assertTrue((String)"Expected enterprise format", (boolean)StoreVersion.isEnterpriseStoreVersion((String)this.version));
        }
    }
}

