/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.store;

import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import java.util.concurrent.TimeUnit;
import org.junit.Ignore;
import org.junit.Test;

@Ignore(value="Not used anymore")
public abstract class TestShortString {
    private static Random random = new Random();

    @Test
    public void canEncodeEmptyString() throws Exception {
        this.assertCanEncode("");
    }

    @Test
    public void canEncodeReallyLongString() throws Exception {
        this.assertCanEncode("                    ");
        this.assertCanEncode("                ");
    }

    @Test
    public void canEncodeFifteenSpaces() throws Exception {
        this.assertCanEncode("               ");
    }

    @Test
    public void canEncodeNumericalString() throws Exception {
        this.assertCanEncode("0123456789+,'.-");
        this.assertCanEncode(" ,'.-0123456789");
        this.assertCanEncode("+ '.0123456789-");
        this.assertCanEncode("+, 0123456789.-");
        this.assertCanEncode("+,0123456789' -");
        this.assertCanEncode("+0123456789,'. ");
        this.assertCanEncode("192.168.0.1");
        this.assertCanEncode("127.0.0.1");
        this.assertCanEncode("255.255.255.255");
    }

    @Test
    public void canEncodeTooLongStringsWithCharsInDifferentTables() throws Exception {
        this.assertCanEncode("____________+");
        this.assertCanEncode("_____+_____");
        this.assertCanEncode("____+____");
        this.assertCanEncode("HELLO world");
        this.assertCanEncode("Hello_World");
    }

    @Test
    public void canEncodeUpToNineEuropeanChars() throws Exception {
        this.assertCanEncode("f\u00e5gel");
        this.assertCanEncode("p\u00e5f\u00e5gel");
        this.assertCanEncode("p\u00e5f\u00e5gel\u00f6");
        this.assertCanEncode("p\u00e5f\u00e5gel\u00f6n");
        this.assertCanEncode("p\u00e5f\u00e5gel\u00f6ar");
    }

    @Test
    public void canEncodeEuropeanCharsWithPunctuation() throws Exception {
        this.assertCanEncode("qHm7 pp3");
        this.assertCanEncode("UKKY3t.gk");
    }

    @Test
    public void canEncodeAlphanumerical() throws Exception {
        this.assertCanEncode("1234567890");
        this.assertCanEncodeInBothCasings("HelloWor1d");
        this.assertCanEncode("          ");
        this.assertCanEncode("_ _ _ _ _ ");
        this.assertCanEncode("H3Lo_ or1D");
        this.assertCanEncode("q1w2e3r4t+");
    }

    @Test
    public void canEncodeHighUnicode() throws Exception {
        this.assertCanEncode("\u02ff");
        this.assertCanEncode("hello\u02ff");
    }

    @Test
    public void canEncodeLatin1SpecialChars() throws Exception {
        this.assertCanEncode("#$#$#$#");
        this.assertCanEncode("$hello#");
    }

    @Test
    public void canEncodeTooLongLatin1String() throws Exception {
        this.assertCanEncode("#$#$#$#$");
    }

    @Test
    public void canEncodeLowercaseAndUppercaseStringsUpTo12Chars() throws Exception {
        this.assertCanEncodeInBothCasings("hello world");
        this.assertCanEncode("hello_world");
        this.assertCanEncode("_hello_world");
        this.assertCanEncode("hello::world");
        this.assertCanEncode("hello//world");
        this.assertCanEncode("hello world");
        this.assertCanEncode("http://ok");
        this.assertCanEncode("::::::::");
        this.assertCanEncode(" _.-:/ _.-:/");
    }

    private void assertCanEncodeInBothCasings(String string) {
        this.assertCanEncode(string.toLowerCase());
        this.assertCanEncode(string.toUpperCase());
    }

    protected abstract void assertCanEncode(String var1);

    public static void main(String[] args) {
        TestShortString.microbench(10L, TimeUnit.SECONDS, Charset.UNIFORM_ASCII);
        TestShortString.microbench(10L, TimeUnit.SECONDS, Charset.SYMBOLS);
        TestShortString.microbench(10L, TimeUnit.SECONDS, Charset.LONG);
        TestShortString.microbench(10L, TimeUnit.SECONDS, Charset.INT);
        TestShortString.microbench(10L, TimeUnit.SECONDS, Charset.UNIFORM_LATIN);
        TestShortString.microbench(10L, TimeUnit.SECONDS, Charset.UNICODE);
    }

    private static void microbench(long time, TimeUnit unit, Charset charset) {
        long remaining;
        long start;
        long successes = 0L;
        long failures = 0L;
        long errors = 0L;
        for (remaining = time = unit.toMillis(time); remaining > 0L; remaining -= System.currentTimeMillis() - start) {
            List<String> strings = TestShortString.randomStrings(1000, charset, 15);
            start = System.currentTimeMillis();
            for (String string : strings) {
                String result = TestShortString.roundtrip(string);
                if (result != null) {
                    if (string.equals(result)) {
                        ++successes;
                        continue;
                    }
                    ++errors;
                    System.out.printf("Expected: %s, got: %s%n", string, result);
                    continue;
                }
                ++failures;
            }
        }
        time -= remaining;
        System.out.printf("=== %s ===%n", charset.name());
        System.out.printf("%s successful, %s non-convertable, %s misconverted%n", successes, failures, errors);
        long total = successes + failures + errors;
        System.out.printf("%.3f conversions per ms%n", (double)total / (double)time);
        System.out.printf("%.2f%% success rate%n", 100.0 * ((double)successes / (double)total));
    }

    private static String roundtrip(String string) {
        return null;
    }

    public static List<String> randomStrings(int count, Charset charset, int maxLen) {
        ArrayList<String> result = new ArrayList<String>(count);
        for (int i = 0; i < count; ++i) {
            result.add(charset.randomString(maxLen));
        }
        return result;
    }

    public static abstract class Charset
    extends Enum<Charset> {
        public static final /* enum */ Charset UNIFORM_ASCII;
        public static final /* enum */ Charset SYMBOLS;
        public static final /* enum */ Charset UNIFORM_LATIN;
        public static final /* enum */ Charset LONG;
        public static final /* enum */ Charset INT;
        public static final /* enum */ Charset UNICODE;
        static char[] SYMBOL_CHARS;
        private static final /* synthetic */ Charset[] $VALUES;

        public static Charset[] values() {
            return (Charset[])$VALUES.clone();
        }

        public static Charset valueOf(String name) {
            return Enum.valueOf(Charset.class, name);
        }

        abstract String randomString(int var1);

        static {
            int c;
            UNIFORM_ASCII = new Charset(){

                @Override
                String randomString(int maxLen) {
                    char[] chars = new char[random.nextInt(maxLen + 1)];
                    for (int i = 0; i < chars.length; ++i) {
                        chars[i] = (char)(32 + random.nextInt(94));
                    }
                    return new String(chars);
                }
            };
            SYMBOLS = new Charset(){

                @Override
                String randomString(int maxLen) {
                    char[] chars = new char[random.nextInt(maxLen + 1)];
                    for (int i = 0; i < chars.length; ++i) {
                        chars[i] = SYMBOL_CHARS[random.nextInt(SYMBOL_CHARS.length)];
                    }
                    return new String(chars);
                }
            };
            UNIFORM_LATIN = new Charset(){

                @Override
                String randomString(int maxLen) {
                    char[] chars = new char[random.nextInt(maxLen + 1)];
                    for (int i = 0; i < chars.length; ++i) {
                        chars[i] = (char)(32 + random.nextInt(192));
                        if (chars[i] <= '\u007f') continue;
                        int n = i;
                        chars[n] = (char)(chars[n] + 32);
                    }
                    return new String(chars);
                }
            };
            LONG = new Charset(){

                @Override
                String randomString(int maxLen) {
                    return Long.toString(random.nextLong() % (long)Math.pow(10.0, maxLen));
                }
            };
            INT = new Charset(){

                @Override
                String randomString(int maxLen) {
                    return Long.toString(random.nextInt());
                }
            };
            UNICODE = new Charset(){

                @Override
                String randomString(int maxLen) {
                    char[] chars = new char[random.nextInt(maxLen + 1)];
                    for (int i = 0; i < chars.length; ++i) {
                        chars[i] = (char)(1 + random.nextInt(55294));
                    }
                    return new String(chars);
                }
            };
            $VALUES = new Charset[]{UNIFORM_ASCII, SYMBOLS, UNIFORM_LATIN, LONG, INT, UNICODE};
            SYMBOL_CHARS = new char[63];
            Charset.SYMBOL_CHARS[0] = 95;
            int i = 1;
            for (c = 48; c <= 57; c = (int)((char)(c + 1))) {
                Charset.SYMBOL_CHARS[i++] = c;
            }
            for (c = 65; c <= 90; c = (int)((char)(c + 1))) {
                Charset.SYMBOL_CHARS[i++] = c;
            }
            for (c = 97; c <= 122; c = (int)((char)(c + 1))) {
                Charset.SYMBOL_CHARS[i++] = c;
            }
        }
    }
}

