/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.store;

import java.io.File;
import java.io.IOException;
import java.nio.file.OpenOption;
import java.nio.file.StandardOpenOption;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.neo4j.graphdb.factory.GraphDatabaseSettings;
import org.neo4j.graphdb.mockfs.EphemeralFileSystemAbstraction;
import org.neo4j.helpers.collection.MapUtil;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.io.pagecache.PageCache;
import org.neo4j.kernel.configuration.Config;
import org.neo4j.kernel.impl.store.MetaDataStore;
import org.neo4j.kernel.impl.store.NeoStores;
import org.neo4j.kernel.impl.store.StoreFactory;
import org.neo4j.kernel.impl.store.StoreNotFoundException;
import org.neo4j.kernel.impl.store.StoreType;
import org.neo4j.kernel.impl.store.format.RecordFormatSelector;
import org.neo4j.kernel.impl.store.format.RecordFormats;
import org.neo4j.kernel.impl.store.id.DefaultIdGeneratorFactory;
import org.neo4j.kernel.impl.store.id.IdGeneratorFactory;
import org.neo4j.logging.LogProvider;
import org.neo4j.logging.NullLogProvider;
import org.neo4j.test.EphemeralFileSystemRule;
import org.neo4j.test.PageCacheRule;

public class StoreFactoryTest {
    @Rule
    public final PageCacheRule pageCacheRule = new PageCacheRule();
    @Rule
    public EphemeralFileSystemRule fsRule = new EphemeralFileSystemRule();
    private NeoStores neoStores;
    private File storeDir;
    private IdGeneratorFactory idGeneratorFactory;
    private PageCache pageCache;

    @Before
    public void setUp() throws IOException {
        EphemeralFileSystemAbstraction fs = this.fsRule.get();
        this.pageCache = this.pageCacheRule.getPageCache((FileSystemAbstraction)fs);
        this.idGeneratorFactory = new DefaultIdGeneratorFactory((FileSystemAbstraction)fs);
        this.storeDir = this.directory("dir");
    }

    private StoreFactory storeFactory(Config config, OpenOption ... openOptions) {
        NullLogProvider logProvider = NullLogProvider.getInstance();
        RecordFormats recordFormats = RecordFormatSelector.selectForStoreOrConfig((Config)config, (File)this.storeDir, (FileSystemAbstraction)this.fsRule.get(), (PageCache)this.pageCache, (LogProvider)logProvider);
        return new StoreFactory(this.storeDir, "neostore", config, this.idGeneratorFactory, this.pageCache, (FileSystemAbstraction)this.fsRule.get(), recordFormats, (LogProvider)logProvider, openOptions);
    }

    private File directory(String name) {
        File dir = new File(name).getAbsoluteFile();
        this.fsRule.get().mkdirs(dir);
        return dir;
    }

    @After
    public void tearDown() {
        if (this.neoStores != null) {
            this.neoStores.close();
        }
    }

    @Test
    public void shouldHaveSameCreationTimeAndUpgradeTimeOnStartup() throws Exception {
        this.neoStores = this.storeFactory(Config.empty(), new OpenOption[0]).openAllNeoStores(true);
        MetaDataStore metaDataStore = this.neoStores.getMetaDataStore();
        Assert.assertThat((Object)metaDataStore.getUpgradeTime(), (Matcher)CoreMatchers.equalTo((Object)metaDataStore.getCreationTime()));
    }

    @Test
    public void shouldHaveSameCommittedTransactionAndUpgradeTransactionOnStartup() throws Exception {
        this.neoStores = this.storeFactory(Config.empty(), new OpenOption[0]).openAllNeoStores(true);
        MetaDataStore metaDataStore = this.neoStores.getMetaDataStore();
        Assert.assertEquals((Object)metaDataStore.getUpgradeTransaction(), (Object)metaDataStore.getLastCommittedTransaction());
    }

    @Test
    public void shouldHaveSpecificCountsTrackerForReadOnlyDatabase() throws IOException {
        StoreFactory readOnlyStoreFactory = this.storeFactory(new Config(MapUtil.stringMap((String[])new String[]{GraphDatabaseSettings.read_only.name(), "true"})), new OpenOption[0]);
        this.neoStores = readOnlyStoreFactory.openAllNeoStores(true);
        long lastClosedTransactionId = this.neoStores.getMetaDataStore().getLastClosedTransactionId();
        Assert.assertEquals((long)-1L, (long)this.neoStores.getCounts().rotate(lastClosedTransactionId));
    }

    @Test(expected=StoreNotFoundException.class)
    public void shouldThrowWhenOpeningNonExistingNeoStores() {
        try (NeoStores neoStores = this.storeFactory(Config.empty(), new OpenOption[0]).openAllNeoStores();){
            neoStores.getMetaDataStore();
        }
    }

    @Test
    public void shouldDelegateDeletionOptionToStores() throws Exception {
        StoreFactory storeFactory = this.storeFactory(Config.empty(), StandardOpenOption.DELETE_ON_CLOSE);
        this.neoStores = storeFactory.openAllNeoStores(true);
        Assert.assertTrue((this.fsRule.get().listFiles(this.storeDir).length >= StoreType.values().length ? 1 : 0) != 0);
        this.neoStores.close();
        Assert.assertEquals((long)0L, (long)this.fsRule.get().listFiles(this.storeDir).length);
    }
}

