/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.store;

import java.io.File;
import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;
import org.neo4j.helpers.collection.Iterables;
import org.neo4j.helpers.collection.Iterators;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.kernel.api.index.SchemaIndexProvider;
import org.neo4j.kernel.configuration.Config;
import org.neo4j.kernel.impl.api.index.TestSchemaIndexProviderDescriptor;
import org.neo4j.kernel.impl.store.NeoStores;
import org.neo4j.kernel.impl.store.SchemaStore;
import org.neo4j.kernel.impl.store.StoreFactory;
import org.neo4j.kernel.impl.store.id.DefaultIdGeneratorFactory;
import org.neo4j.kernel.impl.store.id.IdGeneratorFactory;
import org.neo4j.kernel.impl.store.record.AbstractBaseRecord;
import org.neo4j.kernel.impl.store.record.AbstractSchemaRule;
import org.neo4j.kernel.impl.store.record.DynamicRecord;
import org.neo4j.kernel.impl.store.record.IndexRule;
import org.neo4j.kernel.impl.store.record.RecordSerializable;
import org.neo4j.kernel.impl.store.record.RecordSerializer;
import org.neo4j.logging.LogProvider;
import org.neo4j.logging.NullLogProvider;
import org.neo4j.storageengine.api.schema.SchemaRule;
import org.neo4j.test.EphemeralFileSystemRule;
import org.neo4j.test.PageCacheRule;

public class SchemaStoreTest {
    @ClassRule
    public static PageCacheRule pageCacheRule = new PageCacheRule();
    @Rule
    public EphemeralFileSystemRule fs = new EphemeralFileSystemRule();
    private Config config;
    private SchemaStore store;
    private NeoStores neoStores;
    private StoreFactory storeFactory;

    @Before
    public void before() throws Exception {
        File storeDir = new File("dir");
        this.fs.get().mkdirs(storeDir);
        this.config = Config.empty();
        DefaultIdGeneratorFactory idGeneratorFactory = new DefaultIdGeneratorFactory((FileSystemAbstraction)this.fs.get());
        this.storeFactory = new StoreFactory(storeDir, this.config, (IdGeneratorFactory)idGeneratorFactory, pageCacheRule.getPageCache((FileSystemAbstraction)this.fs.get()), (FileSystemAbstraction)this.fs.get(), (LogProvider)NullLogProvider.getInstance());
        this.neoStores = this.storeFactory.openAllNeoStores(true);
        this.store = this.neoStores.getSchemaStore();
    }

    @After
    public void after() throws Exception {
        this.neoStores.close();
    }

    private long storeRule(SchemaRule rule) {
        List records = this.store.allocateFrom(rule);
        for (DynamicRecord record : records) {
            this.store.updateRecord((AbstractBaseRecord)record);
        }
        return ((DynamicRecord)Iterables.first((Iterable)records)).getId();
    }

    @Test
    public void serializationAndDeserialization() throws Exception {
        int propertyKey = 4;
        int labelId = 1;
        IndexRule indexRule = IndexRule.indexRule((long)this.store.nextId(), (int)labelId, (int)propertyKey, (SchemaIndexProvider.Descriptor)TestSchemaIndexProviderDescriptor.PROVIDER_DESCRIPTOR);
        byte[] serialized = new RecordSerializer().append((RecordSerializable)indexRule).serialize();
        IndexRule readIndexRule = (IndexRule)AbstractSchemaRule.deserialize((long)indexRule.getId(), (ByteBuffer)ByteBuffer.wrap(serialized));
        Assert.assertEquals((long)indexRule.getId(), (long)readIndexRule.getId());
        Assert.assertEquals((Object)indexRule.getKind(), (Object)readIndexRule.getKind());
        Assert.assertEquals((long)indexRule.getLabel(), (long)readIndexRule.getLabel());
        Assert.assertEquals((long)indexRule.getPropertyKey(), (long)readIndexRule.getPropertyKey());
        Assert.assertEquals((Object)indexRule.getProviderDescriptor(), (Object)readIndexRule.getProviderDescriptor());
    }

    @Test
    public void storeAndLoadAllShortRules() throws Exception {
        List<SchemaRule> rules = Arrays.asList(IndexRule.indexRule((long)this.store.nextId(), (int)0, (int)5, (SchemaIndexProvider.Descriptor)TestSchemaIndexProviderDescriptor.PROVIDER_DESCRIPTOR), IndexRule.indexRule((long)this.store.nextId(), (int)1, (int)6, (SchemaIndexProvider.Descriptor)TestSchemaIndexProviderDescriptor.PROVIDER_DESCRIPTOR), IndexRule.indexRule((long)this.store.nextId(), (int)1, (int)7, (SchemaIndexProvider.Descriptor)TestSchemaIndexProviderDescriptor.PROVIDER_DESCRIPTOR));
        for (SchemaRule rule : rules) {
            this.storeRule(rule);
        }
        Collection readRules = Iterators.asCollection((Iterator)this.store.loadAllSchemaRules());
        Assert.assertEquals(rules, (Object)readRules);
    }
}

