/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.store;

import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.RuleChain;
import org.junit.rules.TestRule;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.RelationshipType;
import org.neo4j.graphdb.Transaction;
import org.neo4j.graphdb.factory.GraphDatabaseFactory;
import org.neo4j.graphdb.factory.GraphDatabaseSettings;
import org.neo4j.helpers.collection.Iterables;
import org.neo4j.kernel.impl.storageengine.impl.recordstorage.RecordStorageEngine;
import org.neo4j.kernel.impl.store.NeoStores;
import org.neo4j.kernel.internal.GraphDatabaseAPI;
import org.neo4j.test.CleanupRule;
import org.neo4j.test.TargetDirectory;

public class RelationshipGroupStoreIT {
    private final TargetDirectory.TestDirectory directory = TargetDirectory.testDirForTest(this.getClass());
    private final CleanupRule cleanupRule = new CleanupRule();
    @Rule
    public RuleChain ruleChain = RuleChain.outerRule((TestRule)this.directory).around((TestRule)this.cleanupRule);

    @Test
    public void shouldCreateAllTheseRelationshipTypes() throws Exception {
        GraphDatabaseService db = new GraphDatabaseFactory().newEmbeddedDatabaseBuilder(this.directory.graphDbDir()).setConfig(GraphDatabaseSettings.dense_node_threshold, "1").newGraphDatabase();
        this.cleanupRule.add(db);
        this.shiftHighId((GraphDatabaseAPI)db);
        try (Transaction tx = db.beginTx();){
            Node node = db.createNode();
            for (int i = 0; i < 5000; ++i) {
                node.createRelationshipTo(db.createNode(), this.type(i + 1));
            }
            tx.success();
        }
        int nodeWithHighRelationshipTypeID = 4001;
        try (Transaction ignored = db.beginTx();){
            Node node = db.getNodeById(0L);
            Assert.assertEquals((String)"Should be possible to get relationships of type with id in unsigned short range.", (long)1L, (long)Iterables.count((Iterable)node.getRelationships(new RelationshipType[]{this.type(nodeWithHighRelationshipTypeID)})));
        }
    }

    private void shiftHighId(GraphDatabaseAPI db) {
        RecordStorageEngine storageEngine = (RecordStorageEngine)db.getDependencyResolver().resolveDependency(RecordStorageEngine.class);
        NeoStores neoStores = storageEngine.testAccessNeoStores();
        neoStores.getRelationshipTypeTokenStore().setHighId(30000L);
    }

    private RelationshipType type(int i) {
        return RelationshipType.withName((String)("TYPE_" + i));
    }
}

