/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.store;

import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import org.junit.Rule;
import org.junit.Test;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.NotFoundException;
import org.neo4j.graphdb.Relationship;
import org.neo4j.graphdb.RelationshipType;
import org.neo4j.graphdb.Transaction;
import org.neo4j.graphdb.factory.GraphDatabaseBuilder;
import org.neo4j.graphdb.factory.GraphDatabaseSettings;
import org.neo4j.helpers.Exceptions;
import org.neo4j.kernel.impl.store.InvalidRecordException;
import org.neo4j.test.DatabaseRule;
import org.neo4j.test.EmbeddedDatabaseRule;

public class NeoStoresIT {
    @Rule
    public final DatabaseRule db = new EmbeddedDatabaseRule(){

        @Override
        protected void configure(GraphDatabaseBuilder builder) {
            super.configure(builder);
            builder.setConfig(GraphDatabaseSettings.dense_node_threshold, "1");
        }
    };
    private static final RelationshipType FRIEND = RelationshipType.withName((String)"FRIEND");
    private static final String LONG_STRING_VALUE = "ALALALALALALALALALALALALALALALALALALALALALALALALALALALALALALALALALALALALALALALALALALALALALALALALALALALALAALALALALALALALALALALALALALALALALALALALALALALALALALALALALALALALALALALALALALALALALALALALALALALALALALALALALAALALALALALALALALALALALALALALALALALALALALALALALALALALALALALALALALALALALALALALALALALALALALALALALALALALALALAALALALALALALALALALALALALALALALALALALALALALALALALALALALALALALALALALALALALALALALALALALALALALALALALALALALALAALALALALALALALALALALALALALALALALALALALALALALALALALALALALALALALALALALALALALALALALALALALALALALALALALALALALAALALALALALALALALALALALALALALALALALALALALALALALALALALALALALALALALALALALALALALALALALALALALALALALALALALALALAALALALALALALALALALALALALALALALALALALALALALALALALALALALALALALALALALALALALALALALALALALALALALALALALALALALALAALALALALALALALALALALALALALALALALALALALALALALALALALALALALALALALALALALALALALALALALALALALALALALALALALALALALAALALALALALALALALALALALALALALALALALALALALALALALALALALALALALALALALALALALALALALALALALALALALALALALALALALALALAALALALALALALALALALALALALALALALALALALALALALALALALALALALALALALALALALALALALALALALALALALALALALALALALALALALALAALALALALALALALALALALALALALALALALALALALALALALALALALALALALALALALALALALALALALALALALALALALALALALALALALALALALAALALALALALALALALALALALALALALALALALALALALALALALALALALALALALALALALALALALALALALALALALALALALALALALALALALALALAALALALALALALALALALALALALALALALALALALALALALALALALALALALALALALALALALALALALALALALALALALALALALALALALALALALALAALALALALALALALALALALALALALALALALALALALALALALALALALALALALALALALALALALALALALALALALALALALALALALALALALALALALAALALALALALALALALALALALALALALALALALALALALALALALALALALALALALALALALALALALALALALALALALALALALALALALALALALONG!!";

    @Test
    public void shouldWriteOutTheDynamicChainBeforeUpdatingThePropertyRecord() throws InterruptedException {
        int i;
        ScheduledExecutorService executor = Executors.newSingleThreadScheduledExecutor();
        final long[] latestNodeId = new long[1];
        for (i = 0; i < 100000; ++i) {
            executor.scheduleAtFixedRate(new Runnable(){

                @Override
                public void run() {
                    try (Transaction tx = NeoStoresIT.this.db.beginTx();){
                        Node node = NeoStoresIT.this.db.createNode();
                        latestNodeId[0] = node.getId();
                        node.setProperty("largeProperty", (Object)NeoStoresIT.LONG_STRING_VALUE);
                        tx.success();
                    }
                }
            }, 5L, 25L, TimeUnit.MILLISECONDS);
        }
        for (i = 0; i < 100000; ++i) {
            try (Transaction tx = this.db.getGraphDatabaseAPI().beginTx();){
                Node node = this.db.getGraphDatabaseAPI().getNodeById(latestNodeId[0]);
                for (String propertyKey : node.getPropertyKeys()) {
                    node.getProperty(propertyKey);
                }
                tx.success();
                continue;
            }
            catch (NotFoundException notFoundException) {
                // empty catch block
            }
        }
        executor.shutdown();
        executor.awaitTermination(2000L, TimeUnit.MILLISECONDS);
    }

    @Test
    public void shouldWriteOutThePropertyRecordBeforeReferencingItFromANodeRecord() throws InterruptedException {
        int i;
        ScheduledExecutorService executor = Executors.newSingleThreadScheduledExecutor();
        final long[] latestNodeId = new long[1];
        for (i = 0; i < 100000; ++i) {
            executor.scheduleAtFixedRate(new Runnable(){

                @Override
                public void run() {
                    try (Transaction tx = NeoStoresIT.this.db.beginTx();){
                        Node node = NeoStoresIT.this.db.createNode();
                        latestNodeId[0] = node.getId();
                        node.setProperty("largeProperty", (Object)NeoStoresIT.LONG_STRING_VALUE);
                        tx.success();
                    }
                }
            }, 5L, 25L, TimeUnit.MILLISECONDS);
        }
        for (i = 0; i < 100000; ++i) {
            try (Transaction tx = this.db.getGraphDatabaseAPI().beginTx();){
                Node node = this.db.getGraphDatabaseAPI().getNodeById(latestNodeId[0]);
                for (String propertyKey : node.getPropertyKeys()) {
                    node.getProperty(propertyKey);
                }
                tx.success();
                continue;
            }
            catch (NotFoundException e) {
                if (!Exceptions.contains((Throwable)e, (Class[])new Class[]{InvalidRecordException.class})) continue;
                throw e;
            }
        }
        executor.shutdown();
        executor.awaitTermination(2000L, TimeUnit.MILLISECONDS);
    }

    @Test
    public void shouldWriteOutThePropertyRecordBeforeReferencingItFromARelationshipRecord() throws InterruptedException {
        int i;
        long node2Id;
        long node1Id;
        try (Transaction tx = this.db.beginTx();){
            Node node1 = this.db.createNode();
            node1Id = node1.getId();
            Node node2 = this.db.createNode();
            node2Id = node2.getId();
            tx.success();
        }
        ScheduledExecutorService executor = Executors.newSingleThreadScheduledExecutor();
        final long[] latestRelationshipId = new long[1];
        for (i = 0; i < 100000; ++i) {
            executor.scheduleAtFixedRate(new Runnable(){

                @Override
                public void run() {
                    try (Transaction tx = NeoStoresIT.this.db.beginTx();){
                        Node node1 = NeoStoresIT.this.db.getGraphDatabaseAPI().getNodeById(node1Id);
                        Node node2 = NeoStoresIT.this.db.getGraphDatabaseAPI().getNodeById(node2Id);
                        Relationship rel = node1.createRelationshipTo(node2, FRIEND);
                        latestRelationshipId[0] = rel.getId();
                        rel.setProperty("largeProperty", (Object)NeoStoresIT.LONG_STRING_VALUE);
                        tx.success();
                    }
                }
            }, 5L, 25L, TimeUnit.MILLISECONDS);
        }
        for (i = 0; i < 100000; ++i) {
            try (Transaction tx = this.db.getGraphDatabaseAPI().beginTx();){
                Relationship rel = this.db.getGraphDatabaseAPI().getRelationshipById(latestRelationshipId[0]);
                for (String propertyKey : rel.getPropertyKeys()) {
                    rel.getProperty(propertyKey);
                }
                tx.success();
                continue;
            }
            catch (NotFoundException e) {
                if (!Exceptions.contains((Throwable)e, (Class[])new Class[]{InvalidRecordException.class})) continue;
                throw e;
            }
        }
        executor.shutdown();
        executor.awaitTermination(2000L, TimeUnit.MILLISECONDS);
    }
}

