/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.storageengine.impl.recordstorage;

import java.io.IOException;
import java.util.concurrent.ThreadLocalRandom;
import java.util.concurrent.atomic.AtomicReference;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.RuleChain;
import org.junit.rules.TestRule;
import org.mockito.Mockito;
import org.neo4j.graphdb.mockfs.EphemeralFileSystemAbstraction;
import org.neo4j.helpers.Exceptions;
import org.neo4j.helpers.collection.Visitor;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.io.pagecache.DelegatingPageCache;
import org.neo4j.io.pagecache.IOLimiter;
import org.neo4j.io.pagecache.PageCache;
import org.neo4j.kernel.impl.api.BatchTransactionApplier;
import org.neo4j.kernel.impl.api.BatchTransactionApplierFacade;
import org.neo4j.kernel.impl.api.CountsAccessor;
import org.neo4j.kernel.impl.api.TransactionToApply;
import org.neo4j.kernel.impl.storageengine.impl.recordstorage.RecordStorageEngine;
import org.neo4j.kernel.impl.storageengine.impl.recordstorage.RecordStorageEngineRule;
import org.neo4j.kernel.impl.store.UnderlyingStorageException;
import org.neo4j.kernel.impl.store.counts.CountsTracker;
import org.neo4j.kernel.impl.transaction.TransactionRepresentation;
import org.neo4j.kernel.impl.transaction.log.Commitment;
import org.neo4j.kernel.impl.transaction.log.FakeCommitment;
import org.neo4j.kernel.impl.transaction.log.TransactionIdStore;
import org.neo4j.kernel.internal.DatabaseHealth;
import org.neo4j.storageengine.api.CommandsToApply;
import org.neo4j.storageengine.api.TransactionApplicationMode;
import org.neo4j.test.EphemeralFileSystemRule;
import org.neo4j.test.PageCacheRule;

public class RecordStorageEngineTest {
    private final RecordStorageEngineRule storageEngineRule = new RecordStorageEngineRule();
    private final EphemeralFileSystemRule fsRule = new EphemeralFileSystemRule();
    private final PageCacheRule pageCacheRule = new PageCacheRule();
    private DatabaseHealth databaseHealth = (DatabaseHealth)Mockito.mock(DatabaseHealth.class);
    @Rule
    public RuleChain ruleChain = RuleChain.outerRule((TestRule)this.fsRule).around((TestRule)this.pageCacheRule).around((TestRule)this.storageEngineRule);

    @Test(timeout=30000L)
    public void shutdownRecordStorageEngineAfterFailedTransaction() throws Throwable {
        RecordStorageEngine engine = this.buildRecordStorageEngine();
        Exception applicationError = this.executeFailingTransaction(engine);
        Assert.assertNotNull((Object)applicationError);
    }

    @Test
    public void panicOnExceptionDuringCommandsApply() throws Exception {
        IllegalStateException failure = new IllegalStateException("Too many open files");
        RecordStorageEngine engine = this.storageEngineRule.getWith((FileSystemAbstraction)this.fsRule.get(), this.pageCacheRule.getPageCache((FileSystemAbstraction)this.fsRule.get())).databaseHealth(this.databaseHealth).transactionApplierTransformer(facade -> RecordStorageEngineTest.transactionApplierFacadeTransformer(facade, failure)).build();
        CommandsToApply commandsToApply = (CommandsToApply)Mockito.mock(CommandsToApply.class);
        try {
            engine.apply(commandsToApply, TransactionApplicationMode.INTERNAL);
            Assert.fail((String)"Exception expected");
        }
        catch (Exception exception) {
            Assert.assertSame((Object)failure, (Object)Exceptions.rootCause((Throwable)exception));
        }
        ((DatabaseHealth)Mockito.verify((Object)this.databaseHealth)).panic((Throwable)org.mockito.Matchers.any(Throwable.class));
    }

    private static BatchTransactionApplierFacade transactionApplierFacadeTransformer(BatchTransactionApplierFacade facade, Exception failure) {
        return new FailingBatchTransactionApplierFacade(failure, new BatchTransactionApplier[]{facade});
    }

    @Test
    public void databasePanicIsRaisedWhenTxApplicationFails() throws Throwable {
        RecordStorageEngine engine = this.buildRecordStorageEngine();
        Exception applicationError = this.executeFailingTransaction(engine);
        ((DatabaseHealth)Mockito.verify((Object)this.databaseHealth)).panic((Throwable)applicationError);
    }

    @Test(timeout=30000L)
    public void obtainCountsStoreResetterAfterFailedTransaction() throws Throwable {
        RecordStorageEngine engine = this.buildRecordStorageEngine();
        Exception applicationError = this.executeFailingTransaction(engine);
        Assert.assertNotNull((Object)applicationError);
        CountsTracker countsStore = engine.testAccessNeoStores().getCounts();
        try (CountsAccessor.Updater updater = countsStore.reset(0L);){
            Assert.assertNotNull((Object)updater);
        }
    }

    @Test
    public void mustFlushStoresWithGivenIOLimiter() throws Exception {
        IOLimiter limiter = (stamp, completedIOs, swapper) -> 0L;
        EphemeralFileSystemAbstraction fs = this.fsRule.get();
        final AtomicReference observedLimiter = new AtomicReference();
        DelegatingPageCache pageCache = new DelegatingPageCache(this.pageCacheRule.getPageCache((FileSystemAbstraction)fs)){

            public void flushAndForce(IOLimiter limiter) throws IOException {
                super.flushAndForce(limiter);
                observedLimiter.set(limiter);
            }
        };
        RecordStorageEngine engine = this.storageEngineRule.getWith((FileSystemAbstraction)fs, (PageCache)pageCache).build();
        engine.flushAndForce(limiter);
        Assert.assertThat(observedLimiter.get(), (Matcher)Matchers.sameInstance((Object)limiter));
    }

    private RecordStorageEngine buildRecordStorageEngine() {
        return this.storageEngineRule.getWith((FileSystemAbstraction)this.fsRule.get(), this.pageCacheRule.getPageCache((FileSystemAbstraction)this.fsRule.get())).databaseHealth(this.databaseHealth).build();
    }

    private Exception executeFailingTransaction(RecordStorageEngine engine) throws IOException {
        UnderlyingStorageException applicationError = new UnderlyingStorageException("No space left on device");
        TransactionToApply txToApply = RecordStorageEngineTest.newTransactionThatFailsWith((Exception)((Object)applicationError));
        try {
            engine.apply((CommandsToApply)txToApply, TransactionApplicationMode.INTERNAL);
            Assert.fail((String)"Exception expected");
        }
        catch (Exception e) {
            Assert.assertSame((Object)((Object)applicationError), (Object)Exceptions.rootCause((Throwable)e));
        }
        return applicationError;
    }

    private static TransactionToApply newTransactionThatFailsWith(Exception error) throws IOException {
        TransactionRepresentation transaction = (TransactionRepresentation)Mockito.mock(TransactionRepresentation.class);
        Mockito.when((Object)transaction.additionalHeader()).thenReturn((Object)new byte[0]);
        ((TransactionRepresentation)Mockito.doThrow((Throwable)error).when((Object)transaction)).accept((Visitor)org.mockito.Matchers.any());
        long txId = ThreadLocalRandom.current().nextLong(0L, 1000L);
        TransactionToApply txToApply = new TransactionToApply(transaction);
        FakeCommitment commitment = new FakeCommitment(txId, (TransactionIdStore)Mockito.mock(TransactionIdStore.class));
        commitment.setHasLegacyIndexChanges(false);
        txToApply.commitment((Commitment)commitment, txId);
        return txToApply;
    }

    private static class FailingBatchTransactionApplierFacade
    extends BatchTransactionApplierFacade {
        private Exception failure;

        FailingBatchTransactionApplierFacade(Exception failure, BatchTransactionApplier ... appliers) {
            super(appliers);
            this.failure = failure;
        }

        public void close() throws Exception {
            throw this.failure;
        }
    }
}

