/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.storageengine.impl.recordstorage;

import java.io.File;
import java.util.Collections;
import java.util.function.Function;
import java.util.function.Supplier;
import org.mockito.Mockito;
import org.neo4j.helpers.collection.Iterables;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.io.pagecache.PageCache;
import org.neo4j.kernel.api.TokenNameLookup;
import org.neo4j.kernel.api.index.SchemaIndexProvider;
import org.neo4j.kernel.api.labelscan.LabelScanStore;
import org.neo4j.kernel.configuration.Config;
import org.neo4j.kernel.impl.api.BatchTransactionApplierFacade;
import org.neo4j.kernel.impl.api.KernelTransactionsSnapshot;
import org.neo4j.kernel.impl.api.LegacyIndexProviderLookup;
import org.neo4j.kernel.impl.api.index.IndexingService;
import org.neo4j.kernel.impl.api.scan.InMemoryLabelScanStore;
import org.neo4j.kernel.impl.api.scan.LabelScanStoreProvider;
import org.neo4j.kernel.impl.constraints.ConstraintSemantics;
import org.neo4j.kernel.impl.constraints.StandardConstraintSemantics;
import org.neo4j.kernel.impl.core.DatabasePanicEventGenerator;
import org.neo4j.kernel.impl.core.LabelTokenHolder;
import org.neo4j.kernel.impl.core.PropertyKeyTokenHolder;
import org.neo4j.kernel.impl.core.RelationshipTypeTokenHolder;
import org.neo4j.kernel.impl.index.IndexConfigStore;
import org.neo4j.kernel.impl.locking.LockService;
import org.neo4j.kernel.impl.locking.ReentrantLockService;
import org.neo4j.kernel.impl.storageengine.impl.recordstorage.RecordStorageEngine;
import org.neo4j.kernel.impl.store.id.IdGeneratorFactory;
import org.neo4j.kernel.impl.store.id.IdReuseEligibility;
import org.neo4j.kernel.impl.store.id.configuration.CommunityIdTypeConfigurationProvider;
import org.neo4j.kernel.impl.store.id.configuration.IdTypeConfigurationProvider;
import org.neo4j.kernel.impl.util.IdOrderingQueue;
import org.neo4j.kernel.impl.util.JobScheduler;
import org.neo4j.kernel.impl.util.Neo4jJobScheduler;
import org.neo4j.kernel.impl.util.SynchronizedArrayIdOrderingQueue;
import org.neo4j.kernel.internal.DatabaseHealth;
import org.neo4j.kernel.internal.KernelEventHandlers;
import org.neo4j.kernel.lifecycle.LifeSupport;
import org.neo4j.kernel.lifecycle.Lifecycle;
import org.neo4j.logging.Log;
import org.neo4j.logging.LogProvider;
import org.neo4j.logging.NullLog;
import org.neo4j.logging.NullLogProvider;
import org.neo4j.storageengine.api.TransactionApplicationMode;
import org.neo4j.test.ExternalResource;
import org.neo4j.test.impl.EphemeralIdGenerator;

public class RecordStorageEngineRule
extends ExternalResource {
    private final LifeSupport life = new LifeSupport();

    @Override
    protected void before() throws Throwable {
        super.before();
        this.life.start();
    }

    public Builder getWith(FileSystemAbstraction fs, PageCache pageCache) {
        return new Builder(fs, pageCache);
    }

    private RecordStorageEngine get(FileSystemAbstraction fs, PageCache pageCache, LabelScanStore labelScanStore, SchemaIndexProvider schemaIndexProvider, DatabaseHealth databaseHealth, File storeDirectory, Function<BatchTransactionApplierFacade, BatchTransactionApplierFacade> transactionApplierTransformer) {
        if (!fs.fileExists(storeDirectory) && !fs.mkdir(storeDirectory)) {
            throw new IllegalStateException();
        }
        EphemeralIdGenerator.Factory idGeneratorFactory = new EphemeralIdGenerator.Factory();
        LabelScanStoreProvider labelScanStoreProvider = new LabelScanStoreProvider(labelScanStore, 42);
        LegacyIndexProviderLookup legacyIndexProviderLookup = (LegacyIndexProviderLookup)Mockito.mock(LegacyIndexProviderLookup.class);
        Mockito.when((Object)legacyIndexProviderLookup.all()).thenReturn((Object)Iterables.empty());
        IndexConfigStore indexConfigStore = new IndexConfigStore(storeDirectory, fs);
        JobScheduler scheduler = (JobScheduler)this.life.add((Lifecycle)new Neo4jJobScheduler());
        Config config = Config.defaults();
        Supplier<KernelTransactionsSnapshot> txSnapshotSupplier = () -> new KernelTransactionsSnapshot(Collections.emptySet(), 0L);
        return (RecordStorageEngine)this.life.add((Lifecycle)new ExtendedRecordStorageEngine(storeDirectory, config, idGeneratorFactory, IdReuseEligibility.ALWAYS, (IdTypeConfigurationProvider)new CommunityIdTypeConfigurationProvider(), pageCache, fs, (LogProvider)NullLogProvider.getInstance(), (PropertyKeyTokenHolder)Mockito.mock(PropertyKeyTokenHolder.class), (LabelTokenHolder)Mockito.mock(LabelTokenHolder.class), (RelationshipTypeTokenHolder)Mockito.mock(RelationshipTypeTokenHolder.class), () -> {}, (ConstraintSemantics)new StandardConstraintSemantics(), scheduler, (TokenNameLookup)Mockito.mock(TokenNameLookup.class), (LockService)new ReentrantLockService(), schemaIndexProvider, IndexingService.NO_MONITOR, databaseHealth, labelScanStoreProvider, legacyIndexProviderLookup, indexConfigStore, (IdOrderingQueue)new SynchronizedArrayIdOrderingQueue(20), txSnapshotSupplier, transactionApplierTransformer));
    }

    @Override
    protected void after(boolean successful) throws Throwable {
        this.life.shutdown();
        super.after(successful);
    }

    private class ExtendedRecordStorageEngine
    extends RecordStorageEngine {
        private final Function<BatchTransactionApplierFacade, BatchTransactionApplierFacade> transactionApplierTransformer;

        public ExtendedRecordStorageEngine(File storeDir, Config config, IdGeneratorFactory idGeneratorFactory, IdReuseEligibility eligibleForReuse, IdTypeConfigurationProvider idTypeConfigurationProvider, PageCache pageCache, FileSystemAbstraction fs, LogProvider logProvider, PropertyKeyTokenHolder propertyKeyTokenHolder, LabelTokenHolder labelTokens, RelationshipTypeTokenHolder relationshipTypeTokens, Runnable schemaStateChangeCallback, ConstraintSemantics constraintSemantics, JobScheduler scheduler, TokenNameLookup tokenNameLookup, LockService lockService, SchemaIndexProvider indexProvider, IndexingService.Monitor indexingServiceMonitor, DatabaseHealth databaseHealth, LabelScanStoreProvider labelScanStoreProvider, LegacyIndexProviderLookup legacyIndexProviderLookup, IndexConfigStore indexConfigStore, IdOrderingQueue legacyIndexTransactionOrdering, Supplier<KernelTransactionsSnapshot> transactionsSnapshotSupplier, Function<BatchTransactionApplierFacade, BatchTransactionApplierFacade> transactionApplierTransformer) {
            super(storeDir, config, idGeneratorFactory, eligibleForReuse, idTypeConfigurationProvider, pageCache, fs, logProvider, propertyKeyTokenHolder, labelTokens, relationshipTypeTokens, schemaStateChangeCallback, constraintSemantics, scheduler, tokenNameLookup, lockService, indexProvider, indexingServiceMonitor, databaseHealth, labelScanStoreProvider, legacyIndexProviderLookup, indexConfigStore, legacyIndexTransactionOrdering, transactionsSnapshotSupplier);
            this.transactionApplierTransformer = transactionApplierTransformer;
        }

        protected BatchTransactionApplierFacade applier(TransactionApplicationMode mode) {
            BatchTransactionApplierFacade recordEngineApplier = super.applier(mode);
            return this.transactionApplierTransformer.apply(recordEngineApplier);
        }
    }

    public class Builder {
        private final FileSystemAbstraction fs;
        private final PageCache pageCache;
        private LabelScanStore labelScanStore = new InMemoryLabelScanStore();
        private DatabaseHealth databaseHealth = new DatabaseHealth(new DatabasePanicEventGenerator(new KernelEventHandlers((Log)NullLog.getInstance())), (Log)NullLog.getInstance());
        private File storeDirectory = new File("/graph.db");
        private Function<BatchTransactionApplierFacade, BatchTransactionApplierFacade> transactionApplierTransformer = applierFacade -> applierFacade;
        private SchemaIndexProvider schemaIndexProvider = SchemaIndexProvider.NO_INDEX_PROVIDER;

        public Builder(FileSystemAbstraction fs, PageCache pageCache) {
            this.fs = fs;
            this.pageCache = pageCache;
        }

        public Builder labelScanStore(LabelScanStore labelScanStore) {
            this.labelScanStore = labelScanStore;
            return this;
        }

        public Builder transactionApplierTransformer(Function<BatchTransactionApplierFacade, BatchTransactionApplierFacade> transactionApplierTransformer) {
            this.transactionApplierTransformer = transactionApplierTransformer;
            return this;
        }

        public Builder indexProvider(SchemaIndexProvider schemaIndexProvider) {
            this.schemaIndexProvider = schemaIndexProvider;
            return this;
        }

        public Builder databaseHealth(DatabaseHealth databaseHealth) {
            this.databaseHealth = databaseHealth;
            return this;
        }

        public Builder storeDirectory(File storeDirectory) {
            this.storeDirectory = storeDirectory;
            return this;
        }

        public RecordStorageEngine build() {
            return RecordStorageEngineRule.this.get(this.fs, this.pageCache, this.labelScanStore, this.schemaIndexProvider, this.databaseHealth, this.storeDirectory, this.transactionApplierTransformer);
        }
    }
}

