/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.security;

import java.io.File;
import java.net.URL;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.junit.Assert;
import org.junit.Test;
import org.neo4j.graphdb.config.Configuration;
import org.neo4j.graphdb.factory.GraphDatabaseSettings;
import org.neo4j.graphdb.security.URLAccessValidationError;
import org.neo4j.helpers.collection.MapUtil;
import org.neo4j.kernel.configuration.Config;
import org.neo4j.kernel.impl.security.URLAccessRules;

public class FileURLAccessRuleTest {
    @Test
    public void shouldThrowWhenFileURLContainsAuthority() throws Exception {
        try {
            URLAccessRules.fileAccess().validate((Configuration)Config.empty(), new URL("file://foo/bar/baz"));
            Assert.fail((String)"expected exception not thrown ");
        }
        catch (URLAccessValidationError error) {
            MatcherAssert.assertThat((Object)error.getMessage(), (Matcher)CoreMatchers.equalTo((Object)"file URL may not contain an authority section (i.e. it should be 'file:///')"));
        }
    }

    @Test
    public void shouldThrowWhenFileURLContainsQuery() throws Exception {
        try {
            URLAccessRules.fileAccess().validate((Configuration)Config.empty(), new URL("file:///bar/baz?q=foo"));
            Assert.fail((String)"expected exception not thrown ");
        }
        catch (URLAccessValidationError error) {
            MatcherAssert.assertThat((Object)error.getMessage(), (Matcher)CoreMatchers.equalTo((Object)"file URL may not contain a query component"));
        }
    }

    @Test
    public void shouldThrowWhenFileAccessIsDisabled() throws Exception {
        URL url = new URL("file:///bar/baz.csv");
        Config config = new Config(MapUtil.stringMap((String[])new String[]{GraphDatabaseSettings.allow_file_urls.name(), "false"}));
        try {
            URLAccessRules.fileAccess().validate((Configuration)config, url);
            Assert.fail((String)"expected exception not thrown ");
        }
        catch (URLAccessValidationError error) {
            MatcherAssert.assertThat((Object)error.getMessage(), (Matcher)CoreMatchers.equalTo((Object)"configuration property 'dbms.security.allow_csv_import_from_file_urls' is false"));
        }
    }

    @Test
    public void shouldThrowWhenRelativePathIsOutsideImportDirectory() throws Exception {
        File importDir = new File("/tmp/neo4jtest").getAbsoluteFile();
        Config config = new Config(MapUtil.stringMap((String[])new String[]{GraphDatabaseSettings.load_csv_file_url_root.name(), importDir.toString()}));
        try {
            URLAccessRules.fileAccess().validate((Configuration)config, new URL("file:///../baz.csv"));
            Assert.fail((String)"expected exception not thrown ");
        }
        catch (URLAccessValidationError error) {
            MatcherAssert.assertThat((Object)error.getMessage(), (Matcher)CoreMatchers.equalTo((Object)"file URL points outside configured import directory"));
        }
    }

    @Test
    public void shouldAdjustURLToWithinImportDirectory() throws Exception {
        File importDir = new File("/var/lib/neo4j/import").getAbsoluteFile();
        Config config = new Config(MapUtil.stringMap((String[])new String[]{GraphDatabaseSettings.load_csv_file_url_root.name(), importDir.toString()}));
        URL url = new File("/bar/baz.csv").toURI().toURL();
        URL accessURL = URLAccessRules.fileAccess().validate((Configuration)config, url);
        URL expected = new File(importDir, "bar/baz.csv").toURI().toURL();
        Assert.assertEquals((Object)expected, (Object)accessURL);
    }
}

