/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.query;

import org.junit.Before;
import org.junit.Test;
import org.mockito.Mockito;
import org.neo4j.graphdb.DependencyResolver;
import org.neo4j.kernel.GraphDatabaseQueryService;
import org.neo4j.kernel.api.KernelTransaction;
import org.neo4j.kernel.api.Statement;
import org.neo4j.kernel.guard.Guard;
import org.neo4j.kernel.impl.api.KernelStatement;
import org.neo4j.kernel.impl.core.ThreadToStatementContextBridge;
import org.neo4j.kernel.impl.coreapi.InternalTransaction;
import org.neo4j.kernel.impl.coreapi.PropertyContainerLocker;
import org.neo4j.kernel.impl.coreapi.TopLevelTransaction;
import org.neo4j.kernel.impl.query.Neo4jTransactionalContext;

public class Neo4jTransactionalContextTest {
    private GraphDatabaseQueryService databaseQueryService;
    private DependencyResolver dependencyResolver;
    private ThreadToStatementContextBridge statementContextBridge;
    private Guard guard;
    private KernelStatement statement;
    private PropertyContainerLocker propertyContainerLocker;
    private TopLevelTransaction transaction;

    @Before
    public void setUp() {
        this.setUpMocks();
    }

    @Test
    public void checkKernelStatementOnCheck() throws Exception {
        Neo4jTransactionalContext transactionalContext = new Neo4jTransactionalContext(this.databaseQueryService, (InternalTransaction)this.transaction, (Statement)this.statement, this.propertyContainerLocker);
        transactionalContext.check();
        ((Guard)Mockito.verify((Object)this.guard)).check(this.statement);
    }

    private void setUpMocks() {
        this.databaseQueryService = (GraphDatabaseQueryService)Mockito.mock(GraphDatabaseQueryService.class);
        this.dependencyResolver = (DependencyResolver)Mockito.mock(DependencyResolver.class);
        this.statementContextBridge = (ThreadToStatementContextBridge)Mockito.mock(ThreadToStatementContextBridge.class);
        this.guard = (Guard)Mockito.mock(Guard.class);
        this.statement = (KernelStatement)Mockito.mock(KernelStatement.class);
        this.propertyContainerLocker = (PropertyContainerLocker)Mockito.mock(PropertyContainerLocker.class);
        this.transaction = new TopLevelTransaction((KernelTransaction)Mockito.mock(KernelTransaction.class), () -> this.statement);
        Mockito.when((Object)this.databaseQueryService.getDependencyResolver()).thenReturn((Object)this.dependencyResolver);
        Mockito.when((Object)this.dependencyResolver.resolveDependency(ThreadToStatementContextBridge.class)).thenReturn((Object)this.statementContextBridge);
        Mockito.when((Object)this.dependencyResolver.resolveDependency(Guard.class)).thenReturn((Object)this.guard);
    }
}

