/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.proc;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.stream.Stream;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;
import org.neo4j.collection.RawIterator;
import org.neo4j.helpers.collection.Iterators;
import org.neo4j.kernel.api.exceptions.KernelException;
import org.neo4j.kernel.api.exceptions.ProcedureException;
import org.neo4j.kernel.api.proc.CallableProcedure;
import org.neo4j.kernel.impl.proc.ComponentRegistry;
import org.neo4j.kernel.impl.proc.ReflectiveProcedureCompiler;
import org.neo4j.kernel.impl.proc.TypeMappers;
import org.neo4j.procedure.Context;
import org.neo4j.procedure.Procedure;

public class ResourceInjectionTest {
    @Rule
    public ExpectedException exception = ExpectedException.none();

    @Test
    public void shouldCompileAndRunProcedure() throws Throwable {
        CallableProcedure proc = this.compile(ProcedureWithInjectedAPI.class).get(0);
        List out = Iterators.asList((RawIterator)proc.apply((CallableProcedure.Context)new CallableProcedure.BasicContext(), new Object[0]));
        Assert.assertThat(out.get(0), (Matcher)CoreMatchers.equalTo((Object)new Object[]{"Bonnie"}));
        Assert.assertThat(out.get(1), (Matcher)CoreMatchers.equalTo((Object)new Object[]{"Clyde"}));
    }

    @Test
    public void shouldFailNicelyWhenUnknownAPI() throws Throwable {
        this.exception.expect(ProcedureException.class);
        this.exception.expectMessage("Unable to set up injection for procedure `procedureWithUnknownAPI`, the field `api` has type `class org.neo4j.kernel.impl.proc.ResourceInjectionTest$UnknownAPI` which is not a known injectable component.");
        this.compile(procedureWithUnknownAPI.class).get(0);
    }

    private List<CallableProcedure> compile(Class<?> clazz) throws KernelException {
        ComponentRegistry components = new ComponentRegistry();
        components.register(MyAwesomeAPI.class, ctx -> new MyAwesomeAPI());
        return new ReflectiveProcedureCompiler(new TypeMappers(), components).compile(clazz);
    }

    public static class procedureWithUnknownAPI {
        @Context
        public UnknownAPI api;

        @Procedure
        public Stream<MyOutputRecord> listCoolPeople() {
            return this.api.listCoolPeople().stream().map(MyOutputRecord::new);
        }
    }

    public static class ProcedureWithInjectedAPI {
        @Context
        public MyAwesomeAPI api;

        @Procedure
        public Stream<MyOutputRecord> listCoolPeople() {
            return this.api.listCoolPeople().stream().map(MyOutputRecord::new);
        }
    }

    public static class UnknownAPI {
        List<String> listCoolPeople() {
            return Collections.singletonList("booh!");
        }
    }

    public static class MyAwesomeAPI {
        List<String> listCoolPeople() {
            return Arrays.asList("Bonnie", "Clyde");
        }
    }

    public static class MyOutputRecord {
        public String name;

        public MyOutputRecord(String name) {
            this.name = name;
        }
    }
}

