/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.proc;

import java.util.List;
import java.util.stream.Stream;
import junit.framework.TestCase;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;
import org.mockito.Mockito;
import org.neo4j.collection.RawIterator;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.helpers.collection.Iterators;
import org.neo4j.kernel.api.exceptions.KernelException;
import org.neo4j.kernel.api.exceptions.ProcedureException;
import org.neo4j.kernel.api.proc.CallableProcedure;
import org.neo4j.kernel.api.proc.Neo4jTypes;
import org.neo4j.kernel.api.proc.ProcedureSignature;
import org.neo4j.kernel.impl.proc.ComponentRegistry;
import org.neo4j.kernel.impl.proc.ReflectiveProcedureCompiler;
import org.neo4j.kernel.impl.proc.TypeMappers;
import org.neo4j.logging.Log;
import org.neo4j.procedure.Context;
import org.neo4j.procedure.Procedure;

public class ReflectiveProcedureTest {
    @Rule
    public ExpectedException exception = ExpectedException.none();
    private ReflectiveProcedureCompiler procedureCompiler;
    private ComponentRegistry components;

    @Before
    public void setUp() throws Exception {
        this.components = new ComponentRegistry();
        this.procedureCompiler = new ReflectiveProcedureCompiler(new TypeMappers(), this.components);
    }

    @Test
    public void shouldInjectLogging() throws KernelException {
        Log log = (Log)Mockito.spy(Log.class);
        this.components.register(Log.class, ctx -> log);
        CallableProcedure procedure = (CallableProcedure)this.procedureCompiler.compile(LoggingProcedure.class).get(0);
        procedure.apply((CallableProcedure.Context)new CallableProcedure.BasicContext(), new Object[0]);
        ((Log)Mockito.verify((Object)log)).debug("1");
        ((Log)Mockito.verify((Object)log)).info("2");
        ((Log)Mockito.verify((Object)log)).warn("3");
        ((Log)Mockito.verify((Object)log)).error("4");
    }

    @Test
    public void shouldCompileProcedure() throws Throwable {
        List<CallableProcedure> procedures = this.compile(SingleReadOnlyProcedure.class);
        TestCase.assertEquals((int)1, (int)procedures.size());
        Assert.assertThat((Object)procedures.get(0).signature(), (Matcher)Matchers.equalTo((Object)ProcedureSignature.procedureSignature((String[])new String[]{"org", "neo4j", "kernel", "impl", "proc", "listCoolPeople"}).out("name", (Neo4jTypes.AnyType)Neo4jTypes.NTString).build()));
    }

    @Test
    public void shouldRunSimpleReadOnlyProcedure() throws Throwable {
        CallableProcedure proc = this.compile(SingleReadOnlyProcedure.class).get(0);
        RawIterator out = proc.apply((CallableProcedure.Context)new CallableProcedure.BasicContext(), new Object[0]);
        Assert.assertThat((Object)Iterators.asList((RawIterator)out), (Matcher)Matchers.contains((Object[])new Object[][]{{"Bonnie"}, {"Clyde"}}));
    }

    @Test
    public void shouldIgnoreClassesWithNoProcedures() throws Throwable {
        List<CallableProcedure> procedures = this.compile(PrivateConstructorButNoProcedures.class);
        TestCase.assertEquals((int)0, (int)procedures.size());
    }

    @Test
    public void shouldRunClassWithMultipleProceduresDeclared() throws Throwable {
        List<CallableProcedure> compiled = this.compile(MultiProcedureProcedure.class);
        CallableProcedure bananaPeople = compiled.get(0);
        CallableProcedure coolPeople = compiled.get(1);
        RawIterator coolOut = coolPeople.apply((CallableProcedure.Context)new CallableProcedure.BasicContext(), new Object[0]);
        RawIterator bananaOut = bananaPeople.apply((CallableProcedure.Context)new CallableProcedure.BasicContext(), new Object[0]);
        Assert.assertThat((Object)Iterators.asList((RawIterator)coolOut), (Matcher)Matchers.contains((Object[])new Object[][]{{"Bonnie"}, {"Clyde"}}));
        Assert.assertThat((Object)Iterators.asList((RawIterator)bananaOut), (Matcher)Matchers.contains((Object[])new Object[][]{{"Jake", 18L}, {"Pontus", 2L}}));
    }

    @Test
    public void shouldGiveHelpfulErrorOnConstructorThatRequiresArgument() throws Throwable {
        this.exception.expect(ProcedureException.class);
        this.exception.expectMessage("Unable to find a usable public no-argument constructor in the class `WierdConstructorProcedure`. Please add a valid, public constructor, recompile the class and try again.");
        this.compile(WierdConstructorProcedure.class);
    }

    @Test
    public void shouldGiveHelpfulErrorOnNoPublicConstructor() throws Throwable {
        this.exception.expect(ProcedureException.class);
        this.exception.expectMessage("Unable to find a usable public no-argument constructor in the class `PrivateConstructorProcedure`. Please add a valid, public constructor, recompile the class and try again.");
        this.compile(PrivateConstructorProcedure.class);
    }

    @Test
    public void shouldAllowVoidOutput() throws Throwable {
        CallableProcedure proc = this.compile(ProcedureWithVoidOutput.class).get(0);
        TestCase.assertEquals((int)0, (int)proc.signature().outputSignature().size());
        Assert.assertFalse((boolean)proc.apply(null, new Object[0]).hasNext());
    }

    @Test
    public void shouldGiveHelpfulErrorOnProcedureReturningInvalidRecordType() throws Throwable {
        this.exception.expect(ProcedureException.class);
        this.exception.expectMessage(String.format("Procedures must return a Stream of records, where a record is a concrete class%nthat you define, with public non-final fields defining the fields in the record.%nIf you''d like your procedure to return `String`, you could define a record class like:%npublic class Output '{'%n    public String out;%n'}'%n%nAnd then define your procedure as returning `Stream<Output>`.", new Object[0]));
        this.compile(ProcedureWithInvalidRecordOutput.class).get(0);
    }

    @Test
    public void shouldGiveHelpfulErrorOnContextAnnotatedStaticField() throws Throwable {
        this.exception.expect(ProcedureException.class);
        this.exception.expectMessage(String.format("The field `gdb` in the class named `ProcedureWithStaticContextAnnotatedField` is annotated as a @Context field,%nbut it is static. @Context fields must be public, non-final and non-static,%nbecause they are reset each time a procedure is invoked.", new Object[0]));
        this.compile(ProcedureWithStaticContextAnnotatedField.class).get(0);
    }

    @Test
    public void shouldAllowNonStaticOutput() throws Throwable {
        CallableProcedure proc = this.compile(ProcedureWithNonStaticOutputRecord.class).get(0);
        TestCase.assertEquals((int)1, (int)proc.signature().outputSignature().size());
    }

    @Test
    public void shouldAllowOverridingProcedureName() throws Throwable {
        CallableProcedure proc = this.compile(ProcedureWithOverriddenName.class).get(0);
        TestCase.assertEquals((String)"org.mystuff.thisisActuallyTheName", (String)proc.signature().name().toString());
    }

    @Test
    public void shouldAllowOverridingProcedureNameWithoutNamespace() throws Throwable {
        CallableProcedure proc = this.compile(ProcedureWithSingleName.class).get(0);
        TestCase.assertEquals((String)"singleName", (String)proc.signature().name().toString());
    }

    @Test
    public void shouldGiveHelpfulErrorOnNullMessageException() throws Throwable {
        CallableProcedure proc = this.compile(ProcedureThatThrowsNullMsgExceptionAtInvocation.class).get(0);
        this.exception.expect(ProcedureException.class);
        this.exception.expectMessage("Failed to invoke procedure `org.neo4j.kernel.impl.proc.throwsAtInvocation`: Caused by: java.lang.IndexOutOfBoundsException");
        proc.apply((CallableProcedure.Context)new CallableProcedure.BasicContext(), new Object[0]);
    }

    private List<CallableProcedure> compile(Class<?> clazz) throws KernelException {
        return this.procedureCompiler.compile(clazz);
    }

    public static class ProcedureWithSingleName {
        @Procedure(value="singleName")
        public void blahDoesntMatterEither() {
        }
    }

    public static class ProcedureWithOverriddenName {
        @Procedure(value="org.mystuff.thisisActuallyTheName")
        public void somethingThatShouldntMatter() {
        }

        @Procedure(value="singleName")
        public void blahDoesntMatterEither() {
        }
    }

    public static class PrivateConstructorButNoProcedures {
        private PrivateConstructorButNoProcedures() {
        }

        public Stream<MyOutputRecord> thisIsNotAProcedure() {
            return null;
        }
    }

    public static class PrivateConstructorProcedure {
        private PrivateConstructorProcedure() {
        }

        @Procedure
        public Stream<MyOutputRecord> listCoolPeople() {
            return Stream.of(new MyOutputRecord("Bonnie"), new MyOutputRecord("Clyde"));
        }
    }

    public static class ProcedureThatThrowsNullMsgExceptionMidStream {
        @Procedure
        public Stream<MyOutputRecord> throwsInStream() {
            return Stream.generate(() -> {
                throw new IndexOutOfBoundsException();
            });
        }
    }

    public static class ProcedureThatThrowsNullMsgExceptionAtInvocation {
        @Procedure
        public Stream<MyOutputRecord> throwsAtInvocation() {
            throw new IndexOutOfBoundsException();
        }
    }

    public static class ProcedureWithStaticContextAnnotatedField {
        @Context
        public static GraphDatabaseService gdb;

        @Procedure
        public Stream<MyOutputRecord> test() {
            return null;
        }
    }

    public static class ProcedureWithInvalidRecordOutput {
        @Procedure
        public String test() {
            return "Testing";
        }
    }

    public static class WierdConstructorProcedure {
        public WierdConstructorProcedure(WierdConstructorProcedure wat) {
        }

        @Procedure
        public Stream<MyOutputRecord> listCoolPeople() {
            return Stream.of(new MyOutputRecord("Bonnie"), new MyOutputRecord("Clyde"));
        }
    }

    public static class MultiProcedureProcedure {
        @Procedure
        public Stream<MyOutputRecord> listCoolPeople() {
            return Stream.of(new MyOutputRecord("Bonnie"), new MyOutputRecord("Clyde"));
        }

        @Procedure
        public Stream<SomeOtherOutputRecord> listBananaOwningPeople() {
            return Stream.of(new SomeOtherOutputRecord("Jake", 18L), new SomeOtherOutputRecord("Pontus", 2L));
        }
    }

    public static class ProcedureWithNonStaticOutputRecord {
        @Procedure
        public Stream<NonStatic> voidOutput() {
            return Stream.of(new NonStatic());
        }

        public class NonStatic {
            public String field = "hello, rodl!";
        }
    }

    public static class ProcedureWithVoidOutput {
        @Procedure
        public void voidOutput() {
        }
    }

    public static class SingleReadOnlyProcedure {
        @Procedure
        public Stream<MyOutputRecord> listCoolPeople() {
            return Stream.of(new MyOutputRecord("Bonnie"), new MyOutputRecord("Clyde"));
        }
    }

    public static class LoggingProcedure {
        @Context
        public Log log;

        @Procedure
        public Stream<MyOutputRecord> logAround() {
            this.log.debug("1");
            this.log.info("2");
            this.log.warn("3");
            this.log.error("4");
            return Stream.empty();
        }
    }

    public static class SomeOtherOutputRecord {
        public String name;
        public long bananas;

        public SomeOtherOutputRecord(String name, long bananas) {
            this.name = name;
            this.bananas = bananas;
        }
    }

    public static class MyOutputRecord {
        public String name;

        public MyOutputRecord(String name) {
            this.name = name;
        }
    }
}

