/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.proc;

import java.util.List;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;
import org.neo4j.collection.RawIterator;
import org.neo4j.helpers.collection.Iterables;
import org.neo4j.helpers.collection.Iterators;
import org.neo4j.kernel.api.exceptions.ProcedureException;
import org.neo4j.kernel.api.proc.CallableProcedure;
import org.neo4j.kernel.api.proc.Neo4jTypes;
import org.neo4j.kernel.api.proc.ProcedureSignature;
import org.neo4j.kernel.impl.proc.Procedures;

public class ProceduresTest {
    @Rule
    public ExpectedException exception = ExpectedException.none();
    private final Procedures procs = new Procedures();
    private final ProcedureSignature signature = ProcedureSignature.procedureSignature((String[])new String[]{"org", "myproc"}).build();
    private final CallableProcedure procedure = this.procedure(this.signature);

    @Test
    public void shouldGetRegisteredProcedure() throws Throwable {
        this.procs.register(this.procedure);
        Assert.assertThat((Object)this.procs.get(this.signature.name()), (Matcher)CoreMatchers.equalTo((Object)this.signature));
    }

    @Test
    public void shouldGetAllRegisteredProcedures() throws Throwable {
        this.procs.register(this.procedure(ProcedureSignature.procedureSignature((String[])new String[]{"org", "myproc1"}).build()));
        this.procs.register(this.procedure(ProcedureSignature.procedureSignature((String[])new String[]{"org", "myproc2"}).build()));
        this.procs.register(this.procedure(ProcedureSignature.procedureSignature((String[])new String[]{"org", "myproc3"}).build()));
        List signatures = Iterables.asList((Iterable)this.procs.getAll());
        Assert.assertThat((Object)signatures, (Matcher)Matchers.containsInAnyOrder((Object[])new ProcedureSignature[]{ProcedureSignature.procedureSignature((String[])new String[]{"org", "myproc1"}).build(), ProcedureSignature.procedureSignature((String[])new String[]{"org", "myproc2"}).build(), ProcedureSignature.procedureSignature((String[])new String[]{"org", "myproc3"}).build()}));
    }

    @Test
    public void shouldCallRegisteredProcedure() throws Throwable {
        this.procs.register(this.procedure);
        RawIterator result = this.procs.call((CallableProcedure.Context)new CallableProcedure.BasicContext(){}, this.signature.name(), new Object[]{1337});
        Assert.assertThat((Object)Iterators.asList((RawIterator)result), (Matcher)Matchers.contains((Matcher)CoreMatchers.equalTo((Object)new Object[]{1337})));
    }

    @Test
    public void shouldNotAllowCallingNonExistingProcedure() throws Throwable {
        this.exception.expect(ProcedureException.class);
        this.exception.expectMessage("There is no procedure with the name `org.myproc` registered for this database instance. Please ensure you've spelled the procedure name correctly and that the procedure is properly deployed.");
        this.procs.call((CallableProcedure.Context)new CallableProcedure.BasicContext(){}, this.signature.name(), new Object[]{1337});
    }

    @Test
    public void shouldNotAllowRegisteringConflictingName() throws Throwable {
        this.procs.register(this.procedure);
        this.exception.expect(ProcedureException.class);
        this.exception.expectMessage("Unable to register procedure, because the name `org.myproc` is already in use.");
        this.procs.register(this.procedure);
    }

    @Test
    public void shouldNotAllowDuplicateFieldNamesInInput() throws Throwable {
        this.exception.expect(ProcedureException.class);
        this.exception.expectMessage("Procedure `asd(a :: ANY?, a :: ANY?) :: ()` cannot be registered, because it contains a duplicated input field, 'a'. You need to rename or remove one of the duplicate fields.");
        this.procs.register((CallableProcedure)this.procedureWithSignature(ProcedureSignature.procedureSignature((String[])new String[]{"asd"}).in("a", Neo4jTypes.NTAny).in("a", Neo4jTypes.NTAny).build()));
    }

    @Test
    public void shouldNotAllowDuplicateFieldNamesInOutput() throws Throwable {
        this.exception.expect(ProcedureException.class);
        this.exception.expectMessage("Procedure `asd() :: (a :: ANY?, a :: ANY?)` cannot be registered, because it contains a duplicated output field, 'a'. You need to rename or remove one of the duplicate fields.");
        this.procs.register((CallableProcedure)this.procedureWithSignature(ProcedureSignature.procedureSignature((String[])new String[]{"asd"}).out("a", Neo4jTypes.NTAny).out("a", Neo4jTypes.NTAny).build()));
    }

    @Test
    public void shouldSignalNonExistingProcedure() throws Throwable {
        this.exception.expect(ProcedureException.class);
        this.exception.expectMessage("There is no procedure with the name `org.myproc` registered for this database instance. Please ensure you've spelled the procedure name correctly and that the procedure is properly deployed.");
        this.procs.get(this.signature.name());
    }

    @Test
    public void shouldMakeContextAvailable() throws Throwable {
        final CallableProcedure.Key someKey = CallableProcedure.Key.key((String)"someKey", String.class);
        this.procs.register((CallableProcedure)new CallableProcedure.BasicProcedure(this.signature){

            public RawIterator<Object[], ProcedureException> apply(CallableProcedure.Context ctx, Object[] input) throws ProcedureException {
                return RawIterator.of((Object[])new Object[][]{{ctx.get(someKey)}});
            }
        });
        CallableProcedure.BasicContext ctx = new CallableProcedure.BasicContext();
        ctx.put(someKey, (Object)"hello, world");
        RawIterator result = this.procs.call((CallableProcedure.Context)ctx, this.signature.name(), new Object[0]);
        Assert.assertThat((Object)Iterators.asList((RawIterator)result), (Matcher)Matchers.contains((Matcher)CoreMatchers.equalTo((Object)new Object[]{"hello, world"})));
    }

    private CallableProcedure.BasicProcedure procedureWithSignature(ProcedureSignature signature) {
        return new CallableProcedure.BasicProcedure(signature){

            public RawIterator<Object[], ProcedureException> apply(CallableProcedure.Context ctx, Object[] input) throws ProcedureException {
                return null;
            }
        };
    }

    private CallableProcedure procedure(ProcedureSignature signature) {
        return new CallableProcedure.BasicProcedure(signature){

            public RawIterator<Object[], ProcedureException> apply(CallableProcedure.Context ctx, Object[] input) {
                return RawIterator.of((Object[])new Object[][]{input});
            }
        };
    }
}

