/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.proc;

import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;
import org.neo4j.kernel.api.proc.Neo4jTypes;
import org.neo4j.kernel.api.proc.ProcedureSignature;

public class ProcedureSignatureTest {
    @Rule
    public ExpectedException exception = ExpectedException.none();
    private final ProcedureSignature signature = ProcedureSignature.procedureSignature((String[])new String[]{"asd"}).in("a", Neo4jTypes.NTAny).build();

    @Test
    public void inputSignatureShouldNotBeModifiable() throws Throwable {
        this.exception.expect(UnsupportedOperationException.class);
        this.signature.inputSignature().add(new ProcedureSignature.FieldSignature("b", Neo4jTypes.NTAny));
    }

    @Test
    public void outputSignatureShouldNotBeModifiable() throws Throwable {
        this.exception.expect(UnsupportedOperationException.class);
        this.signature.outputSignature().add(new ProcedureSignature.FieldSignature("b", Neo4jTypes.NTAny));
    }

    @Test
    public void shouldHonorVoidInEquals() {
        ProcedureSignature sig1 = ProcedureSignature.procedureSignature((String[])new String[]{"foo"}).in("a", Neo4jTypes.NTAny).build();
        ProcedureSignature sig2 = ProcedureSignature.procedureSignature((String[])new String[]{"foo"}).in("a", Neo4jTypes.NTAny).out(ProcedureSignature.VOID).build();
        ProcedureSignature sig2clone = ProcedureSignature.procedureSignature((String[])new String[]{"foo"}).in("a", Neo4jTypes.NTAny).out(ProcedureSignature.VOID).build();
        Assert.assertEquals((Object)sig2, (Object)sig2clone);
        Assert.assertNotEquals((Object)sig1, (Object)sig2);
    }

    @Test
    public void toStringShouldMatchCypherSyntax() throws Throwable {
        String toStr = ProcedureSignature.procedureSignature((String[])new String[]{"org", "myProcedure"}).in("inputArg", (Neo4jTypes.AnyType)Neo4jTypes.NTList((Neo4jTypes.AnyType)Neo4jTypes.NTString)).out("outputArg", (Neo4jTypes.AnyType)Neo4jTypes.NTNumber).build().toString();
        Assert.assertEquals((Object)"org.myProcedure(inputArg :: LIST? OF STRING?) :: (outputArg :: NUMBER?)", (Object)toStr);
    }

    @Test
    public void toStringForVoidProcedureShouldMatchCypherSyntax() throws Throwable {
        ProcedureSignature proc = ProcedureSignature.procedureSignature((String[])new String[]{"org", "myProcedure"}).in("inputArg", (Neo4jTypes.AnyType)Neo4jTypes.NTList((Neo4jTypes.AnyType)Neo4jTypes.NTString)).out(ProcedureSignature.VOID).build();
        String toStr = proc.toString();
        Assert.assertEquals((Object)"org.myProcedure(inputArg :: LIST? OF STRING?) :: VOID", (Object)toStr);
    }
}

