/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.proc;

import java.util.Arrays;
import java.util.Map;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;
import org.neo4j.kernel.api.exceptions.ProcedureException;
import org.neo4j.kernel.api.proc.Neo4jTypes;
import org.neo4j.kernel.api.proc.ProcedureSignature;
import org.neo4j.kernel.impl.proc.OutputMappers;
import org.neo4j.kernel.impl.proc.TypeMappers;

public class OutputMappersTest {
    @Rule
    public ExpectedException exception = ExpectedException.none();

    @Test
    public void shouldMapSimpleRecordWithString() throws Throwable {
        OutputMappers.OutputMapper mapper = this.mapper(SingleStringFieldRecord.class);
        Assert.assertThat((Object)mapper.signature(), (Matcher)Matchers.contains((Object[])new ProcedureSignature.FieldSignature[]{new ProcedureSignature.FieldSignature("name", (Neo4jTypes.AnyType)Neo4jTypes.NTString)}));
        Assert.assertThat(Arrays.asList(mapper.apply((Object)new SingleStringFieldRecord("hello, world!"))), (Matcher)Matchers.contains((Object[])new Object[]{"hello, world!"}));
    }

    @Test
    public void shouldSkipStaticFields() throws Throwable {
        OutputMappers.OutputMapper mapper = this.mapper(RecordWithStaticFields.class);
        Assert.assertThat((Object)mapper.signature(), (Matcher)Matchers.contains((Object[])new ProcedureSignature.FieldSignature[]{new ProcedureSignature.FieldSignature("includeMe", (Neo4jTypes.AnyType)Neo4jTypes.NTString)}));
        Assert.assertThat(Arrays.asList(mapper.apply((Object)new RecordWithStaticFields("hello, world!"))), (Matcher)Matchers.contains((Object[])new Object[]{"hello, world!"}));
    }

    @Test
    public void shouldGiveHelpfulErrorOnUnmappable() throws Throwable {
        this.exception.expect(ProcedureException.class);
        this.exception.expectMessage("Field `wat` in record `UnmappableRecord` cannot be converted to a Neo4j type: Don't know how to map `class org.neo4j.kernel.impl.proc.OutputMappersTest$UnmappableRecord`");
        this.mapper(UnmappableRecord.class);
    }

    @Test
    public void shouldGiveHelpfulErrorOnPrivateField() throws Throwable {
        this.exception.expect(ProcedureException.class);
        this.exception.expectMessage("Field `wat` in record `RecordWithPrivateField` cannot be accessed. Please ensure the field is marked as `public`.");
        this.mapper(RecordWithPrivateField.class);
    }

    @Test
    public void shouldGiveHelpfulErrorOnMapWithNonStringKeyMap() throws Throwable {
        this.exception.expect(ProcedureException.class);
        this.exception.expectMessage("Field `wat` in record `RecordWithNonStringKeyMap` cannot be converted to a Neo4j type: Maps are required to have `String` keys - but this map has `org.neo4j.kernel.impl.proc.OutputMappersTest$RecordWithNonStringKeyMap` keys.");
        this.mapper(RecordWithNonStringKeyMap.class);
    }

    @Test
    public void shouldWarnAgainstStdLibraryClassesSinceTheseIndicateUserError() throws Throwable {
        this.exception.expect(ProcedureException.class);
        this.exception.expectMessage(String.format("Procedures must return a Stream of records, where a record is a concrete class%nthat you define, with public non-final fields defining the fields in the record.%nIf you''d like your procedure to return `Long`, you could define a record class like:%npublic class Output '{'%n    public Long out;%n'}'%n%nAnd then define your procedure as returning `Stream<Output>`.", new Object[0]));
        this.mapper(Long.class);
    }

    private OutputMappers.OutputMapper mapper(Class<?> clazz) throws ProcedureException {
        return new OutputMappers(new TypeMappers()).mapper(clazz);
    }

    public static class RecordWithStaticFields {
        public static String skipMePublic;
        public String includeMe;
        private static String skipMePrivate;

        public RecordWithStaticFields(String val) {
            this.includeMe = val;
        }
    }

    public static class RecordWithNonStringKeyMap {
        public Map<RecordWithNonStringKeyMap, Object> wat;
    }

    public static class RecordWithPrivateField {
        private String wat;
    }

    public static class UnmappableRecord {
        public UnmappableRecord wat;
    }

    public static class SingleStringFieldRecord {
        public String name;

        public SingleStringFieldRecord(String name) {
            this.name = name;
        }
    }
}

