/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.pagecache;

import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import org.neo4j.io.pagecache.impl.SingleFilePageSwapperFactory;
import org.neo4j.kernel.configuration.Config;
import org.neo4j.kernel.impl.pagecache.ConfigurablePageSwapperFactory;

public class PageSwapperFactoryForTesting
extends SingleFilePageSwapperFactory
implements ConfigurablePageSwapperFactory {
    public static final String TEST_PAGESWAPPER_NAME = "pageSwapperForTesting";
    public static final AtomicInteger createdCounter = new AtomicInteger();
    public static final AtomicInteger configuredCounter = new AtomicInteger();
    public static final AtomicInteger cachePageSizeHint = new AtomicInteger(8192);
    public static final AtomicBoolean cachePageSizeHintIsStrict = new AtomicBoolean();

    public static int countCreatedPageSwapperFactories() {
        return createdCounter.get();
    }

    public static int countConfiguredPageSwapperFactories() {
        return configuredCounter.get();
    }

    public PageSwapperFactoryForTesting() {
        createdCounter.getAndIncrement();
    }

    public String implementationName() {
        return TEST_PAGESWAPPER_NAME;
    }

    public int getCachePageSizeHint() {
        return cachePageSizeHint.get();
    }

    public boolean isCachePageSizeHintStrict() {
        return cachePageSizeHintIsStrict.get();
    }

    public void configure(Config config) {
        configuredCounter.getAndIncrement();
    }
}

