/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.locking;

import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import junit.framework.TestCase;
import org.hamcrest.MatcherAssert;
import org.junit.Rule;
import org.junit.runner.RunWith;
import org.junit.runners.Suite;
import org.neo4j.kernel.api.index.ParameterizedSuiteRunner;
import org.neo4j.kernel.impl.locking.AcquireAndReleaseLocksCompatibility;
import org.neo4j.kernel.impl.locking.CloseCompatibility;
import org.neo4j.kernel.impl.locking.DeadlockCompatibility;
import org.neo4j.kernel.impl.locking.LockReentrancyCompatibility;
import org.neo4j.kernel.impl.locking.Locks;
import org.neo4j.kernel.impl.locking.RWLockCompatibility;
import org.neo4j.kernel.impl.locking.StopCompatibility;
import org.neo4j.storageengine.api.lock.AcquireLockTimeoutException;
import org.neo4j.storageengine.api.lock.ResourceType;
import org.neo4j.test.OtherThreadExecutor;
import org.neo4j.test.OtherThreadRule;
import org.neo4j.test.TargetDirectory;

@RunWith(value=ParameterizedSuiteRunner.class)
@Suite.SuiteClasses(value={AcquireAndReleaseLocksCompatibility.class, DeadlockCompatibility.class, LockReentrancyCompatibility.class, RWLockCompatibility.class, StopCompatibility.class, CloseCompatibility.class})
public abstract class LockingCompatibilityTestSuite {
    protected abstract Locks createLockManager();

    public static abstract class Compatibility {
        @Rule
        public OtherThreadRule<Void> threadA = new OtherThreadRule();
        @Rule
        public OtherThreadRule<Void> threadB = new OtherThreadRule();
        @Rule
        public OtherThreadRule<Void> threadC = new OtherThreadRule();
        @Rule
        public TargetDirectory.TestDirectory testDir = TargetDirectory.testDirForTest(this.getClass());
        protected final Locks locks;
        protected final Locks.Client clientA;
        protected final Locks.Client clientB;
        protected final Locks.Client clientC;
        private final Map<Locks.Client, OtherThreadRule<Void>> clientToThreadMap = new HashMap<Locks.Client, OtherThreadRule<Void>>();

        public Compatibility(LockingCompatibilityTestSuite suite) {
            this.locks = suite.createLockManager();
            this.clientA = this.locks.newClient();
            this.clientB = this.locks.newClient();
            this.clientC = this.locks.newClient();
            this.clientToThreadMap.put(this.clientA, this.threadA);
            this.clientToThreadMap.put(this.clientB, this.threadB);
            this.clientToThreadMap.put(this.clientC, this.threadC);
        }

        protected LockCommand acquireExclusive(Locks.Client client, final ResourceType resourceType, final long key) {
            return new LockCommand(this.clientToThreadMap.get(client), client){

                @Override
                public void doWork(Locks.Client client) throws AcquireLockTimeoutException {
                    client.acquireExclusive(resourceType, new long[]{key});
                }
            };
        }

        protected LockCommand acquireShared(Locks.Client client, final ResourceType resourceType, final long key) {
            return new LockCommand(this.clientToThreadMap.get(client), client){

                @Override
                public void doWork(Locks.Client client) throws AcquireLockTimeoutException {
                    client.acquireShared(resourceType, new long[]{key});
                }
            };
        }

        protected LockCommand release(Locks.Client client, final ResourceType resourceType, final long key) {
            return new LockCommand(this.clientToThreadMap.get(client), client){

                @Override
                public void doWork(Locks.Client client) {
                    client.releaseExclusive(resourceType, key);
                }
            };
        }

        protected void assertNotWaiting(Locks.Client client, Future<Object> lock) {
            try {
                lock.get(5L, TimeUnit.SECONDS);
            }
            catch (InterruptedException | ExecutionException | TimeoutException e) {
                throw new RuntimeException("Waiting for lock timed out!");
            }
        }

        protected void assertWaiting(Locks.Client client, Future<Object> lock) {
            try {
                lock.get(10L, TimeUnit.MILLISECONDS);
                TestCase.fail((String)"Should be waiting.");
            }
            catch (TimeoutException timeoutException) {
            }
            catch (InterruptedException | ExecutionException e) {
                throw new RuntimeException(e);
            }
            MatcherAssert.assertThat(this.clientToThreadMap.get(client), OtherThreadRule.isWaiting());
        }

        public abstract class LockCommand
        implements OtherThreadExecutor.WorkerCommand<Void, Object> {
            private final OtherThreadRule<Void> thread;
            private final Locks.Client client;

            protected LockCommand(OtherThreadRule<Void> thread, Locks.Client client) {
                this.thread = thread;
                this.client = client;
            }

            public Future<Object> call() {
                return this.thread.execute(this);
            }

            public Future<Object> callAndAssertWaiting() {
                Future<Object> otherThreadLock = this.call();
                MatcherAssert.assertThat(this.thread, OtherThreadRule.isWaiting());
                TestCase.assertFalse((String)"Should not have acquired lock.", (boolean)otherThreadLock.isDone());
                return otherThreadLock;
            }

            public Future<Object> callAndAssertNotWaiting() {
                Future<Object> run = this.call();
                Compatibility.this.assertNotWaiting(this.client, run);
                return run;
            }

            @Override
            public Object doWork(Void state) throws Exception {
                this.doWork(this.client);
                return null;
            }

            @Override
            abstract void doWork(Locks.Client var1) throws AcquireLockTimeoutException;

            public Locks.Client client() {
                return this.client;
            }
        }
    }
}

