/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.index;

import java.io.File;
import java.util.Map;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.graphdb.Transaction;
import org.neo4j.graphdb.index.Index;
import org.neo4j.helpers.collection.Iterables;
import org.neo4j.helpers.collection.MapUtil;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.test.EphemeralFileSystemRule;
import org.neo4j.test.TestGraphDatabaseFactory;

public class TestIndexImplOnNeo {
    @Rule
    public EphemeralFileSystemRule fs = new EphemeralFileSystemRule();
    private GraphDatabaseService db;

    @Before
    public void createDb() throws Exception {
        this.db = new TestGraphDatabaseFactory().setFileSystem((FileSystemAbstraction)this.fs.get()).newImpermanentDatabase(new File("mydb"));
    }

    private void restartDb() throws Exception {
        this.shutdownDb();
        this.createDb();
    }

    @After
    public void shutdownDb() throws Exception {
        this.db.shutdown();
    }

    @Test
    public void createIndexWithProviderThatUsesNeoAsDataSource() throws Exception {
        Index index;
        String indexName = "inneo";
        Assert.assertFalse((boolean)this.indexExists(indexName));
        Map config = MapUtil.stringMap((String[])new String[]{"provider", "test-dummy-neo-index", "config1", "A value", "another config", "Another value"});
        try (Transaction transaction = this.db.beginTx();){
            index = this.db.index().forNodes(indexName, config);
            transaction.success();
        }
        var5_4 = null;
        try (Transaction tx = this.db.beginTx();){
            Assert.assertTrue((boolean)this.indexExists(indexName));
            Assert.assertEquals((Object)config, (Object)this.db.index().getConfiguration(index));
            Assert.assertEquals((long)0L, (long)Iterables.count((Iterable)index.get("key", (Object)"something else")));
            tx.success();
        }
        catch (Throwable throwable) {
            var5_4 = throwable;
            throw throwable;
        }
        this.restartDb();
        tx = this.db.beginTx();
        var5_4 = null;
        try {
            Assert.assertTrue((boolean)this.indexExists(indexName));
            Assert.assertEquals((Object)config, (Object)this.db.index().getConfiguration(index));
            tx.success();
        }
        catch (Throwable throwable) {
            var5_4 = throwable;
            throw throwable;
        }
        finally {
            if (tx != null) {
                if (var5_4 != null) {
                    try {
                        tx.close();
                    }
                    catch (Throwable throwable) {
                        var5_4.addSuppressed(throwable);
                    }
                } else {
                    tx.close();
                }
            }
        }
    }

    private boolean indexExists(String indexName) {
        try (Transaction transaction = this.db.beginTx();){
            boolean exists = this.db.index().existsForNodes(indexName);
            transaction.success();
            boolean bl = exists;
            return bl;
        }
    }
}

