/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.event;

import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.hamcrest.Description;
import org.hamcrest.TypeSafeMatcher;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;
import org.junit.rules.RuleChain;
import org.junit.rules.TestRule;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.graphdb.Label;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.PropertyContainer;
import org.neo4j.graphdb.Relationship;
import org.neo4j.graphdb.RelationshipType;
import org.neo4j.graphdb.Transaction;
import org.neo4j.graphdb.event.TransactionData;
import org.neo4j.graphdb.event.TransactionEventHandler;
import org.neo4j.kernel.impl.event.ExpectedTransactionData;
import org.neo4j.kernel.impl.event.VerifyingTransactionEventHandler;
import org.neo4j.test.DatabaseRule;
import org.neo4j.test.ImpermanentDatabaseRule;
import org.neo4j.test.RandomRule;

public class TransactionEventsIT {
    private final DatabaseRule db = new ImpermanentDatabaseRule();
    private final RandomRule random = new RandomRule();
    private final ExpectedException expectedException = ExpectedException.none();
    @Rule
    public RuleChain ruleChain = RuleChain.outerRule((TestRule)this.random).around((TestRule)this.expectedException).around((TestRule)this.db);

    @Test
    public void shouldSeeExpectedTransactionData() throws Exception {
        Graph state = new Graph((GraphDatabaseService)this.db, this.random);
        ExpectedTransactionData expected = new ExpectedTransactionData(true);
        VerifyingTransactionEventHandler handler = new VerifyingTransactionEventHandler(expected);
        try (Transaction tx = this.db.beginTx();){
            int i;
            for (i = 0; i < 100; ++i) {
                Operation.createNode.perform(state, expected);
            }
            for (i = 0; i < 20; ++i) {
                Operation.createRelationship.perform(state, expected);
            }
            tx.success();
        }
        this.db.registerTransactionEventHandler(handler);
        Operation[] operations = Operation.values();
        for (int i = 0; i < 1000; ++i) {
            expected.clear();
            try (Transaction tx = this.db.beginTx();){
                int transactionSize = this.random.intBetween(1, 20);
                for (int j = 0; j < transactionSize; ++j) {
                    this.random.among(operations).perform(state, expected);
                }
                tx.success();
                continue;
            }
        }
    }

    @Test
    public void transactionIdAndCommitTimeAccessibleAfterCommit() {
        TransactionIdCommitTimeTracker commitTimeTracker = new TransactionIdCommitTimeTracker();
        this.db.registerTransactionEventHandler(commitTimeTracker);
        this.runTransaction();
        long firstTransactionId = commitTimeTracker.getTransactionIdAfterCommit();
        long firstTransactionCommitTime = commitTimeTracker.getCommitTimeAfterCommit();
        Assert.assertTrue((String)"Should be positive tx id.", (firstTransactionId > 0L ? 1 : 0) != 0);
        Assert.assertTrue((String)"Should be positive.", (firstTransactionCommitTime > 0L ? 1 : 0) != 0);
        this.runTransaction();
        long secondTransactionId = commitTimeTracker.getTransactionIdAfterCommit();
        long secondTransactionCommitTime = commitTimeTracker.getCommitTimeAfterCommit();
        Assert.assertTrue((String)"Should be positive tx id.", (secondTransactionId > 0L ? 1 : 0) != 0);
        Assert.assertTrue((String)"Should be positive commit time value.", (secondTransactionCommitTime > 0L ? 1 : 0) != 0);
        Assert.assertTrue((String)"Second tx id should be higher then first one.", (secondTransactionId > firstTransactionId ? 1 : 0) != 0);
        Assert.assertTrue((String)"Second commit time should be higher or equals then first one.", (secondTransactionCommitTime >= firstTransactionCommitTime ? 1 : 0) != 0);
    }

    @Test
    public void transactionIdNotAccessibleBeforeCommit() {
        this.db.registerTransactionEventHandler(this.getBeforeCommitHandler(TransactionData::getTransactionId));
        String message = "Transaction id is not assigned yet. It will be assigned during transaction commit.";
        this.expectedException.expectCause(new RootCauseMatcher<IllegalStateException>(IllegalStateException.class, message));
        this.runTransaction();
    }

    @Test
    public void commitTimeNotAccessibleBeforeCommit() {
        this.db.registerTransactionEventHandler(this.getBeforeCommitHandler(TransactionData::getCommitTime));
        String message = "Transaction commit time is not assigned yet. It will be assigned during transaction commit.";
        this.expectedException.expectCause(new RootCauseMatcher<IllegalStateException>(IllegalStateException.class, message));
        this.runTransaction();
    }

    private TransactionEventHandler.Adapter<Object> getBeforeCommitHandler(final Consumer<TransactionData> dataConsumer) {
        return new TransactionEventHandler.Adapter<Object>(){

            public Object beforeCommit(TransactionData data) throws Exception {
                dataConsumer.accept(data);
                return super.beforeCommit(data);
            }
        };
    }

    private void runTransaction() {
        try (Transaction transaction = this.db.beginTx();){
            Node node = this.db.createNode();
            transaction.success();
        }
    }

    private class RootCauseMatcher<T extends Throwable>
    extends TypeSafeMatcher<T> {
        private Class<T> rootCause;
        private String message;
        private Throwable cause;

        RootCauseMatcher(Class<T> rootCause, String message) {
            this.rootCause = rootCause;
            this.message = message;
        }

        protected boolean matchesSafely(T item) {
            this.cause = ExceptionUtils.getRootCause(item);
            return this.rootCause.isInstance(this.cause) && this.cause.getMessage().equals(this.message);
        }

        public void describeTo(Description description) {
            description.appendText("Expected root cause of ").appendValue(this.rootCause).appendText(" with message: ").appendValue((Object)this.message).appendText(", but was ").appendValue(this.cause.getClass()).appendText(" with message: ").appendValue((Object)this.cause.getMessage());
        }
    }

    private static class TransactionIdCommitTimeTracker
    extends TransactionEventHandler.Adapter<Object> {
        private long transactionIdAfterCommit;
        private long commitTimeAfterCommit;

        private TransactionIdCommitTimeTracker() {
        }

        public Object beforeCommit(TransactionData data) throws Exception {
            return super.beforeCommit(data);
        }

        public void afterCommit(TransactionData data, Object state) {
            this.commitTimeAfterCommit = data.getCommitTime();
            this.transactionIdAfterCommit = data.getTransactionId();
            super.afterCommit(data, state);
        }

        public long getTransactionIdAfterCommit() {
            return this.transactionIdAfterCommit;
        }

        public long getCommitTimeAfterCommit() {
            return this.commitTimeAfterCommit;
        }
    }

    private static class Graph {
        private static final String[] TOKENS = new String[]{"A", "B", "C", "D", "E"};
        private final GraphDatabaseService db;
        private final RandomRule random;
        private final List<Node> nodes = new ArrayList<Node>();
        private final List<Relationship> relationships = new ArrayList<Relationship>();

        Graph(GraphDatabaseService db, RandomRule random) {
            this.db = db;
            this.random = random;
        }

        private <E extends PropertyContainer> E random(List<E> entities) {
            return (E)(entities.isEmpty() ? null : (PropertyContainer)entities.get(this.random.nextInt(entities.size())));
        }

        Node randomNode() {
            return this.random(this.nodes);
        }

        Relationship randomRelationship() {
            return this.random(this.relationships);
        }

        Node createNode() {
            Node node = this.db.createNode();
            this.nodes.add(node);
            return node;
        }

        void deleteRelationship(Relationship relationship) {
            relationship.delete();
            this.relationships.remove(relationship);
        }

        void deleteNode(Node node) {
            node.delete();
            this.nodes.remove(node);
        }

        private String randomToken() {
            return this.random.among(TOKENS);
        }

        Label randomLabel() {
            return Label.label((String)this.randomToken());
        }

        RelationshipType randomRelationshipType() {
            return RelationshipType.withName((String)this.randomToken());
        }

        String randomPropertyKey() {
            return this.randomToken();
        }

        Object randomPropertyValue() {
            return this.random.propertyValue();
        }

        int nodeCount() {
            return this.nodes.size();
        }

        Relationship createRelationship(Node node1, Node node2, RelationshipType type) {
            Relationship relationship = node1.createRelationshipTo(node2, type);
            this.relationships.add(relationship);
            return relationship;
        }
    }

    static enum Operation {
        createNode{

            @Override
            void perform(Graph graph, ExpectedTransactionData expectations) {
                Node node = graph.createNode();
                expectations.createdNode(node);
                this.debug(node);
            }
        }
        ,
        deleteNode{

            @Override
            void perform(Graph graph, ExpectedTransactionData expectations) {
                Node node = graph.randomNode();
                if (node != null) {
                    for (Relationship relationship : node.getRelationships()) {
                        graph.deleteRelationship(relationship);
                        expectations.deletedRelationship(relationship);
                        this.debug(relationship);
                    }
                    graph.deleteNode(node);
                    expectations.deletedNode(node);
                    this.debug(node);
                }
            }
        }
        ,
        assignLabel{

            @Override
            void perform(Graph graph, ExpectedTransactionData expectations) {
                Label label;
                Node node = graph.randomNode();
                if (node != null && !node.hasLabel(label = graph.randomLabel())) {
                    node.addLabel(label);
                    expectations.assignedLabel(node, label);
                    this.debug(node + " " + label);
                }
            }
        }
        ,
        removeLabel{

            @Override
            void perform(Graph graph, ExpectedTransactionData expectations) {
                Label label;
                Node node = graph.randomNode();
                if (node != null && node.hasLabel(label = graph.randomLabel())) {
                    node.removeLabel(label);
                    expectations.removedLabel(node, label);
                    this.debug(node + " " + label);
                }
            }
        }
        ,
        setNodeProperty{

            @Override
            void perform(Graph graph, ExpectedTransactionData expectations) {
                Node node = graph.randomNode();
                if (node != null) {
                    String key = graph.randomPropertyKey();
                    Object valueBefore = node.getProperty(key, null);
                    Object value = graph.randomPropertyValue();
                    node.setProperty(key, value);
                    expectations.assignedProperty(node, key, value, valueBefore);
                    this.debug(node + " " + key + "=" + value + " prev " + valueBefore);
                }
            }
        }
        ,
        removeNodeProperty{

            @Override
            void perform(Graph graph, ExpectedTransactionData expectations) {
                String key;
                Node node = graph.randomNode();
                if (node != null && node.hasProperty(key = graph.randomPropertyKey())) {
                    Object valueBefore = node.removeProperty(key);
                    expectations.removedProperty(node, key, valueBefore);
                    this.debug(node + " " + key + "=" + valueBefore);
                }
            }
        }
        ,
        setRelationshipProperty{

            @Override
            void perform(Graph graph, ExpectedTransactionData expectations) {
                Relationship relationship = graph.randomRelationship();
                if (relationship != null) {
                    String key = graph.randomPropertyKey();
                    Object valueBefore = relationship.getProperty(key, null);
                    Object value = graph.randomPropertyValue();
                    relationship.setProperty(key, value);
                    expectations.assignedProperty(relationship, key, value, valueBefore);
                    this.debug(relationship + " " + key + "=" + value + " prev " + valueBefore);
                }
            }
        }
        ,
        removeRelationshipProperty{

            @Override
            void perform(Graph graph, ExpectedTransactionData expectations) {
                String key;
                Relationship relationship = graph.randomRelationship();
                if (relationship != null && relationship.hasProperty(key = graph.randomPropertyKey())) {
                    Object valueBefore = relationship.removeProperty(key);
                    expectations.removedProperty(relationship, key, valueBefore);
                    this.debug(relationship + " " + key + "=" + valueBefore);
                }
            }
        }
        ,
        createRelationship{

            @Override
            void perform(Graph graph, ExpectedTransactionData expectations) {
                while (graph.nodeCount() < 2) {
                    createNode.perform(graph, expectations);
                }
                Node node1 = graph.randomNode();
                Node node2 = graph.randomNode();
                Relationship relationship = graph.createRelationship(node1, node2, graph.randomRelationshipType());
                expectations.createdRelationship(relationship);
                this.debug(relationship);
            }
        }
        ,
        deleteRelationship{

            @Override
            void perform(Graph graph, ExpectedTransactionData expectations) {
                Relationship relationship = graph.randomRelationship();
                if (relationship != null) {
                    graph.deleteRelationship(relationship);
                    expectations.deletedRelationship(relationship);
                    this.debug(relationship);
                }
            }
        };


        abstract void perform(Graph var1, ExpectedTransactionData var2);

        void debug(Object value) {
        }
    }
}

