/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.coreapi.schema;

import java.io.File;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.graphdb.Label;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.Transaction;
import org.neo4j.graphdb.index.IndexPopulationProgress;
import org.neo4j.graphdb.schema.IndexDefinition;
import org.neo4j.graphdb.schema.Schema;
import org.neo4j.helpers.collection.Iterables;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.test.EphemeralFileSystemRule;
import org.neo4j.test.TestGraphDatabaseFactory;

public class SchemaImplTest {
    @Rule
    public EphemeralFileSystemRule fs = new EphemeralFileSystemRule();
    private GraphDatabaseService db;

    @Before
    public void createDb() throws Exception {
        this.db = new TestGraphDatabaseFactory().setFileSystem((FileSystemAbstraction)this.fs.get()).newImpermanentDatabase(new File("mydb"));
    }

    private void restartDb() throws Exception {
        this.shutdownDb();
        this.createDb();
    }

    @After
    public void shutdownDb() throws Exception {
        this.db.shutdown();
    }

    @Test
    public void testGetIndexPopulationProgress() throws Exception {
        IndexDefinition indexDefinition;
        Schema schema;
        Assert.assertFalse((boolean)this.indexExists(Label.label((String)"User")));
        try (Transaction tx = this.db.beginTx();){
            Label label = Label.label((String)"User");
            for (int id = 0; id < 100000; ++id) {
                Node userNode = this.db.createNode(new Label[]{label});
                userNode.setProperty("username", (Object)("user" + id + "@neo4j.org"));
            }
            tx.success();
        }
        try (Transaction tx = this.db.beginTx();){
            schema = this.db.schema();
            indexDefinition = schema.indexFor(Label.label((String)"User")).on("username").create();
            tx.success();
        }
        tx = this.db.beginTx();
        var3_3 = null;
        try {
            IndexPopulationProgress progress;
            Schema.IndexState state;
            schema = this.db.schema();
            do {
                state = schema.getIndexState(indexDefinition);
                progress = schema.getIndexPopulationProgress(indexDefinition);
                Assert.assertTrue((progress.getCompletedPercentage() >= 0.0f ? 1 : 0) != 0);
                Assert.assertTrue((progress.getCompletedPercentage() <= 100.0f ? 1 : 0) != 0);
                Thread.sleep(10L);
            } while (state == Schema.IndexState.POPULATING);
            Assert.assertTrue((state == Schema.IndexState.ONLINE ? 1 : 0) != 0);
            Assert.assertEquals((float)100.0f, (float)progress.getCompletedPercentage(), (float)0.0f);
        }
        catch (Throwable throwable) {
            var3_3 = throwable;
            throw throwable;
        }
        finally {
            if (tx != null) {
                if (var3_3 != null) {
                    try {
                        tx.close();
                    }
                    catch (Throwable throwable) {
                        var3_3.addSuppressed(throwable);
                    }
                } else {
                    tx.close();
                }
            }
        }
    }

    private boolean indexExists(Label label) {
        try (Transaction transaction = this.db.beginTx();){
            Iterable indexes = this.db.schema().getIndexes(label);
            IndexDefinition index = (IndexDefinition)Iterables.firstOrNull((Iterable)indexes);
            boolean exists = index != null;
            transaction.success();
            boolean bl = exists;
            return bl;
        }
    }
}

