/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.core;

import java.io.File;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.neo4j.graphdb.Direction;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.graphdb.Neo4jMatchers;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.NotInTransactionException;
import org.neo4j.graphdb.Relationship;
import org.neo4j.graphdb.RelationshipType;
import org.neo4j.graphdb.Transaction;
import org.neo4j.graphdb.TransactionFailureException;
import org.neo4j.graphdb.factory.GraphDatabaseSettings;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.kernel.api.exceptions.ReadOnlyDbException;
import org.neo4j.test.DbRepresentation;
import org.neo4j.test.EphemeralFileSystemRule;
import org.neo4j.test.TestGraphDatabaseFactory;

public class TestReadOnlyNeo4j {
    private static final File PATH = new File("read-only");
    @Rule
    public final EphemeralFileSystemRule fs = new EphemeralFileSystemRule();

    @Test
    public void testSimple() {
        DbRepresentation someData = this.createSomeData();
        GraphDatabaseService readGraphDb = new TestGraphDatabaseFactory().setFileSystem((FileSystemAbstraction)this.fs.get()).newImpermanentDatabaseBuilder(PATH).setConfig(GraphDatabaseSettings.read_only, "true").newGraphDatabase();
        Assert.assertEquals((Object)someData, (Object)DbRepresentation.of(readGraphDb));
        try (Transaction tx = readGraphDb.beginTx();){
            readGraphDb.createNode();
            tx.success();
        }
        catch (TransactionFailureException e) {
            Assert.assertThat((Object)e.getCause(), (Matcher)CoreMatchers.instanceOf(ReadOnlyDbException.class));
        }
        readGraphDb.shutdown();
    }

    private DbRepresentation createSomeData() {
        RelationshipType type = RelationshipType.withName((String)"KNOWS");
        GraphDatabaseService db = new TestGraphDatabaseFactory().setFileSystem((FileSystemAbstraction)this.fs.get()).newImpermanentDatabase(PATH);
        try (Transaction tx = db.beginTx();){
            Node prevNode = db.createNode();
            for (int i = 0; i < 100; ++i) {
                Node node = db.createNode();
                Relationship rel = prevNode.createRelationshipTo(node, type);
                node.setProperty("someKey" + i % 10, (Object)(i % 15));
                rel.setProperty("since", (Object)System.currentTimeMillis());
            }
            tx.success();
        }
        DbRepresentation result = DbRepresentation.of(db);
        db.shutdown();
        return result;
    }

    @Test
    public void testReadOnlyOperationsAndNoTransaction() {
        GraphDatabaseService db = new TestGraphDatabaseFactory().setFileSystem((FileSystemAbstraction)this.fs.get()).newImpermanentDatabase(PATH);
        Transaction tx = db.beginTx();
        Node node1 = db.createNode();
        Node node2 = db.createNode();
        Relationship rel = node1.createRelationshipTo(node2, RelationshipType.withName((String)"TEST"));
        node1.setProperty("key1", (Object)"value1");
        rel.setProperty("key1", (Object)"value1");
        tx.success();
        tx.close();
        try {
            db.createNode();
            Assert.fail((String)"Write operation and no transaction should throw exception");
        }
        catch (NotInTransactionException notInTransactionException) {
            // empty catch block
        }
        try {
            node1.createRelationshipTo(node2, RelationshipType.withName((String)"TEST2"));
            Assert.fail((String)"Write operation and no transaction should throw exception");
        }
        catch (NotInTransactionException notInTransactionException) {
            // empty catch block
        }
        try {
            node1.setProperty("key1", (Object)"value2");
            Assert.fail((String)"Write operation and no transaction should throw exception");
        }
        catch (NotInTransactionException notInTransactionException) {
            // empty catch block
        }
        try {
            rel.removeProperty("key1");
            Assert.fail((String)"Write operation and no transaction should throw exception");
        }
        catch (NotInTransactionException notInTransactionException) {
            // empty catch block
        }
        Transaction transaction = db.beginTx();
        Assert.assertEquals((Object)node1, (Object)db.getNodeById(node1.getId()));
        Assert.assertEquals((Object)node2, (Object)db.getNodeById(node2.getId()));
        Assert.assertEquals((Object)rel, (Object)db.getRelationshipById(rel.getId()));
        Assert.assertThat((Object)node1, Neo4jMatchers.inTx(db, Neo4jMatchers.hasProperty("key1").withValue("value1")));
        Relationship loadedRel = node1.getSingleRelationship(RelationshipType.withName((String)"TEST"), Direction.OUTGOING);
        Assert.assertEquals((Object)rel, (Object)loadedRel);
        Assert.assertThat((Object)loadedRel, Neo4jMatchers.inTx(db, Neo4jMatchers.hasProperty("key1").withValue("value1")));
        transaction.close();
        db.shutdown();
    }
}

