/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.core;

import org.apache.commons.lang3.RandomStringUtils;
import org.apache.commons.lang3.RandomUtils;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.Matchers;
import org.mockito.Mockito;
import org.neo4j.graphdb.DynamicLabel;
import org.neo4j.graphdb.Label;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.PropertyContainer;
import org.neo4j.graphdb.Relationship;
import org.neo4j.graphdb.RelationshipType;
import org.neo4j.graphdb.Transaction;
import org.neo4j.kernel.impl.core.PropertyContainerProxyTest;
import org.neo4j.kernel.impl.core.RelationshipProxy;
import org.neo4j.kernel.impl.core.RelationshipTypeToken;

public class RelationshipProxyTest
extends PropertyContainerProxyTest {
    @Override
    protected long createPropertyContainer() {
        return this.db.createNode().createRelationshipTo(this.db.createNode(), RelationshipType.withName((String)"FOO")).getId();
    }

    @Override
    protected PropertyContainer lookupPropertyContainer(long id) {
        return this.db.getRelationshipById(id);
    }

    @Test
    public void shouldBeAbleToReferToIdsBeyondMaxInt() throws Exception {
        RelationshipProxy.RelationshipActions actions = (RelationshipProxy.RelationshipActions)Mockito.mock(RelationshipProxy.RelationshipActions.class);
        Mockito.when((Object)actions.newNodeProxy(Matchers.anyLong())).then(invocation -> this.nodeWithId((Long)invocation.getArguments()[0]));
        Mockito.when((Object)actions.getRelationshipTypeById(Matchers.anyInt())).then(invocation -> new RelationshipTypeToken("whatever", ((Integer)invocation.getArguments()[0]).intValue()));
        long[] ids = new long[]{1437589437L, 2047587483L, 2147496246L, 2147342921L, 3276473721L, 4762746373L, 57587348738L, 59892898932L};
        int[] types = new int[]{0, 10, 101, 3024, 20123, 45008};
        for (int i = 0; i < ids.length - 2; ++i) {
            long id = ids[i];
            long nodeId1 = ids[i + 1];
            long nodeId2 = ids[i + 2];
            int type = types[i];
            this.verifyIds(actions, id, nodeId1, type, nodeId2);
            this.verifyIds(actions, id, nodeId2, type, nodeId1);
        }
    }

    @Test
    public void shouldPrintCypherEsqueRelationshipToString() throws Exception {
        RelationshipType type = RelationshipType.withName((String)"NICE");
        try (Transaction tx = this.db.beginTx();){
            Node start = this.db.createNode();
            Node end = this.db.createNode();
            Relationship relationship = start.createRelationshipTo(end, type);
            tx.success();
            String toString = relationship.toString();
            Assert.assertEquals((Object)("(" + start.getId() + ")-[" + type + "," + relationship.getId() + "]->(" + end.getId() + ")"), (Object)toString);
        }
    }

    public void createDropRelationshipLongStringProperty() {
        Relationship relationship3;
        Label markerLabel = DynamicLabel.label((String)"marker");
        String testPropertyKey = "testProperty";
        String propertyValue = RandomStringUtils.randomAscii((int)255);
        try (Transaction tx = this.db.beginTx();){
            Node start = this.db.createNode(markerLabel);
            Node end = this.db.createNode(markerLabel);
            Relationship relationship2 = start.createRelationshipTo(end, RelationshipType.withName((String)"type"));
            relationship2.setProperty(testPropertyKey, (Object)propertyValue);
            tx.success();
        }
        tx = this.db.beginTx();
        var5_5 = null;
        try {
            relationship3 = this.db.getRelationshipById(0L);
            Assert.assertEquals((Object)propertyValue, (Object)relationship3.getProperty(testPropertyKey));
            tx.success();
        }
        catch (Throwable relationship3) {
            var5_5 = relationship3;
            throw relationship3;
        }
        finally {
            if (tx != null) {
                if (var5_5 != null) {
                    try {
                        tx.close();
                    }
                    catch (Throwable relationship3) {
                        var5_5.addSuppressed(relationship3);
                    }
                } else {
                    tx.close();
                }
            }
        }
        tx = this.db.beginTx();
        var5_5 = null;
        try {
            relationship3 = this.db.getRelationshipById(0L);
            relationship3.removeProperty(testPropertyKey);
            tx.success();
        }
        catch (Throwable relationship4) {
            var5_5 = relationship4;
            throw relationship4;
        }
        finally {
            if (tx != null) {
                if (var5_5 != null) {
                    try {
                        tx.close();
                    }
                    catch (Throwable relationship4) {
                        var5_5.addSuppressed(relationship4);
                    }
                } else {
                    tx.close();
                }
            }
        }
        tx = this.db.beginTx();
        var5_5 = null;
        try {
            relationship3 = this.db.getRelationshipById(0L);
            Assert.assertFalse((boolean)relationship3.hasProperty(testPropertyKey));
            tx.success();
        }
        catch (Throwable throwable) {
            var5_5 = throwable;
            throw throwable;
        }
        finally {
            if (tx != null) {
                if (var5_5 != null) {
                    try {
                        tx.close();
                    }
                    catch (Throwable throwable) {
                        var5_5.addSuppressed(throwable);
                    }
                } else {
                    tx.close();
                }
            }
        }
    }

    @Test
    public void createDropRelationshipLongArrayProperty() {
        Relationship relationship3;
        Label markerLabel = DynamicLabel.label((String)"marker");
        String testPropertyKey = "testProperty";
        byte[] propertyValue = RandomUtils.nextBytes((int)1024);
        try (Transaction tx = this.db.beginTx();){
            Node start = this.db.createNode(markerLabel);
            Node end = this.db.createNode(markerLabel);
            Relationship relationship2 = start.createRelationshipTo(end, RelationshipType.withName((String)"type"));
            relationship2.setProperty(testPropertyKey, (Object)propertyValue);
            tx.success();
        }
        tx = this.db.beginTx();
        var5_5 = null;
        try {
            relationship3 = this.db.getRelationshipById(0L);
            Assert.assertArrayEquals((byte[])propertyValue, (byte[])((byte[])relationship3.getProperty(testPropertyKey)));
            tx.success();
        }
        catch (Throwable relationship3) {
            var5_5 = relationship3;
            throw relationship3;
        }
        finally {
            if (tx != null) {
                if (var5_5 != null) {
                    try {
                        tx.close();
                    }
                    catch (Throwable relationship3) {
                        var5_5.addSuppressed(relationship3);
                    }
                } else {
                    tx.close();
                }
            }
        }
        tx = this.db.beginTx();
        var5_5 = null;
        try {
            relationship3 = this.db.getRelationshipById(0L);
            relationship3.removeProperty(testPropertyKey);
            tx.success();
        }
        catch (Throwable relationship4) {
            var5_5 = relationship4;
            throw relationship4;
        }
        finally {
            if (tx != null) {
                if (var5_5 != null) {
                    try {
                        tx.close();
                    }
                    catch (Throwable relationship4) {
                        var5_5.addSuppressed(relationship4);
                    }
                } else {
                    tx.close();
                }
            }
        }
        tx = this.db.beginTx();
        var5_5 = null;
        try {
            relationship3 = this.db.getRelationshipById(0L);
            Assert.assertFalse((boolean)relationship3.hasProperty(testPropertyKey));
            tx.success();
        }
        catch (Throwable throwable) {
            var5_5 = throwable;
            throw throwable;
        }
        finally {
            if (tx != null) {
                if (var5_5 != null) {
                    try {
                        tx.close();
                    }
                    catch (Throwable throwable) {
                        var5_5.addSuppressed(throwable);
                    }
                } else {
                    tx.close();
                }
            }
        }
    }

    private void verifyIds(RelationshipProxy.RelationshipActions actions, long relationshipId, long nodeId1, int typeId, long nodeId2) {
        RelationshipProxy proxy = new RelationshipProxy(actions, relationshipId, nodeId1, typeId, nodeId2);
        Assert.assertEquals((long)relationshipId, (long)proxy.getId());
        Assert.assertEquals((long)typeId, (long)((RelationshipTypeToken)proxy.getType()).id());
        Assert.assertEquals((long)nodeId1, (long)proxy.getStartNode().getId());
        Assert.assertEquals((long)nodeId2, (long)proxy.getEndNode().getId());
        Assert.assertEquals((long)nodeId2, (long)proxy.getOtherNode(this.nodeWithId(nodeId1)).getId());
        Assert.assertEquals((long)nodeId1, (long)proxy.getOtherNode(this.nodeWithId(nodeId2)).getId());
    }

    private Node nodeWithId(long id) {
        Node node = (Node)Mockito.mock(Node.class);
        Mockito.when((Object)node.getId()).thenReturn((Object)id);
        return node;
    }
}

