/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.core;

import java.io.File;
import java.util.Map;
import org.junit.Ignore;
import org.junit.Test;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.graphdb.Label;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.RelationshipType;
import org.neo4j.graphdb.Transaction;
import org.neo4j.graphdb.factory.GraphDatabaseFactory;
import org.neo4j.helpers.collection.MapUtil;
import org.neo4j.kernel.impl.AbstractNeo4jTestCase;
import org.neo4j.unsafe.batchinsert.BatchInserter;
import org.neo4j.unsafe.batchinsert.BatchInserters;

@Ignore(value="Requires a lot of disk space")
public class ProveFiveBillionIT {
    private static final File PATH = new File("target/var/5b");
    private static final RelationshipType TYPE = RelationshipType.withName((String)"CHAIN");

    @Test
    public void proveIt() throws Exception {
        long i;
        AbstractNeo4jTestCase.deleteFileOrDirectory(PATH);
        BatchInserter inserter = BatchInserters.inserter((File)PATH);
        long first = inserter.createNode(MapUtil.map((Object[])new Object[0]), new Label[0]);
        int max = (int)Math.pow(2.0, 32.0) - 1000;
        Map nodeProperties = MapUtil.map((Object[])new Object[]{"number", 123});
        Map relationshipProperties = MapUtil.map((Object[])new Object[]{"string", "A long string, which is longer than shortstring boundaries"});
        for (i = 0L; i < (long)max; ++i) {
            long second = inserter.createNode(nodeProperties, new Label[0]);
            inserter.createRelationship(first, second, TYPE, relationshipProperties);
            if (i > 0L && i % 1000000L == 0L) {
                System.out.println(i / 1000000L + "M");
            }
            first = second;
        }
        inserter.shutdown();
        System.out.println("Switch to embedded");
        GraphDatabaseService db = new GraphDatabaseFactory().newEmbeddedDatabase(PATH);
        Node firstNode = db.getNodeById(first);
        Transaction tx = db.beginTx();
        while (i < 5000000000L) {
            Node secondNode = db.createNode();
            firstNode.createRelationshipTo(secondNode, TYPE);
            firstNode = secondNode;
            if (i % 100000L == 0L) {
                tx.success();
                tx.close();
                System.out.println(i / 1000000L + "M");
                tx = db.beginTx();
            }
            ++i;
        }
        db.shutdown();
    }
}

