/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.core;

import java.util.ArrayList;
import java.util.Iterator;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.core.IsInstanceOf;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.Relationship;
import org.neo4j.graphdb.RelationshipType;
import org.neo4j.graphdb.ResourceIterator;
import org.neo4j.graphdb.Transaction;
import org.neo4j.helpers.collection.Iterators;
import org.neo4j.kernel.impl.core.NodeManager;
import org.neo4j.kernel.impl.coreapi.PlaceboTransaction;
import org.neo4j.kernel.internal.GraphDatabaseAPI;
import org.neo4j.test.TestGraphDatabaseFactory;

public class NodeManagerTest {
    private GraphDatabaseAPI db;

    @Before
    public void init() {
        this.db = (GraphDatabaseAPI)new TestGraphDatabaseFactory().newImpermanentDatabase();
    }

    @After
    public void stop() {
        this.db.shutdown();
    }

    @Test
    public void getAllNodesIteratorShouldPickUpHigherIdsThanHighIdWhenStarted() throws Exception {
        Transaction tx = this.db.beginTx();
        this.db.createNode();
        this.db.createNode();
        tx.success();
        tx.close();
        Transaction transaction = this.db.beginTx();
        ResourceIterator allNodes = this.db.getAllNodes().iterator();
        allNodes.next();
        Thread thread = new Thread(() -> {
            Transaction newTx = this.db.beginTx();
            Assert.assertThat((Object)newTx, (Matcher)CoreMatchers.not((Matcher)IsInstanceOf.instanceOf(PlaceboTransaction.class)));
            this.db.createNode();
            newTx.success();
            newTx.close();
        });
        thread.start();
        thread.join();
        Assert.assertThat((Object)((ArrayList)Iterators.addToCollection((Iterator)allNodes, new ArrayList())).size(), (Matcher)CoreMatchers.is((Object)2));
        transaction.close();
    }

    @Test
    public void getAllRelationshipsIteratorShouldPickUpHigherIdsThanHighIdWhenStarted() throws Exception {
        Transaction tx = this.db.beginTx();
        this.createRelationshipAssumingTxWith("key", 1);
        this.createRelationshipAssumingTxWith("key", 2);
        tx.success();
        tx.close();
        tx = this.db.beginTx();
        ResourceIterator allRelationships = this.db.getAllRelationships().iterator();
        Thread thread = new Thread(new Runnable(){

            @Override
            public void run() {
                Transaction newTx = NodeManagerTest.this.db.beginTx();
                Assert.assertThat((Object)newTx, (Matcher)CoreMatchers.not((Matcher)IsInstanceOf.instanceOf(PlaceboTransaction.class)));
                NodeManagerTest.this.createRelationshipAssumingTxWith("key", 3);
                newTx.success();
                newTx.close();
            }
        });
        thread.start();
        thread.join();
        Assert.assertThat((Object)((ArrayList)Iterators.addToCollection((Iterator)allRelationships, new ArrayList())).size(), (Matcher)CoreMatchers.is((Object)3));
        tx.success();
        tx.close();
    }

    private void delete(Relationship relationship) {
        Transaction tx = this.db.beginTx();
        relationship.delete();
        tx.success();
        tx.close();
    }

    private Node createNodeWith(String key, Object value) {
        Transaction tx = this.db.beginTx();
        Node node = this.db.createNode();
        node.setProperty(key, value);
        tx.success();
        tx.close();
        return node;
    }

    private Relationship createRelationshipWith(String key, Object value) {
        Transaction tx = this.db.beginTx();
        Relationship relationship = this.createRelationshipAssumingTxWith(key, value);
        tx.success();
        tx.close();
        return relationship;
    }

    private Relationship createRelationshipAssumingTxWith(String key, Object value) {
        Node a = this.db.createNode();
        Node b = this.db.createNode();
        Relationship relationship = a.createRelationshipTo(b, RelationshipType.withName((String)"FOO"));
        relationship.setProperty(key, value);
        return relationship;
    }

    private void delete(Node node) {
        Transaction tx = this.db.beginTx();
        node.delete();
        tx.success();
        tx.close();
    }

    private NodeManager getNodeManager() {
        return (NodeManager)this.db.getDependencyResolver().resolveDependency(NodeManager.class);
    }
}

