/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.core;

import org.junit.Assert;
import org.junit.Test;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.NotFoundException;
import org.neo4j.graphdb.Relationship;
import org.neo4j.graphdb.RelationshipType;
import org.neo4j.graphdb.Transaction;
import org.neo4j.kernel.impl.AbstractNeo4jTestCase;
import org.neo4j.kernel.impl.MyRelTypes;

public class Neo4jConstraintsTest
extends AbstractNeo4jTestCase {
    private final String key = "testproperty";

    @Test
    public void testDeleteReferenceNodeOrLastNodeIsOk() {
        Transaction tx = this.getTransaction();
        for (int i = 0; i < 10; ++i) {
            this.getGraphDb().createNode();
        }
        for (Node node : this.getGraphDb().getAllNodes()) {
            for (Relationship rel : node.getRelationships()) {
                rel.delete();
            }
            node.delete();
        }
        tx.success();
        tx.close();
        tx = this.getGraphDb().beginTx();
        Assert.assertFalse((boolean)this.getGraphDb().getAllNodes().iterator().hasNext());
        tx.success();
        tx.close();
    }

    @Test
    public void testDeleteNodeWithRel1() {
        Node node1 = this.getGraphDb().createNode();
        Node node2 = this.getGraphDb().createNode();
        node1.createRelationshipTo(node2, (RelationshipType)MyRelTypes.TEST);
        node1.delete();
        try {
            Transaction tx = this.getTransaction();
            tx.success();
            tx.close();
            Assert.fail((String)"Should not validate");
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.setTransaction(this.getGraphDb().beginTx());
    }

    @Test
    public void testDeleteNodeWithRel2() {
        Node node1 = this.getGraphDb().createNode();
        Node node2 = this.getGraphDb().createNode();
        node1.createRelationshipTo(node2, (RelationshipType)MyRelTypes.TEST);
        node2.delete();
        node1.delete();
        try {
            Transaction tx = this.getTransaction();
            tx.success();
            tx.close();
            Assert.fail((String)"Should not validate");
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.setTransaction(this.getGraphDb().beginTx());
    }

    @Test
    public void testDeleteNodeWithRel3() {
        Node node0 = this.getGraphDb().createNode();
        Node node1 = this.getGraphDb().createNode();
        Node node2 = this.getGraphDb().createNode();
        Relationship rel0 = node0.createRelationshipTo(node1, (RelationshipType)MyRelTypes.TEST);
        Relationship rel1 = node0.createRelationshipTo(node2, (RelationshipType)MyRelTypes.TEST);
        node1.delete();
        rel0.delete();
        Transaction tx = this.getTransaction();
        tx.success();
        tx.close();
        this.setTransaction(this.getGraphDb().beginTx());
        node2.delete();
        rel1.delete();
        node0.delete();
    }

    @Test
    public void testCreateRelOnDeletedNode() {
        Node node1 = this.getGraphDb().createNode();
        Node node2 = this.getGraphDb().createNode();
        Transaction tx = this.getTransaction();
        tx.success();
        tx.close();
        tx = this.getGraphDb().beginTx();
        node1.delete();
        try {
            node1.createRelationshipTo(node2, (RelationshipType)MyRelTypes.TEST);
            Assert.fail((String)"Create of rel on deleted node should fail fast");
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            tx.failure();
            tx.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.setTransaction(this.getGraphDb().beginTx());
        node2.delete();
        node1.delete();
    }

    @Test
    public void testAddPropertyDeletedNode() {
        Node node = this.getGraphDb().createNode();
        node.delete();
        try {
            node.setProperty("testproperty", (Object)1);
            Assert.fail((String)"Add property on deleted node should not validate");
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Test
    public void testRemovePropertyDeletedNode() {
        Node node = this.getGraphDb().createNode();
        node.setProperty("testproperty", (Object)1);
        node.delete();
        try {
            node.removeProperty("testproperty");
            Transaction tx = this.getTransaction();
            tx.success();
            tx.close();
            Assert.fail((String)"Change property on deleted node should not validate");
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Test
    public void testChangePropertyDeletedNode() {
        Node node = this.getGraphDb().createNode();
        node.setProperty("testproperty", (Object)1);
        node.delete();
        try {
            node.setProperty("testproperty", (Object)2);
            Transaction tx = this.getTransaction();
            tx.success();
            tx.close();
            Assert.fail((String)"Change property on deleted node should not validate");
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Test
    public void testAddPropertyDeletedRelationship() {
        Node node1 = this.getGraphDb().createNode();
        Node node2 = this.getGraphDb().createNode();
        Relationship rel = node1.createRelationshipTo(node2, (RelationshipType)MyRelTypes.TEST);
        rel.delete();
        try {
            rel.setProperty("testproperty", (Object)1);
            Transaction tx = this.getTransaction();
            tx.success();
            tx.close();
            Assert.fail((String)"Add property on deleted rel should not validate");
        }
        catch (Exception exception) {
            // empty catch block
        }
        node1.delete();
        node2.delete();
    }

    @Test
    public void testRemovePropertyDeletedRelationship() {
        Node node1 = this.getGraphDb().createNode();
        Node node2 = this.getGraphDb().createNode();
        Relationship rel = node1.createRelationshipTo(node2, (RelationshipType)MyRelTypes.TEST);
        rel.setProperty("testproperty", (Object)1);
        rel.delete();
        try {
            rel.removeProperty("testproperty");
            Transaction tx = this.getTransaction();
            tx.success();
            tx.close();
            Assert.fail((String)"Remove property on deleted rel should not validate");
        }
        catch (Exception exception) {
            // empty catch block
        }
        node1.delete();
        node2.delete();
    }

    @Test
    public void testChangePropertyDeletedRelationship() {
        Node node1 = this.getGraphDb().createNode();
        Node node2 = this.getGraphDb().createNode();
        Relationship rel = node1.createRelationshipTo(node2, (RelationshipType)MyRelTypes.TEST);
        rel.setProperty("testproperty", (Object)1);
        rel.delete();
        try {
            rel.setProperty("testproperty", (Object)2);
            Transaction tx = this.getTransaction();
            tx.success();
            tx.close();
            Assert.fail((String)"Change property on deleted rel should not validate");
        }
        catch (Exception exception) {
            // empty catch block
        }
        node1.delete();
        node2.delete();
    }

    @Test
    public void testMultipleDeleteNode() {
        Node node1 = this.getGraphDb().createNode();
        node1.delete();
        try {
            node1.delete();
            Transaction tx = this.getTransaction();
            tx.success();
            tx.close();
            Assert.fail((String)"Should not validate");
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Test
    public void testMultipleDeleteRelationship() {
        Node node1 = this.getGraphDb().createNode();
        Node node2 = this.getGraphDb().createNode();
        Relationship rel = node1.createRelationshipTo(node2, (RelationshipType)MyRelTypes.TEST);
        rel.delete();
        node1.delete();
        node2.delete();
        try {
            rel.delete();
            Transaction tx = this.getTransaction();
            tx.success();
            tx.close();
            Assert.fail((String)"Should not validate");
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Test
    public void testIllegalPropertyType() {
        Node node1 = this.getGraphDb().createNode();
        try {
            node1.setProperty("testproperty", new Object());
            Assert.fail((String)"Shouldn't validate");
        }
        catch (Exception exception) {
            // empty catch block
        }
        Transaction tx22 = this.getTransaction();
        tx22.failure();
        tx22.close();
        this.setTransaction(this.getGraphDb().beginTx());
        try {
            this.getGraphDb().getNodeById(node1.getId());
            Assert.fail((String)"Node should not exist, previous tx didn't rollback");
        }
        catch (NotFoundException tx22) {
            // empty catch block
        }
        node1 = this.getGraphDb().createNode();
        Node node2 = this.getGraphDb().createNode();
        Relationship rel = node1.createRelationshipTo(node2, (RelationshipType)MyRelTypes.TEST);
        try {
            rel.setProperty("testproperty", new Object());
            Assert.fail((String)"Shouldn't validate");
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            Transaction tx = this.getTransaction();
            tx.success();
            tx.close();
            Assert.fail((String)"Shouldn't validate");
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.setTransaction(this.getGraphDb().beginTx());
        try {
            this.getGraphDb().getNodeById(node1.getId());
            Assert.fail((String)"Node should not exist, previous tx didn't rollback");
        }
        catch (NotFoundException notFoundException) {
            // empty catch block
        }
        try {
            this.getGraphDb().getNodeById(node2.getId());
            Assert.fail((String)"Node should not exist, previous tx didn't rollback");
        }
        catch (NotFoundException notFoundException) {
            // empty catch block
        }
    }

    @Test
    public void testNodeRelDeleteSemantics() {
        Node node1 = this.getGraphDb().createNode();
        Node node2 = this.getGraphDb().createNode();
        Relationship rel1 = node1.createRelationshipTo(node2, (RelationshipType)MyRelTypes.TEST);
        Relationship rel2 = node1.createRelationshipTo(node2, (RelationshipType)MyRelTypes.TEST);
        node1.setProperty("key1", (Object)"value1");
        rel1.setProperty("key1", (Object)"value1");
        this.newTransaction();
        node1.delete();
        try {
            node1.getProperty("key1");
            Assert.fail((String)"Should throw exception");
        }
        catch (NotFoundException notFoundException) {
            // empty catch block
        }
        try {
            node1.setProperty("key1", (Object)"value2");
            Assert.fail((String)"Should throw exception");
        }
        catch (NotFoundException notFoundException) {
            // empty catch block
        }
        try {
            node1.removeProperty("key1");
            Assert.fail((String)"Should throw exception");
        }
        catch (NotFoundException notFoundException) {
            // empty catch block
        }
        node2.delete();
        try {
            node2.delete();
            Assert.fail((String)"Should throw exception");
        }
        catch (NotFoundException notFoundException) {
            // empty catch block
        }
        try {
            node1.getProperty("key1");
            Assert.fail((String)"Should throw exception");
        }
        catch (NotFoundException notFoundException) {
            // empty catch block
        }
        try {
            node1.setProperty("key1", (Object)"value2");
            Assert.fail((String)"Should throw exception");
        }
        catch (NotFoundException notFoundException) {
            // empty catch block
        }
        try {
            node1.removeProperty("key1");
            Assert.fail((String)"Should throw exception");
        }
        catch (NotFoundException notFoundException) {
            // empty catch block
        }
        Assert.assertEquals((Object)"value1", (Object)rel1.getProperty("key1"));
        rel1.delete();
        try {
            rel1.delete();
            Assert.fail((String)"Should throw exception");
        }
        catch (NotFoundException notFoundException) {
            // empty catch block
        }
        try {
            rel1.getProperty("key1");
            Assert.fail((String)"Should throw exception");
        }
        catch (NotFoundException notFoundException) {
            // empty catch block
        }
        try {
            rel1.setProperty("key1", (Object)"value2");
            Assert.fail((String)"Should throw exception");
        }
        catch (NotFoundException notFoundException) {
            // empty catch block
        }
        try {
            rel1.removeProperty("key1");
            Assert.fail((String)"Should throw exception");
        }
        catch (NotFoundException notFoundException) {
            // empty catch block
        }
        try {
            rel1.getProperty("key1");
            Assert.fail((String)"Should throw exception");
        }
        catch (NotFoundException notFoundException) {
            // empty catch block
        }
        try {
            rel1.setProperty("key1", (Object)"value2");
            Assert.fail((String)"Should throw exception");
        }
        catch (NotFoundException notFoundException) {
            // empty catch block
        }
        try {
            rel1.removeProperty("key1");
            Assert.fail((String)"Should throw exception");
        }
        catch (NotFoundException notFoundException) {
            // empty catch block
        }
        try {
            node2.createRelationshipTo(node1, (RelationshipType)MyRelTypes.TEST);
            Assert.fail((String)"Should throw exception");
        }
        catch (NotFoundException notFoundException) {
            // empty catch block
        }
        try {
            node2.createRelationshipTo(node1, (RelationshipType)MyRelTypes.TEST);
            Assert.fail((String)"Should throw exception");
        }
        catch (NotFoundException notFoundException) {
            // empty catch block
        }
        Assert.assertEquals((Object)node1, (Object)rel1.getStartNode());
        Assert.assertEquals((Object)node2, (Object)rel2.getEndNode());
        Node[] nodes = rel1.getNodes();
        Assert.assertEquals((Object)node1, (Object)nodes[0]);
        Assert.assertEquals((Object)node2, (Object)nodes[1]);
        Assert.assertEquals((Object)node2, (Object)rel1.getOtherNode(node1));
        rel2.delete();
        this.rollback();
    }
}

