/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.core;

import java.io.File;
import java.util.ArrayList;
import java.util.Map;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Ignore;
import org.junit.Test;
import org.neo4j.graphdb.Direction;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.PropertyContainer;
import org.neo4j.graphdb.Relationship;
import org.neo4j.graphdb.RelationshipType;
import org.neo4j.graphdb.Transaction;
import org.neo4j.graphdb.factory.GraphDatabaseSettings;
import org.neo4j.helpers.collection.Iterables;
import org.neo4j.helpers.collection.MapUtil;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.kernel.GraphDatabaseDependencies;
import org.neo4j.kernel.impl.AbstractNeo4jTestCase;
import org.neo4j.kernel.impl.core.BigStoreIT;
import org.neo4j.kernel.impl.core.JumpingFileSystemAbstraction;
import org.neo4j.kernel.impl.core.JumpingIdGeneratorFactory;
import org.neo4j.kernel.impl.factory.CommunityEditionModule;
import org.neo4j.kernel.impl.factory.CommunityFacadeFactory;
import org.neo4j.kernel.impl.factory.EditionModule;
import org.neo4j.kernel.impl.factory.GraphDatabaseFacade;
import org.neo4j.kernel.impl.factory.GraphDatabaseFacadeFactory;
import org.neo4j.kernel.impl.factory.PlatformModule;
import org.neo4j.kernel.impl.store.id.IdGeneratorFactory;
import org.neo4j.kernel.impl.store.id.configuration.IdTypeConfigurationProvider;

@Ignore(value="Ignored because the new page cache cannot turn off 'memory mapping', and that makes it run afoul of the hack in JumpingFileSystemAbstraction$JumpingFileChannel.assertWithinDiff() for the PropertyStore alignment.")
public class BigJumpingStoreIT {
    private static final int SIZE_PER_JUMP = 1000;
    private static final File PATH = new File("target/var/bigjump");
    private static final RelationshipType TYPE = RelationshipType.withName((String)"KNOWS");
    private static final RelationshipType TYPE2 = RelationshipType.withName((String)"DROP_KICKS");
    private GraphDatabaseService db;

    @Before
    public void doBefore() {
        AbstractNeo4jTestCase.deleteFileOrDirectory(PATH);
        this.db = new CommunityFacadeFactory(){

            protected PlatformModule createPlatform(File storeDir, Map<String, String> params, GraphDatabaseFacadeFactory.Dependencies dependencies, GraphDatabaseFacade graphDatabaseFacade) {
                return new PlatformModule(storeDir, params, this.databaseInfo(), dependencies, graphDatabaseFacade){

                    protected FileSystemAbstraction createFileSystemAbstraction() {
                        return new JumpingFileSystemAbstraction(1000);
                    }
                };
            }

            protected EditionModule createEdition(PlatformModule platformModule) {
                return new CommunityEditionModule(platformModule){

                    protected IdGeneratorFactory createIdGeneratorFactory(FileSystemAbstraction fs, IdTypeConfigurationProvider idTypeConfigurationProvider) {
                        return new JumpingIdGeneratorFactory(1000);
                    }
                };
            }
        }.newFacade(PATH, this.config(), (GraphDatabaseFacadeFactory.Dependencies)GraphDatabaseDependencies.newDependencies());
    }

    private Map<String, String> config() {
        return MapUtil.stringMap((String[])new String[]{GraphDatabaseSettings.pagecache_memory.name(), "10M"});
    }

    @After
    public void doAfter() {
        if (this.db != null) {
            this.db.shutdown();
        }
        this.db = null;
    }

    @Test
    public void crudOnHighIds() throws Exception {
        int t;
        ArrayList<Node> nodes = new ArrayList<Node>();
        Transaction tx = this.db.beginTx();
        int numberOfNodes = 3000;
        String stringValue = "a longer string than short";
        byte[] arrayValue = new byte[]{3, 7};
        for (int i = 0; i < numberOfNodes; ++i) {
            Node node = this.db.createNode();
            node.setProperty("number", (Object)i);
            node.setProperty("string", (Object)stringValue);
            node.setProperty("array", (Object)arrayValue);
            nodes.add(node);
        }
        int numberOfRels = numberOfNodes - 100;
        for (int i = 0; i < numberOfRels; ++i) {
            Node node1 = (Node)nodes.get(i / 100);
            Node node2 = (Node)nodes.get(i + 1);
            Relationship relationship = node1.createRelationshipTo(node2, TYPE);
        }
        tx.success();
        tx.close();
        tx = this.db.beginTx();
        int relCount = 0;
        for (t = 0; t < 2; ++t) {
            int nodeCount = 0;
            relCount = 0;
            for (Node node : nodes) {
                node = this.db.getNodeById(node.getId());
                BigStoreIT.assertProperties(MapUtil.map((Object[])new Object[]{"number", nodeCount++, "string", stringValue, "array", arrayValue}), (PropertyContainer)node);
                relCount = (int)((long)relCount + Iterables.count((Iterable)node.getRelationships(Direction.OUTGOING)));
            }
        }
        Assert.assertEquals((long)numberOfRels, (long)relCount);
        tx.close();
        tx = this.db.beginTx();
        for (int i = 0; i < nodes.size(); ++i) {
            Node node = (Node)nodes.get(i);
            switch (i % 6) {
                case 0: {
                    node.removeProperty("number");
                    break;
                }
                case 1: {
                    node.removeProperty("string");
                    break;
                }
                case 2: {
                    node.removeProperty("array");
                    break;
                }
                case 3: {
                    node.removeProperty("number");
                    node.removeProperty("string");
                    node.removeProperty("array");
                    break;
                }
                case 4: {
                    node.setProperty("new", (Object)34);
                    break;
                }
                case 5: {
                    Object oldValue = node.getProperty("string", null);
                    if (oldValue == null) break;
                    node.setProperty("string", (Object)"asjdkasdjkasjdkasjdkasdjkasdj");
                    node.setProperty("string", (Object)stringValue);
                }
            }
            if (Iterables.count((Iterable)node.getRelationships()) > 50L) {
                if (i % 2 == 0) {
                    this.deleteIfNotNull((Relationship)Iterables.firstOrNull((Iterable)node.getRelationships()));
                    this.deleteIfNotNull((Relationship)Iterables.lastOrNull((Iterable)node.getRelationships()));
                } else {
                    this.deleteEveryOther(node.getRelationships());
                }
                this.setPropertyOnAll(node.getRelationships(Direction.OUTGOING), "relprop", "rel value");
                continue;
            }
            if (i % 20 != 0) continue;
            Node otherNode = (Node)nodes.get(nodes.size() - i - 1);
            Relationship rel = node.createRelationshipTo(otherNode, TYPE2);
            rel.setProperty("other relprop", (Object)1010);
        }
        tx.success();
        tx.close();
        tx = this.db.beginTx();
        for (t = 0; t < 2; ++t) {
            int nodeCount = 0;
            for (Node node : nodes) {
                node = this.db.getNodeById(node.getId());
                switch (nodeCount % 6) {
                    case 0: {
                        BigStoreIT.assertProperties(MapUtil.map((Object[])new Object[]{"string", stringValue, "array", arrayValue}), (PropertyContainer)node);
                        break;
                    }
                    case 1: {
                        BigStoreIT.assertProperties(MapUtil.map((Object[])new Object[]{"number", nodeCount, "array", arrayValue}), (PropertyContainer)node);
                        break;
                    }
                    case 2: {
                        BigStoreIT.assertProperties(MapUtil.map((Object[])new Object[]{"number", nodeCount, "string", stringValue}), (PropertyContainer)node);
                        break;
                    }
                    case 3: {
                        Assert.assertEquals((long)0L, (long)Iterables.count((Iterable)node.getPropertyKeys()));
                        break;
                    }
                    case 4: {
                        BigStoreIT.assertProperties(MapUtil.map((Object[])new Object[]{"number", nodeCount, "string", stringValue, "array", arrayValue, "new", 34}), (PropertyContainer)node);
                        break;
                    }
                    case 5: {
                        BigStoreIT.assertProperties(MapUtil.map((Object[])new Object[]{"number", nodeCount, "string", stringValue, "array", arrayValue}), (PropertyContainer)node);
                        break;
                    }
                }
                for (Relationship rel : node.getRelationships(Direction.OUTGOING)) {
                    if (rel.isType(TYPE)) {
                        BigStoreIT.assertProperties(MapUtil.map((Object[])new Object[]{"relprop", "rel value"}), (PropertyContainer)rel);
                        continue;
                    }
                    if (rel.isType(TYPE2)) {
                        BigStoreIT.assertProperties(MapUtil.map((Object[])new Object[]{"other relprop", 1010}), (PropertyContainer)rel);
                        continue;
                    }
                    Assert.fail((String)("Invalid type " + rel.getType() + " for " + rel));
                }
                ++nodeCount;
            }
        }
        tx.close();
    }

    private void setPropertyOnAll(Iterable<Relationship> relationships, String key, Object value) {
        for (Relationship rel : relationships) {
            rel.setProperty(key, value);
        }
    }

    private void deleteEveryOther(Iterable<Relationship> relationships) {
        int relCounter = 0;
        for (Relationship rel : relationships) {
            if (relCounter++ % 2 != 0) continue;
            rel.delete();
        }
    }

    private void deleteIfNotNull(Relationship relationship) {
        if (relationship != null) {
            relationship.delete();
        }
    }
}

