/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.api.store;

import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.RuleChain;
import org.junit.rules.TestRule;
import org.mockito.Mockito;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.kernel.impl.api.store.StoreSingleRelationshipCursor;
import org.neo4j.kernel.impl.locking.LockService;
import org.neo4j.kernel.impl.store.NeoStores;
import org.neo4j.kernel.impl.store.RecordCursors;
import org.neo4j.kernel.impl.store.RelationshipStore;
import org.neo4j.kernel.impl.store.StoreFactory;
import org.neo4j.kernel.impl.store.record.AbstractBaseRecord;
import org.neo4j.kernel.impl.store.record.RelationshipRecord;
import org.neo4j.kernel.impl.util.InstanceCache;
import org.neo4j.logging.LogProvider;
import org.neo4j.logging.NullLogProvider;
import org.neo4j.test.DefaultFileSystemRule;
import org.neo4j.test.PageCacheRule;
import org.neo4j.test.TargetDirectory;

public class StoreSingleRelationshipCursorTest {
    private static final long RELATIONSHIP_ID = 1L;
    private NeoStores neoStores;
    private final TargetDirectory.TestDirectory testDirectory = TargetDirectory.testDirForTest(this.getClass());
    private final PageCacheRule pageCacheRule = new PageCacheRule();
    private final DefaultFileSystemRule fileSystemRule = new DefaultFileSystemRule();
    @Rule
    public final RuleChain ruleChain = RuleChain.outerRule((TestRule)this.testDirectory).around((TestRule)this.pageCacheRule).around((TestRule)this.fileSystemRule);

    @After
    public void tearDown() {
        if (this.neoStores != null) {
            this.neoStores.close();
        }
    }

    @Before
    public void setUp() {
        StoreFactory storeFactory = this.getStoreFactory();
        this.neoStores = storeFactory.openAllNeoStores(true);
    }

    @Test
    public void retrieveUsedRelationship() throws Exception {
        RelationshipStore relationshipStore = this.neoStores.getRelationshipStore();
        this.createRelationshipRecord(relationshipStore, true);
        try (StoreSingleRelationshipCursor cursor = this.createRelationshipCursor();){
            cursor.init(1L);
            Assert.assertTrue((boolean)cursor.next());
            Assert.assertEquals((long)1L, (long)cursor.get().id());
        }
    }

    @Test
    public void retrieveUnusedRelationship() {
        RelationshipStore relationshipStore = this.neoStores.getRelationshipStore();
        relationshipStore.setHighId(10L);
        this.createRelationshipRecord(relationshipStore, false);
        try (StoreSingleRelationshipCursor cursor = this.createRelationshipCursor();){
            cursor.init(1L);
            Assert.assertFalse((boolean)cursor.next());
        }
    }

    private void createRelationshipRecord(RelationshipStore relationshipStore, boolean used) {
        relationshipStore.updateRecord((AbstractBaseRecord)new RelationshipRecord(1L, used, 1L, 2L, 1, -1L, -1L, -1L, -1L, true, true));
    }

    private StoreFactory getStoreFactory() {
        return new StoreFactory(this.testDirectory.directory(), this.pageCacheRule.getPageCache((FileSystemAbstraction)this.fileSystemRule.get()), (FileSystemAbstraction)this.fileSystemRule.get(), (LogProvider)NullLogProvider.getInstance());
    }

    private StoreSingleRelationshipCursor createRelationshipCursor() {
        InstanceCache instanceCache = (InstanceCache)Mockito.mock(InstanceCache.class);
        return new StoreSingleRelationshipCursor(new RelationshipRecord(-1L), instanceCache, new RecordCursors(this.neoStores), LockService.NO_LOCK_SERVICE);
    }
}

