/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.api.store;

import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.junit.After;
import org.junit.Before;
import org.neo4j.graphdb.DependencyResolver;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.graphdb.Label;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.RelationshipType;
import org.neo4j.graphdb.Transaction;
import org.neo4j.graphdb.schema.IndexDefinition;
import org.neo4j.kernel.api.ReadOperations;
import org.neo4j.kernel.api.Statement;
import org.neo4j.kernel.api.index.IndexDescriptor;
import org.neo4j.kernel.impl.api.KernelStatement;
import org.neo4j.kernel.impl.core.ThreadToStatementContextBridge;
import org.neo4j.kernel.impl.proc.Procedures;
import org.neo4j.kernel.internal.GraphDatabaseAPI;
import org.neo4j.storageengine.api.StorageEngine;
import org.neo4j.storageengine.api.StoreReadLayer;
import org.neo4j.test.TestGraphDatabaseFactory;

public abstract class DiskLayerTest {
    protected GraphDatabaseAPI db;
    protected final Label label1 = Label.label((String)"FirstLabel");
    protected final Label label2 = Label.label((String)"SecondLabel");
    protected final RelationshipType relType1 = RelationshipType.withName((String)"type1");
    protected final RelationshipType relType2 = RelationshipType.withName((String)"type2");
    protected final String propertyKey = "name";
    protected final String otherPropertyKey = "age";
    protected KernelStatement state;
    protected StoreReadLayer disk;

    @Before
    public void before() {
        this.db = (GraphDatabaseAPI)this.createGraphDatabase();
        DependencyResolver resolver = this.db.getDependencyResolver();
        this.disk = ((StorageEngine)resolver.resolveDependency(StorageEngine.class)).storeReadLayer();
        this.state = new KernelStatement(null, null, null, this.disk.newStatement(), new Procedures());
    }

    protected GraphDatabaseService createGraphDatabase() {
        return new TestGraphDatabaseFactory().newImpermanentDatabase();
    }

    @After
    public void after() {
        this.db.shutdown();
    }

    protected static Node createLabeledNode(GraphDatabaseService db, Map<String, Object> properties, Label ... labels) {
        try (Transaction tx = db.beginTx();){
            Node node = db.createNode(labels);
            for (Map.Entry<String, Object> property : properties.entrySet()) {
                node.setProperty(property.getKey(), property.getValue());
            }
            tx.success();
            Node node2 = node;
            return node2;
        }
    }

    protected IndexDescriptor createIndexAndAwaitOnline(Label label, String propertyKey) throws Exception {
        IndexDefinition index;
        try (Transaction tx = this.db.beginTx();){
            index = this.db.schema().indexFor(label).on(propertyKey).create();
            tx.success();
        }
        var5_4 = null;
        try (Transaction ignored = this.db.beginTx();){
            this.db.schema().awaitIndexOnline(index, 10L, TimeUnit.SECONDS);
            IndexDescriptor indexDescriptor = this.disk.indexGetForLabelAndPropertyKey(this.disk.labelGetForName(label.name()), this.disk.propertyKeyGetForName(propertyKey));
            return indexDescriptor;
        }
        catch (Throwable throwable) {
            var5_4 = throwable;
            throw throwable;
        }
    }

    protected int labelId(Label label) {
        try (Transaction ignored = this.db.beginTx();){
            int n = this.readOps().labelGetForName(label.name());
            return n;
        }
    }

    protected int relationshipTypeId(RelationshipType type) {
        try (Transaction ignored = this.db.beginTx();){
            int n = this.readOps().relationshipTypeGetForName(type.name());
            return n;
        }
    }

    protected int propertyKeyId(String propertyKey) {
        try (Transaction ignored = this.db.beginTx();){
            int n = this.readOps().propertyKeyGetForName(propertyKey);
            return n;
        }
    }

    protected ReadOperations readOps() {
        DependencyResolver dependencyResolver = this.db.getDependencyResolver();
        Statement statement = ((ThreadToStatementContextBridge)dependencyResolver.resolveDependency(ThreadToStatementContextBridge.class)).get();
        return statement.readOperations();
    }
}

