/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.api.store;

import junit.framework.Assert;
import junit.framework.TestCase;
import org.junit.Test;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.graphdb.Label;
import org.neo4j.graphdb.RelationshipType;
import org.neo4j.graphdb.Transaction;
import org.neo4j.helpers.collection.MapUtil;
import org.neo4j.kernel.impl.api.store.DiskLayerTest;

public class DiskLayerNodeAndRelTest
extends DiskLayerTest {
    @Test
    public void shouldTellIfNodeExists() throws Exception {
        long created = DiskLayerNodeAndRelTest.createLabeledNode((GraphDatabaseService)this.db, MapUtil.map((Object[])new Object[0]), new Label[0]).getId();
        long createdAndRemoved = DiskLayerNodeAndRelTest.createLabeledNode((GraphDatabaseService)this.db, MapUtil.map((Object[])new Object[0]), new Label[0]).getId();
        long neverExisted = createdAndRemoved + 99L;
        try (Transaction tx = this.db.beginTx();){
            this.db.getNodeById(createdAndRemoved).delete();
            tx.success();
        }
        TestCase.assertTrue((boolean)this.nodeExists(created));
        Assert.assertFalse((boolean)this.nodeExists(createdAndRemoved));
        Assert.assertFalse((boolean)this.nodeExists(neverExisted));
    }

    @Test
    public void shouldTellIfRelExists() throws Exception {
        long createdAndRemoved;
        long created;
        long node = DiskLayerNodeAndRelTest.createLabeledNode((GraphDatabaseService)this.db, MapUtil.map((Object[])new Object[0]), new Label[0]).getId();
        try (Transaction tx = this.db.beginTx();){
            created = this.db.createNode().createRelationshipTo(this.db.createNode(), RelationshipType.withName((String)"Banana")).getId();
            createdAndRemoved = this.db.createNode().createRelationshipTo(this.db.createNode(), RelationshipType.withName((String)"Banana")).getId();
            tx.success();
        }
        tx = this.db.beginTx();
        var10_3 = null;
        try {
            this.db.getRelationshipById(createdAndRemoved).delete();
            tx.success();
        }
        catch (Throwable throwable) {
            var10_3 = throwable;
            throw throwable;
        }
        finally {
            if (tx != null) {
                if (var10_3 != null) {
                    try {
                        tx.close();
                    }
                    catch (Throwable throwable) {
                        var10_3.addSuppressed(throwable);
                    }
                } else {
                    tx.close();
                }
            }
        }
        long neverExisted = created + 99L;
        TestCase.assertTrue((boolean)this.relationshipExists(node));
        Assert.assertFalse((boolean)this.relationshipExists(createdAndRemoved));
        Assert.assertFalse((boolean)this.relationshipExists(neverExisted));
    }

    /*
     * Exception decompiling
     */
    private boolean nodeExists(long id) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Exception decompiling
     */
    private boolean relationshipExists(long id) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }
}

