/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.api.state;

import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.graphdb.Label;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.PropertyContainer;
import org.neo4j.graphdb.Transaction;
import org.neo4j.graphdb.index.Index;
import org.neo4j.helpers.collection.MapUtil;
import org.neo4j.kernel.impl.transaction.log.TransactionIdStore;
import org.neo4j.kernel.internal.GraphDatabaseAPI;
import org.neo4j.test.DatabaseRule;
import org.neo4j.test.ImpermanentDatabaseRule;
import org.neo4j.test.TestLabels;

public class NoChangeWriteTransactionTest {
    @Rule
    public final DatabaseRule dbr = new ImpermanentDatabaseRule();

    @Test
    public void shouldIdentifyTransactionWithNetZeroChangesAsReadOnly() throws Exception {
        GraphDatabaseAPI db = this.dbr.getGraphDatabaseAPI();
        TransactionIdStore txIdStore = (TransactionIdStore)db.getDependencyResolver().resolveDependency(TransactionIdStore.class);
        long startTxId = txIdStore.getLastCommittedTransactionId();
        Node node = this.createEmptyNode((GraphDatabaseService)db);
        try (Transaction tx = db.beginTx();){
            node.addLabel((Label)TestLabels.LABEL_ONE);
            node.removeLabel((Label)TestLabels.LABEL_ONE);
            tx.success();
        }
        Assert.assertEquals((String)"Expected last txId to be what it started at + 2 (1 for the empty node, and one for the label)", (long)(startTxId + 2L), (long)txIdStore.getLastCommittedTransactionId());
    }

    @Test
    public void shouldDetectNoChangesInCommitsAlsoForTheIndexes() throws Exception {
        GraphDatabaseAPI db = this.dbr.getGraphDatabaseAPI();
        TransactionIdStore txIdStore = (TransactionIdStore)db.getDependencyResolver().resolveDependency(TransactionIdStore.class);
        long startTxId = txIdStore.getLastCommittedTransactionId();
        Node node = this.createEmptyNode((GraphDatabaseService)db);
        Index<Node> index = this.createNodeIndex(db);
        try (Transaction tx = db.beginTx();){
            node.addLabel((Label)TestLabels.LABEL_ONE);
            node.removeLabel((Label)TestLabels.LABEL_ONE);
            index.add((PropertyContainer)node, "key", (Object)"value");
            index.remove((PropertyContainer)node, "key", (Object)"value");
            tx.success();
        }
        Assert.assertEquals((String)"Expected last txId to be what it started at + 3 (1 for the empty node, 1 for index, and one for the label)", (long)(startTxId + 3L), (long)txIdStore.getLastCommittedTransactionId());
    }

    private Index<Node> createNodeIndex(GraphDatabaseAPI db) {
        try (Transaction tx = db.beginTx();){
            Index index = db.index().forNodes("test", MapUtil.stringMap((String[])new String[]{"provider", "test-dummy-neo-index"}));
            tx.success();
            Index index2 = index;
            return index2;
        }
    }

    private Node createEmptyNode(GraphDatabaseService db) {
        try (Transaction tx = db.beginTx();){
            Node node = db.createNode();
            tx.success();
            Node node2 = node;
            return node2;
        }
    }
}

