/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.api.state;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import java.util.function.Function;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.Matchers;
import org.mockito.Mockito;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.Relationship;
import org.neo4j.kernel.impl.api.state.LegacyIndexTransactionStateImpl;
import org.neo4j.kernel.impl.index.IndexCommand;
import org.neo4j.kernel.impl.index.IndexConfigStore;
import org.neo4j.kernel.impl.index.IndexDefineCommand;
import org.neo4j.kernel.impl.index.IndexEntityType;
import org.neo4j.kernel.impl.transaction.command.Command;
import org.neo4j.kernel.spi.legacyindex.IndexImplementation;
import org.neo4j.storageengine.api.StorageCommand;

public class LegacyIndexTransactionStateImplTest {
    @Test
    public void tracksNodeCommands() {
        LegacyIndexTransactionStateImpl state = LegacyIndexTransactionStateImplTest.newLegacyIndexTxState();
        state.addNode("index1", 1L, "key1", (Object)"value1");
        state.removeNode("index1", 1L, "key2", (Object)"value2");
        state.addNode("index1", 2L, "key1", (Object)"value3");
        state.addNode("index1", 3L, "key2", (Object)"value4");
        state.removeNode("index2", 4L, "key1", (Object)"value5");
        IndexDefineCommand indexDefinedCommand = new IndexDefineCommand();
        indexDefinedCommand.getOrAssignIndexNameId("index1");
        indexDefinedCommand.getOrAssignIndexNameId("index2");
        indexDefinedCommand.getOrAssignKeyId("key1");
        indexDefinedCommand.getOrAssignKeyId("key2");
        HashSet<Command> expectedCommands = new HashSet<Command>(Arrays.asList(indexDefinedCommand, LegacyIndexTransactionStateImplTest.addNode(1, 1L, 1, "value1"), LegacyIndexTransactionStateImplTest.removeNode(1, 1L, 2, "value2"), LegacyIndexTransactionStateImplTest.addNode(1, 2L, 1, "value3"), LegacyIndexTransactionStateImplTest.addNode(1, 3L, 2, "value4"), LegacyIndexTransactionStateImplTest.removeNode(2, 4L, 1, "value5")));
        Assert.assertEquals(expectedCommands, LegacyIndexTransactionStateImplTest.extractCommands(state));
    }

    @Test
    public void tracksRelationshipCommands() {
        LegacyIndexTransactionStateImpl state = LegacyIndexTransactionStateImplTest.newLegacyIndexTxState();
        state.removeRelationship("index1", 1L, "key1", (Object)"value1");
        state.addRelationship("index1", 1L, "key2", (Object)"value2", 11L, 11L);
        state.removeRelationship("index1", 2L, "key1", (Object)"value3");
        state.addRelationship("index1", 3L, "key2", (Object)"value4", 22L, 22L);
        state.addRelationship("index2", 4L, "key1", (Object)"value5", 33L, 33L);
        IndexDefineCommand indexDefinedCommand = new IndexDefineCommand();
        indexDefinedCommand.getOrAssignIndexNameId("index1");
        indexDefinedCommand.getOrAssignIndexNameId("index2");
        indexDefinedCommand.getOrAssignKeyId("key1");
        indexDefinedCommand.getOrAssignKeyId("key2");
        HashSet<Command> expectedCommands = new HashSet<Command>(Arrays.asList(indexDefinedCommand, LegacyIndexTransactionStateImplTest.removeRelationship(1, 1L, 1, "value1"), LegacyIndexTransactionStateImplTest.addRelationship(1, 1L, 2, "value2", 11L, 11L), LegacyIndexTransactionStateImplTest.removeRelationship(1, 2L, 1, "value3"), LegacyIndexTransactionStateImplTest.addRelationship(1, 3L, 2, "value4", 22L, 22L), LegacyIndexTransactionStateImplTest.addRelationship(2, 4L, 1, "value5", 33L, 33L)));
        Assert.assertEquals(expectedCommands, LegacyIndexTransactionStateImplTest.extractCommands(state));
    }

    @Test
    public void nodeIndexDeletionRemovesCommands() {
        LegacyIndexTransactionStateImpl state = LegacyIndexTransactionStateImplTest.newLegacyIndexTxState();
        state.addNode("index", 1L, "key", (Object)"value1");
        state.addNode("index", 2L, "key", (Object)"value2");
        state.removeNode("index", 3L, "key", (Object)"value3");
        state.deleteIndex(IndexEntityType.Node, "index");
        IndexDefineCommand indexDefinedCommand = new IndexDefineCommand();
        indexDefinedCommand.getOrAssignIndexNameId("index");
        indexDefinedCommand.getOrAssignKeyId("key");
        IndexCommand.DeleteCommand delete = new IndexCommand.DeleteCommand();
        delete.init(1, IndexEntityType.Node.id());
        HashSet<Command> expectedCommands = new HashSet<Command>(Arrays.asList(indexDefinedCommand, delete));
        Assert.assertEquals(expectedCommands, LegacyIndexTransactionStateImplTest.extractCommands(state));
    }

    @Test
    public void relationshipIndexDeletionRemovesCommands() {
        LegacyIndexTransactionStateImpl state = LegacyIndexTransactionStateImplTest.newLegacyIndexTxState();
        state.removeRelationship("index", 1L, "key", (Object)"value1");
        state.addRelationship("index", 2L, "key", (Object)"value2", 11L, 11L);
        state.addRelationship("index", 3L, "key", (Object)"value3", 22L, 22L);
        state.deleteIndex(IndexEntityType.Relationship, "index");
        IndexDefineCommand indexDefinedCommand = new IndexDefineCommand();
        indexDefinedCommand.getOrAssignIndexNameId("index");
        indexDefinedCommand.getOrAssignKeyId("key");
        IndexCommand.DeleteCommand delete = new IndexCommand.DeleteCommand();
        delete.init(1, IndexEntityType.Relationship.id());
        HashSet<Command> expectedCommands = new HashSet<Command>(Arrays.asList(indexDefinedCommand, delete));
        Assert.assertEquals(expectedCommands, LegacyIndexTransactionStateImplTest.extractCommands(state));
    }

    @Test
    public void removalOfNodeIndexDoesNotClearRelationshipCommandsForRelationshipIndexWithSameName() {
        LegacyIndexTransactionStateImpl state = LegacyIndexTransactionStateImplTest.newLegacyIndexTxState();
        state.addNode("index", 1L, "key", (Object)"value");
        state.addRelationship("index", 1L, "key", (Object)"value", 11L, 11L);
        state.deleteIndex(IndexEntityType.Node, "index");
        IndexDefineCommand indexDefinedCommand = new IndexDefineCommand();
        indexDefinedCommand.getOrAssignIndexNameId("index");
        indexDefinedCommand.getOrAssignKeyId("key");
        IndexCommand.DeleteCommand delete = new IndexCommand.DeleteCommand();
        delete.init(1, IndexEntityType.Node.id());
        HashSet<Command> expectedCommands = new HashSet<Command>(Arrays.asList(indexDefinedCommand, delete, LegacyIndexTransactionStateImplTest.addRelationship(1, 1L, 1, "value", 11L, 11L)));
        Assert.assertEquals(expectedCommands, LegacyIndexTransactionStateImplTest.extractCommands(state));
    }

    @Test
    public void removalOfRelationshipIndexDoesNotClearNodeCommandsForNodeIndexWithSameName() {
        LegacyIndexTransactionStateImpl state = LegacyIndexTransactionStateImplTest.newLegacyIndexTxState();
        state.addNode("index", 1L, "key", (Object)"value");
        state.addRelationship("index", 1L, "key", (Object)"value", 11L, 11L);
        state.deleteIndex(IndexEntityType.Relationship, "index");
        IndexDefineCommand indexDefinedCommand = new IndexDefineCommand();
        indexDefinedCommand.getOrAssignIndexNameId("index");
        indexDefinedCommand.getOrAssignKeyId("key");
        IndexCommand.DeleteCommand delete = new IndexCommand.DeleteCommand();
        delete.init(1, IndexEntityType.Relationship.id());
        HashSet<Command> expectedCommands = new HashSet<Command>(Arrays.asList(indexDefinedCommand, delete, LegacyIndexTransactionStateImplTest.addNode(1, 1L, 1, "value")));
        Assert.assertEquals(expectedCommands, LegacyIndexTransactionStateImplTest.extractCommands(state));
    }

    private static Set<StorageCommand> extractCommands(LegacyIndexTransactionStateImpl state) {
        HashSet<StorageCommand> commands = new HashSet<StorageCommand>();
        state.extractCommands(commands);
        return commands;
    }

    private static Command addNode(int index, long id, int key, Object value) {
        IndexCommand.AddNodeCommand command = new IndexCommand.AddNodeCommand();
        command.init(index, id, key, value);
        return command;
    }

    private static Command addRelationship(int index, long id, int key, Object value, long startNode, long endNode) {
        IndexCommand.AddRelationshipCommand command = new IndexCommand.AddRelationshipCommand();
        command.init(index, id, key, value, startNode, endNode);
        return command;
    }

    private static Command removeNode(int index, long id, int key, Object value) {
        IndexCommand.RemoveCommand command = new IndexCommand.RemoveCommand();
        command.init(index, IndexEntityType.Node.id(), id, key, value);
        return command;
    }

    private static Command removeRelationship(int index, long id, int key, Object value) {
        IndexCommand.RemoveCommand command = new IndexCommand.RemoveCommand();
        command.init(index, IndexEntityType.Relationship.id(), id, key, value);
        return command;
    }

    private static LegacyIndexTransactionStateImpl newLegacyIndexTxState() {
        IndexConfigStore indexConfigStore = (IndexConfigStore)Mockito.mock(IndexConfigStore.class);
        Mockito.when((Object)indexConfigStore.get((Class)Matchers.eq(Node.class), Matchers.anyString())).thenReturn(Collections.singletonMap("provider", "test"));
        Mockito.when((Object)indexConfigStore.get((Class)Matchers.eq(Relationship.class), Matchers.anyString())).thenReturn(Collections.singletonMap("provider", "test"));
        Function<String, IndexImplementation> providerLookup = s -> (IndexImplementation)Mockito.mock(IndexImplementation.class);
        return new LegacyIndexTransactionStateImpl(indexConfigStore, providerLookup);
    }
}

