/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.api.state;

import java.util.Arrays;
import java.util.Collections;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Mockito;
import org.neo4j.collection.primitive.PrimitiveLongCollections;
import org.neo4j.collection.primitive.PrimitiveLongIterator;
import org.neo4j.collection.primitive.PrimitiveLongResourceIterator;
import org.neo4j.cursor.Cursor;
import org.neo4j.graphdb.Neo4jMockitoHelpers;
import org.neo4j.graphdb.Resource;
import org.neo4j.helpers.collection.Iterators;
import org.neo4j.kernel.api.index.IndexDescriptor;
import org.neo4j.kernel.api.index.InternalIndexState;
import org.neo4j.kernel.api.legacyindex.AutoIndexing;
import org.neo4j.kernel.api.properties.DefinedProperty;
import org.neo4j.kernel.api.properties.Property;
import org.neo4j.kernel.api.txstate.TransactionState;
import org.neo4j.kernel.configuration.Config;
import org.neo4j.kernel.impl.api.ConstraintEnforcingEntityOperations;
import org.neo4j.kernel.impl.api.KernelStatement;
import org.neo4j.kernel.impl.api.StateHandlingStatementOperations;
import org.neo4j.kernel.impl.api.StatementOperationsTestHelper;
import org.neo4j.kernel.impl.api.legacyindex.InternalAutoIndexing;
import org.neo4j.kernel.impl.api.operations.EntityOperations;
import org.neo4j.kernel.impl.api.operations.EntityReadOperations;
import org.neo4j.kernel.impl.api.operations.EntityWriteOperations;
import org.neo4j.kernel.impl.api.operations.SchemaReadOperations;
import org.neo4j.kernel.impl.api.operations.SchemaWriteOperations;
import org.neo4j.kernel.impl.api.state.ConstraintIndexCreator;
import org.neo4j.kernel.impl.api.state.StubCursors;
import org.neo4j.kernel.impl.api.state.TxState;
import org.neo4j.kernel.impl.api.store.StoreStatement;
import org.neo4j.kernel.impl.constraints.ConstraintSemantics;
import org.neo4j.kernel.impl.constraints.StandardConstraintSemantics;
import org.neo4j.kernel.impl.index.LegacyIndexStore;
import org.neo4j.kernel.impl.util.Cursors;
import org.neo4j.storageengine.api.LabelItem;
import org.neo4j.storageengine.api.StoreReadLayer;
import org.neo4j.storageengine.api.schema.IndexReader;

public class IndexQueryTransactionStateTest {
    int labelId = 2;
    int propertyKeyId = 3;
    String value = "My Value";
    IndexDescriptor indexDescriptor = new IndexDescriptor(this.labelId, this.propertyKeyId);
    private StoreReadLayer store;
    private StoreStatement statement;
    private EntityOperations txContext;
    private KernelStatement state;
    private IndexReader indexReader;

    @Before
    public void before() throws Exception {
        TxState txState = new TxState();
        this.state = StatementOperationsTestHelper.mockedState((TransactionState)txState);
        int labelId1 = 10;
        int labelId2 = 12;
        this.store = (StoreReadLayer)Mockito.mock(StoreReadLayer.class);
        Mockito.when((Object)this.store.indexGetState(this.indexDescriptor)).thenReturn((Object)InternalIndexState.ONLINE);
        Mockito.when((Object)this.store.indexesGetForLabel(labelId1)).then(Neo4jMockitoHelpers.answerAsIteratorFrom(Collections.emptyList()));
        Mockito.when((Object)this.store.indexesGetForLabel(labelId2)).then(Neo4jMockitoHelpers.answerAsIteratorFrom(Collections.emptyList()));
        Mockito.when((Object)this.store.indexesGetAll()).then(Neo4jMockitoHelpers.answerAsIteratorFrom(Collections.emptyList()));
        Mockito.when((Object)this.store.constraintsGetForLabel(this.labelId)).thenReturn(Collections.emptyIterator());
        Mockito.when((Object)this.store.indexGetForLabelAndPropertyKey(this.labelId, this.propertyKeyId)).thenReturn((Object)new IndexDescriptor(this.labelId, this.propertyKeyId));
        this.statement = (StoreStatement)Mockito.mock(StoreStatement.class);
        Mockito.when((Object)this.state.getStoreStatement()).thenReturn((Object)this.statement);
        this.indexReader = (IndexReader)Mockito.mock(IndexReader.class);
        Mockito.when((Object)this.statement.getIndexReader(this.indexDescriptor)).thenReturn((Object)this.indexReader);
        Mockito.when((Object)this.statement.getFreshIndexReader(this.indexDescriptor)).thenReturn((Object)this.indexReader);
        StateHandlingStatementOperations stateHandlingOperations = new StateHandlingStatementOperations(this.store, (AutoIndexing)new InternalAutoIndexing(Config.empty(), null), (ConstraintIndexCreator)Mockito.mock(ConstraintIndexCreator.class), (LegacyIndexStore)Mockito.mock(LegacyIndexStore.class));
        this.txContext = new ConstraintEnforcingEntityOperations((ConstraintSemantics)new StandardConstraintSemantics(), (EntityWriteOperations)stateHandlingOperations, (EntityReadOperations)stateHandlingOperations, (SchemaWriteOperations)stateHandlingOperations, (SchemaReadOperations)stateHandlingOperations);
    }

    @Test
    public void shouldExcludeRemovedNodesFromIndexQuery() throws Exception {
        long nodeId = 2L;
        Mockito.when((Object)this.indexReader.seek((Object)this.value)).then(Neo4jMockitoHelpers.answerAsPrimitiveLongIteratorFrom(Arrays.asList(1L, nodeId, 3L)));
        Mockito.when((Object)this.statement.acquireSingleNodeCursor(nodeId)).thenReturn(StubCursors.asNodeCursor(nodeId));
        this.txContext.nodeDelete(this.state, nodeId);
        PrimitiveLongIterator result = this.txContext.nodesGetFromIndexSeek(this.state, this.indexDescriptor, (Object)this.value);
        Assert.assertThat((Object)PrimitiveLongCollections.toSet((PrimitiveLongIterator)result), (Matcher)Matchers.equalTo((Object)Iterators.asSet((Object[])new Long[]{1L, 3L})));
    }

    @Test
    public void shouldExcludeRemovedNodeFromUniqueIndexQuery() throws Exception {
        long nodeId = 1L;
        Mockito.when((Object)this.indexReader.seek((Object)this.value)).thenReturn((Object)IndexQueryTransactionStateTest.asPrimitiveResourceIterator(nodeId));
        Mockito.when((Object)this.statement.acquireSingleNodeCursor(nodeId)).thenReturn(StubCursors.asNodeCursor(nodeId));
        this.txContext.nodeDelete(this.state, nodeId);
        long result = this.txContext.nodeGetFromUniqueIndexSeek(this.state, this.indexDescriptor, (Object)this.value);
        this.assertNoSuchNode(result);
    }

    @Test
    public void shouldExcludeChangedNodesWithMissingLabelFromIndexQuery() throws Exception {
        Mockito.when((Object)this.indexReader.seek((Object)this.value)).then(Neo4jMockitoHelpers.answerAsPrimitiveLongIteratorFrom(Arrays.asList(2L, 3L)));
        this.state.txState().nodeDoReplaceProperty(1L, Property.noNodeProperty((long)1L, (int)this.propertyKeyId), Property.intProperty((int)this.propertyKeyId, (int)10));
        PrimitiveLongIterator result = this.txContext.nodesGetFromIndexSeek(this.state, this.indexDescriptor, (Object)this.value);
        Assert.assertThat((Object)PrimitiveLongCollections.toSet((PrimitiveLongIterator)result), (Matcher)Matchers.equalTo((Object)Iterators.asSet((Object[])new Long[]{2L, 3L})));
    }

    @Test
    public void shouldExcludeChangedNodeWithMissingLabelFromUniqueIndexQuery() throws Exception {
        Mockito.when((Object)this.indexReader.seek((Object)this.value)).thenReturn((Object)IndexQueryTransactionStateTest.asPrimitiveResourceIterator(new long[0]));
        this.state.txState().nodeDoReplaceProperty(1L, Property.noNodeProperty((long)1L, (int)this.propertyKeyId), Property.intProperty((int)this.propertyKeyId, (int)10));
        long result = this.txContext.nodeGetFromUniqueIndexSeek(this.state, this.indexDescriptor, (Object)this.value);
        this.assertNoSuchNode(result);
    }

    @Test
    public void shouldIncludeCreatedNodesWithCorrectLabelAndProperty() throws Exception {
        Mockito.when((Object)this.indexReader.seek((Object)this.value)).then(Neo4jMockitoHelpers.answerAsPrimitiveLongIteratorFrom(Arrays.asList(2L, 3L)));
        long nodeId = 1L;
        this.state.txState().nodeDoReplaceProperty(nodeId, Property.noNodeProperty((long)nodeId, (int)this.propertyKeyId), Property.stringProperty((int)this.propertyKeyId, (String)this.value));
        Mockito.when((Object)this.statement.acquireSingleNodeCursor(nodeId)).thenReturn(StubCursors.asNodeCursor(nodeId, StubCursors.asPropertyCursor(Property.stringProperty((int)this.propertyKeyId, (String)this.value)), (Cursor<LabelItem>)Cursors.empty()));
        this.txContext.nodeAddLabel(this.state, nodeId, this.labelId);
        PrimitiveLongIterator result = this.txContext.nodesGetFromIndexSeek(this.state, this.indexDescriptor, (Object)this.value);
        Assert.assertThat((Object)PrimitiveLongCollections.toSet((PrimitiveLongIterator)result), (Matcher)Matchers.equalTo((Object)Iterators.asSet((Object[])new Long[]{nodeId, 2L, 3L})));
    }

    @Test
    public void shouldIncludeUniqueCreatedNodeWithCorrectLabelAndProperty() throws Exception {
        Mockito.when((Object)this.indexReader.seek((Object)this.value)).thenReturn((Object)IndexQueryTransactionStateTest.asPrimitiveResourceIterator(new long[0]));
        long nodeId = 1L;
        this.state.txState().nodeDoReplaceProperty(nodeId, Property.noNodeProperty((long)nodeId, (int)this.propertyKeyId), Property.stringProperty((int)this.propertyKeyId, (String)this.value));
        Mockito.when((Object)this.statement.acquireSingleNodeCursor(nodeId)).thenReturn(StubCursors.asNodeCursor(nodeId, StubCursors.asPropertyCursor(Property.stringProperty((int)this.propertyKeyId, (String)this.value)), (Cursor<LabelItem>)Cursors.empty()));
        this.txContext.nodeAddLabel(this.state, nodeId, this.labelId);
        long result = this.txContext.nodeGetFromUniqueIndexSeek(this.state, this.indexDescriptor, (Object)this.value);
        Assert.assertThat((Object)result, (Matcher)Matchers.equalTo((Object)nodeId));
    }

    @Test
    public void shouldIncludeExistingNodesWithCorrectPropertyAfterAddingLabel() throws Exception {
        Mockito.when((Object)this.indexReader.seek((Object)this.value)).then(Neo4jMockitoHelpers.answerAsPrimitiveLongIteratorFrom(Arrays.asList(2L, 3L)));
        long nodeId = 1L;
        Mockito.when((Object)this.statement.acquireSingleNodeCursor(nodeId)).thenReturn(StubCursors.asNodeCursor(nodeId, StubCursors.asPropertyCursor(Property.stringProperty((int)this.propertyKeyId, (String)this.value)), StubCursors.asLabelCursor(new Integer[0])));
        this.txContext.nodeAddLabel(this.state, nodeId, this.labelId);
        PrimitiveLongIterator result = this.txContext.nodesGetFromIndexSeek(this.state, this.indexDescriptor, (Object)this.value);
        Assert.assertThat((Object)PrimitiveLongCollections.toSet((PrimitiveLongIterator)result), (Matcher)Matchers.equalTo((Object)Iterators.asSet((Object[])new Long[]{nodeId, 2L, 3L})));
    }

    @Test
    public void shouldIncludeExistingUniqueNodeWithCorrectPropertyAfterAddingLabel() throws Exception {
        Mockito.when((Object)this.indexReader.seek((Object)this.value)).thenReturn((Object)IndexQueryTransactionStateTest.asPrimitiveResourceIterator(new long[0]));
        long nodeId = 2L;
        Mockito.when((Object)this.statement.acquireSingleNodeCursor(nodeId)).thenReturn(StubCursors.asNodeCursor(nodeId, StubCursors.asPropertyCursor(Property.stringProperty((int)this.propertyKeyId, (String)this.value)), StubCursors.asLabelCursor(new Integer[0])));
        this.txContext.nodeAddLabel(this.state, nodeId, this.labelId);
        long result = this.txContext.nodeGetFromUniqueIndexSeek(this.state, this.indexDescriptor, (Object)this.value);
        Assert.assertThat((Object)result, (Matcher)Matchers.equalTo((Object)nodeId));
    }

    @Test
    public void shouldExcludeExistingNodesWithCorrectPropertyAfterRemovingLabel() throws Exception {
        long nodeId = 1L;
        Mockito.when((Object)this.indexReader.seek((Object)this.value)).then(Neo4jMockitoHelpers.answerAsPrimitiveLongIteratorFrom(Arrays.asList(nodeId, 2L, 3L)));
        Mockito.when((Object)this.statement.acquireSingleNodeCursor(nodeId)).thenReturn(StubCursors.asNodeCursor(nodeId, StubCursors.asPropertyCursor(Property.stringProperty((int)this.propertyKeyId, (String)this.value)), StubCursors.asLabelCursor(this.labelId)));
        this.txContext.nodeRemoveLabel(this.state, nodeId, this.labelId);
        PrimitiveLongIterator result = this.txContext.nodesGetFromIndexSeek(this.state, this.indexDescriptor, (Object)this.value);
        Assert.assertThat((Object)PrimitiveLongCollections.toSet((PrimitiveLongIterator)result), (Matcher)Matchers.equalTo((Object)Iterators.asSet((Object[])new Long[]{2L, 3L})));
    }

    @Test
    public void shouldExcludeExistingUniqueNodeWithCorrectPropertyAfterRemovingLabel() throws Exception {
        long nodeId = 1L;
        Mockito.when((Object)this.indexReader.seek((Object)this.value)).thenReturn((Object)IndexQueryTransactionStateTest.asPrimitiveResourceIterator(nodeId));
        Mockito.when((Object)this.statement.acquireSingleNodeCursor(nodeId)).thenReturn(StubCursors.asNodeCursor(nodeId, StubCursors.asPropertyCursor(Property.stringProperty((int)this.propertyKeyId, (String)this.value)), StubCursors.asLabelCursor(this.labelId)));
        this.txContext.nodeRemoveLabel(this.state, nodeId, this.labelId);
        long result = this.txContext.nodeGetFromUniqueIndexSeek(this.state, this.indexDescriptor, (Object)this.value);
        this.assertNoSuchNode(result);
    }

    @Test
    public void shouldExcludeNodesWithRemovedProperty() throws Exception {
        Mockito.when((Object)this.indexReader.seek((Object)this.value)).then(Neo4jMockitoHelpers.answerAsPrimitiveLongIteratorFrom(Arrays.asList(2L, 3L)));
        long nodeId = 1L;
        this.state.txState().nodeDoReplaceProperty(nodeId, Property.noNodeProperty((long)nodeId, (int)this.propertyKeyId), Property.intProperty((int)this.propertyKeyId, (int)10));
        Mockito.when((Object)this.statement.acquireSingleNodeCursor(nodeId)).thenReturn(StubCursors.asNodeCursor(nodeId, StubCursors.asPropertyCursor(new DefinedProperty[0]), StubCursors.asLabelCursor(this.labelId)));
        this.txContext.nodeAddLabel(this.state, nodeId, this.labelId);
        PrimitiveLongIterator result = this.txContext.nodesGetFromIndexSeek(this.state, this.indexDescriptor, (Object)this.value);
        Assert.assertThat((Object)PrimitiveLongCollections.toSet((PrimitiveLongIterator)result), (Matcher)Matchers.equalTo((Object)Iterators.asSet((Object[])new Long[]{2L, 3L})));
    }

    @Test
    public void shouldExcludeUniqueNodeWithRemovedProperty() throws Exception {
        long nodeId = 1L;
        Mockito.when((Object)this.indexReader.seek((Object)this.value)).thenReturn((Object)IndexQueryTransactionStateTest.asPrimitiveResourceIterator(nodeId));
        Mockito.when((Object)this.statement.acquireSingleNodeCursor(nodeId)).thenReturn(StubCursors.asNodeCursor(nodeId, StubCursors.asPropertyCursor(Property.stringProperty((int)this.propertyKeyId, (String)this.value)), StubCursors.asLabelCursor(this.labelId)));
        this.txContext.nodeRemoveProperty(this.state, nodeId, this.propertyKeyId);
        long result = this.txContext.nodeGetFromUniqueIndexSeek(this.state, this.indexDescriptor, (Object)this.value);
        this.assertNoSuchNode(result);
    }

    private void assertNoSuchNode(long node) {
        Assert.assertThat((Object)node, (Matcher)Matchers.equalTo((Object)-1L));
    }

    private static PrimitiveLongResourceIterator asPrimitiveResourceIterator(long ... values) {
        return PrimitiveLongCollections.resourceIterator((PrimitiveLongIterator)PrimitiveLongCollections.iterator((long[])values), (Resource)new Resource(){

            public void close() {
            }
        });
    }
}

