/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.api.integrationtest;

import java.util.concurrent.Future;
import java.util.function.Function;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.neo4j.graphdb.ConstraintViolationException;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.graphdb.Label;
import org.neo4j.graphdb.Transaction;
import org.neo4j.test.DatabaseRule;
import org.neo4j.test.ImpermanentDatabaseRule;
import org.neo4j.test.OtherThreadExecutor;
import org.neo4j.test.OtherThreadRule;

public class UniquenessConstraintValidationConcurrencyIT {
    @Rule
    public final DatabaseRule database = new ImpermanentDatabaseRule();
    @Rule
    public final OtherThreadRule<Void> otherThread = new OtherThreadRule();

    @Test
    public void shouldAllowConcurrentCreationOfNonConflictingData() throws Exception {
        this.database.executeAndCommit(UniquenessConstraintValidationConcurrencyIT.createUniquenessConstraint("Label1", "key1"));
        Future created = this.database.executeAndCommit(db -> {
            db.createNode(new Label[]{Label.label((String)"Label1")}).setProperty("key1", (Object)"value1");
            return this.otherThread.execute(UniquenessConstraintValidationConcurrencyIT.createNode(db, "Label1", "key1", "value2"));
        });
        Assert.assertTrue((String)"Node creation should succeed", (boolean)((Boolean)created.get()));
    }

    @Test
    public void shouldPreventConcurrentCreationOfConflictingData() throws Exception {
        this.database.executeAndCommit(UniquenessConstraintValidationConcurrencyIT.createUniquenessConstraint("Label1", "key1"));
        Future created = this.database.executeAndCommit(db -> {
            db.createNode(new Label[]{Label.label((String)"Label1")}).setProperty("key1", (Object)"value1");
            try {
                Future<Boolean> future = this.otherThread.execute(UniquenessConstraintValidationConcurrencyIT.createNode(db, "Label1", "key1", "value1"));
                return future;
            }
            finally {
                Assert.assertThat(this.otherThread, OtherThreadRule.isWaiting());
            }
        });
        Assert.assertFalse((String)"node creation should fail", (boolean)((Boolean)created.get()));
    }

    @Test
    public void shouldAllowOtherTransactionToCompleteIfFirstTransactionRollsBack() throws Exception {
        this.database.executeAndCommit(UniquenessConstraintValidationConcurrencyIT.createUniquenessConstraint("Label1", "key1"));
        Future created = this.database.executeAndRollback(db -> {
            db.createNode(new Label[]{Label.label((String)"Label1")}).setProperty("key1", (Object)"value1");
            try {
                Future<Boolean> future = this.otherThread.execute(UniquenessConstraintValidationConcurrencyIT.createNode(db, "Label1", "key1", "value1"));
                return future;
            }
            finally {
                Assert.assertThat(this.otherThread, OtherThreadRule.isWaiting());
            }
        });
        Assert.assertTrue((String)"Node creation should succeed", (boolean)((Boolean)created.get()));
    }

    private static Function<GraphDatabaseService, Void> createUniquenessConstraint(String label, String propertyKey) {
        return db -> {
            db.schema().constraintFor(Label.label((String)label)).assertPropertyIsUnique(propertyKey).create();
            return null;
        };
    }

    public static OtherThreadExecutor.WorkerCommand<Void, Boolean> createNode(GraphDatabaseService db, String label, String propertyKey, Object propertyValue) {
        return nothing -> {
            try (Transaction tx = db.beginTx();){
                db.createNode(new Label[]{Label.label((String)label)}).setProperty(propertyKey, propertyValue);
                tx.success();
                Boolean bl = true;
                return bl;
            }
            catch (ConstraintViolationException e) {
                return false;
            }
        };
    }
}

