/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.api.integrationtest;

import java.util.List;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.hamcrest.core.IsCollectionContaining;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;
import org.neo4j.collection.RawIterator;
import org.neo4j.helpers.collection.Iterables;
import org.neo4j.helpers.collection.Iterators;
import org.neo4j.kernel.api.KernelTransaction;
import org.neo4j.kernel.api.exceptions.ProcedureException;
import org.neo4j.kernel.api.proc.CallableProcedure;
import org.neo4j.kernel.api.proc.Neo4jTypes;
import org.neo4j.kernel.api.proc.ProcedureSignature;
import org.neo4j.kernel.impl.api.integrationtest.KernelIntegrationTest;

public class ProceduresKernelIT
extends KernelIntegrationTest {
    @Rule
    public ExpectedException exception = ExpectedException.none();
    private final ProcedureSignature signature = ProcedureSignature.procedureSignature((String[])new String[]{"example", "exampleProc"}).in("name", (Neo4jTypes.AnyType)Neo4jTypes.NTString).out("name", (Neo4jTypes.AnyType)Neo4jTypes.NTString).build();
    private final CallableProcedure procedure = ProceduresKernelIT.procedure(this.signature);

    @Test
    public void shouldGetProcedureByName() throws Throwable {
        this.kernel.registerProcedure(this.procedure);
        ProcedureSignature found = this.readOperationsInNewTransaction().procedureGet(new ProcedureSignature.ProcedureName(new String[]{"example"}, "exampleProc"));
        MatcherAssert.assertThat((Object)found, (Matcher)CoreMatchers.equalTo((Object)this.signature));
    }

    @Test
    public void shouldGetBuiltInProcedureByName() throws Throwable {
        ProcedureSignature found = this.readOperationsInNewTransaction().procedureGet(ProcedureSignature.procedureName((String[])new String[]{"db", "labels"}));
        MatcherAssert.assertThat((Object)found, (Matcher)CoreMatchers.equalTo((Object)ProcedureSignature.procedureSignature((ProcedureSignature.ProcedureName)ProcedureSignature.procedureName((String[])new String[]{"db", "labels"})).out("label", (Neo4jTypes.AnyType)Neo4jTypes.NTString).build()));
    }

    @Test
    public void shouldGetAllProcedures() throws Throwable {
        this.kernel.registerProcedure(this.procedure);
        this.kernel.registerProcedure(ProceduresKernelIT.procedure(ProcedureSignature.procedureSignature((String[])new String[]{"example", "exampleProc2"}).build()));
        this.kernel.registerProcedure(ProceduresKernelIT.procedure(ProcedureSignature.procedureSignature((String[])new String[]{"example", "exampleProc3"}).build()));
        List signatures = Iterables.asList((Iterable)this.readOperationsInNewTransaction().proceduresGetAll());
        MatcherAssert.assertThat((Object)signatures, (Matcher)IsCollectionContaining.hasItems((Object[])new ProcedureSignature[]{this.procedure.signature(), ProcedureSignature.procedureSignature((String[])new String[]{"example", "exampleProc2"}).build(), ProcedureSignature.procedureSignature((String[])new String[]{"example", "exampleProc3"}).build()}));
    }

    @Test
    public void shouldCallReadOnlyProcedure() throws Throwable {
        this.kernel.registerProcedure(this.procedure);
        RawIterator found = this.readOperationsInNewTransaction().procedureCallRead(new ProcedureSignature.ProcedureName(new String[]{"example"}, "exampleProc"), new Object[]{1337});
        MatcherAssert.assertThat((Object)Iterators.asList((RawIterator)found), (Matcher)Matchers.contains((Matcher)CoreMatchers.equalTo((Object)new Object[]{1337})));
    }

    @Test
    public void registeredProcedureShouldGetReadOperations() throws Throwable {
        this.kernel.registerProcedure((CallableProcedure)new CallableProcedure.BasicProcedure(this.signature){

            public RawIterator<Object[], ProcedureException> apply(CallableProcedure.Context ctx, Object[] input) throws ProcedureException {
                return RawIterator.of((Object[])new Object[][]{{((KernelTransaction)ctx.get(CallableProcedure.Context.KERNEL_TRANSACTION)).acquireStatement().readOperations()}});
            }
        });
        RawIterator stream = this.readOperationsInNewTransaction().procedureCallRead(this.signature.name(), new Object[]{""});
        Assert.assertNotNull((Object)((Object[])Iterators.asList((RawIterator)stream).get(0))[0]);
    }

    private static CallableProcedure procedure(ProcedureSignature signature) {
        return new CallableProcedure.BasicProcedure(signature){

            public RawIterator<Object[], ProcedureException> apply(CallableProcedure.Context ctx, Object[] input) {
                return RawIterator.of((Object[])new Object[][]{input});
            }
        };
    }
}

