/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.api.integrationtest;

import org.junit.After;
import org.junit.Before;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.graphdb.mockfs.EphemeralFileSystemAbstraction;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.kernel.api.DataWriteOperations;
import org.neo4j.kernel.api.KernelAPI;
import org.neo4j.kernel.api.KernelTransaction;
import org.neo4j.kernel.api.ReadOperations;
import org.neo4j.kernel.api.SchemaWriteOperations;
import org.neo4j.kernel.api.Statement;
import org.neo4j.kernel.api.TokenWriteOperations;
import org.neo4j.kernel.api.dbms.DbmsOperations;
import org.neo4j.kernel.api.exceptions.KernelException;
import org.neo4j.kernel.api.exceptions.TransactionFailureException;
import org.neo4j.kernel.api.security.AccessMode;
import org.neo4j.kernel.impl.api.index.IndexingService;
import org.neo4j.kernel.impl.core.ThreadToStatementContextBridge;
import org.neo4j.kernel.internal.GraphDatabaseAPI;
import org.neo4j.test.TestGraphDatabaseBuilder;
import org.neo4j.test.TestGraphDatabaseFactory;

public abstract class KernelIntegrationTest {
    protected GraphDatabaseAPI db;
    protected ThreadToStatementContextBridge statementContextSupplier;
    protected KernelAPI kernel;
    protected IndexingService indexingService;
    private KernelTransaction transaction;
    private Statement statement;
    private EphemeralFileSystemAbstraction fs;
    private DbmsOperations dbmsOperations;

    protected TokenWriteOperations tokenWriteOperationsInNewTransaction() throws KernelException {
        this.transaction = this.kernel.newTransaction(KernelTransaction.Type.implicit, (AccessMode)AccessMode.Static.WRITE);
        this.statement = this.transaction.acquireStatement();
        return this.statement.tokenWriteOperations();
    }

    protected DataWriteOperations dataWriteOperationsInNewTransaction() throws KernelException {
        this.transaction = this.kernel.newTransaction(KernelTransaction.Type.implicit, (AccessMode)AccessMode.Static.WRITE);
        this.statement = this.transaction.acquireStatement();
        return this.statement.dataWriteOperations();
    }

    protected SchemaWriteOperations schemaWriteOperationsInNewTransaction() throws KernelException {
        this.transaction = this.kernel.newTransaction(KernelTransaction.Type.implicit, (AccessMode)AccessMode.Static.FULL);
        this.statement = this.transaction.acquireStatement();
        return this.statement.schemaWriteOperations();
    }

    protected ReadOperations readOperationsInNewTransaction() throws TransactionFailureException {
        this.transaction = this.kernel.newTransaction(KernelTransaction.Type.implicit, (AccessMode)AccessMode.Static.READ);
        this.statement = this.transaction.acquireStatement();
        return this.statement.readOperations();
    }

    protected DbmsOperations dbmsOperations() {
        return this.dbmsOperations;
    }

    protected void commit() throws TransactionFailureException {
        this.statement.close();
        this.statement = null;
        this.transaction.success();
        try {
            this.transaction.close();
        }
        finally {
            this.transaction = null;
        }
    }

    protected void rollback() throws TransactionFailureException {
        this.statement.close();
        this.statement = null;
        this.transaction.failure();
        try {
            this.transaction.close();
        }
        finally {
            this.transaction = null;
        }
    }

    @Before
    public void setup() {
        this.fs = new EphemeralFileSystemAbstraction();
        this.startDb();
    }

    @After
    public void cleanup() throws Exception {
        this.stopDb();
        this.fs.shutdown();
    }

    protected void startDb() {
        this.db = (GraphDatabaseAPI)this.createGraphDatabase(this.fs);
        this.kernel = (KernelAPI)this.db.getDependencyResolver().resolveDependency(KernelAPI.class);
        this.indexingService = (IndexingService)this.db.getDependencyResolver().resolveDependency(IndexingService.class);
        this.statementContextSupplier = (ThreadToStatementContextBridge)this.db.getDependencyResolver().resolveDependency(ThreadToStatementContextBridge.class);
        this.dbmsOperations = (DbmsOperations)this.db.getDependencyResolver().resolveDependency(DbmsOperations.class);
    }

    protected GraphDatabaseService createGraphDatabase(EphemeralFileSystemAbstraction fs) {
        TestGraphDatabaseBuilder graphDatabaseFactory = (TestGraphDatabaseBuilder)new TestGraphDatabaseFactory().setFileSystem((FileSystemAbstraction)fs).newImpermanentDatabaseBuilder();
        return graphDatabaseFactory.newGraphDatabase();
    }

    protected void dbWithNoCache() throws TransactionFailureException {
        this.stopDb();
        this.startDb();
    }

    protected void stopDb() throws TransactionFailureException {
        if (this.transaction != null) {
            this.transaction.close();
        }
        this.db.shutdown();
    }

    protected void restartDb() throws TransactionFailureException {
        this.stopDb();
        this.startDb();
    }
}

