/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.api.integrationtest;

import java.util.Map;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.neo4j.graphdb.DependencyResolver;
import org.neo4j.graphdb.config.Setting;
import org.neo4j.graphdb.factory.GraphDatabaseSettings;
import org.neo4j.helpers.collection.MapUtil;
import org.neo4j.kernel.guard.EmptyGuard;
import org.neo4j.kernel.guard.Guard;
import org.neo4j.kernel.guard.TimeoutGuard;
import org.neo4j.kernel.impl.api.GuardingStatementOperations;
import org.neo4j.kernel.impl.api.StatementOperationParts;
import org.neo4j.kernel.internal.GraphDatabaseAPI;
import org.neo4j.test.CleanupRule;
import org.neo4j.test.TestGraphDatabaseFactory;

public class GuardIT {
    @Rule
    public CleanupRule cleanupRule = new CleanupRule();

    @Test
    public void timeoutGuardUsedWhenGuardEnabled() throws Exception {
        GraphDatabaseAPI database = this.startDataBase(this.getEnabledGuardConfigMap());
        DependencyResolver dependencyResolver = database.getDependencyResolver();
        Guard guard = (Guard)dependencyResolver.resolveDependency(Guard.class);
        Assert.assertThat((Object)guard, (Matcher)Matchers.instanceOf(TimeoutGuard.class));
    }

    @Test
    public void emptyGuardUsedWhenGuardDisabled() throws Exception {
        GraphDatabaseAPI database = this.startDataBase(this.getDisabledGuardConfigMap());
        DependencyResolver dependencyResolver = database.getDependencyResolver();
        Guard guard = (Guard)dependencyResolver.resolveDependency(Guard.class);
        Assert.assertThat((Object)guard, (Matcher)Matchers.instanceOf(EmptyGuard.class));
    }

    @Test
    public void includeGuardingOperationLayerWhenGuardEnabled() throws Exception {
        GraphDatabaseAPI database = this.startDataBase(this.getEnabledGuardConfigMap());
        DependencyResolver dependencyResolver = database.getDependencyResolver();
        StatementOperationParts operationParts = (StatementOperationParts)dependencyResolver.resolveDependency(StatementOperationParts.class);
        Assert.assertThat((Object)operationParts.entityReadOperations(), (Matcher)Matchers.instanceOf(GuardingStatementOperations.class));
        Assert.assertThat((Object)operationParts.entityWriteOperations(), (Matcher)Matchers.instanceOf(GuardingStatementOperations.class));
    }

    @Test
    public void noGuardingOperationLayerWhenGuardDisabled() throws Exception {
        GraphDatabaseAPI database = this.startDataBase(this.getDisabledGuardConfigMap());
        DependencyResolver dependencyResolver = database.getDependencyResolver();
        StatementOperationParts operationParts = (StatementOperationParts)dependencyResolver.resolveDependency(StatementOperationParts.class);
        Assert.assertThat((Object)operationParts.entityReadOperations(), (Matcher)Matchers.not((Matcher)Matchers.instanceOf(GuardingStatementOperations.class)));
        Assert.assertThat((Object)operationParts.entityWriteOperations(), (Matcher)Matchers.not((Matcher)Matchers.instanceOf(GuardingStatementOperations.class)));
    }

    private GraphDatabaseAPI startDataBase(Map<Setting<?>, String> disabledGuardConfigMap) {
        GraphDatabaseAPI database = (GraphDatabaseAPI)new TestGraphDatabaseFactory().newImpermanentDatabase(disabledGuardConfigMap);
        this.cleanupRule.add(database);
        return database;
    }

    private Map<Setting<?>, String> getEnabledGuardConfigMap() {
        return MapUtil.genericMap((Object[])new Object[]{GraphDatabaseSettings.execution_guard_enabled, "true"});
    }

    private Map<Setting<?>, String> getDisabledGuardConfigMap() {
        return MapUtil.genericMap((Object[])new Object[]{GraphDatabaseSettings.execution_guard_enabled, "false"});
    }
}

