/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.api.integrationtest;

import java.util.Collections;
import java.util.concurrent.TimeUnit;
import junit.framework.TestCase;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.hamcrest.core.IsEqual;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;
import org.mockito.Mockito;
import org.neo4j.collection.RawIterator;
import org.neo4j.graphdb.Transaction;
import org.neo4j.graphdb.schema.IndexDefinition;
import org.neo4j.graphdb.security.AuthorizationViolationException;
import org.neo4j.helpers.collection.Iterators;
import org.neo4j.kernel.api.DataWriteOperations;
import org.neo4j.kernel.api.SchemaWriteOperations;
import org.neo4j.kernel.api.exceptions.ProcedureException;
import org.neo4j.kernel.api.proc.ProcedureSignature;
import org.neo4j.kernel.api.security.AccessMode;
import org.neo4j.kernel.builtinprocs.ListIndexesProcedure;
import org.neo4j.kernel.impl.api.integrationtest.KernelIntegrationTest;
import org.neo4j.kernel.internal.Version;
import org.neo4j.server.security.auth.AuthSubject;

public class BuiltinProceduresIT
extends KernelIntegrationTest {
    @Rule
    public ExpectedException exception = ExpectedException.none();

    @Test
    public void listAllLabels() throws Throwable {
        DataWriteOperations ops = this.dataWriteOperationsInNewTransaction();
        long nodeId = ops.nodeCreate();
        int labelId = ops.labelGetOrCreateForName("MyLabel");
        ops.nodeAddLabel(nodeId, labelId);
        this.commit();
        RawIterator stream = this.readOperationsInNewTransaction().procedureCallRead(ProcedureSignature.procedureName((String[])new String[]{"db", "labels"}), new Object[0]);
        MatcherAssert.assertThat((Object)Iterators.asList((RawIterator)stream), (Matcher)Matchers.contains((Matcher)IsEqual.equalTo((Object)new Object[]{"MyLabel"})));
    }

    @Test
    public void failWhenCallingListAllLabelsInDbmsMode() throws Throwable {
        try {
            RawIterator stream = this.dbmsOperations().procedureCallDbms(ProcedureSignature.procedureName((String[])new String[]{"db", "labels"}), new Object[0], (AccessMode)AccessMode.Static.NONE);
            TestCase.fail((String)"Should have failed.");
        }
        catch (Exception e) {
            MatcherAssert.assertThat(e.getClass(), (Matcher)IsEqual.equalTo(ProcedureException.class));
        }
    }

    @Test
    public void listPropertyKeys() throws Throwable {
        DataWriteOperations ops = this.dataWriteOperationsInNewTransaction();
        ops.propertyKeyGetOrCreateForName("MyProp");
        this.commit();
        RawIterator stream = this.readOperationsInNewTransaction().procedureCallRead(ProcedureSignature.procedureName((String[])new String[]{"db", "propertyKeys"}), new Object[0]);
        MatcherAssert.assertThat((Object)Iterators.asList((RawIterator)stream), (Matcher)Matchers.contains((Matcher)IsEqual.equalTo((Object)new Object[]{"MyProp"})));
    }

    @Test
    public void failWhenCallingListPropertyKeysInDbmsMode() throws Throwable {
        try {
            RawIterator stream = this.dbmsOperations().procedureCallDbms(ProcedureSignature.procedureName((String[])new String[]{"db", "propertyKeys"}), new Object[0], (AccessMode)AccessMode.Static.NONE);
            TestCase.fail((String)"Should have failed.");
        }
        catch (Exception e) {
            MatcherAssert.assertThat(e.getClass(), (Matcher)IsEqual.equalTo(ProcedureException.class));
        }
    }

    @Test
    public void listRelationshipTypes() throws Throwable {
        DataWriteOperations ops = this.dataWriteOperationsInNewTransaction();
        int relType = ops.relationshipTypeGetOrCreateForName("MyRelType");
        ops.relationshipCreate(relType, ops.nodeCreate(), ops.nodeCreate());
        this.commit();
        RawIterator stream = this.readOperationsInNewTransaction().procedureCallRead(ProcedureSignature.procedureName((String[])new String[]{"db", "relationshipTypes"}), new Object[0]);
        MatcherAssert.assertThat((Object)Iterators.asList((RawIterator)stream), (Matcher)Matchers.contains((Matcher)IsEqual.equalTo((Object)new Object[]{"MyRelType"})));
    }

    @Test
    public void failWhenCallingListRelationshipTypesInDbmsMode() throws Throwable {
        try {
            RawIterator stream = this.dbmsOperations().procedureCallDbms(ProcedureSignature.procedureName((String[])new String[]{"db", "relationshipTypes"}), new Object[0], (AccessMode)AccessMode.Static.NONE);
            TestCase.fail((String)"Should have failed.");
        }
        catch (Exception e) {
            MatcherAssert.assertThat(e.getClass(), (Matcher)IsEqual.equalTo(ProcedureException.class));
        }
    }

    @Test
    public void listProcedures() throws Throwable {
        RawIterator stream = this.readOperationsInNewTransaction().procedureCallRead(ProcedureSignature.procedureName((String[])new String[]{"dbms", "procedures"}), new Object[0]);
        MatcherAssert.assertThat((Object)Iterators.asList((RawIterator)stream), (Matcher)Matchers.containsInAnyOrder((Matcher[])new Matcher[]{IsEqual.equalTo((Object)new Object[]{"db.constraints", "db.constraints() :: (description :: STRING?)"}), IsEqual.equalTo((Object)new Object[]{"db.indexes", "db.indexes() :: (description :: STRING?, state :: STRING?, type :: STRING?)"}), IsEqual.equalTo((Object)new Object[]{"db.propertyKeys", "db.propertyKeys() :: (propertyKey :: STRING?)"}), IsEqual.equalTo((Object)new Object[]{"db.labels", "db.labels() :: (label :: STRING?)"}), IsEqual.equalTo((Object)new Object[]{"db.relationshipTypes", "db.relationshipTypes() :: (relationshipType :: STRING?)"}), IsEqual.equalTo((Object)new Object[]{"dbms.procedures", "dbms.procedures() :: (name :: STRING?, signature :: STRING?)"}), IsEqual.equalTo((Object)new Object[]{"dbms.components", "dbms.components() :: (name :: STRING?, versions :: LIST? OF STRING?, edition :: STRING?)"}), IsEqual.equalTo((Object)new Object[]{"dbms.changePassword", "dbms.changePassword(password :: STRING?) :: ()"}), IsEqual.equalTo((Object)new Object[]{"dbms.queryJmx", "dbms.queryJmx(query :: STRING?) :: (name :: STRING?, description :: STRING?, attributes :: MAP?)"})}));
    }

    @Test
    public void failWhenCallingListProceduresInDbmsMode() throws Throwable {
        try {
            RawIterator stream = this.dbmsOperations().procedureCallDbms(ProcedureSignature.procedureName((String[])new String[]{"sys", "procedures"}), new Object[0], (AccessMode)AccessMode.Static.NONE);
            MatcherAssert.assertThat((String)"This should never get here", (boolean)false);
        }
        catch (Exception e) {
            MatcherAssert.assertThat(e.getClass(), (Matcher)IsEqual.equalTo(ProcedureException.class));
        }
    }

    @Test
    public void callChangePasswordWithAccessModeInDbmsMode() throws Throwable {
        Object[] inputArray = new Object[]{"newPassword"};
        AuthSubject authSubject = (AuthSubject)Mockito.mock(AuthSubject.class);
        RawIterator stream = this.dbmsOperations().procedureCallDbms(ProcedureSignature.procedureName((String[])new String[]{"dbms", "changePassword"}), inputArray, (AccessMode)authSubject);
        ((AuthSubject)Mockito.verify((Object)authSubject)).setPassword((String)inputArray[0]);
        MatcherAssert.assertThat((Object)Iterators.asList((RawIterator)stream), (Matcher)Matchers.emptyIterable());
    }

    @Test
    public void shouldFailWhenChangePasswordWithStaticAccessModeInDbmsMode() throws Throwable {
        try {
            Object[] inputArray = new Object[]{"newPassword"};
            RawIterator stream = this.dbmsOperations().procedureCallDbms(ProcedureSignature.procedureName((String[])new String[]{"dbms", "changePassword"}), inputArray, (AccessMode)AccessMode.Static.NONE);
            TestCase.fail((String)"Should have failed.");
        }
        catch (Exception e) {
            MatcherAssert.assertThat(e.getClass(), (Matcher)IsEqual.equalTo(AuthorizationViolationException.class));
        }
    }

    @Test
    public void listAllIndexes() throws Throwable {
        SchemaWriteOperations ops = this.schemaWriteOperationsInNewTransaction();
        int labelId1 = ops.labelGetOrCreateForName("Person");
        int labelId2 = ops.labelGetOrCreateForName("Age");
        int propertyKeyId = ops.propertyKeyGetOrCreateForName("foo");
        ops.indexCreate(labelId1, propertyKeyId);
        ops.uniquePropertyConstraintCreate(labelId2, propertyKeyId);
        this.commit();
        try (Transaction tx = this.db.beginTx();){
            this.db.schema().awaitIndexOnline((IndexDefinition)this.db.schema().getIndexes().iterator().next(), 20L, TimeUnit.SECONDS);
            tx.success();
        }
        RawIterator stream = this.readOperationsInNewTransaction().procedureCallRead(ProcedureSignature.procedureName((String[])new String[]{"db", "indexes"}), new Object[0]);
        MatcherAssert.assertThat((Object)stream.next(), (Matcher)IsEqual.equalTo((Object)new Object[]{"INDEX ON :Age(foo)", "online", ListIndexesProcedure.IndexType.NODE_UNIQUE_PROPERTY.typeName()}));
        MatcherAssert.assertThat((Object)stream.next(), (Matcher)IsEqual.equalTo((Object)new Object[]{"INDEX ON :Person(foo)", "online", ListIndexesProcedure.IndexType.NODE_LABEL_PROPERTY.typeName()}));
    }

    @Test
    public void shouldFalilistAllIndexesnDbmsMode() throws Throwable {
        try {
            RawIterator stream = this.dbmsOperations().procedureCallDbms(ProcedureSignature.procedureName((String[])new String[]{"db", "indexes"}), new Object[0], (AccessMode)AccessMode.Static.NONE);
            TestCase.fail((String)"Should have failed.");
        }
        catch (Exception e) {
            MatcherAssert.assertThat(e.getClass(), (Matcher)IsEqual.equalTo(ProcedureException.class));
        }
    }

    @Test
    public void listAllComponents() throws Throwable {
        RawIterator stream = this.readOperationsInNewTransaction().procedureCallRead(ProcedureSignature.procedureName((String[])new String[]{"dbms", "components"}), new Object[0]);
        MatcherAssert.assertThat((Object)Iterators.asList((RawIterator)stream), (Matcher)Matchers.contains((Matcher)IsEqual.equalTo((Object)new Object[]{"Neo4j Kernel", Collections.singletonList(Version.getNeo4jVersion()), "community"})));
    }
}

