/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.api.index;

import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLong;
import java.util.function.IntPredicate;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Description;
import org.hamcrest.Matcher;
import org.hamcrest.TypeSafeMatcher;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.mockito.ArgumentCaptor;
import org.mockito.InOrder;
import org.mockito.Matchers;
import org.mockito.Mockito;
import org.mockito.invocation.InvocationOnMock;
import org.mockito.stubbing.Answer;
import org.mockito.verification.VerificationMode;
import org.neo4j.collection.primitive.PrimitiveLongCollections;
import org.neo4j.collection.primitive.PrimitiveLongIterator;
import org.neo4j.collection.primitive.PrimitiveLongObjectMap;
import org.neo4j.collection.primitive.PrimitiveLongSet;
import org.neo4j.graphdb.ResourceIterator;
import org.neo4j.graphdb.factory.GraphDatabaseSettings;
import org.neo4j.helpers.collection.ArrayIterator;
import org.neo4j.helpers.collection.BoundedIterable;
import org.neo4j.helpers.collection.Iterables;
import org.neo4j.helpers.collection.Iterators;
import org.neo4j.helpers.collection.MapUtil;
import org.neo4j.helpers.collection.Visitor;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.io.pagecache.PageCache;
import org.neo4j.kernel.api.TokenNameLookup;
import org.neo4j.kernel.api.exceptions.index.IndexEntryConflictException;
import org.neo4j.kernel.api.exceptions.index.IndexNotFoundKernelException;
import org.neo4j.kernel.api.exceptions.index.IndexPopulationFailedKernelException;
import org.neo4j.kernel.api.index.IndexAccessor;
import org.neo4j.kernel.api.index.IndexConfiguration;
import org.neo4j.kernel.api.index.IndexDescriptor;
import org.neo4j.kernel.api.index.IndexPopulator;
import org.neo4j.kernel.api.index.IndexUpdater;
import org.neo4j.kernel.api.index.InternalIndexState;
import org.neo4j.kernel.api.index.NodePropertyUpdate;
import org.neo4j.kernel.api.index.PropertyAccessor;
import org.neo4j.kernel.api.index.SchemaIndexProvider;
import org.neo4j.kernel.configuration.Config;
import org.neo4j.kernel.impl.api.index.IndexPopulationJob;
import org.neo4j.kernel.impl.api.index.IndexProxy;
import org.neo4j.kernel.impl.api.index.IndexStoreView;
import org.neo4j.kernel.impl.api.index.IndexUpdateMode;
import org.neo4j.kernel.impl.api.index.IndexingService;
import org.neo4j.kernel.impl.api.index.IndexingServiceFactory;
import org.neo4j.kernel.impl.api.index.MultipleIndexPopulator;
import org.neo4j.kernel.impl.api.index.NodePropertyUpdates;
import org.neo4j.kernel.impl.api.index.SchemaIndexProviderMap;
import org.neo4j.kernel.impl.api.index.StoreScan;
import org.neo4j.kernel.impl.api.index.TestSchemaIndexProviderDescriptor;
import org.neo4j.kernel.impl.api.index.sampling.IndexSamplingConfig;
import org.neo4j.kernel.impl.api.index.sampling.IndexSamplingMode;
import org.neo4j.kernel.impl.api.scan.LabelScanStoreProvider;
import org.neo4j.kernel.impl.store.record.IndexRule;
import org.neo4j.kernel.impl.storemigration.StoreMigrationParticipant;
import org.neo4j.kernel.impl.transaction.command.Command;
import org.neo4j.kernel.impl.transaction.state.DefaultSchemaIndexProviderMap;
import org.neo4j.kernel.impl.transaction.state.DirectIndexUpdates;
import org.neo4j.kernel.impl.transaction.state.IndexUpdates;
import org.neo4j.kernel.impl.util.JobScheduler;
import org.neo4j.kernel.impl.util.Neo4jJobScheduler;
import org.neo4j.kernel.lifecycle.LifeRule;
import org.neo4j.kernel.lifecycle.Lifecycle;
import org.neo4j.kernel.lifecycle.LifecycleException;
import org.neo4j.logging.AssertableLogProvider;
import org.neo4j.logging.LogProvider;
import org.neo4j.register.Register;
import org.neo4j.register.Registers;
import org.neo4j.storageengine.api.schema.IndexReader;
import org.neo4j.storageengine.api.schema.IndexSample;
import org.neo4j.storageengine.api.schema.PopulationProgress;
import org.neo4j.test.AwaitAnswer;
import org.neo4j.test.DoubleLatch;

public class IndexingServiceTest {
    @Rule
    public final LifeRule life = new LifeRule();
    private static final AssertableLogProvider.LogMatcherBuilder logMatch = AssertableLogProvider.inLog(IndexingService.class);
    private static final Runnable DO_NOTHING_CALLBACK = () -> {};
    private final int labelId = 7;
    private final int propertyKeyId = 15;
    private final IndexPopulator populator = (IndexPopulator)Mockito.mock(IndexPopulator.class);
    private final IndexUpdater updater = (IndexUpdater)Mockito.mock(IndexUpdater.class);
    private final SchemaIndexProvider indexProvider = (SchemaIndexProvider)Mockito.mock(SchemaIndexProvider.class);
    private final IndexAccessor accessor = (IndexAccessor)Mockito.mock(IndexAccessor.class, (Answer)Mockito.RETURNS_MOCKS);
    private final IndexStoreView storeView = (IndexStoreView)Mockito.mock(IndexStoreView.class);
    private final TokenNameLookup nameLookup = (TokenNameLookup)Mockito.mock(TokenNameLookup.class);
    private final AssertableLogProvider logProvider = new AssertableLogProvider();

    @Before
    public void setUp() {
        Mockito.when((Object)this.populator.sampleResult()).thenReturn((Object)new IndexSample());
        Mockito.when((Object)this.storeView.indexSample((IndexDescriptor)Matchers.any(IndexDescriptor.class), (Register.DoubleLongRegister)Matchers.any(Register.DoubleLongRegister.class))).thenAnswer(invocation -> invocation.getArguments()[1]);
    }

    @Test
    public void shouldBringIndexOnlineAndFlipOverToIndexAccessor() throws Exception {
        Mockito.when((Object)this.accessor.newUpdater((IndexUpdateMode)Matchers.any(IndexUpdateMode.class))).thenReturn((Object)this.updater);
        IndexingService indexingService = this.newIndexingServiceWithMockedDependencies(this.populator, this.accessor, this.withData(new NodePropertyUpdate[0]), new IndexRule[0]);
        this.life.start();
        indexingService.createIndexes(new IndexRule[]{IndexRule.indexRule((long)0L, (int)7, (int)15, (SchemaIndexProvider.Descriptor)TestSchemaIndexProviderDescriptor.PROVIDER_DESCRIPTOR)});
        IndexProxy proxy = indexingService.getIndexProxy(0L);
        this.waitForIndexesToComeOnline(indexingService, 0L);
        ((IndexPopulator)Mockito.verify((Object)this.populator, (VerificationMode)Mockito.timeout((long)1000L))).close(true);
        try (IndexUpdater updater = proxy.newUpdater(IndexUpdateMode.ONLINE);){
            updater.process(this.add(10L, "foo"));
        }
        Assert.assertEquals((Object)InternalIndexState.ONLINE, (Object)proxy.getState());
        InOrder order = Mockito.inOrder((Object[])new Object[]{this.populator, this.accessor, this.updater});
        ((IndexPopulator)order.verify((Object)this.populator)).create();
        ((IndexPopulator)order.verify((Object)this.populator)).close(true);
        ((IndexAccessor)order.verify((Object)this.accessor)).newUpdater(IndexUpdateMode.RECOVERY);
        ((IndexUpdater)order.verify((Object)this.updater)).process(this.add(10L, "foo"));
        ((IndexUpdater)order.verify((Object)this.updater)).close();
    }

    @Test
    public void indexCreationShouldBeIdempotent() throws Exception {
        Mockito.when((Object)this.accessor.newUpdater((IndexUpdateMode)Matchers.any(IndexUpdateMode.class))).thenReturn((Object)this.updater);
        IndexingService indexingService = this.newIndexingServiceWithMockedDependencies(this.populator, this.accessor, this.withData(new NodePropertyUpdate[0]), new IndexRule[0]);
        this.life.start();
        indexingService.createIndexes(new IndexRule[]{IndexRule.indexRule((long)0L, (int)7, (int)15, (SchemaIndexProvider.Descriptor)TestSchemaIndexProviderDescriptor.PROVIDER_DESCRIPTOR)});
        indexingService.createIndexes(new IndexRule[]{IndexRule.indexRule((long)0L, (int)7, (int)15, (SchemaIndexProvider.Descriptor)TestSchemaIndexProviderDescriptor.PROVIDER_DESCRIPTOR)});
        this.waitForIndexesToComeOnline(indexingService, 0L);
    }

    @Test
    public void shouldDeliverUpdatesThatOccurDuringPopulationToPopulator() throws Exception {
        Mockito.when((Object)this.populator.newPopulatingUpdater((PropertyAccessor)this.storeView)).thenReturn((Object)this.updater);
        CountDownLatch latch = new CountDownLatch(1);
        ((IndexPopulator)Mockito.doAnswer(AwaitAnswer.afterAwaiting(latch)).when((Object)this.populator)).add((Collection)Matchers.anyList());
        IndexingService indexingService = this.newIndexingServiceWithMockedDependencies(this.populator, this.accessor, this.withData(this.add(1L, "value1")), new IndexRule[0]);
        this.life.start();
        indexingService.createIndexes(new IndexRule[]{IndexRule.indexRule((long)0L, (int)7, (int)15, (SchemaIndexProvider.Descriptor)TestSchemaIndexProviderDescriptor.PROVIDER_DESCRIPTOR)});
        IndexProxy proxy = indexingService.getIndexProxy(0L);
        Assert.assertEquals((Object)InternalIndexState.POPULATING, (Object)proxy.getState());
        NodePropertyUpdate value2 = this.add(2L, "value2");
        try (IndexUpdater updater = proxy.newUpdater(IndexUpdateMode.ONLINE);){
            updater.process(value2);
        }
        latch.countDown();
        this.waitForIndexesToComeOnline(indexingService, 0L);
        ((IndexPopulator)Mockito.verify((Object)this.populator, (VerificationMode)Mockito.timeout((long)1000L))).close(true);
        Assert.assertEquals((Object)InternalIndexState.ONLINE, (Object)proxy.getState());
        InOrder order = Mockito.inOrder((Object[])new Object[]{this.populator, this.accessor, this.updater});
        ((IndexPopulator)order.verify((Object)this.populator)).create();
        ((IndexPopulator)order.verify((Object)this.populator)).includeSample(this.add(1L, "value1"));
        ((IndexPopulator)order.verify((Object)this.populator)).add((Collection)Mockito.anyListOf(NodePropertyUpdate.class));
        ((IndexPopulator)order.verify((Object)this.populator)).verifyDeferredConstraints((PropertyAccessor)this.storeView);
        ((IndexPopulator)order.verify((Object)this.populator)).newPopulatingUpdater((PropertyAccessor)this.storeView);
        ((IndexUpdater)order.verify((Object)this.updater)).close();
        ((IndexPopulator)order.verify((Object)this.populator)).sampleResult();
        ((IndexPopulator)order.verify((Object)this.populator)).close(true);
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.updater});
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.populator});
        Mockito.verifyZeroInteractions((Object[])new Object[]{this.accessor});
    }

    @Test
    public void shouldStillReportInternalIndexStateAsPopulatingWhenConstraintIndexIsDonePopulating() throws Exception {
        Mockito.when((Object)this.accessor.newUpdater((IndexUpdateMode)Matchers.any(IndexUpdateMode.class))).thenReturn((Object)this.updater);
        IndexingService indexingService = this.newIndexingServiceWithMockedDependencies(this.populator, this.accessor, this.withData(new NodePropertyUpdate[0]), new IndexRule[0]);
        this.life.start();
        indexingService.createIndexes(new IndexRule[]{IndexRule.constraintIndexRule((long)0L, (int)7, (int)15, (SchemaIndexProvider.Descriptor)TestSchemaIndexProviderDescriptor.PROVIDER_DESCRIPTOR, null)});
        IndexProxy proxy = indexingService.getIndexProxy(0L);
        ((IndexPopulator)Mockito.verify((Object)this.populator, (VerificationMode)Mockito.timeout((long)2000L))).close(true);
        try (IndexUpdater updater = proxy.newUpdater(IndexUpdateMode.ONLINE);){
            updater.process(this.add(10L, "foo"));
        }
        Assert.assertEquals((Object)InternalIndexState.POPULATING, (Object)proxy.getState());
        InOrder order = Mockito.inOrder((Object[])new Object[]{this.populator, this.accessor, this.updater});
        ((IndexPopulator)order.verify((Object)this.populator)).create();
        ((IndexPopulator)order.verify((Object)this.populator)).close(true);
        ((IndexAccessor)order.verify((Object)this.accessor)).newUpdater(IndexUpdateMode.ONLINE);
        ((IndexUpdater)order.verify((Object)this.updater)).process(this.add(10L, "foo"));
        ((IndexUpdater)order.verify((Object)this.updater)).close();
    }

    @Test
    public void shouldBringConstraintIndexOnlineWhenExplicitlyToldTo() throws Exception {
        IndexingService indexingService = this.newIndexingServiceWithMockedDependencies(this.populator, this.accessor, this.withData(new NodePropertyUpdate[0]), new IndexRule[0]);
        this.life.start();
        indexingService.createIndexes(new IndexRule[]{IndexRule.constraintIndexRule((long)0L, (int)7, (int)15, (SchemaIndexProvider.Descriptor)TestSchemaIndexProviderDescriptor.PROVIDER_DESCRIPTOR, null)});
        IndexProxy proxy = indexingService.getIndexProxy(0L);
        indexingService.activateIndex(0L);
        Assert.assertEquals((Object)InternalIndexState.ONLINE, (Object)proxy.getState());
        InOrder order = Mockito.inOrder((Object[])new Object[]{this.populator, this.accessor});
        ((IndexPopulator)order.verify((Object)this.populator)).create();
        ((IndexPopulator)order.verify((Object)this.populator)).close(true);
    }

    @Test
    public void shouldLogIndexStateOnInit() throws Exception {
        SchemaIndexProvider provider = (SchemaIndexProvider)Mockito.mock(SchemaIndexProvider.class);
        Mockito.when((Object)provider.getProviderDescriptor()).thenReturn((Object)TestSchemaIndexProviderDescriptor.PROVIDER_DESCRIPTOR);
        DefaultSchemaIndexProviderMap providerMap = new DefaultSchemaIndexProviderMap(provider);
        TokenNameLookup mockLookup = (TokenNameLookup)Mockito.mock(TokenNameLookup.class);
        IndexRule onlineIndex = IndexRule.indexRule((long)1L, (int)1, (int)1, (SchemaIndexProvider.Descriptor)TestSchemaIndexProviderDescriptor.PROVIDER_DESCRIPTOR);
        IndexRule populatingIndex = IndexRule.indexRule((long)2L, (int)1, (int)2, (SchemaIndexProvider.Descriptor)TestSchemaIndexProviderDescriptor.PROVIDER_DESCRIPTOR);
        IndexRule failedIndex = IndexRule.indexRule((long)3L, (int)2, (int)2, (SchemaIndexProvider.Descriptor)TestSchemaIndexProviderDescriptor.PROVIDER_DESCRIPTOR);
        this.life.add((Lifecycle)IndexingServiceFactory.createIndexingService((Config)Config.empty(), (JobScheduler)((JobScheduler)Mockito.mock(JobScheduler.class)), (SchemaIndexProviderMap)providerMap, (IndexStoreView)((IndexStoreView)Mockito.mock(IndexStoreView.class)), (TokenNameLookup)mockLookup, Arrays.asList(onlineIndex, populatingIndex, failedIndex), (LogProvider)this.logProvider, (IndexingService.Monitor)IndexingService.NO_MONITOR, (Runnable)DO_NOTHING_CALLBACK));
        Mockito.when((Object)provider.getInitialState(onlineIndex.getId())).thenReturn((Object)InternalIndexState.ONLINE);
        Mockito.when((Object)provider.getInitialState(populatingIndex.getId())).thenReturn((Object)InternalIndexState.POPULATING);
        Mockito.when((Object)provider.getInitialState(failedIndex.getId())).thenReturn((Object)InternalIndexState.FAILED);
        Mockito.when((Object)mockLookup.labelGetName(1)).thenReturn((Object)"LabelOne");
        Mockito.when((Object)mockLookup.labelGetName(2)).thenReturn((Object)"LabelTwo");
        Mockito.when((Object)mockLookup.propertyKeyGetName(1)).thenReturn((Object)"propertyOne");
        Mockito.when((Object)mockLookup.propertyKeyGetName(2)).thenReturn((Object)"propertyTwo");
        this.life.init();
        this.logProvider.assertExactly(new AssertableLogProvider.LogMatcher[]{logMatch.info("IndexingService.init: index 1 on :LabelOne(propertyOne) is ONLINE"), logMatch.info("IndexingService.init: index 2 on :LabelOne(propertyTwo) is POPULATING"), logMatch.info("IndexingService.init: index 3 on :LabelTwo(propertyTwo) is FAILED")});
    }

    @Test
    public void shouldLogIndexStateOnStart() throws Exception {
        SchemaIndexProvider provider = (SchemaIndexProvider)Mockito.mock(SchemaIndexProvider.class);
        Mockito.when((Object)provider.getProviderDescriptor()).thenReturn((Object)TestSchemaIndexProviderDescriptor.PROVIDER_DESCRIPTOR);
        DefaultSchemaIndexProviderMap providerMap = new DefaultSchemaIndexProviderMap(provider);
        TokenNameLookup mockLookup = (TokenNameLookup)Mockito.mock(TokenNameLookup.class);
        IndexRule onlineIndex = IndexRule.indexRule((long)1L, (int)1, (int)1, (SchemaIndexProvider.Descriptor)TestSchemaIndexProviderDescriptor.PROVIDER_DESCRIPTOR);
        IndexRule populatingIndex = IndexRule.indexRule((long)2L, (int)1, (int)2, (SchemaIndexProvider.Descriptor)TestSchemaIndexProviderDescriptor.PROVIDER_DESCRIPTOR);
        IndexRule failedIndex = IndexRule.indexRule((long)3L, (int)2, (int)2, (SchemaIndexProvider.Descriptor)TestSchemaIndexProviderDescriptor.PROVIDER_DESCRIPTOR);
        IndexingService indexingService = IndexingServiceFactory.createIndexingService((Config)Config.empty(), (JobScheduler)((JobScheduler)Mockito.mock(JobScheduler.class)), (SchemaIndexProviderMap)providerMap, (IndexStoreView)this.storeView, (TokenNameLookup)mockLookup, Arrays.asList(onlineIndex, populatingIndex, failedIndex), (LogProvider)this.logProvider, (IndexingService.Monitor)IndexingService.NO_MONITOR, (Runnable)DO_NOTHING_CALLBACK);
        Mockito.when((Object)provider.getInitialState(onlineIndex.getId())).thenReturn((Object)InternalIndexState.ONLINE);
        Mockito.when((Object)provider.getInitialState(populatingIndex.getId())).thenReturn((Object)InternalIndexState.POPULATING);
        Mockito.when((Object)provider.getInitialState(failedIndex.getId())).thenReturn((Object)InternalIndexState.FAILED);
        indexingService.init();
        Mockito.when((Object)mockLookup.labelGetName(1)).thenReturn((Object)"LabelOne");
        Mockito.when((Object)mockLookup.labelGetName(2)).thenReturn((Object)"LabelTwo");
        Mockito.when((Object)mockLookup.propertyKeyGetName(1)).thenReturn((Object)"propertyOne");
        Mockito.when((Object)mockLookup.propertyKeyGetName(2)).thenReturn((Object)"propertyTwo");
        Mockito.when((Object)this.storeView.indexSample((IndexDescriptor)Matchers.any(IndexDescriptor.class), (Register.DoubleLongRegister)Matchers.any(Register.DoubleLongRegister.class))).thenReturn((Object)Registers.newDoubleLongRegister((long)32L, (long)32L));
        this.logProvider.clear();
        indexingService.start();
        ((SchemaIndexProvider)Mockito.verify((Object)provider)).getPopulationFailure(3L);
        this.logProvider.assertAtLeastOnce(new AssertableLogProvider.LogMatcher[]{logMatch.info("IndexingService.start: index 1 on :LabelOne(propertyOne) is ONLINE"), logMatch.info("IndexingService.start: index 2 on :LabelOne(propertyTwo) is POPULATING"), logMatch.info("IndexingService.start: index 3 on :LabelTwo(propertyTwo) is FAILED")});
    }

    @Test
    public void shouldFailToStartIfMissingIndexProvider() throws Exception {
        String otherProviderKey = "something-completely-different";
        SchemaIndexProvider.Descriptor otherDescriptor = new SchemaIndexProvider.Descriptor(otherProviderKey, "no-version");
        IndexRule rule = IndexRule.indexRule((long)1L, (int)2, (int)3, (SchemaIndexProvider.Descriptor)otherDescriptor);
        IndexingService indexing = this.newIndexingServiceWithMockedDependencies((IndexPopulator)Mockito.mock(IndexPopulator.class), (IndexAccessor)Mockito.mock(IndexAccessor.class), new DataUpdates(new NodePropertyUpdate[0]), rule);
        try {
            this.life.init();
            Assert.fail((String)"initIndexes with mismatching index provider should fail");
        }
        catch (LifecycleException e) {
            Assert.assertThat((Object)e.getCause().getMessage(), (Matcher)CoreMatchers.containsString((String)"existing index"));
            Assert.assertThat((Object)e.getCause().getMessage(), (Matcher)CoreMatchers.containsString((String)otherProviderKey));
        }
    }

    @Test
    public void shouldSnapshotOnlineIndexes() throws Exception {
        int indexId = 1;
        int indexId2 = 2;
        IndexRule rule1 = IndexRule.indexRule((long)indexId, (int)2, (int)3, (SchemaIndexProvider.Descriptor)TestSchemaIndexProviderDescriptor.PROVIDER_DESCRIPTOR);
        IndexRule rule2 = IndexRule.indexRule((long)indexId2, (int)4, (int)5, (SchemaIndexProvider.Descriptor)TestSchemaIndexProviderDescriptor.PROVIDER_DESCRIPTOR);
        IndexAccessor indexAccessor = (IndexAccessor)Mockito.mock(IndexAccessor.class);
        IndexingService indexing = this.newIndexingServiceWithMockedDependencies((IndexPopulator)Mockito.mock(IndexPopulator.class), indexAccessor, new DataUpdates(new NodePropertyUpdate[0]), rule1, rule2);
        File theFile = new File("Blah");
        Mockito.when((Object)indexAccessor.snapshotFiles()).thenAnswer(this.newResourceIterator(theFile));
        Mockito.when((Object)this.indexProvider.getInitialState((long)indexId)).thenReturn((Object)InternalIndexState.ONLINE);
        Mockito.when((Object)this.indexProvider.getInitialState((long)indexId2)).thenReturn((Object)InternalIndexState.ONLINE);
        Mockito.when((Object)this.storeView.indexSample((IndexDescriptor)Matchers.any(IndexDescriptor.class), (Register.DoubleLongRegister)Matchers.any(Register.DoubleLongRegister.class))).thenReturn((Object)Registers.newDoubleLongRegister((long)32L, (long)32L));
        this.life.start();
        ResourceIterator files = indexing.snapshotStoreFiles();
        Assert.assertThat((Object)Iterators.asCollection((Iterator)files), (Matcher)org.hamcrest.Matchers.equalTo((Object)Iterators.asCollection((Iterator)Iterators.iterator((Object[])new File[]{theFile, theFile}))));
    }

    @Test
    public void shouldNotSnapshotPopulatingIndexes() throws Exception {
        CountDownLatch populatorLatch = new CountDownLatch(1);
        IndexAccessor indexAccessor = (IndexAccessor)Mockito.mock(IndexAccessor.class);
        int indexId = 1;
        int indexId2 = 2;
        IndexRule rule1 = IndexRule.indexRule((long)indexId, (int)2, (int)3, (SchemaIndexProvider.Descriptor)TestSchemaIndexProviderDescriptor.PROVIDER_DESCRIPTOR);
        IndexRule rule2 = IndexRule.indexRule((long)indexId2, (int)4, (int)5, (SchemaIndexProvider.Descriptor)TestSchemaIndexProviderDescriptor.PROVIDER_DESCRIPTOR);
        IndexingService indexing = this.newIndexingServiceWithMockedDependencies(this.populator, indexAccessor, new DataUpdates(new NodePropertyUpdate[0]), rule1, rule2);
        File theFile = new File("Blah");
        ((IndexPopulator)Mockito.doAnswer(this.waitForLatch(populatorLatch)).when((Object)this.populator)).create();
        Mockito.when((Object)indexAccessor.snapshotFiles()).thenAnswer(this.newResourceIterator(theFile));
        Mockito.when((Object)this.indexProvider.getInitialState((long)indexId)).thenReturn((Object)InternalIndexState.POPULATING);
        Mockito.when((Object)this.indexProvider.getInitialState((long)indexId2)).thenReturn((Object)InternalIndexState.ONLINE);
        Mockito.when((Object)this.storeView.indexSample((IndexDescriptor)Matchers.any(IndexDescriptor.class), (Register.DoubleLongRegister)Matchers.any(Register.DoubleLongRegister.class))).thenReturn((Object)Registers.newDoubleLongRegister((long)32L, (long)32L));
        this.life.start();
        ResourceIterator files = indexing.snapshotStoreFiles();
        populatorLatch.countDown();
        this.waitForIndexesToComeOnline(indexing, indexId, indexId2);
        Assert.assertThat((Object)Iterators.asCollection((Iterator)files), (Matcher)org.hamcrest.Matchers.equalTo((Object)Iterators.asCollection((Iterator)Iterators.iterator((Object)theFile))));
    }

    @Test
    public void shouldIgnoreActivateCallDuringRecovery() throws Exception {
        IndexingService indexingService = this.newIndexingServiceWithMockedDependencies(this.populator, this.accessor, this.withData(new NodePropertyUpdate[0]), new IndexRule[0]);
        indexingService.activateIndex(0L);
    }

    @Test
    public void shouldLogTriggerSamplingOnAllIndexes() throws Exception {
        IndexingService indexingService = this.newIndexingServiceWithMockedDependencies(this.populator, this.accessor, this.withData(new NodePropertyUpdate[0]), new IndexRule[0]);
        IndexSamplingMode mode = IndexSamplingMode.TRIGGER_REBUILD_ALL;
        indexingService.triggerIndexSampling(mode);
        this.logProvider.assertAtLeastOnce(new AssertableLogProvider.LogMatcher[]{logMatch.info("Manual trigger for sampling all indexes [" + mode + "]")});
    }

    @Test
    public void shouldLogTriggerSamplingOnAnIndexes() throws Exception {
        IndexingService indexingService = this.newIndexingServiceWithMockedDependencies(this.populator, this.accessor, this.withData(new NodePropertyUpdate[0]), new IndexRule[0]);
        IndexSamplingMode mode = IndexSamplingMode.TRIGGER_REBUILD_ALL;
        IndexDescriptor descriptor = new IndexDescriptor(0, 1);
        indexingService.triggerIndexSampling(descriptor, mode);
        String userDescription = descriptor.userDescription(this.nameLookup);
        this.logProvider.assertAtLeastOnce(new AssertableLogProvider.LogMatcher[]{logMatch.info("Manual trigger for sampling index " + userDescription + " [" + mode + "]")});
    }

    @Test
    public void applicationOfIndexUpdatesShouldThrowIfServiceIsStopped() throws IOException, IndexEntryConflictException {
        IndexingService indexingService = this.newIndexingServiceWithMockedDependencies(this.populator, this.accessor, this.withData(new NodePropertyUpdate[0]), new IndexRule[0]);
        this.life.start();
        this.life.stop();
        try {
            indexingService.apply(this.updates(Iterators.asSet((Object[])new NodePropertyUpdate[]{this.add(1L, "foo")})));
            Assert.fail((String)("Should have thrown " + IllegalStateException.class.getSimpleName()));
        }
        catch (IllegalStateException e) {
            Assert.assertThat((Object)e.getMessage(), (Matcher)CoreMatchers.startsWith((String)"Can't apply index updates"));
        }
    }

    private IndexUpdates updates(Iterable<NodePropertyUpdate> updates) {
        return new DirectIndexUpdates(updates);
    }

    @Test
    public void applicationOfUpdatesShouldFlush() throws Exception {
        Mockito.when((Object)this.accessor.newUpdater((IndexUpdateMode)Matchers.any(IndexUpdateMode.class))).thenReturn((Object)this.updater);
        IndexingService indexing = this.newIndexingServiceWithMockedDependencies(this.populator, this.accessor, this.withData(new NodePropertyUpdate[0]), new IndexRule[0]);
        this.life.start();
        indexing.createIndexes(new IndexRule[]{IndexRule.indexRule((long)0L, (int)7, (int)15, (SchemaIndexProvider.Descriptor)TestSchemaIndexProviderDescriptor.PROVIDER_DESCRIPTOR)});
        this.waitForIndexesToComeOnline(indexing, 0L);
        ((IndexPopulator)Mockito.verify((Object)this.populator, (VerificationMode)Mockito.timeout((long)1000L))).close(true);
        indexing.apply(this.updates(Arrays.asList(this.add(1L, "foo"), this.add(2L, "bar"))));
        InOrder inOrder = Mockito.inOrder((Object[])new Object[]{this.updater});
        ((IndexUpdater)inOrder.verify((Object)this.updater)).process(this.add(1L, "foo"));
        ((IndexUpdater)inOrder.verify((Object)this.updater)).process(this.add(2L, "bar"));
        ((IndexUpdater)inOrder.verify((Object)this.updater)).close();
        inOrder.verifyNoMoreInteractions();
    }

    @Test
    public void closingOfValidatedUpdatesShouldCloseUpdaters() throws Exception {
        long indexId1 = 1L;
        long indexId2 = 2L;
        int labelId1 = 24;
        int labelId2 = 42;
        IndexingService indexing = this.newIndexingServiceWithMockedDependencies(this.populator, this.accessor, this.withData(new NodePropertyUpdate[0]), new IndexRule[0]);
        IndexAccessor accessor1 = (IndexAccessor)Mockito.mock(IndexAccessor.class);
        IndexUpdater updater1 = (IndexUpdater)Mockito.mock(IndexUpdater.class);
        Mockito.when((Object)accessor1.newUpdater((IndexUpdateMode)Matchers.any(IndexUpdateMode.class))).thenReturn((Object)updater1);
        IndexAccessor accessor2 = (IndexAccessor)Mockito.mock(IndexAccessor.class);
        IndexUpdater updater2 = (IndexUpdater)Mockito.mock(IndexUpdater.class);
        Mockito.when((Object)accessor2.newUpdater((IndexUpdateMode)Matchers.any(IndexUpdateMode.class))).thenReturn((Object)updater2);
        Mockito.when((Object)this.indexProvider.getOnlineAccessor(Matchers.eq((long)1L), (IndexConfiguration)Matchers.any(IndexConfiguration.class), (IndexSamplingConfig)Matchers.any(IndexSamplingConfig.class))).thenReturn((Object)accessor1);
        Mockito.when((Object)this.indexProvider.getOnlineAccessor(Matchers.eq((long)2L), (IndexConfiguration)Matchers.any(IndexConfiguration.class), (IndexSamplingConfig)Matchers.any(IndexSamplingConfig.class))).thenReturn((Object)accessor2);
        this.life.start();
        indexing.createIndexes(new IndexRule[]{IndexRule.indexRule((long)indexId1, (int)labelId1, (int)15, (SchemaIndexProvider.Descriptor)TestSchemaIndexProviderDescriptor.PROVIDER_DESCRIPTOR)});
        indexing.createIndexes(new IndexRule[]{IndexRule.indexRule((long)indexId2, (int)labelId2, (int)15, (SchemaIndexProvider.Descriptor)TestSchemaIndexProviderDescriptor.PROVIDER_DESCRIPTOR)});
        this.waitForIndexesToComeOnline(indexing, indexId1, indexId2);
        ((IndexPopulator)Mockito.verify((Object)this.populator, (VerificationMode)Mockito.timeout((long)1000L).times(2))).close(true);
        indexing.apply(this.updates(Arrays.asList(NodePropertyUpdate.add((long)1L, (int)15, (Object)"foo", (long[])new long[]{labelId1}), NodePropertyUpdate.add((long)2L, (int)15, (Object)"bar", (long[])new long[]{labelId2}))));
        ((IndexUpdater)Mockito.verify((Object)updater1)).close();
        ((IndexUpdater)Mockito.verify((Object)updater2)).close();
    }

    private void waitForIndexesToComeOnline(IndexingService indexing, long ... indexRuleIds) throws IndexNotFoundKernelException {
        long end = System.currentTimeMillis() + TimeUnit.SECONDS.toMillis(30L);
        while (!this.allOnline(indexing, indexRuleIds)) {
            if (System.currentTimeMillis() <= end) continue;
            Assert.fail((String)"Indexes couldn't come online");
        }
    }

    private boolean allOnline(IndexingService indexing, long[] indexRuleIds) throws IndexNotFoundKernelException {
        for (long indexRuleId : indexRuleIds) {
            if (indexing.getIndexProxy(indexRuleId).getState() == InternalIndexState.ONLINE) continue;
            return false;
        }
        return true;
    }

    @Test
    public void recoveredUpdatesShouldBeApplied() throws Exception {
        long nodeId1 = 1L;
        long nodeId2 = 2L;
        final PrimitiveLongSet nodeIds = PrimitiveLongCollections.setOf((long[])new long[]{1L, 2L});
        NodePropertyUpdate nodeUpdate1 = this.add(1L, "foo");
        NodePropertyUpdate nodeUpdate2 = this.add(2L, "bar");
        final Set nodeUpdates = Iterators.asSet((Object[])new NodePropertyUpdate[]{nodeUpdate1, nodeUpdate2});
        final AtomicBoolean applyingRecoveredDataCalled = new AtomicBoolean();
        final AtomicBoolean appliedRecoveredDataCalled = new AtomicBoolean();
        IndexingService.MonitorAdapter monitor = new IndexingService.MonitorAdapter(){

            public void applyingRecoveredData(PrimitiveLongSet recoveredNodeIds) {
                Assert.assertEquals((Object)nodeIds, (Object)recoveredNodeIds);
                applyingRecoveredDataCalled.set(true);
            }

            public void appliedRecoveredData(Iterable<NodePropertyUpdate> updates) {
                Assert.assertEquals((Object)nodeUpdates, (Object)Iterables.asSet(updates));
                appliedRecoveredDataCalled.set(true);
            }
        };
        IndexingService indexing = this.newIndexingServiceWithMockedDependencies(this.populator, this.accessor, this.withData(new NodePropertyUpdate[0]), (IndexingService.Monitor)monitor, new IndexRule[0]);
        ((IndexStoreView)Mockito.doAnswer((Answer)this.nodeUpdatesAnswer(nodeUpdate1)).when((Object)this.storeView)).nodeAsUpdates(Matchers.eq((long)1L), (Collection)Matchers.any(Collection.class));
        ((IndexStoreView)Mockito.doAnswer((Answer)this.nodeUpdatesAnswer(nodeUpdate2)).when((Object)this.storeView)).nodeAsUpdates(Matchers.eq((long)2L), (Collection)Matchers.any(Collection.class));
        this.life.init();
        IndexUpdates updates = this.nodeIdsAsIndexUpdates(nodeIds);
        indexing.apply(updates);
        this.life.start();
        Assert.assertTrue((String)"applyingRecoveredData was not called", (boolean)applyingRecoveredDataCalled.get());
        Assert.assertTrue((String)"appliedRecoveredData was not called", (boolean)appliedRecoveredDataCalled.get());
    }

    private IndexUpdates nodeIdsAsIndexUpdates(final PrimitiveLongSet nodeIds) {
        return new IndexUpdates(){

            public Iterator<NodePropertyUpdate> iterator() {
                throw new UnsupportedOperationException();
            }

            public void collectUpdatedNodeIds(PrimitiveLongSet target) {
                target.addAll(nodeIds.iterator());
            }

            public void feed(PrimitiveLongObjectMap<List<Command.PropertyCommand>> propCommands, PrimitiveLongObjectMap<Command.NodeCommand> nodeCommands) {
                throw new UnsupportedOperationException();
            }

            public boolean hasUpdates() {
                return !nodeIds.isEmpty();
            }
        };
    }

    @Test
    public void shouldNotLoseIndexDescriptorDueToOtherSimilarIndexDuringRecovery() throws Exception {
        long nodeId = 0L;
        long indexId = 1L;
        long otherIndexId = 2L;
        NodePropertyUpdate update = this.add(nodeId, "value");
        ((IndexStoreView)Mockito.doAnswer((Answer)this.nodeUpdatesAnswer(update)).when((Object)this.storeView)).nodeAsUpdates(Matchers.eq((long)nodeId), (Collection)Matchers.any(Collection.class));
        Register.DoubleLongRegister register = (Register.DoubleLongRegister)Mockito.mock(Register.DoubleLongRegister.class);
        Mockito.when((Object)register.readSecond()).thenReturn((Object)42L);
        Mockito.when((Object)this.storeView.indexSample((IndexDescriptor)Matchers.any(IndexDescriptor.class), (Register.DoubleLongRegister)Matchers.any(Register.DoubleLongRegister.class))).thenReturn((Object)register);
        IndexAccessor accessor = (IndexAccessor)Mockito.spy((Object)new TrackingIndexAccessor());
        IndexRule index = IndexRule.indexRule((long)1L, (int)7, (int)15, (SchemaIndexProvider.Descriptor)TestSchemaIndexProviderDescriptor.PROVIDER_DESCRIPTOR);
        IndexingService indexing = this.newIndexingServiceWithMockedDependencies(this.populator, accessor, this.withData(update), index);
        Mockito.when((Object)this.indexProvider.getInitialState(indexId)).thenReturn((Object)InternalIndexState.ONLINE);
        this.life.init();
        IndexRule otherIndex = IndexRule.indexRule((long)otherIndexId, (int)7, (int)15, (SchemaIndexProvider.Descriptor)TestSchemaIndexProviderDescriptor.PROVIDER_DESCRIPTOR);
        indexing.createIndexes(new IndexRule[]{otherIndex});
        indexing.dropIndex(otherIndex);
        indexing.apply(this.nodeIdsAsIndexUpdates(PrimitiveLongCollections.asSet((PrimitiveLongIterator)PrimitiveLongCollections.iterator((long[])new long[]{nodeId}))));
        indexing.createIndexes(new IndexRule[]{index});
        Mockito.reset((Object[])new IndexAccessor[]{accessor});
        this.life.start();
        ((IndexAccessor)Mockito.verify((Object)accessor, (VerificationMode)Mockito.times((int)2))).newUpdater(IndexUpdateMode.RECOVERY);
    }

    @Test
    public void shouldWaitForRecoveredUniquenessConstraintIndexesToBeFullyPopulated() throws Exception {
        final DoubleLatch latch = new DoubleLatch();
        ControlledIndexPopulator populator = new ControlledIndexPopulator(latch);
        final AtomicLong indexId = new AtomicLong(-1L);
        IndexingService.MonitorAdapter monitor = new IndexingService.MonitorAdapter(){

            public void awaitingPopulationOfRecoveredIndex(long index, IndexDescriptor descriptor) {
                indexId.set(index);
                latch.start();
            }
        };
        IndexingService indexing = this.newIndexingServiceWithMockedDependencies((IndexPopulator)populator, this.accessor, this.withData(NodePropertyUpdate.add((long)0L, (int)0, (Object)"value", (long[])new long[]{1L})), (IndexingService.Monitor)monitor, new IndexRule[0]);
        this.life.init();
        long fakeOwningConstraintRuleId = 1L;
        indexing.createIndexes(new IndexRule[]{new IndexRule(2L, 7, 15, TestSchemaIndexProviderDescriptor.PROVIDER_DESCRIPTOR, Long.valueOf(fakeOwningConstraintRuleId))});
        this.life.start();
        Assert.assertEquals((long)2L, (long)indexId.get());
        Assert.assertEquals((Object)InternalIndexState.ONLINE, (Object)indexing.getIndexProxy(indexId.get()).getState());
    }

    @Test
    public void shouldCreateMultipleIndexesInOneCall() throws Exception {
        IndexingService.Monitor monitor = IndexingService.NO_MONITOR;
        IndexingService indexing = this.newIndexingServiceWithMockedDependencies(this.populator, this.accessor, this.withData(NodePropertyUpdate.add((long)0L, (int)0, (Object)"value", (long[])new long[]{1L})), monitor, new IndexRule[0]);
        this.life.start();
        IndexRule indexRule1 = IndexRule.indexRule((long)0L, (int)0, (int)0, (SchemaIndexProvider.Descriptor)TestSchemaIndexProviderDescriptor.PROVIDER_DESCRIPTOR);
        IndexRule indexRule2 = IndexRule.indexRule((long)1L, (int)0, (int)1, (SchemaIndexProvider.Descriptor)TestSchemaIndexProviderDescriptor.PROVIDER_DESCRIPTOR);
        IndexRule indexRule3 = IndexRule.indexRule((long)2L, (int)1, (int)0, (SchemaIndexProvider.Descriptor)TestSchemaIndexProviderDescriptor.PROVIDER_DESCRIPTOR);
        indexing.createIndexes(new IndexRule[]{indexRule1, indexRule2, indexRule3});
        ((SchemaIndexProvider)Mockito.verify((Object)this.indexProvider)).getPopulator(Matchers.eq((long)0L), (IndexDescriptor)Matchers.eq((Object)new IndexDescriptor(0, 0)), (IndexConfiguration)Matchers.eq((Object)IndexConfiguration.NON_UNIQUE), (IndexSamplingConfig)Matchers.any(IndexSamplingConfig.class));
        ((SchemaIndexProvider)Mockito.verify((Object)this.indexProvider)).getPopulator(Matchers.eq((long)1L), (IndexDescriptor)Matchers.eq((Object)new IndexDescriptor(0, 1)), (IndexConfiguration)Matchers.eq((Object)IndexConfiguration.NON_UNIQUE), (IndexSamplingConfig)Matchers.any(IndexSamplingConfig.class));
        ((SchemaIndexProvider)Mockito.verify((Object)this.indexProvider)).getPopulator(Matchers.eq((long)2L), (IndexDescriptor)Matchers.eq((Object)new IndexDescriptor(1, 0)), (IndexConfiguration)Matchers.eq((Object)IndexConfiguration.NON_UNIQUE), (IndexSamplingConfig)Matchers.any(IndexSamplingConfig.class));
        this.waitForIndexesToComeOnline(indexing, 0L, 1L, 2L);
    }

    @Test
    public void shouldStoreIndexFailureWhenFailingToCreateOnlineAccessorAfterPopulating() throws Exception {
        long indexId = 1L;
        IndexingService indexing = this.newIndexingServiceWithMockedDependencies(this.populator, this.accessor, this.withData(new NodePropertyUpdate[0]), new IndexRule[0]);
        IOException exception = new IOException("Expected failure");
        Mockito.when((Object)this.nameLookup.labelGetName(7)).thenReturn((Object)"TheLabel");
        Mockito.when((Object)this.nameLookup.propertyKeyGetName(15)).thenReturn((Object)"propertyKey");
        Mockito.when((Object)this.indexProvider.getOnlineAccessor(Matchers.eq((long)indexId), (IndexConfiguration)Matchers.any(IndexConfiguration.class), (IndexSamplingConfig)Matchers.any(IndexSamplingConfig.class))).thenThrow(new Throwable[]{exception});
        this.life.start();
        ArgumentCaptor closeArgs = ArgumentCaptor.forClass(Boolean.class);
        indexing.createIndexes(new IndexRule[]{IndexRule.indexRule((long)indexId, (int)7, (int)15, (SchemaIndexProvider.Descriptor)TestSchemaIndexProviderDescriptor.PROVIDER_DESCRIPTOR)});
        ((IndexPopulator)Mockito.verify((Object)this.populator, (VerificationMode)Mockito.timeout((long)1000L).times(2))).close(((Boolean)closeArgs.capture()).booleanValue());
        Assert.assertEquals((Object)InternalIndexState.FAILED, (Object)indexing.getIndexProxy(1L).getState());
        Assert.assertEquals(Arrays.asList(true, false), (Object)closeArgs.getAllValues());
        Assert.assertThat((Object)this.storedFailure(), (Matcher)CoreMatchers.containsString((String)String.format("java.io.IOException: Expected failure%n\tat ", new Object[0])));
        this.logProvider.assertAtLeastOnce(new AssertableLogProvider.LogMatcher[]{AssertableLogProvider.inLog(IndexPopulationJob.class).error(org.hamcrest.Matchers.equalTo((Object)"Failed to populate index: [:TheLabel(propertyKey) [provider: {key=quantum-dex, version=25.0}]]"), IndexingServiceTest.causedBy(exception))});
        this.logProvider.assertNone(AssertableLogProvider.inLog(IndexPopulationJob.class).info("Index population completed. Index is now online: [%s]", new Object[]{":TheLabel(propertyKey) [provider: {key=quantum-dex, version=25.0}]"}));
    }

    @Test
    public void shouldStoreIndexFailureWhenFailingToCreateOnlineAccessorAfterRecoveringPopulatingIndex() throws Exception {
        long indexId = 1L;
        IndexingService indexing = this.newIndexingServiceWithMockedDependencies(this.populator, this.accessor, this.withData(new NodePropertyUpdate[0]), IndexRule.indexRule((long)indexId, (int)7, (int)15, (SchemaIndexProvider.Descriptor)TestSchemaIndexProviderDescriptor.PROVIDER_DESCRIPTOR));
        IOException exception = new IOException("Expected failure");
        Mockito.when((Object)this.nameLookup.labelGetName(7)).thenReturn((Object)"TheLabel");
        Mockito.when((Object)this.nameLookup.propertyKeyGetName(15)).thenReturn((Object)"propertyKey");
        Mockito.when((Object)this.indexProvider.getInitialState(indexId)).thenReturn((Object)InternalIndexState.POPULATING);
        Mockito.when((Object)this.indexProvider.getOnlineAccessor(Matchers.eq((long)indexId), (IndexConfiguration)Matchers.any(IndexConfiguration.class), (IndexSamplingConfig)Matchers.any(IndexSamplingConfig.class))).thenThrow(new Throwable[]{exception});
        this.life.start();
        ArgumentCaptor closeArgs = ArgumentCaptor.forClass(Boolean.class);
        ((IndexPopulator)Mockito.verify((Object)this.populator, (VerificationMode)Mockito.timeout((long)1000L).times(2))).close(((Boolean)closeArgs.capture()).booleanValue());
        Assert.assertEquals((Object)InternalIndexState.FAILED, (Object)indexing.getIndexProxy(1L).getState());
        Assert.assertEquals(Arrays.asList(true, false), (Object)closeArgs.getAllValues());
        Assert.assertThat((Object)this.storedFailure(), (Matcher)CoreMatchers.containsString((String)String.format("java.io.IOException: Expected failure%n\tat ", new Object[0])));
        this.logProvider.assertAtLeastOnce(new AssertableLogProvider.LogMatcher[]{AssertableLogProvider.inLog(IndexPopulationJob.class).error(org.hamcrest.Matchers.equalTo((Object)"Failed to populate index: [:TheLabel(propertyKey) [provider: {key=quantum-dex, version=25.0}]]"), IndexingServiceTest.causedBy(exception))});
        this.logProvider.assertNone(AssertableLogProvider.inLog(IndexPopulationJob.class).info("Index population completed. Index is now online: [%s]", new Object[]{":TheLabel(propertyKey) [provider: {key=quantum-dex, version=25.0}]"}));
    }

    static Matcher<? extends Throwable> causedBy(final Throwable exception) {
        return new TypeSafeMatcher<Throwable>(){

            protected boolean matchesSafely(Throwable item) {
                while (item != null) {
                    if (item == exception) {
                        return true;
                    }
                    item = item.getCause();
                }
                return false;
            }

            public void describeTo(Description description) {
                description.appendText("exception caused by ").appendValue((Object)exception);
            }
        };
    }

    private String storedFailure() throws IOException {
        ArgumentCaptor reason = ArgumentCaptor.forClass(String.class);
        ((IndexPopulator)Mockito.verify((Object)this.populator)).markAsFailed((String)reason.capture());
        return (String)reason.getValue();
    }

    private Answer<Void> waitForLatch(CountDownLatch latch) {
        return invocationOnMock -> {
            latch.await();
            return null;
        };
    }

    private Answer<ResourceIterator<File>> newResourceIterator(File theFile) {
        return invocationOnMock -> Iterators.asResourceIterator((Iterator)Iterators.iterator((Object)theFile));
    }

    private NodePropertyUpdate add(long nodeId, Object propertyValue) {
        return NodePropertyUpdate.add((long)nodeId, (int)15, (Object)propertyValue, (long[])new long[]{7L});
    }

    private IndexingService newIndexingServiceWithMockedDependencies(IndexPopulator populator, IndexAccessor accessor, DataUpdates data, IndexRule ... rules) throws IOException {
        return this.newIndexingServiceWithMockedDependencies(populator, accessor, data, IndexingService.NO_MONITOR, rules);
    }

    private IndexingService newIndexingServiceWithMockedDependencies(IndexPopulator populator, IndexAccessor accessor, DataUpdates data, IndexingService.Monitor monitor, IndexRule ... rules) throws IOException {
        Mockito.when((Object)this.indexProvider.getProviderDescriptor()).thenReturn((Object)TestSchemaIndexProviderDescriptor.PROVIDER_DESCRIPTOR);
        Mockito.when((Object)this.indexProvider.getPopulator(Matchers.anyLong(), (IndexDescriptor)Matchers.any(IndexDescriptor.class), (IndexConfiguration)Matchers.any(IndexConfiguration.class), (IndexSamplingConfig)Matchers.any(IndexSamplingConfig.class))).thenReturn((Object)populator);
        data.getsProcessedByStoreScanFrom(this.storeView);
        Mockito.when((Object)this.indexProvider.getOnlineAccessor(Matchers.anyLong(), (IndexConfiguration)Matchers.any(IndexConfiguration.class), (IndexSamplingConfig)Matchers.any(IndexSamplingConfig.class))).thenReturn((Object)accessor);
        Mockito.when((Object)this.indexProvider.snapshotMetaFiles()).thenReturn((Object)Iterators.emptyIterator());
        Mockito.when((Object)this.indexProvider.storeMigrationParticipant((FileSystemAbstraction)Matchers.any(FileSystemAbstraction.class), (PageCache)Matchers.any(PageCache.class), (LabelScanStoreProvider)Matchers.any(LabelScanStoreProvider.class))).thenReturn((Object)StoreMigrationParticipant.NOT_PARTICIPATING);
        Mockito.when((Object)this.nameLookup.labelGetName(Matchers.anyInt())).thenAnswer((Answer)new NameLookupAnswer("label"));
        Mockito.when((Object)this.nameLookup.propertyKeyGetName(Matchers.anyInt())).thenAnswer((Answer)new NameLookupAnswer("property"));
        Config config = new Config(MapUtil.stringMap((String[])new String[]{GraphDatabaseSettings.multi_threaded_schema_index_population_enabled.name(), "false"}));
        return (IndexingService)this.life.add((Lifecycle)IndexingServiceFactory.createIndexingService((Config)config, (JobScheduler)((JobScheduler)this.life.add((Lifecycle)new Neo4jJobScheduler())), (SchemaIndexProviderMap)new DefaultSchemaIndexProviderMap(this.indexProvider), (IndexStoreView)this.storeView, (TokenNameLookup)this.nameLookup, (Iterable)Iterators.loop((Iterator)Iterators.iterator((Object[])rules)), (LogProvider)this.logProvider, (IndexingService.Monitor)monitor, (Runnable)DO_NOTHING_CALLBACK));
    }

    private DataUpdates withData(NodePropertyUpdate ... updates) {
        return new DataUpdates(updates);
    }

    private Answer nodeUpdatesAnswer(NodePropertyUpdate ... updates) {
        return invocation -> {
            Collection target = (Collection)invocation.getArguments()[1];
            target.addAll(Arrays.asList(updates));
            return null;
        };
    }

    private static class TrackingIndexAccessor
    implements IndexAccessor {
        private final IndexUpdater updater = (IndexUpdater)Mockito.mock(IndexUpdater.class);

        private TrackingIndexAccessor() {
        }

        public void drop() {
            throw new UnsupportedOperationException("Not required");
        }

        public IndexUpdater newUpdater(IndexUpdateMode mode) {
            return this.updater;
        }

        public void force() {
        }

        public void flush() {
        }

        public void close() {
        }

        public IndexReader newReader() {
            throw new UnsupportedOperationException("Not required");
        }

        public BoundedIterable<Long> newAllEntriesReader() {
            throw new UnsupportedOperationException("Not required");
        }

        public ResourceIterator<File> snapshotFiles() {
            throw new UnsupportedOperationException("Not required");
        }
    }

    private static class NameLookupAnswer
    implements Answer<String> {
        private final String kind;

        public NameLookupAnswer(String kind) {
            this.kind = kind;
        }

        public String answer(InvocationOnMock invocation) throws Throwable {
            int id = (Integer)invocation.getArguments()[0];
            return this.kind + "[" + id + "]";
        }
    }

    private static class DataUpdates
    implements Answer<StoreScan<IndexPopulationFailedKernelException>>,
    Iterable<NodePropertyUpdate> {
        private final NodePropertyUpdate[] updates;

        DataUpdates(NodePropertyUpdate[] updates) {
            this.updates = updates;
        }

        void getsProcessedByStoreScanFrom(IndexStoreView mock) {
            Mockito.when((Object)mock.visitNodes((int[])Matchers.any(int[].class), (IntPredicate)Matchers.any(IntPredicate.class), (Visitor)Matchers.any(Visitor.class), (Visitor)Matchers.any(Visitor.class))).thenAnswer((Answer)this);
        }

        public StoreScan<IndexPopulationFailedKernelException> answer(InvocationOnMock invocation) throws Throwable {
            final Visitor<NodePropertyUpdates, IndexPopulationFailedKernelException> visitor = DataUpdates.visitor(invocation.getArguments()[2]);
            return new StoreScan<IndexPopulationFailedKernelException>(){
                NodePropertyUpdates propertyUpdates = new NodePropertyUpdates();

                public void run() throws IndexPopulationFailedKernelException {
                    for (NodePropertyUpdate update : updates) {
                        this.propertyUpdates.initForNodeId(update.getNodeId());
                        this.propertyUpdates.add(update);
                        visitor.visit((Object)this.propertyUpdates);
                        this.propertyUpdates.reset();
                    }
                }

                public void stop() {
                    throw new UnsupportedOperationException();
                }

                public void acceptUpdate(MultipleIndexPopulator.MultipleIndexUpdater updater, NodePropertyUpdate update, long currentlyIndexedNodeId) {
                }

                public PopulationProgress getProgress() {
                    return new PopulationProgress(42L, 100L);
                }

                public void configure(List<MultipleIndexPopulator.IndexPopulation> populations) {
                }
            };
        }

        private static Visitor<NodePropertyUpdates, IndexPopulationFailedKernelException> visitor(Object v) {
            return (Visitor)v;
        }

        @Override
        public Iterator<NodePropertyUpdate> iterator() {
            return new ArrayIterator((Object[])this.updates);
        }

        public String toString() {
            return Arrays.toString(this.updates);
        }
    }

    private static class ControlledIndexPopulator
    extends IndexPopulator.Adapter {
        private final DoubleLatch latch;

        ControlledIndexPopulator(DoubleLatch latch) {
            this.latch = latch;
        }

        public void add(Collection<NodePropertyUpdate> updates) throws IndexEntryConflictException, IOException {
            this.latch.awaitStart();
        }

        public void close(boolean populationCompletedSuccessfully) throws IOException {
            this.latch.finish();
        }
    }
}

