/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.api.index;

import java.io.IOException;
import org.junit.Test;
import org.neo4j.kernel.api.exceptions.index.IndexEntryConflictException;
import org.neo4j.kernel.api.index.IndexUpdater;
import org.neo4j.kernel.impl.api.index.ContractCheckingIndexProxy;
import org.neo4j.kernel.impl.api.index.IndexProxy;
import org.neo4j.kernel.impl.api.index.IndexProxyAdapter;
import org.neo4j.kernel.impl.api.index.IndexUpdateMode;
import org.neo4j.kernel.impl.api.index.SchemaIndexTestHelper;
import org.neo4j.test.DoubleLatch;

public class ContractCheckingIndexProxyTest {
    @Test(expected=IllegalStateException.class)
    public void shouldNotCreateIndexTwice() throws IOException {
        IndexProxy inner = SchemaIndexTestHelper.mockIndexProxy();
        ContractCheckingIndexProxy outer = this.newContractCheckingIndexProxy(inner);
        outer.start();
        outer.start();
    }

    @Test(expected=IllegalStateException.class)
    public void shouldNotCloseIndexTwice() throws IOException {
        IndexProxy inner = SchemaIndexTestHelper.mockIndexProxy();
        ContractCheckingIndexProxy outer = this.newContractCheckingIndexProxy(inner);
        outer.close();
        outer.close();
    }

    @Test(expected=IllegalStateException.class)
    public void shouldNotDropIndexTwice() throws IOException {
        IndexProxy inner = SchemaIndexTestHelper.mockIndexProxy();
        ContractCheckingIndexProxy outer = this.newContractCheckingIndexProxy(inner);
        outer.drop();
        outer.drop();
    }

    @Test(expected=IllegalStateException.class)
    public void shouldNotDropAfterClose() throws IOException {
        IndexProxy inner = SchemaIndexTestHelper.mockIndexProxy();
        ContractCheckingIndexProxy outer = this.newContractCheckingIndexProxy(inner);
        outer.close();
        outer.drop();
    }

    @Test
    public void shouldDropAfterCreate() throws IOException {
        IndexProxy inner = SchemaIndexTestHelper.mockIndexProxy();
        ContractCheckingIndexProxy outer = this.newContractCheckingIndexProxy(inner);
        outer.start();
        outer.drop();
    }

    @Test
    public void shouldCloseAfterCreate() throws IOException {
        IndexProxy inner = SchemaIndexTestHelper.mockIndexProxy();
        ContractCheckingIndexProxy outer = this.newContractCheckingIndexProxy(inner);
        outer.start();
        outer.close();
    }

    @Test(expected=IllegalStateException.class)
    public void shouldNotUpdateBeforeCreate() throws Exception {
        IndexProxy inner = SchemaIndexTestHelper.mockIndexProxy();
        ContractCheckingIndexProxy outer = this.newContractCheckingIndexProxy(inner);
        try (IndexUpdater updater = outer.newUpdater(IndexUpdateMode.ONLINE);){
            updater.process(null);
        }
    }

    @Test(expected=IllegalStateException.class)
    public void shouldNotUpdateAfterClose() throws Exception {
        IndexProxy inner = SchemaIndexTestHelper.mockIndexProxy();
        ContractCheckingIndexProxy outer = this.newContractCheckingIndexProxy(inner);
        outer.start();
        outer.close();
        try (IndexUpdater updater = outer.newUpdater(IndexUpdateMode.ONLINE);){
            updater.process(null);
        }
    }

    @Test(expected=IllegalStateException.class)
    public void shouldNotForceBeforeCreate() throws IOException {
        IndexProxy inner = SchemaIndexTestHelper.mockIndexProxy();
        ContractCheckingIndexProxy outer = this.newContractCheckingIndexProxy(inner);
        outer.force();
    }

    @Test(expected=IllegalStateException.class)
    public void shouldNotForceAfterClose() throws IOException {
        IndexProxy inner = SchemaIndexTestHelper.mockIndexProxy();
        ContractCheckingIndexProxy outer = this.newContractCheckingIndexProxy(inner);
        outer.start();
        outer.close();
        outer.force();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(expected=IllegalStateException.class)
    public void shouldNotCloseWhileCreating() throws IOException {
        final DoubleLatch latch = new DoubleLatch();
        IndexProxyAdapter inner = new IndexProxyAdapter(){

            @Override
            public void start() {
                latch.startAndAwaitFinish();
            }
        };
        ContractCheckingIndexProxy outer = this.newContractCheckingIndexProxy(inner);
        this.runInSeparateThread(new ThrowingRunnable((IndexProxy)outer){
            final /* synthetic */ IndexProxy val$outer;
            {
                this.val$outer = indexProxy;
            }

            @Override
            public void run() throws IOException {
                this.val$outer.start();
            }
        });
        try {
            latch.awaitStart();
            outer.close();
        }
        finally {
            latch.finish();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(expected=IllegalStateException.class)
    public void shouldNotDropWhileCreating() throws IOException {
        final DoubleLatch latch = new DoubleLatch();
        IndexProxyAdapter inner = new IndexProxyAdapter(){

            @Override
            public void start() {
                latch.startAndAwaitFinish();
            }
        };
        ContractCheckingIndexProxy outer = this.newContractCheckingIndexProxy(inner);
        this.runInSeparateThread(new ThrowingRunnable((IndexProxy)outer){
            final /* synthetic */ IndexProxy val$outer;
            {
                this.val$outer = indexProxy;
            }

            @Override
            public void run() throws IOException {
                this.val$outer.start();
            }
        });
        try {
            latch.awaitStart();
            outer.drop();
        }
        finally {
            latch.finish();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(expected=IllegalStateException.class)
    public void shouldNotCloseWhileUpdating() throws IOException {
        DoubleLatch latch = new DoubleLatch();
        IndexProxyAdapter inner = new IndexProxyAdapter(){

            @Override
            public IndexUpdater newUpdater(IndexUpdateMode mode) {
                return super.newUpdater(mode);
            }
        };
        ContractCheckingIndexProxy outer = this.newContractCheckingIndexProxy(inner);
        outer.start();
        this.runInSeparateThread(new ThrowingRunnable((IndexProxy)outer, latch){
            final /* synthetic */ IndexProxy val$outer;
            final /* synthetic */ DoubleLatch val$latch;
            {
                this.val$outer = indexProxy;
                this.val$latch = doubleLatch;
            }

            @Override
            public void run() throws IOException {
                try (IndexUpdater updater = this.val$outer.newUpdater(IndexUpdateMode.ONLINE);){
                    updater.process(null);
                    this.val$latch.startAndAwaitFinish();
                }
                catch (IndexEntryConflictException e) {
                    throw new RuntimeException(e);
                }
            }
        });
        try {
            latch.awaitStart();
            outer.close();
        }
        finally {
            latch.finish();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(expected=IllegalStateException.class)
    public void shouldNotCloseWhileForcing() throws IOException {
        final DoubleLatch latch = new DoubleLatch();
        IndexProxyAdapter inner = new IndexProxyAdapter(){

            @Override
            public void force() {
                latch.startAndAwaitFinish();
            }
        };
        ContractCheckingIndexProxy outer = this.newContractCheckingIndexProxy(inner);
        outer.start();
        this.runInSeparateThread(new ThrowingRunnable((IndexProxy)outer){
            final /* synthetic */ IndexProxy val$outer;
            {
                this.val$outer = indexProxy;
            }

            @Override
            public void run() throws IOException {
                this.val$outer.force();
            }
        });
        try {
            latch.awaitStart();
            outer.close();
        }
        finally {
            latch.finish();
        }
    }

    private void runInSeparateThread(final ThrowingRunnable action) {
        new Thread(new Runnable(){

            @Override
            public void run() {
                try {
                    action.run();
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            }
        }).start();
    }

    private ContractCheckingIndexProxy newContractCheckingIndexProxy(IndexProxy inner) {
        return new ContractCheckingIndexProxy(inner, false);
    }

    private static interface ThrowingRunnable {
        public void run() throws IOException;
    }
}

