/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.api.constraints;

import java.util.ArrayList;
import java.util.List;
import java.util.function.Predicate;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.Mockito;
import org.neo4j.kernel.api.KernelAPI;
import org.neo4j.kernel.api.KernelTransaction;
import org.neo4j.kernel.api.Statement;
import org.neo4j.kernel.api.TransactionHook;
import org.neo4j.kernel.api.exceptions.Status;
import org.neo4j.kernel.api.exceptions.TransactionFailureException;
import org.neo4j.kernel.api.exceptions.index.IndexPopulationFailedKernelException;
import org.neo4j.kernel.api.exceptions.schema.ConstraintVerificationFailedKernelException;
import org.neo4j.kernel.api.index.IndexDescriptor;
import org.neo4j.kernel.api.index.PreexistingIndexEntryConflictException;
import org.neo4j.kernel.api.proc.CallableProcedure;
import org.neo4j.kernel.api.security.AccessMode;
import org.neo4j.kernel.api.txstate.TransactionState;
import org.neo4j.kernel.impl.api.KernelStatement;
import org.neo4j.kernel.impl.api.StatementOperationParts;
import org.neo4j.kernel.impl.api.StatementOperationsTestHelper;
import org.neo4j.kernel.impl.api.index.IndexProxy;
import org.neo4j.kernel.impl.api.index.IndexingService;
import org.neo4j.kernel.impl.api.operations.SchemaReadOperations;
import org.neo4j.kernel.impl.api.state.ConstraintIndexCreator;
import org.neo4j.kernel.impl.store.SchemaStorage;

public class ConstraintIndexCreatorTest {
    @Test
    public void shouldCreateIndexInAnotherTransaction() throws Exception {
        StatementOperationParts constraintCreationContext = StatementOperationsTestHelper.mockedParts();
        StatementOperationParts indexCreationContext = StatementOperationsTestHelper.mockedParts();
        IndexDescriptor descriptor = new IndexDescriptor(123, 456);
        KernelStatement state = StatementOperationsTestHelper.mockedState();
        IndexingService indexingService = (IndexingService)Mockito.mock(IndexingService.class);
        StubKernel kernel = new StubKernel();
        Mockito.when((Object)constraintCreationContext.schemaReadOperations().indexGetCommittedId(state, descriptor, (Predicate)SchemaStorage.IndexRuleKind.CONSTRAINT)).thenReturn((Object)2468L);
        IndexProxy indexProxy = (IndexProxy)Mockito.mock(IndexProxy.class);
        Mockito.when((Object)indexingService.getIndexProxy(2468L)).thenReturn((Object)indexProxy);
        ConstraintIndexCreator creator = new ConstraintIndexCreator(() -> kernel, indexingService);
        long indexId = creator.createUniquenessConstraintIndex(state, constraintCreationContext.schemaReadOperations(), 123, 456);
        Assert.assertEquals((long)2468L, (long)indexId);
        Assert.assertEquals((long)1L, (long)kernel.statements.size());
        ((TransactionState)Mockito.verify((Object)((KernelStatement)kernel.statements.get(0)).txState())).constraintIndexRuleDoAdd(descriptor);
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{indexCreationContext.schemaWriteOperations()});
        ((SchemaReadOperations)Mockito.verify((Object)constraintCreationContext.schemaReadOperations())).indexGetCommittedId(state, descriptor, (Predicate)SchemaStorage.IndexRuleKind.CONSTRAINT);
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{constraintCreationContext.schemaReadOperations()});
        ((IndexProxy)Mockito.verify((Object)indexProxy)).awaitStoreScanCompleted();
    }

    @Test
    public void shouldDropIndexIfPopulationFails() throws Exception {
        StatementOperationParts constraintCreationContext = StatementOperationsTestHelper.mockedParts();
        KernelStatement state = StatementOperationsTestHelper.mockedState();
        IndexDescriptor descriptor = new IndexDescriptor(123, 456);
        IndexingService indexingService = (IndexingService)Mockito.mock(IndexingService.class);
        StubKernel kernel = new StubKernel();
        Mockito.when((Object)constraintCreationContext.schemaReadOperations().indexGetCommittedId(state, descriptor, (Predicate)SchemaStorage.IndexRuleKind.CONSTRAINT)).thenReturn((Object)2468L);
        IndexProxy indexProxy = (IndexProxy)Mockito.mock(IndexProxy.class);
        Mockito.when((Object)indexingService.getIndexProxy(2468L)).thenReturn((Object)indexProxy);
        PreexistingIndexEntryConflictException cause = new PreexistingIndexEntryConflictException((Object)"a", 2L, 1L);
        ((IndexProxy)Mockito.doThrow((Throwable)new IndexPopulationFailedKernelException(descriptor, "some index", (Throwable)cause)).when((Object)indexProxy)).awaitStoreScanCompleted();
        ConstraintIndexCreator creator = new ConstraintIndexCreator(() -> kernel, indexingService);
        try {
            creator.createUniquenessConstraintIndex(state, constraintCreationContext.schemaReadOperations(), 123, 456);
            Assert.fail((String)"expected exception");
        }
        catch (ConstraintVerificationFailedKernelException e) {
            Assert.assertEquals((Object)"Existing data does not satisfy CONSTRAINT ON ( n:label[123] ) ASSERT n.property[456] IS UNIQUE.", (Object)e.getMessage());
        }
        Assert.assertEquals((long)2L, (long)kernel.statements.size());
        TransactionState tx1 = ((KernelStatement)kernel.statements.get(0)).txState();
        ((TransactionState)Mockito.verify((Object)tx1)).constraintIndexRuleDoAdd(new IndexDescriptor(123, 456));
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{tx1});
        ((SchemaReadOperations)Mockito.verify((Object)constraintCreationContext.schemaReadOperations())).indexGetCommittedId(state, descriptor, (Predicate)SchemaStorage.IndexRuleKind.CONSTRAINT);
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{constraintCreationContext.schemaReadOperations()});
        TransactionState tx2 = ((KernelStatement)kernel.statements.get(1)).txState();
        ((TransactionState)Mockito.verify((Object)tx2)).constraintIndexDoDrop(new IndexDescriptor(123, 456));
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{tx2});
    }

    @Test
    public void shouldDropIndexInAnotherTransaction() throws Exception {
        StubKernel kernel = new StubKernel();
        IndexingService indexingService = (IndexingService)Mockito.mock(IndexingService.class);
        IndexDescriptor descriptor = new IndexDescriptor(123, 456);
        ConstraintIndexCreator creator = new ConstraintIndexCreator(() -> kernel, indexingService);
        creator.dropUniquenessConstraintIndex(descriptor);
        Assert.assertEquals((long)1L, (long)kernel.statements.size());
        ((TransactionState)Mockito.verify((Object)((KernelStatement)kernel.statements.get(0)).txState())).constraintIndexDoDrop(descriptor);
        Mockito.verifyZeroInteractions((Object[])new Object[]{indexingService});
    }

    public class StubKernel
    implements KernelAPI {
        private final List<KernelStatement> statements = new ArrayList<KernelStatement>();

        public KernelTransaction newTransaction(KernelTransaction.Type type, AccessMode accessMode) {
            return new StubKernelTransaction();
        }

        public KernelTransaction newTransaction(KernelTransaction.Type type, AccessMode accessMode, long timeout) throws TransactionFailureException {
            return new StubKernelTransaction(timeout);
        }

        public void registerTransactionHook(TransactionHook hook) {
            throw new UnsupportedOperationException("Please implement");
        }

        public void unregisterTransactionHook(TransactionHook hook) {
            throw new UnsupportedOperationException("Please implement");
        }

        public void registerProcedure(CallableProcedure signature) {
            throw new UnsupportedOperationException();
        }

        private class StubKernelTransaction
        implements KernelTransaction {
            private long timeout = 0L;

            public StubKernelTransaction() {
            }

            public StubKernelTransaction(long timeout) {
                this.timeout = timeout;
            }

            public void success() {
            }

            public void failure() {
            }

            public void close() throws TransactionFailureException {
            }

            public Statement acquireStatement() {
                return this.remember(StatementOperationsTestHelper.mockedState());
            }

            private Statement remember(KernelStatement mockedState) {
                StubKernel.this.statements.add(mockedState);
                return mockedState;
            }

            public boolean isOpen() {
                return true;
            }

            public AccessMode mode() {
                throw new UnsupportedOperationException();
            }

            public Status getReasonIfTerminated() {
                return null;
            }

            public void markForTermination(Status reason) {
            }

            public long lastTransactionTimestampWhenStarted() {
                return 0L;
            }

            public void registerCloseListener(KernelTransaction.CloseListener listener) {
            }

            public KernelTransaction.Type transactionType() {
                return null;
            }

            public long getTransactionId() {
                return -1L;
            }

            public long getCommitTime() {
                return -1L;
            }

            public KernelTransaction.Revertable restrict(AccessMode read) {
                return null;
            }

            public long lastTransactionIdWhenStarted() {
                return 0L;
            }

            public long startTime() {
                return 0L;
            }

            public long timeout() {
                return this.timeout;
            }
        }
    }
}

